/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.FrameManager;
import android.filterfw.core.GLEnvironment;
import android.filterfw.core.GLFrameTimer;
import android.filterfw.core.NativeFrame;
import android.filterfw.core.SimpleFrame;
import android.filterfw.core.StopWatchMap;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.opengl.GLES20;
import java.nio.ByteBuffer;

public class GLFrame
extends Frame {
    public static final int EXISTING_FBO_BINDING = 101;
    public static final int EXISTING_TEXTURE_BINDING = 100;
    public static final int EXTERNAL_TEXTURE = 104;
    public static final int NEW_FBO_BINDING = 103;
    public static final int NEW_TEXTURE_BINDING = 102;
    private int glFrameId = -1;
    private GLEnvironment mGLEnvironment;
    private boolean mOwnsTexture = true;

    static {
        System.loadLibrary("filterfw");
    }

    GLFrame(FrameFormat frameFormat, FrameManager frameManager) {
        super(frameFormat, frameManager);
    }

    GLFrame(FrameFormat frameFormat, FrameManager frameManager, int n, long l) {
        super(frameFormat, frameManager, n, l);
    }

    private void assertGLEnvValid() {
        if (!this.mGLEnvironment.isContextActive()) {
            if (GLEnvironment.isAnyContextActive()) {
                throw new RuntimeException("Attempting to access " + this + " with foreign GL " + "context active!");
            }
            throw new RuntimeException("Attempting to access " + this + " with no GL context " + " active!");
        }
    }

    private native boolean generateNativeMipMap();

    private native boolean getNativeBitmap(Bitmap var1);

    private native byte[] getNativeData();

    private native int getNativeFboId();

    private native float[] getNativeFloats();

    private native int[] getNativeInts();

    private native int getNativeTextureId();

    private void initNew(boolean bl) {
        if (bl) {
            if (!this.nativeAllocateExternal(this.mGLEnvironment)) {
                throw new RuntimeException("Could not allocate external GL frame!");
            }
        } else if (!this.nativeAllocate(this.mGLEnvironment, this.getFormat().getWidth(), this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate GL frame!");
        }
    }

    private void initWithFbo(int n) {
        int n2;
        int n3 = this.getFormat().getWidth();
        if (!this.nativeAllocateWithFbo(this.mGLEnvironment, n, n3, n2 = this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate FBO backed GL frame!");
        }
    }

    private void initWithTexture(int n) {
        int n2;
        int n3 = this.getFormat().getWidth();
        if (!this.nativeAllocateWithTexture(this.mGLEnvironment, n, n3, n2 = this.getFormat().getHeight())) {
            throw new RuntimeException("Could not allocate texture backed GL frame!");
        }
        this.mOwnsTexture = false;
        this.markReadOnly();
    }

    private native boolean nativeAllocate(GLEnvironment var1, int var2, int var3);

    private native boolean nativeAllocateExternal(GLEnvironment var1);

    private native boolean nativeAllocateWithFbo(GLEnvironment var1, int var2, int var3, int var4);

    private native boolean nativeAllocateWithTexture(GLEnvironment var1, int var2, int var3, int var4);

    private native boolean nativeCopyFromGL(GLFrame var1);

    private native boolean nativeCopyFromNative(NativeFrame var1);

    private native boolean nativeDeallocate();

    private native boolean nativeDetachTexFromFbo();

    private native boolean nativeFocus();

    private native boolean nativeReattachTexToFbo();

    private native boolean nativeResetParams();

    private native boolean setNativeBitmap(Bitmap var1, int var2);

    private native boolean setNativeData(byte[] var1, int var2, int var3);

    private native boolean setNativeFloats(float[] var1);

    private native boolean setNativeInts(int[] var1);

    private native boolean setNativeTextureParam(int var1, int var2);

    private native boolean setNativeViewport(int var1, int var2, int var3, int var4);

    void flushGPU(String string2) {
        StopWatchMap stopWatchMap = GLFrameTimer.get();
        if (stopWatchMap.LOG_MFF_RUNNING_TIMES) {
            stopWatchMap.start("glFinish " + string2);
            GLES20.glFinish();
            stopWatchMap.stop("glFinish " + string2);
        }
    }

    public void focus() {
        if (!this.nativeFocus()) {
            throw new RuntimeException("Could not focus on GLFrame for drawing!");
        }
    }

    public void generateMipMap() {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.generateNativeMipMap()) {
            throw new RuntimeException("Could not generate mip-map for GL frame!");
        }
    }

    @Override
    public Bitmap getBitmap() {
        this.assertGLEnvValid();
        this.flushGPU("getBitmap");
        Bitmap bitmap = Bitmap.createBitmap(this.getFormat().getWidth(), this.getFormat().getHeight(), Bitmap.Config.ARGB_8888);
        if (!this.getNativeBitmap(bitmap)) {
            throw new RuntimeException("Could not get bitmap data from GL frame!");
        }
        return bitmap;
    }

    @Override
    public ByteBuffer getData() {
        this.assertGLEnvValid();
        this.flushGPU("getData");
        return ByteBuffer.wrap(this.getNativeData());
    }

    public int getFboId() {
        return this.getNativeFboId();
    }

    @Override
    public float[] getFloats() {
        this.assertGLEnvValid();
        this.flushGPU("getFloats");
        return this.getNativeFloats();
    }

    public GLEnvironment getGLEnvironment() {
        return this.mGLEnvironment;
    }

    @Override
    public int[] getInts() {
        this.assertGLEnvValid();
        this.flushGPU("getInts");
        return this.getNativeInts();
    }

    @Override
    public Object getObjectValue() {
        this.assertGLEnvValid();
        return ByteBuffer.wrap(this.getNativeData());
    }

    public int getTextureId() {
        return this.getNativeTextureId();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    protected boolean hasNativeAllocation() {
        synchronized (this) {
            int n = this.glFrameId;
            if (n == -1) return false;
            return true;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void init(GLEnvironment gLEnvironment) {
        FrameFormat frameFormat = this.getFormat();
        this.mGLEnvironment = gLEnvironment;
        if (frameFormat.getBytesPerSample() != 4) {
            throw new IllegalArgumentException("GL frames must have 4 bytes per sample!");
        }
        if (frameFormat.getDimensionCount() != 2) {
            throw new IllegalArgumentException("GL frames must be 2-dimensional!");
        }
        if (this.getFormat().getSize() < 0) {
            throw new IllegalArgumentException("Initializing GL frame with zero size!");
        }
        int n = this.getBindingType();
        boolean bl = true;
        if (n == 0) {
            this.initNew(false);
        } else if (n == 104) {
            this.initNew(true);
            bl = false;
        } else if (n == 100) {
            this.initWithTexture((int)this.getBindingId());
        } else if (n == 101) {
            this.initWithFbo((int)this.getBindingId());
        } else if (n == 102) {
            this.initWithTexture((int)this.getBindingId());
        } else {
            if (n != 103) {
                throw new RuntimeException("Attempting to create GL frame with unknown binding type " + n + "!");
            }
            this.initWithFbo((int)this.getBindingId());
        }
        this.setReusable(bl);
    }

    @Override
    protected void onFrameFetch() {
        if (!this.mOwnsTexture) {
            this.nativeReattachTexToFbo();
        }
    }

    @Override
    protected void onFrameStore() {
        if (!this.mOwnsTexture) {
            this.nativeDetachTexFromFbo();
        }
    }

    @Override
    protected void releaseNativeAllocation() {
        synchronized (this) {
            this.nativeDeallocate();
            this.glFrameId = -1;
            return;
        }
    }

    @Override
    protected void reset(FrameFormat frameFormat) {
        if (!this.nativeResetParams()) {
            throw new RuntimeException("Could not reset GLFrame texture parameters!");
        }
        super.reset(frameFormat);
    }

    @Override
    public void setBitmap(Bitmap bitmap) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (this.getFormat().getWidth() != bitmap.getWidth() || this.getFormat().getHeight() != bitmap.getHeight()) {
            throw new RuntimeException("Bitmap dimensions do not match GL frame dimensions!");
        }
        Bitmap bitmap2 = GLFrame.convertBitmapToRGBA(bitmap);
        if (!this.setNativeBitmap(bitmap2, bitmap2.getByteCount())) {
            throw new RuntimeException("Could not set GL frame bitmap data!");
        }
    }

    @Override
    public void setData(ByteBuffer byteBuffer, int n, int n2) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        byte[] byArray = byteBuffer.array();
        if (this.getFormat().getSize() != byArray.length) {
            throw new RuntimeException("Data size in setData does not match GL frame size!");
        }
        if (!this.setNativeData(byArray, n, n2)) {
            throw new RuntimeException("Could not set GL frame data!");
        }
    }

    @Override
    public void setDataFromFrame(Frame frame) {
        this.assertGLEnvValid();
        if (this.getFormat().getSize() < frame.getFormat().getSize()) {
            throw new RuntimeException("Attempting to assign frame of size " + frame.getFormat().getSize() + " to " + "smaller GL frame of size " + this.getFormat().getSize() + "!");
        }
        if (frame instanceof NativeFrame) {
            this.nativeCopyFromNative((NativeFrame)frame);
            return;
        }
        if (frame instanceof GLFrame) {
            this.nativeCopyFromGL((GLFrame)frame);
            return;
        }
        if (frame instanceof SimpleFrame) {
            this.setObjectValue(frame.getObjectValue());
            return;
        }
        super.setDataFromFrame(frame);
    }

    @Override
    public void setFloats(float[] fArray) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeFloats(fArray)) {
            throw new RuntimeException("Could not set int values for GL frame!");
        }
    }

    @Override
    public void setInts(int[] nArray) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeInts(nArray)) {
            throw new RuntimeException("Could not set int values for GL frame!");
        }
    }

    public void setTextureParameter(int n, int n2) {
        this.assertFrameMutable();
        this.assertGLEnvValid();
        if (!this.setNativeTextureParam(n, n2)) {
            throw new RuntimeException("Could not set texture value " + n + " = " + n2 + " " + "for GLFrame!");
        }
    }

    public void setViewport(int n, int n2, int n3, int n4) {
        this.assertFrameMutable();
        this.setNativeViewport(n, n2, n3, n4);
    }

    public void setViewport(Rect rect) {
        this.assertFrameMutable();
        this.setNativeViewport(rect.left, rect.top, rect.right - rect.left, rect.bottom - rect.top);
    }

    public String toString() {
        return "GLFrame id: " + this.glFrameId + " (" + this.getFormat() + ") with texture ID " + this.getTextureId() + ", FBO ID " + this.getFboId();
    }
}

