/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.Frame;
import android.filterfw.core.FrameFormat;
import android.filterfw.core.SimpleFrameManager;
import java.util.Iterator;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;

public class CachedFrameManager
extends SimpleFrameManager {
    private SortedMap<Integer, Frame> mAvailableFrames = new TreeMap<Integer, Frame>();
    private int mStorageCapacity = 0x1800000;
    private int mStorageSize = 0;
    private int mTimeStamp = 0;

    private void dropOldestFrame() {
        int n = this.mAvailableFrames.firstKey();
        Frame frame = (Frame)this.mAvailableFrames.get(n);
        this.mStorageSize -= frame.getFormat().getSize();
        frame.releaseNativeAllocation();
        this.mAvailableFrames.remove(n);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Frame findAvailableFrame(FrameFormat frameFormat, int n, long l) {
        SortedMap<Integer, Frame> sortedMap = this.mAvailableFrames;
        synchronized (sortedMap) {
            Map.Entry entry;
            Frame frame;
            Iterator iterator = this.mAvailableFrames.entrySet().iterator();
            do {
                if (iterator.hasNext()) continue;
                return null;
            } while (!(frame = (Frame)(entry = iterator.next()).getValue()).getFormat().isReplaceableBy(frameFormat) || n != frame.getBindingType() || n != 0 && l != frame.getBindingId());
            super.retainFrame(frame);
            this.mAvailableFrames.remove(entry.getKey());
            frame.onFrameFetch();
            frame.reset(frameFormat);
            this.mStorageSize -= frameFormat.getSize();
            return frame;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean storeFrame(Frame frame) {
        SortedMap<Integer, Frame> sortedMap = this.mAvailableFrames;
        synchronized (sortedMap) {
            int n = frame.getFormat().getSize();
            if (n > this.mStorageCapacity) {
                return false;
            }
            int n2 = n + this.mStorageSize;
            while (true) {
                if (n2 <= this.mStorageCapacity) {
                    frame.onFrameStore();
                    this.mStorageSize = n2;
                    this.mAvailableFrames.put(this.mTimeStamp, frame);
                    this.mTimeStamp = 1 + this.mTimeStamp;
                    return true;
                }
                this.dropOldestFrame();
                n2 = n + this.mStorageSize;
            }
        }
    }

    public void clearCache() {
        Iterator iterator = this.mAvailableFrames.values().iterator();
        while (iterator.hasNext()) {
            ((Frame)iterator.next()).releaseNativeAllocation();
        }
        this.mAvailableFrames.clear();
    }

    @Override
    public Frame newBoundFrame(FrameFormat frameFormat, int n, long l) {
        Frame frame = this.findAvailableFrame(frameFormat, n, l);
        if (frame == null) {
            frame = super.newBoundFrame(frameFormat, n, l);
        }
        frame.setTimestamp(-2L);
        return frame;
    }

    @Override
    public Frame newFrame(FrameFormat frameFormat) {
        Frame frame = this.findAvailableFrame(frameFormat, 0, 0L);
        if (frame == null) {
            frame = super.newFrame(frameFormat);
        }
        frame.setTimestamp(-2L);
        return frame;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public Frame releaseFrame(Frame frame) {
        if (frame.isReusable()) {
            int n = frame.decRefCount();
            if (n == 0 && frame.hasNativeAllocation()) {
                if (this.storeFrame(frame)) return null;
                frame.releaseNativeAllocation();
                return null;
            }
            if (n >= 0) return frame;
            throw new RuntimeException("Frame reference count dropped below 0!");
        }
        super.releaseFrame(frame);
        return frame;
    }

    @Override
    public Frame retainFrame(Frame frame) {
        return super.retainFrame(frame);
    }

    @Override
    public void tearDown() {
        this.clearCache();
    }
}

