/*
 * Decompiled with CFR 0.152.
 */
package android.filterfw.core;

import android.filterfw.core.FilterContext;
import android.filterfw.core.FilterGraph;
import android.filterfw.core.GraphRunner;
import android.filterfw.core.SimpleScheduler;
import android.filterfw.core.SyncRunner;
import android.os.AsyncTask;
import android.util.Log;

public class AsyncRunner
extends GraphRunner {
    private static final String TAG = "AsyncRunner";
    private boolean isProcessing;
    private GraphRunner.OnRunnerDoneListener mDoneListener;
    private Exception mException;
    private boolean mLogVerbose;
    private AsyncRunnerTask mRunTask;
    private SyncRunner mRunner;
    private Class mSchedulerClass;

    public AsyncRunner(FilterContext filterContext) {
        super(filterContext);
        this.mSchedulerClass = SimpleScheduler.class;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    public AsyncRunner(FilterContext filterContext, Class clazz) {
        super(filterContext);
        this.mSchedulerClass = clazz;
        this.mLogVerbose = Log.isLoggable(TAG, 2);
    }

    private void setException(Exception exception) {
        synchronized (this) {
            this.mException = exception;
            return;
        }
    }

    private void setRunning(boolean bl) {
        synchronized (this) {
            this.isProcessing = bl;
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void close() {
        synchronized (this) {
            if (this.isRunning()) {
                throw new RuntimeException("Cannot close graph while it is running!");
            }
            if (this.mLogVerbose) {
                Log.v(TAG, "Closing filters.");
            }
            this.mRunner.close();
            return;
        }
    }

    @Override
    public Exception getError() {
        synchronized (this) {
            Exception exception = this.mException;
            return exception;
        }
    }

    @Override
    public FilterGraph getGraph() {
        if (this.mRunner != null) {
            return this.mRunner.getGraph();
        }
        return null;
    }

    @Override
    public boolean isRunning() {
        synchronized (this) {
            boolean bl = this.isProcessing;
            return bl;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        synchronized (this) {
            if (this.mLogVerbose) {
                Log.v(TAG, "Running graph.");
            }
            this.setException(null);
            if (this.isRunning()) {
                throw new RuntimeException("Graph is already running!");
            }
            if (this.mRunner == null) {
                throw new RuntimeException("Cannot run before a graph is set!");
            }
            this.mRunTask = new AsyncRunnerTask();
            this.setRunning(true);
            AsyncRunnerTask asyncRunnerTask = this.mRunTask;
            SyncRunner[] syncRunnerArray = new SyncRunner[]{this.mRunner};
            asyncRunnerTask.execute(syncRunnerArray);
            return;
        }
    }

    @Override
    public void setDoneCallback(GraphRunner.OnRunnerDoneListener onRunnerDoneListener) {
        this.mDoneListener = onRunnerDoneListener;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setGraph(FilterGraph filterGraph) {
        synchronized (this) {
            if (this.isRunning()) {
                throw new RuntimeException("Graph is already running!");
            }
            this.mRunner = new SyncRunner(this.mFilterContext, filterGraph, this.mSchedulerClass);
            return;
        }
    }

    @Override
    public void stop() {
        synchronized (this) {
            if (this.mRunTask != null && !this.mRunTask.isCancelled()) {
                if (this.mLogVerbose) {
                    Log.v(TAG, "Stopping graph.");
                }
                this.mRunTask.cancel(false);
            }
            return;
        }
    }

    private class AsyncRunnerTask
    extends AsyncTask<SyncRunner, Void, RunnerResult> {
        private static final String TAG = "AsyncRunnerTask";

        private AsyncRunnerTask() {
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        protected RunnerResult doInBackground(SyncRunner ... syncRunnerArray) {
            RunnerResult runnerResult = new RunnerResult();
            try {
                if (syncRunnerArray.length > 1) {
                    throw new RuntimeException("More than one runner received!");
                }
                syncRunnerArray[0].assertReadyToStep();
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Starting background graph processing.");
                }
                AsyncRunner.this.activateGlContext();
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Preparing filter graph for processing.");
                }
                syncRunnerArray[0].beginProcessing();
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Running graph.");
                }
                runnerResult.status = 1;
                while (!this.isCancelled() && runnerResult.status == 1) {
                    if (syncRunnerArray[0].performStep()) continue;
                    runnerResult.status = syncRunnerArray[0].determinePostRunState();
                    if (runnerResult.status != 3) continue;
                    syncRunnerArray[0].waitUntilWake();
                    runnerResult.status = 1;
                }
                if (this.isCancelled()) {
                    runnerResult.status = 5;
                }
            }
            catch (Exception exception) {
                runnerResult.exception = exception;
                runnerResult.status = 6;
            }
            try {
                AsyncRunner.this.deactivateGlContext();
            }
            catch (Exception exception) {
                runnerResult.exception = exception;
                runnerResult.status = 6;
            }
            if (AsyncRunner.this.mLogVerbose) {
                Log.v(TAG, "Done with background graph processing.");
            }
            return runnerResult;
        }

        @Override
        protected void onCancelled(RunnerResult runnerResult) {
            this.onPostExecute(runnerResult);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        protected void onPostExecute(RunnerResult runnerResult) {
            if (AsyncRunner.this.mLogVerbose) {
                Log.v(TAG, "Starting post-execute.");
            }
            AsyncRunner.this.setRunning(false);
            if (runnerResult == null) {
                runnerResult = new RunnerResult();
                runnerResult.status = 5;
            }
            AsyncRunner.this.setException(runnerResult.exception);
            if (runnerResult.status == 5 || runnerResult.status == 6) {
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Closing filters.");
                }
                try {
                    AsyncRunner.this.mRunner.close();
                }
                catch (Exception exception) {
                    runnerResult.status = 6;
                    AsyncRunner.this.setException(exception);
                }
            }
            if (AsyncRunner.this.mDoneListener != null) {
                if (AsyncRunner.this.mLogVerbose) {
                    Log.v(TAG, "Calling graph done callback.");
                }
                AsyncRunner.this.mDoneListener.onRunnerDone(runnerResult.status);
            }
            if (AsyncRunner.this.mLogVerbose) {
                Log.v(TAG, "Completed post-execute.");
            }
        }
    }

    private class RunnerResult {
        public Exception exception;
        public int status = 0;

        private RunnerResult() {
        }
    }
}

