/*
 * Decompiled with CFR 0.152.
 */
package android.drm;

import android.drm.DrmUtils;
import android.drm.ProcessedData;
import java.io.File;
import java.io.IOException;

public class DrmRights {
    private String mAccountId;
    private byte[] mData;
    private String mMimeType;
    private String mSubscriptionId;

    public DrmRights(ProcessedData processedData, String string2) {
        if (processedData == null) {
            throw new IllegalArgumentException("data is null");
        }
        this.mData = processedData.getData();
        this.mAccountId = processedData.getAccountId();
        this.mSubscriptionId = processedData.getSubscriptionId();
        this.mMimeType = string2;
        if (!this.isValid()) {
            throw new IllegalArgumentException("mimeType: " + this.mMimeType + "," + "data: " + this.mData);
        }
    }

    public DrmRights(File file, String string2) {
        this.instantiate(file, string2);
    }

    public DrmRights(String string2, String string3) {
        this.instantiate(new File(string2), string3);
    }

    public DrmRights(String string2, String string3, String string4) {
        this(string2, string3);
        this.mAccountId = string4;
    }

    public DrmRights(String string2, String string3, String string4, String string5) {
        this(string2, string3);
        this.mAccountId = string4;
        this.mSubscriptionId = string5;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void instantiate(File file, String string2) {
        try {
            this.mData = DrmUtils.readBytes(file);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
        this.mMimeType = string2;
        if (!this.isValid()) {
            throw new IllegalArgumentException("mimeType: " + this.mMimeType + "," + "data: " + this.mData);
        }
    }

    public String getAccountId() {
        return this.mAccountId;
    }

    public byte[] getData() {
        return this.mData;
    }

    public String getMimeType() {
        return this.mMimeType;
    }

    public String getSubscriptionId() {
        return this.mSubscriptionId;
    }

    boolean isValid() {
        return this.mMimeType != null && !this.mMimeType.equals("") && this.mData != null && this.mData.length > 0;
    }
}

