/*
 * Decompiled with CFR 0.152.
 */
package android.ddm;

import android.os.Debug;
import android.util.Log;
import java.io.IOException;
import java.nio.ByteBuffer;
import org.apache.harmony.dalvik.ddmc.Chunk;
import org.apache.harmony.dalvik.ddmc.ChunkHandler;
import org.apache.harmony.dalvik.ddmc.DdmServer;
import org.apache.harmony.dalvik.ddmc.DdmVmInternal;

public class DdmHandleHeap
extends ChunkHandler {
    public static final int CHUNK_HPDS;
    public static final int CHUNK_HPDU;
    public static final int CHUNK_HPGC;
    public static final int CHUNK_HPIF;
    public static final int CHUNK_HPSG;
    public static final int CHUNK_NHSG;
    public static final int CHUNK_REAE;
    public static final int CHUNK_REAL;
    public static final int CHUNK_REAQ;
    private static DdmHandleHeap mInstance;

    static {
        CHUNK_HPIF = DdmHandleHeap.type((String)"HPIF");
        CHUNK_HPSG = DdmHandleHeap.type((String)"HPSG");
        CHUNK_HPDU = DdmHandleHeap.type((String)"HPDU");
        CHUNK_HPDS = DdmHandleHeap.type((String)"HPDS");
        CHUNK_NHSG = DdmHandleHeap.type((String)"NHSG");
        CHUNK_HPGC = DdmHandleHeap.type((String)"HPGC");
        CHUNK_REAE = DdmHandleHeap.type((String)"REAE");
        CHUNK_REAQ = DdmHandleHeap.type((String)"REAQ");
        CHUNK_REAL = DdmHandleHeap.type((String)"REAL");
        mInstance = new DdmHandleHeap();
    }

    private DdmHandleHeap() {
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk handleHPDS(Chunk chunk) {
        DdmHandleHeap.wrapChunk((Chunk)chunk);
        String string2 = null;
        try {
            Debug.dumpHprofDataDdms();
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            string2 = "hprof dumps not supported in this VM";
        }
        catch (RuntimeException runtimeException) {
            string2 = "Exception: " + runtimeException.getMessage();
        }
        if (string2 != null) {
            Log.w("ddm-heap", string2);
            return DdmHandleHeap.createFailChunk((int)1, (String)string2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private Chunk handleHPDU(Chunk chunk) {
        byte by;
        ByteBuffer byteBuffer = DdmHandleHeap.wrapChunk((Chunk)chunk);
        String string2 = DdmHandleHeap.getString((ByteBuffer)byteBuffer, (int)byteBuffer.getInt());
        try {
            Debug.dumpHprofData(string2);
            by = 0;
        }
        catch (UnsupportedOperationException unsupportedOperationException) {
            Log.w("ddm-heap", "hprof dumps not supported in this VM");
            by = -1;
        }
        catch (IOException iOException) {
            by = -1;
        }
        catch (RuntimeException runtimeException) {
            by = -1;
        }
        byte[] byArray = new byte[]{by};
        return new Chunk(CHUNK_HPDU, byArray, 0, byArray.length);
    }

    private Chunk handleHPGC(Chunk chunk) {
        Runtime.getRuntime().gc();
        return null;
    }

    private Chunk handleHPIF(Chunk chunk) {
        if (!DdmVmInternal.heapInfoNotify((int)DdmHandleHeap.wrapChunk((Chunk)chunk).get())) {
            return DdmHandleHeap.createFailChunk((int)1, (String)"Unsupported HPIF what");
        }
        return null;
    }

    private Chunk handleHPSGNHSG(Chunk chunk, boolean bl) {
        ByteBuffer byteBuffer = DdmHandleHeap.wrapChunk((Chunk)chunk);
        if (!DdmVmInternal.heapSegmentNotify((int)byteBuffer.get(), (int)byteBuffer.get(), (boolean)bl)) {
            return DdmHandleHeap.createFailChunk((int)1, (String)"Unsupported HPSG what/when");
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleREAE(Chunk chunk) {
        boolean bl = DdmHandleHeap.wrapChunk((Chunk)chunk).get() != 0;
        DdmVmInternal.enableRecentAllocations((boolean)bl);
        return null;
    }

    private Chunk handleREAL(Chunk chunk) {
        byte[] byArray = DdmVmInternal.getRecentAllocations();
        return new Chunk(CHUNK_REAL, byArray, 0, byArray.length);
    }

    /*
     * Enabled aggressive block sorting
     */
    private Chunk handleREAQ(Chunk chunk) {
        int n = 1;
        byte[] byArray = new byte[n];
        if (!DdmVmInternal.getRecentAllocationStatus()) {
            n = 0;
        }
        byArray[0] = n;
        return new Chunk(CHUNK_REAQ, byArray, 0, byArray.length);
    }

    public static void register() {
        DdmServer.registerHandler((int)CHUNK_HPIF, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPSG, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPDU, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPDS, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_NHSG, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_HPGC, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_REAE, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_REAQ, (ChunkHandler)mInstance);
        DdmServer.registerHandler((int)CHUNK_REAL, (ChunkHandler)mInstance);
    }

    public void connected() {
    }

    public void disconnected() {
    }

    public Chunk handleChunk(Chunk chunk) {
        int n = chunk.type;
        if (n == CHUNK_HPIF) {
            return this.handleHPIF(chunk);
        }
        if (n == CHUNK_HPSG) {
            return this.handleHPSGNHSG(chunk, false);
        }
        if (n == CHUNK_HPDU) {
            return this.handleHPDU(chunk);
        }
        if (n == CHUNK_HPDS) {
            return this.handleHPDS(chunk);
        }
        if (n == CHUNK_NHSG) {
            return this.handleHPSGNHSG(chunk, true);
        }
        if (n == CHUNK_HPGC) {
            return this.handleHPGC(chunk);
        }
        if (n == CHUNK_REAE) {
            return this.handleREAE(chunk);
        }
        if (n == CHUNK_REAQ) {
            return this.handleREAQ(chunk);
        }
        if (n == CHUNK_REAL) {
            return this.handleREAL(chunk);
        }
        throw new RuntimeException("Unknown packet " + ChunkHandler.name((int)n));
    }
}

