/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.sqlite.SQLiteConnection;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteGlobal;
import android.os.CancellationSignal;
import android.os.OperationCanceledException;
import android.os.SystemClock;
import android.util.Log;
import android.util.PrefixPrinter;
import android.util.Printer;
import dalvik.system.CloseGuard;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.locks.LockSupport;

public final class SQLiteConnectionPool
implements Closeable {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    public static final int CONNECTION_FLAG_INTERACTIVE = 4;
    public static final int CONNECTION_FLAG_PRIMARY_CONNECTION_AFFINITY = 2;
    public static final int CONNECTION_FLAG_READ_ONLY = 1;
    private static final long CONNECTION_POOL_BUSY_MILLIS = 30000L;
    private static final String TAG = "SQLiteConnectionPool";
    private final WeakHashMap<SQLiteConnection, AcquiredConnectionStatus> mAcquiredConnections;
    private final ArrayList<SQLiteConnection> mAvailableNonPrimaryConnections;
    private SQLiteConnection mAvailablePrimaryConnection;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final SQLiteDatabaseConfiguration mConfiguration;
    private final AtomicBoolean mConnectionLeaked;
    private ConnectionWaiter mConnectionWaiterPool;
    private ConnectionWaiter mConnectionWaiterQueue;
    private boolean mIsOpen;
    private final Object mLock = new Object();
    private int mMaxConnectionPoolSize;
    private int mNextConnectionId;

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !SQLiteConnectionPool.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    private SQLiteConnectionPool(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        this.mConnectionLeaked = new AtomicBoolean();
        this.mAvailableNonPrimaryConnections = new ArrayList();
        this.mAcquiredConnections = new WeakHashMap();
        this.mConfiguration = new SQLiteDatabaseConfiguration(sQLiteDatabaseConfiguration);
        this.setMaxConnectionPoolSizeLocked();
    }

    /*
     * Enabled aggressive block sorting
     */
    private void cancelConnectionWaiterLocked(ConnectionWaiter connectionWaiter) {
        if (connectionWaiter.mAssignedConnection != null || connectionWaiter.mException != null) {
            return;
        }
        ConnectionWaiter connectionWaiter2 = null;
        ConnectionWaiter connectionWaiter3 = this.mConnectionWaiterQueue;
        while (connectionWaiter3 != connectionWaiter) {
            if (!$assertionsDisabled && connectionWaiter3 == null) {
                throw new AssertionError();
            }
            connectionWaiter2 = connectionWaiter3;
            connectionWaiter3 = connectionWaiter3.mNext;
        }
        if (connectionWaiter2 != null) {
            connectionWaiter2.mNext = connectionWaiter.mNext;
        } else {
            this.mConnectionWaiterQueue = connectionWaiter.mNext;
        }
        connectionWaiter.mException = new OperationCanceledException();
        LockSupport.unpark(connectionWaiter.mThread);
        this.wakeConnectionWaitersLocked();
    }

    private void closeAvailableConnectionsAndLogExceptionsLocked() {
        this.closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked();
        if (this.mAvailablePrimaryConnection != null) {
            this.closeConnectionAndLogExceptionsLocked(this.mAvailablePrimaryConnection);
            this.mAvailablePrimaryConnection = null;
        }
    }

    private void closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked() {
        int n = this.mAvailableNonPrimaryConnections.size();
        for (int i = 0; i < n; ++i) {
            this.closeConnectionAndLogExceptionsLocked(this.mAvailableNonPrimaryConnections.get(i));
        }
        this.mAvailableNonPrimaryConnections.clear();
    }

    private void closeConnectionAndLogExceptionsLocked(SQLiteConnection sQLiteConnection) {
        try {
            sQLiteConnection.close();
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e(TAG, "Failed to close connection, its fate is now in the hands of the merciful GC: " + sQLiteConnection, runtimeException);
            return;
        }
    }

    private void closeExcessConnectionsAndLogExceptionsLocked() {
        int n = this.mAvailableNonPrimaryConnections.size();
        while (true) {
            int n2 = n - 1;
            if (n <= -1 + this.mMaxConnectionPoolSize) break;
            this.closeConnectionAndLogExceptionsLocked(this.mAvailableNonPrimaryConnections.remove(n2));
            n = n2;
        }
    }

    private void discardAcquiredConnectionsLocked() {
        this.markAcquiredConnectionsLocked(AcquiredConnectionStatus.DISCARD);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void dispose(boolean bl) {
        if (this.mCloseGuard != null) {
            if (bl) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (bl) {
            return;
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfClosedLocked();
            this.mIsOpen = false;
            this.closeAvailableConnectionsAndLogExceptionsLocked();
            int n = this.mAcquiredConnections.size();
            if (n != 0) {
                Log.i(TAG, "The connection pool for " + this.mConfiguration.label + " has been closed but there are still " + n + " connections in use.  They will be closed " + "as they are released back to the pool.");
            }
            this.wakeConnectionWaitersLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void finishAcquireConnectionLocked(SQLiteConnection sQLiteConnection, int n) {
        boolean bl = (n & 1) != 0;
        try {
            sQLiteConnection.setOnlyAllowReadOnlyOperations(bl);
            this.mAcquiredConnections.put(sQLiteConnection, AcquiredConnectionStatus.NORMAL);
            return;
        }
        catch (RuntimeException runtimeException) {
            Log.e(TAG, "Failed to prepare acquired connection for session, closing it: " + sQLiteConnection + ", connectionFlags=" + n);
            this.closeConnectionAndLogExceptionsLocked(sQLiteConnection);
            throw runtimeException;
        }
    }

    private static int getPriority(int n) {
        if ((n & 4) != 0) {
            return 1;
        }
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isSessionBlockingImportantConnectionWaitersLocked(boolean bl, int n) {
        ConnectionWaiter connectionWaiter = this.mConnectionWaiterQueue;
        if (connectionWaiter == null) return false;
        int n2 = SQLiteConnectionPool.getPriority(n);
        do {
            if (n2 > connectionWaiter.mPriority) {
                return false;
            }
            if (bl) return true;
            if (connectionWaiter.mWantPrimaryConnection) continue;
            return true;
        } while ((connectionWaiter = connectionWaiter.mNext) != null);
        return false;
    }

    private void logConnectionPoolBusyLocked(long l, int n) {
        Thread thread = Thread.currentThread();
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("The connection pool for database '").append(this.mConfiguration.label);
        stringBuilder.append("' has been unable to grant a connection to thread ");
        stringBuilder.append(thread.getId()).append(" (").append(thread.getName()).append(") ");
        stringBuilder.append("with flags 0x").append(Integer.toHexString(n));
        stringBuilder.append(" for ").append(0.001f * (float)l).append(" seconds.\n");
        ArrayList<String> arrayList = new ArrayList<String>();
        boolean bl = this.mAcquiredConnections.isEmpty();
        int n2 = 0;
        int n3 = 0;
        if (!bl) {
            Iterator<SQLiteConnection> iterator = this.mAcquiredConnections.keySet().iterator();
            while (iterator.hasNext()) {
                String string2 = iterator.next().describeCurrentOperationUnsafe();
                if (string2 != null) {
                    arrayList.add(string2);
                    ++n2;
                    continue;
                }
                ++n3;
            }
        }
        int n4 = this.mAvailableNonPrimaryConnections.size();
        if (this.mAvailablePrimaryConnection != null) {
            ++n4;
        }
        stringBuilder.append("Connections: ").append(n2).append(" active, ");
        stringBuilder.append(n3).append(" idle, ");
        stringBuilder.append(n4).append(" available.\n");
        if (!arrayList.isEmpty()) {
            stringBuilder.append("\nRequests in progress:\n");
            for (String string3 : arrayList) {
                stringBuilder.append("  ").append(string3).append("\n");
            }
        }
        Log.w(TAG, stringBuilder.toString());
    }

    private void markAcquiredConnectionsLocked(AcquiredConnectionStatus acquiredConnectionStatus) {
        if (!this.mAcquiredConnections.isEmpty()) {
            ArrayList<SQLiteConnection> arrayList = new ArrayList<SQLiteConnection>(this.mAcquiredConnections.size());
            for (Map.Entry<SQLiteConnection, AcquiredConnectionStatus> entry : this.mAcquiredConnections.entrySet()) {
                AcquiredConnectionStatus acquiredConnectionStatus2 = entry.getValue();
                if (acquiredConnectionStatus == acquiredConnectionStatus2 || acquiredConnectionStatus2 == AcquiredConnectionStatus.DISCARD) continue;
                arrayList.add(entry.getKey());
            }
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                this.mAcquiredConnections.put((SQLiteConnection)arrayList.get(i), acquiredConnectionStatus);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private ConnectionWaiter obtainConnectionWaiterLocked(Thread thread, long l, int n, boolean bl, String string2, int n2) {
        ConnectionWaiter connectionWaiter = this.mConnectionWaiterPool;
        if (connectionWaiter != null) {
            this.mConnectionWaiterPool = connectionWaiter.mNext;
            connectionWaiter.mNext = null;
        } else {
            connectionWaiter = new ConnectionWaiter();
        }
        connectionWaiter.mThread = thread;
        connectionWaiter.mStartTime = l;
        connectionWaiter.mPriority = n;
        connectionWaiter.mWantPrimaryConnection = bl;
        connectionWaiter.mSql = string2;
        connectionWaiter.mConnectionFlags = n2;
        return connectionWaiter;
    }

    public static SQLiteConnectionPool open(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        if (sQLiteDatabaseConfiguration == null) {
            throw new IllegalArgumentException("configuration must not be null.");
        }
        SQLiteConnectionPool sQLiteConnectionPool = new SQLiteConnectionPool(sQLiteDatabaseConfiguration);
        sQLiteConnectionPool.open();
        return sQLiteConnectionPool;
    }

    private void open() {
        this.mAvailablePrimaryConnection = this.openConnectionLocked(this.mConfiguration, true);
        this.mIsOpen = true;
        this.mCloseGuard.open("close");
    }

    private SQLiteConnection openConnectionLocked(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration, boolean bl) {
        int n = this.mNextConnectionId;
        this.mNextConnectionId = n + 1;
        return SQLiteConnection.open(this, sQLiteDatabaseConfiguration, n, bl);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void reconfigureAllConnectionsLocked() {
        if (this.mAvailablePrimaryConnection != null) {
            try {
                this.mAvailablePrimaryConnection.reconfigure(this.mConfiguration);
            }
            catch (RuntimeException runtimeException) {
                Log.e(TAG, "Failed to reconfigure available primary connection, closing it: " + this.mAvailablePrimaryConnection, runtimeException);
                this.closeConnectionAndLogExceptionsLocked(this.mAvailablePrimaryConnection);
                this.mAvailablePrimaryConnection = null;
            }
        }
        int n = this.mAvailableNonPrimaryConnections.size();
        int n2 = 0;
        while (true) {
            int n3;
            if (n2 >= n) {
                this.markAcquiredConnectionsLocked(AcquiredConnectionStatus.RECONFIGURE);
                return;
            }
            SQLiteConnection sQLiteConnection = this.mAvailableNonPrimaryConnections.get(n2);
            try {
                sQLiteConnection.reconfigure(this.mConfiguration);
                n3 = n2;
            }
            catch (RuntimeException runtimeException) {
                Log.e(TAG, "Failed to reconfigure available non-primary connection, closing it: " + sQLiteConnection, runtimeException);
                this.closeConnectionAndLogExceptionsLocked(sQLiteConnection);
                ArrayList<SQLiteConnection> arrayList = this.mAvailableNonPrimaryConnections;
                n3 = n2 - 1;
                arrayList.remove(n2);
                --n;
            }
            n2 = n3 + 1;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean recycleConnectionLocked(SQLiteConnection sQLiteConnection, AcquiredConnectionStatus acquiredConnectionStatus) {
        if (acquiredConnectionStatus == AcquiredConnectionStatus.RECONFIGURE) {
            try {
                sQLiteConnection.reconfigure(this.mConfiguration);
            }
            catch (RuntimeException runtimeException) {
                Log.e(TAG, "Failed to reconfigure released connection, closing it: " + sQLiteConnection, runtimeException);
                acquiredConnectionStatus = AcquiredConnectionStatus.DISCARD;
            }
        }
        if (acquiredConnectionStatus == AcquiredConnectionStatus.DISCARD) {
            this.closeConnectionAndLogExceptionsLocked(sQLiteConnection);
            return false;
        }
        return true;
    }

    private void recycleConnectionWaiterLocked(ConnectionWaiter connectionWaiter) {
        connectionWaiter.mNext = this.mConnectionWaiterPool;
        connectionWaiter.mThread = null;
        connectionWaiter.mSql = null;
        connectionWaiter.mAssignedConnection = null;
        connectionWaiter.mException = null;
        connectionWaiter.mNonce = 1 + connectionWaiter.mNonce;
        this.mConnectionWaiterPool = connectionWaiter;
    }

    private void setMaxConnectionPoolSizeLocked() {
        if ((0x20000000 & this.mConfiguration.openFlags) != 0) {
            this.mMaxConnectionPoolSize = SQLiteGlobal.getWALConnectionPoolSize();
            return;
        }
        this.mMaxConnectionPoolSize = 1;
    }

    private void throwIfClosedLocked() {
        if (!this.mIsOpen) {
            throw new IllegalStateException("Cannot perform this operation because the connection pool has been closed.");
        }
    }

    private SQLiteConnection tryAcquireNonPrimaryConnectionLocked(String string2, int n) {
        int n2 = this.mAvailableNonPrimaryConnections.size();
        if (n2 > 1 && string2 != null) {
            for (int i = 0; i < n2; ++i) {
                SQLiteConnection sQLiteConnection = this.mAvailableNonPrimaryConnections.get(i);
                if (!sQLiteConnection.isPreparedStatementInCache(string2)) continue;
                this.mAvailableNonPrimaryConnections.remove(i);
                this.finishAcquireConnectionLocked(sQLiteConnection, n);
                return sQLiteConnection;
            }
        }
        if (n2 > 0) {
            SQLiteConnection sQLiteConnection = this.mAvailableNonPrimaryConnections.remove(n2 - 1);
            this.finishAcquireConnectionLocked(sQLiteConnection, n);
            return sQLiteConnection;
        }
        int n3 = this.mAcquiredConnections.size();
        if (this.mAvailablePrimaryConnection != null) {
            ++n3;
        }
        if (n3 >= this.mMaxConnectionPoolSize) {
            return null;
        }
        SQLiteConnection sQLiteConnection = this.openConnectionLocked(this.mConfiguration, false);
        this.finishAcquireConnectionLocked(sQLiteConnection, n);
        return sQLiteConnection;
    }

    private SQLiteConnection tryAcquirePrimaryConnectionLocked(int n) {
        SQLiteConnection sQLiteConnection = this.mAvailablePrimaryConnection;
        if (sQLiteConnection != null) {
            this.mAvailablePrimaryConnection = null;
            this.finishAcquireConnectionLocked(sQLiteConnection, n);
            return sQLiteConnection;
        }
        Iterator<SQLiteConnection> iterator = this.mAcquiredConnections.keySet().iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().isPrimaryConnection()) continue;
            return null;
        }
        SQLiteConnection sQLiteConnection2 = this.openConnectionLocked(this.mConfiguration, true);
        this.finishAcquireConnectionLocked(sQLiteConnection2, n);
        return sQLiteConnection2;
    }

    /*
     * Exception decompiling
     */
    private SQLiteConnection waitForConnection(String var1_1, int var2_2, CancellationSignal var3_3) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 16[TRYBLOCK] [19 : 319->322)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void wakeConnectionWaitersLocked() {
        ConnectionWaiter connectionWaiter = null;
        ConnectionWaiter connectionWaiter2 = this.mConnectionWaiterQueue;
        boolean bl = false;
        boolean bl2 = false;
        while (connectionWaiter2 != null) {
            boolean bl3;
            block15: {
                if (!this.mIsOpen) {
                    bl3 = true;
                } else {
                    try {
                        boolean bl4 = connectionWaiter2.mWantPrimaryConnection;
                        SQLiteConnection sQLiteConnection = null;
                        if (!bl4) {
                            sQLiteConnection = null;
                            if (!bl2 && (sQLiteConnection = this.tryAcquireNonPrimaryConnectionLocked(connectionWaiter2.mSql, connectionWaiter2.mConnectionFlags)) == null) {
                                bl2 = true;
                            }
                        }
                        if (sQLiteConnection == null && !bl && (sQLiteConnection = this.tryAcquirePrimaryConnectionLocked(connectionWaiter2.mConnectionFlags)) == null) {
                            bl = true;
                        }
                        if (sQLiteConnection != null) {
                            connectionWaiter2.mAssignedConnection = sQLiteConnection;
                            bl3 = true;
                            break block15;
                        }
                        bl3 = false;
                        if (bl2) {
                            bl3 = false;
                            if (bl) {
                                return;
                            }
                        }
                    }
                    catch (RuntimeException runtimeException) {
                        connectionWaiter2.mException = runtimeException;
                        bl3 = true;
                    }
                }
            }
            ConnectionWaiter connectionWaiter3 = connectionWaiter2.mNext;
            if (bl3) {
                if (connectionWaiter != null) {
                    connectionWaiter.mNext = connectionWaiter3;
                } else {
                    this.mConnectionWaiterQueue = connectionWaiter3;
                }
                connectionWaiter2.mNext = null;
                LockSupport.unpark(connectionWaiter2.mThread);
            } else {
                connectionWaiter = connectionWaiter2;
            }
            connectionWaiter2 = connectionWaiter3;
        }
    }

    public SQLiteConnection acquireConnection(String string2, int n, CancellationSignal cancellationSignal) {
        return this.waitForConnection(string2, n, cancellationSignal);
    }

    @Override
    public void close() {
        this.dispose(false);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void collectDbStats(ArrayList<SQLiteDebug.DbStats> arrayList) {
        Object object = this.mLock;
        synchronized (object) {
            if (this.mAvailablePrimaryConnection != null) {
                this.mAvailablePrimaryConnection.collectDbStats(arrayList);
            }
            Iterator<SQLiteConnection> iterator = this.mAvailableNonPrimaryConnections.iterator();
            while (iterator.hasNext()) {
                iterator.next().collectDbStats(arrayList);
            }
            Iterator<SQLiteConnection> iterator2 = this.mAcquiredConnections.keySet().iterator();
            while (iterator2.hasNext()) {
                iterator2.next().collectDbStatsUnsafe(arrayList);
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void dump(Printer printer, boolean bl) {
        Printer printer2 = PrefixPrinter.create(printer, "    ");
        Object object = this.mLock;
        synchronized (object) {
            printer.println("Connection pool for " + this.mConfiguration.path + ":");
            printer.println("  Open: " + this.mIsOpen);
            printer.println("  Max connections: " + this.mMaxConnectionPoolSize);
            printer.println("  Available primary connection:");
            if (this.mAvailablePrimaryConnection != null) {
                this.mAvailablePrimaryConnection.dump(printer2, bl);
            } else {
                printer2.println("<none>");
            }
            printer.println("  Available non-primary connections:");
            if (!this.mAvailableNonPrimaryConnections.isEmpty()) {
                int n = this.mAvailableNonPrimaryConnections.size();
                for (int i = 0; i < n; ++i) {
                    this.mAvailableNonPrimaryConnections.get(i).dump(printer2, bl);
                }
            } else {
                printer2.println("<none>");
            }
            printer.println("  Acquired connections:");
            if (!this.mAcquiredConnections.isEmpty()) {
                for (Map.Entry<SQLiteConnection, AcquiredConnectionStatus> entry : this.mAcquiredConnections.entrySet()) {
                    entry.getKey().dumpUnsafe(printer2, bl);
                    printer2.println("  Status: " + (Object)((Object)entry.getValue()));
                }
            } else {
                printer2.println("<none>");
            }
            printer.println("  Connection waiters:");
            if (this.mConnectionWaiterQueue != null) {
                int n = 0;
                long l = SystemClock.uptimeMillis();
                ConnectionWaiter connectionWaiter = this.mConnectionWaiterQueue;
                while (connectionWaiter != null) {
                    printer2.println(n + ": waited for " + 0.001f * (float)(l - connectionWaiter.mStartTime) + " ms - thread=" + connectionWaiter.mThread + ", priority=" + connectionWaiter.mPriority + ", sql='" + connectionWaiter.mSql + "'");
                    connectionWaiter = connectionWaiter.mNext;
                    ++n;
                }
            } else {
                printer2.println("<none>");
            }
            return;
        }
    }

    protected void finalize() throws Throwable {
        try {
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    void onConnectionLeaked() {
        Log.w(TAG, "A SQLiteConnection object for database '" + this.mConfiguration.label + "' was leaked!  Please fix your application " + "to end transactions in progress properly and to close the database " + "when it is no longer needed.");
        this.mConnectionLeaked.set(true);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void reconfigure(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        boolean bl = true;
        if (sQLiteDatabaseConfiguration == null) {
            throw new IllegalArgumentException("configuration must not be null.");
        }
        Object object = this.mLock;
        synchronized (object) {
            this.throwIfClosedLocked();
            boolean bl2 = (0x20000000 & (sQLiteDatabaseConfiguration.openFlags ^ this.mConfiguration.openFlags)) != 0 ? bl : false;
            if (bl2) {
                if (!this.mAcquiredConnections.isEmpty()) {
                    throw new IllegalStateException("Write Ahead Logging (WAL) mode cannot be enabled or disabled while there are transactions in progress.  Finish all transactions and release all active database connections first.");
                }
                this.closeAvailableNonPrimaryConnectionsAndLogExceptionsLocked();
                if (!$assertionsDisabled && !this.mAvailableNonPrimaryConnections.isEmpty()) {
                    throw new AssertionError();
                }
            }
            if (sQLiteDatabaseConfiguration.foreignKeyConstraintsEnabled == this.mConfiguration.foreignKeyConstraintsEnabled) {
                bl = false;
            }
            if (bl && !this.mAcquiredConnections.isEmpty()) {
                throw new IllegalStateException("Foreign Key Constraints cannot be enabled or disabled while there are transactions in progress.  Finish all transactions and release all active database connections first.");
            }
            if (this.mConfiguration.openFlags != sQLiteDatabaseConfiguration.openFlags) {
                if (bl2) {
                    this.closeAvailableConnectionsAndLogExceptionsLocked();
                }
                SQLiteConnection sQLiteConnection = this.openConnectionLocked(sQLiteDatabaseConfiguration, true);
                this.closeAvailableConnectionsAndLogExceptionsLocked();
                this.discardAcquiredConnectionsLocked();
                this.mAvailablePrimaryConnection = sQLiteConnection;
                this.mConfiguration.updateParametersFrom(sQLiteDatabaseConfiguration);
                this.setMaxConnectionPoolSizeLocked();
            } else {
                this.mConfiguration.updateParametersFrom(sQLiteDatabaseConfiguration);
                this.setMaxConnectionPoolSizeLocked();
                this.closeExcessConnectionsAndLogExceptionsLocked();
                this.reconfigureAllConnectionsLocked();
            }
            this.wakeConnectionWaitersLocked();
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void releaseConnection(SQLiteConnection sQLiteConnection) {
        Object object = this.mLock;
        synchronized (object) {
            AcquiredConnectionStatus acquiredConnectionStatus = this.mAcquiredConnections.remove(sQLiteConnection);
            if (acquiredConnectionStatus == null) {
                throw new IllegalStateException("Cannot perform this operation because the specified connection was not acquired from this pool or has already been released.");
            }
            if (!this.mIsOpen) {
                this.closeConnectionAndLogExceptionsLocked(sQLiteConnection);
            } else if (sQLiteConnection.isPrimaryConnection()) {
                if (this.recycleConnectionLocked(sQLiteConnection, acquiredConnectionStatus)) {
                    if (!$assertionsDisabled && this.mAvailablePrimaryConnection != null) {
                        throw new AssertionError();
                    }
                    this.mAvailablePrimaryConnection = sQLiteConnection;
                }
                this.wakeConnectionWaitersLocked();
            } else if (this.mAvailableNonPrimaryConnections.size() >= -1 + this.mMaxConnectionPoolSize) {
                this.closeConnectionAndLogExceptionsLocked(sQLiteConnection);
            } else {
                if (this.recycleConnectionLocked(sQLiteConnection, acquiredConnectionStatus)) {
                    this.mAvailableNonPrimaryConnections.add(sQLiteConnection);
                }
                this.wakeConnectionWaitersLocked();
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public boolean shouldYieldConnection(SQLiteConnection sQLiteConnection, int n) {
        Object object = this.mLock;
        synchronized (object) {
            if (!this.mAcquiredConnections.containsKey(sQLiteConnection)) {
                throw new IllegalStateException("Cannot perform this operation because the specified connection was not acquired from this pool or has already been released.");
            }
            if (this.mIsOpen) return this.isSessionBlockingImportantConnectionWaitersLocked(sQLiteConnection.isPrimaryConnection(), n);
            return false;
        }
    }

    public String toString() {
        return "SQLiteConnectionPool: " + this.mConfiguration.path;
    }

    static final class AcquiredConnectionStatus
    extends Enum<AcquiredConnectionStatus> {
        private static final /* synthetic */ AcquiredConnectionStatus[] $VALUES;
        public static final /* enum */ AcquiredConnectionStatus DISCARD;
        public static final /* enum */ AcquiredConnectionStatus NORMAL;
        public static final /* enum */ AcquiredConnectionStatus RECONFIGURE;

        static {
            NORMAL = new AcquiredConnectionStatus();
            RECONFIGURE = new AcquiredConnectionStatus();
            DISCARD = new AcquiredConnectionStatus();
            AcquiredConnectionStatus[] acquiredConnectionStatusArray = new AcquiredConnectionStatus[]{NORMAL, RECONFIGURE, DISCARD};
            $VALUES = acquiredConnectionStatusArray;
        }

        public static AcquiredConnectionStatus valueOf(String string2) {
            return Enum.valueOf(AcquiredConnectionStatus.class, string2);
        }

        public static AcquiredConnectionStatus[] values() {
            return (AcquiredConnectionStatus[])$VALUES.clone();
        }
    }

    private static final class ConnectionWaiter {
        public SQLiteConnection mAssignedConnection;
        public int mConnectionFlags;
        public RuntimeException mException;
        public ConnectionWaiter mNext;
        public int mNonce;
        public int mPriority;
        public String mSql;
        public long mStartTime;
        public Thread mThread;
        public boolean mWantPrimaryConnection;

        private ConnectionWaiter() {
        }
    }
}

