/*
 * Decompiled with CFR 0.152.
 */
package android.database.sqlite;

import android.database.CursorWindow;
import android.database.DatabaseUtils;
import android.database.sqlite.SQLiteBindOrColumnIndexOutOfRangeException;
import android.database.sqlite.SQLiteConnectionPool;
import android.database.sqlite.SQLiteCustomFunction;
import android.database.sqlite.SQLiteDatabaseConfiguration;
import android.database.sqlite.SQLiteDatabaseLockedException;
import android.database.sqlite.SQLiteDebug;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteGlobal;
import android.database.sqlite.SQLiteStatementInfo;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.util.Log;
import android.util.LruCache;
import android.util.Printer;
import dalvik.system.BlockGuard;
import dalvik.system.CloseGuard;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import java.util.regex.Pattern;

public final class SQLiteConnection
implements CancellationSignal.OnCancelListener {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final boolean DEBUG = false;
    private static final byte[] EMPTY_BYTE_ARRAY;
    private static final String[] EMPTY_STRING_ARRAY;
    private static final String TAG = "SQLiteConnection";
    private static final Pattern TRIM_SQL_PATTERN;
    private int mCancellationSignalAttachCount;
    private final CloseGuard mCloseGuard = CloseGuard.get();
    private final SQLiteDatabaseConfiguration mConfiguration;
    private final int mConnectionId;
    private long mConnectionPtr;
    private final boolean mIsPrimaryConnection;
    private final boolean mIsReadOnlyConnection;
    private boolean mOnlyAllowReadOnlyOperations;
    private final SQLiteConnectionPool mPool;
    private final PreparedStatementCache mPreparedStatementCache;
    private PreparedStatement mPreparedStatementPool;
    private final OperationLog mRecentOperations = new OperationLog();

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !SQLiteConnection.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
        EMPTY_STRING_ARRAY = new String[0];
        EMPTY_BYTE_ARRAY = new byte[0];
        TRIM_SQL_PATTERN = Pattern.compile("[\\s]*\\n+[\\s]*");
    }

    /*
     * Enabled aggressive block sorting
     */
    private SQLiteConnection(SQLiteConnectionPool sQLiteConnectionPool, SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration, int n, boolean bl) {
        this.mPool = sQLiteConnectionPool;
        this.mConfiguration = new SQLiteDatabaseConfiguration(sQLiteDatabaseConfiguration);
        this.mConnectionId = n;
        this.mIsPrimaryConnection = bl;
        boolean bl2 = (1 & sQLiteDatabaseConfiguration.openFlags) != 0;
        this.mIsReadOnlyConnection = bl2;
        this.mPreparedStatementCache = new PreparedStatementCache(this.mConfiguration.maxSqlCacheSize);
        this.mCloseGuard.open("close");
    }

    private PreparedStatement acquirePreparedStatement(String string2) {
        PreparedStatement preparedStatement;
        block6: {
            int n;
            preparedStatement = (PreparedStatement)this.mPreparedStatementCache.get(string2);
            boolean bl = false;
            if (preparedStatement != null) {
                if (!preparedStatement.mInUse) {
                    return preparedStatement;
                }
                bl = true;
            }
            long l = SQLiteConnection.nativePrepareStatement(this.mConnectionPtr, string2);
            try {
                int n2 = SQLiteConnection.nativeGetParameterCount(this.mConnectionPtr, l);
                n = DatabaseUtils.getSqlStatementType(string2);
                preparedStatement = this.obtainPreparedStatement(string2, l, n2, n, SQLiteConnection.nativeIsReadOnly(this.mConnectionPtr, l));
                if (bl) break block6;
            }
            catch (RuntimeException runtimeException) {
                if (preparedStatement == null || !preparedStatement.mInCache) {
                    SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, l);
                }
                throw runtimeException;
            }
            if (!SQLiteConnection.isCacheable(n)) break block6;
            this.mPreparedStatementCache.put(string2, preparedStatement);
            preparedStatement.mInCache = true;
        }
        preparedStatement.mInUse = true;
        return preparedStatement;
    }

    private void applyBlockGuardPolicy(PreparedStatement preparedStatement) {
        block3: {
            block2: {
                if (this.mConfiguration.isInMemoryDb()) break block2;
                if (!preparedStatement.mReadOnly) break block3;
                BlockGuard.getThreadPolicy().onReadFromDisk();
            }
            return;
        }
        BlockGuard.getThreadPolicy().onWriteToDisk();
    }

    private void attachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            cancellationSignal.throwIfCanceled();
            this.mCancellationSignalAttachCount = 1 + this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 1) {
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, true);
                cancellationSignal.setOnCancelListener(this);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void bindArguments(PreparedStatement preparedStatement, Object[] objectArray) {
        block9: {
            int n = objectArray != null ? objectArray.length : 0;
            if (n != preparedStatement.mNumParameters) {
                throw new SQLiteBindOrColumnIndexOutOfRangeException("Expected " + preparedStatement.mNumParameters + " bind arguments but " + n + " were provided.");
            }
            if (n == 0) break block9;
            long l = preparedStatement.mStatementPtr;
            block6: for (int i = 0; i < n; ++i) {
                Object object;
                block10: {
                    long l2;
                    int n2;
                    long l3;
                    object = objectArray[i];
                    switch (DatabaseUtils.getTypeOfObject(object)) {
                        default: {
                            if (object instanceof Boolean) {
                                l3 = this.mConnectionPtr;
                                n2 = i + 1;
                                l2 = (Boolean)object != false ? 1L : 0L;
                            }
                            break block10;
                        }
                        case 0: {
                            SQLiteConnection.nativeBindNull(this.mConnectionPtr, l, i + 1);
                            continue block6;
                        }
                        case 1: {
                            SQLiteConnection.nativeBindLong(this.mConnectionPtr, l, i + 1, ((Number)object).longValue());
                            continue block6;
                        }
                        case 2: {
                            SQLiteConnection.nativeBindDouble(this.mConnectionPtr, l, i + 1, ((Number)object).doubleValue());
                            continue block6;
                        }
                        case 4: {
                            SQLiteConnection.nativeBindBlob(this.mConnectionPtr, l, i + 1, (byte[])object);
                            continue block6;
                        }
                    }
                    SQLiteConnection.nativeBindLong(l3, l, n2, l2);
                    continue;
                }
                SQLiteConnection.nativeBindString(this.mConnectionPtr, l, i + 1, object.toString());
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static String canonicalizeSyncMode(String string2) {
        if (string2.equals("0")) {
            return "OFF";
        }
        if (string2.equals("1")) {
            return "NORMAL";
        }
        if (!string2.equals("2")) return string2;
        return "FULL";
    }

    private void detachCancellationSignal(CancellationSignal cancellationSignal) {
        if (cancellationSignal != null) {
            if (!$assertionsDisabled && this.mCancellationSignalAttachCount <= 0) {
                throw new AssertionError();
            }
            this.mCancellationSignalAttachCount = -1 + this.mCancellationSignalAttachCount;
            if (this.mCancellationSignalAttachCount == 0) {
                cancellationSignal.setOnCancelListener(null);
                SQLiteConnection.nativeResetCancel(this.mConnectionPtr, false);
            }
        }
    }

    private void dispose(boolean bl) {
        int n;
        if (this.mCloseGuard != null) {
            if (bl) {
                this.mCloseGuard.warnIfOpen();
            }
            this.mCloseGuard.close();
        }
        if (this.mConnectionPtr != 0L) {
            n = this.mRecentOperations.beginOperation("close", null, null);
            this.mPreparedStatementCache.evictAll();
            SQLiteConnection.nativeClose(this.mConnectionPtr);
            this.mConnectionPtr = 0L;
        }
        return;
        finally {
            this.mRecentOperations.endOperation(n);
        }
    }

    private void finalizePreparedStatement(PreparedStatement preparedStatement) {
        SQLiteConnection.nativeFinalizeStatement(this.mConnectionPtr, preparedStatement.mStatementPtr);
        this.recyclePreparedStatement(preparedStatement);
    }

    private SQLiteDebug.DbStats getMainDbStatsUnsafe(int n, long l, long l2) {
        String string2 = this.mConfiguration.path;
        if (!this.mIsPrimaryConnection) {
            string2 = string2 + " (" + this.mConnectionId + ")";
        }
        return new SQLiteDebug.DbStats(string2, l, l2, n, this.mPreparedStatementCache.hitCount(), this.mPreparedStatementCache.missCount(), this.mPreparedStatementCache.size());
    }

    private static boolean isCacheable(int n) {
        return n == 2 || n == 1;
    }

    private static native void nativeBindBlob(long var0, long var2, int var4, byte[] var5);

    private static native void nativeBindDouble(long var0, long var2, int var4, double var5);

    private static native void nativeBindLong(long var0, long var2, int var4, long var5);

    private static native void nativeBindNull(long var0, long var2, int var4);

    private static native void nativeBindString(long var0, long var2, int var4, String var5);

    private static native void nativeCancel(long var0);

    private static native void nativeClose(long var0);

    private static native void nativeExecute(long var0, long var2);

    private static native int nativeExecuteForBlobFileDescriptor(long var0, long var2);

    private static native int nativeExecuteForChangedRowCount(long var0, long var2);

    private static native long nativeExecuteForCursorWindow(long var0, long var2, long var4, int var6, int var7, boolean var8);

    private static native long nativeExecuteForLastInsertedRowId(long var0, long var2);

    private static native long nativeExecuteForLong(long var0, long var2);

    private static native String nativeExecuteForString(long var0, long var2);

    private static native void nativeFinalizeStatement(long var0, long var2);

    private static native int nativeGetColumnCount(long var0, long var2);

    private static native String nativeGetColumnName(long var0, long var2, int var4);

    private static native int nativeGetDbLookaside(long var0);

    private static native int nativeGetParameterCount(long var0, long var2);

    private static native boolean nativeIsReadOnly(long var0, long var2);

    private static native long nativeOpen(String var0, int var1, String var2, boolean var3, boolean var4);

    private static native long nativePrepareStatement(long var0, String var2);

    private static native void nativeRegisterCustomFunction(long var0, SQLiteCustomFunction var2);

    private static native void nativeRegisterLocalizedCollators(long var0, String var2);

    private static native void nativeResetCancel(long var0, boolean var2);

    private static native void nativeResetStatementAndClearBindings(long var0, long var2);

    /*
     * Enabled aggressive block sorting
     */
    private PreparedStatement obtainPreparedStatement(String string2, long l, int n, int n2, boolean bl) {
        PreparedStatement preparedStatement = this.mPreparedStatementPool;
        if (preparedStatement != null) {
            this.mPreparedStatementPool = preparedStatement.mPoolNext;
            preparedStatement.mPoolNext = null;
            preparedStatement.mInCache = false;
        } else {
            preparedStatement = new PreparedStatement();
        }
        preparedStatement.mSql = string2;
        preparedStatement.mStatementPtr = l;
        preparedStatement.mNumParameters = n;
        preparedStatement.mType = n2;
        preparedStatement.mReadOnly = bl;
        return preparedStatement;
    }

    static SQLiteConnection open(SQLiteConnectionPool sQLiteConnectionPool, SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration, int n, boolean bl) {
        SQLiteConnection sQLiteConnection = new SQLiteConnection(sQLiteConnectionPool, sQLiteDatabaseConfiguration, n, bl);
        try {
            sQLiteConnection.open();
            return sQLiteConnection;
        }
        catch (SQLiteException sQLiteException) {
            sQLiteConnection.dispose(false);
            throw sQLiteException;
        }
    }

    private void open() {
        this.mConnectionPtr = SQLiteConnection.nativeOpen(this.mConfiguration.path, this.mConfiguration.openFlags, this.mConfiguration.label, SQLiteDebug.DEBUG_SQL_STATEMENTS, SQLiteDebug.DEBUG_SQL_TIME);
        this.setPageSize();
        this.setForeignKeyModeFromConfiguration();
        this.setWalModeFromConfiguration();
        this.setJournalSizeLimit();
        this.setAutoCheckpointInterval();
        this.setLocaleFromConfiguration();
        int n = this.mConfiguration.customFunctions.size();
        for (int i = 0; i < n; ++i) {
            SQLiteCustomFunction sQLiteCustomFunction = this.mConfiguration.customFunctions.get(i);
            SQLiteConnection.nativeRegisterCustomFunction(this.mConnectionPtr, sQLiteCustomFunction);
        }
    }

    private void recyclePreparedStatement(PreparedStatement preparedStatement) {
        preparedStatement.mSql = null;
        preparedStatement.mPoolNext = this.mPreparedStatementPool;
        this.mPreparedStatementPool = preparedStatement;
    }

    private void releasePreparedStatement(PreparedStatement preparedStatement) {
        preparedStatement.mInUse = false;
        if (preparedStatement.mInCache) {
            try {
                SQLiteConnection.nativeResetStatementAndClearBindings(this.mConnectionPtr, preparedStatement.mStatementPtr);
                return;
            }
            catch (SQLiteException sQLiteException) {
                this.mPreparedStatementCache.remove(preparedStatement.mSql);
                return;
            }
        }
        this.finalizePreparedStatement(preparedStatement);
    }

    private void setAutoCheckpointInterval() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long l = SQLiteGlobal.getWALAutoCheckpoint();
            if (this.executeForLong("PRAGMA wal_autocheckpoint", null, null) != l) {
                this.executeForLong("PRAGMA wal_autocheckpoint=" + l, null, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setForeignKeyModeFromConfiguration() {
        if (!this.mIsReadOnlyConnection) {
            long l = this.mConfiguration.foreignKeyConstraintsEnabled ? 1L : 0L;
            if (this.executeForLong("PRAGMA foreign_keys", null, null) != l) {
                this.execute("PRAGMA foreign_keys=" + l, null, null);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void setJournalMode(String string2) {
        String string3;
        block2: {
            string3 = this.executeForString("PRAGMA journal_mode", null, null);
            if (string3.equalsIgnoreCase(string2)) return;
            try {
                boolean bl = this.executeForString("PRAGMA journal_mode=" + string2, null, null).equalsIgnoreCase(string2);
                if (!bl) break block2;
                return;
            }
            catch (SQLiteDatabaseLockedException sQLiteDatabaseLockedException) {
                // empty catch block
            }
        }
        Log.w(TAG, "Could not change the database journal mode of '" + this.mConfiguration.label + "' from '" + string3 + "' to '" + string2 + "' because the database is locked.  This usually means that " + "there are other open connections to the database which prevents " + "the database from enabling or disabling write-ahead logging mode.  " + "Proceeding without changing the journal mode.");
    }

    private void setJournalSizeLimit() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long l = SQLiteGlobal.getJournalSizeLimit();
            if (this.executeForLong("PRAGMA journal_size_limit", null, null) != l) {
                this.executeForLong("PRAGMA journal_size_limit=" + l, null, null);
            }
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Lifted jumps to return sites
     */
    private void setLocaleFromConfiguration() {
        if ((0x10 & this.mConfiguration.openFlags) != 0) {
            return;
        }
        String string2 = this.mConfiguration.locale.toString();
        SQLiteConnection.nativeRegisterLocalizedCollators(this.mConnectionPtr, string2);
        if (this.mIsReadOnlyConnection) return;
        try {
            this.execute("CREATE TABLE IF NOT EXISTS android_metadata (locale TEXT)", null, null);
            String string3 = this.executeForString("SELECT locale FROM android_metadata UNION SELECT NULL ORDER BY locale DESC LIMIT 1", null, null);
            if (string3 != null) {
                if (string3.equals(string2)) return;
            }
            this.execute("BEGIN", null, null);
        }
        catch (RuntimeException runtimeException) {
            throw new SQLiteException("Failed to change locale for db '" + this.mConfiguration.label + "' to '" + string2 + "'.", runtimeException);
        }
        this.execute("DELETE FROM android_metadata", null, null);
        this.execute("INSERT INTO android_metadata (locale) VALUES(?)", new Object[]{string2}, null);
        this.execute("REINDEX LOCALIZED", null, null);
        String string4 = "COMMIT";
        this.execute(string4, null, null);
        return;
        catch (Throwable throwable) {}
        String string5 = "ROLLBACK";
        this.execute(string5, null, null);
        throw throwable;
    }

    private void setPageSize() {
        if (!this.mConfiguration.isInMemoryDb() && !this.mIsReadOnlyConnection) {
            long l = SQLiteGlobal.getDefaultPageSize();
            if (this.executeForLong("PRAGMA page_size", null, null) != l) {
                this.execute("PRAGMA page_size=" + l, null, null);
            }
        }
    }

    private void setSyncMode(String string2) {
        if (!SQLiteConnection.canonicalizeSyncMode(this.executeForString("PRAGMA synchronous", null, null)).equalsIgnoreCase(SQLiteConnection.canonicalizeSyncMode(string2))) {
            this.execute("PRAGMA synchronous=" + string2, null, null);
        }
    }

    private void setWalModeFromConfiguration() {
        block3: {
            block2: {
                if (this.mConfiguration.isInMemoryDb() || this.mIsReadOnlyConnection) break block2;
                if ((0x20000000 & this.mConfiguration.openFlags) == 0) break block3;
                this.setJournalMode("WAL");
                this.setSyncMode(SQLiteGlobal.getWALSyncMode());
            }
            return;
        }
        this.setJournalMode(SQLiteGlobal.getDefaultJournalMode());
        this.setSyncMode(SQLiteGlobal.getDefaultSyncMode());
    }

    private void throwIfStatementForbidden(PreparedStatement preparedStatement) {
        if (this.mOnlyAllowReadOnlyOperations && !preparedStatement.mReadOnly) {
            throw new SQLiteException("Cannot execute this statement because it might modify the database but the connection is read-only.");
        }
    }

    private static String trimSqlForDisplay(String string2) {
        return TRIM_SQL_PATTERN.matcher(string2).replaceAll(" ");
    }

    void close() {
        this.dispose(false);
    }

    /*
     * Unable to fully structure code
     */
    void collectDbStats(ArrayList<SQLiteDebug.DbStats> var1_1) {
        var2_2 = SQLiteConnection.nativeGetDbLookaside(this.mConnectionPtr);
        var3_3 = 0L;
        var5_4 = 0L;
        try {
            var3_3 = this.executeForLong("PRAGMA page_count;", null, null);
            var5_4 = var26_5 = this.executeForLong("PRAGMA page_size;", null, null);
        }
        catch (SQLiteException var7_6) {
            ** continue;
        }
lbl7:
        // 2 sources

        while (true) {
            var1_1.add(this.getMainDbStatsUnsafe(var2_2, var3_3, var5_4));
            var9_7 = new CursorWindow("collectDbStats");
            try {
                this.executeForCursorWindow("PRAGMA database_list;", null, var9_7, 0, 0, false, null);
                var13_8 = 1;
            }
            catch (SQLiteException var11_17) {
                var9_7.close();
                return;
            }
            catch (Throwable var10_18) {
                var9_7.close();
                throw var10_18;
            }
            block11: while (true) {
                var14_9 = var9_7.getNumRows();
                if (var13_8 >= var14_9) break;
                var15_10 = var9_7.getString(var13_8, 1);
                var16_11 = var9_7.getString(var13_8, 2);
                var17_12 = 0L;
                var19_13 = 0L;
                var17_12 = this.executeForLong("PRAGMA " + var15_10 + ".page_count;", null, null);
                var19_13 = var24_16 = this.executeForLong("PRAGMA " + var15_10 + ".page_size;", null, null);
lbl27:
                // 2 sources

                while (true) {
                    var22_15 = "  (attached) " + var15_10;
                    if (!var16_11.isEmpty()) {
                        var22_15 = var22_15 + ": " + var16_11;
                    }
                    var1_1.add(new SQLiteDebug.DbStats(var22_15, var17_12, var19_13, 0, 0, 0, 0));
                    ++var13_8;
                    continue block11;
                    break;
                }
                break;
            }
            var9_7.close();
            return;
            catch (SQLiteException var21_14) {
                ** continue;
            }
            break;
        }
    }

    void collectDbStatsUnsafe(ArrayList<SQLiteDebug.DbStats> arrayList) {
        arrayList.add(this.getMainDbStatsUnsafe(0, 0L, 0L));
    }

    String describeCurrentOperationUnsafe() {
        return this.mRecentOperations.describeCurrentOperation();
    }

    public void dump(Printer printer, boolean bl) {
        this.dumpUnsafe(printer, bl);
    }

    void dumpUnsafe(Printer printer, boolean bl) {
        printer.println("Connection #" + this.mConnectionId + ":");
        if (bl) {
            printer.println("  connectionPtr: 0x" + Long.toHexString(this.mConnectionPtr));
        }
        printer.println("  isPrimaryConnection: " + this.mIsPrimaryConnection);
        printer.println("  onlyAllowReadOnlyOperations: " + this.mOnlyAllowReadOnlyOperations);
        this.mRecentOperations.dump(printer, bl);
        if (bl) {
            this.mPreparedStatementCache.dump(printer);
        }
    }

    /*
     * Loose catch block
     */
    public void execute(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int n = this.mRecentOperations.beginOperation("execute", string2, objectArray);
        PreparedStatement preparedStatement = this.acquirePreparedStatement(string2);
        this.throwIfStatementForbidden(preparedStatement);
        this.bindArguments(preparedStatement, objectArray);
        this.applyBlockGuardPolicy(preparedStatement);
        this.attachCancellationSignal(cancellationSignal);
        {
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.mRecentOperations.failOperation(n, runtimeException);
                    throw runtimeException;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        SQLiteConnection.nativeExecute(this.mConnectionPtr, preparedStatement.mStatementPtr);
        this.detachCancellationSignal(cancellationSignal);
        this.releasePreparedStatement(preparedStatement);
        return;
        catch (Throwable throwable) {
            this.detachCancellationSignal(cancellationSignal);
            throw throwable;
        }
        finally {
            this.mRecentOperations.endOperation(n);
        }
    }

    /*
     * Loose catch block
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ParcelFileDescriptor executeForBlobFileDescriptor(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        ParcelFileDescriptor parcelFileDescriptor;
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int n = this.mRecentOperations.beginOperation("executeForBlobFileDescriptor", string2, objectArray);
        PreparedStatement preparedStatement = this.acquirePreparedStatement(string2);
        this.throwIfStatementForbidden(preparedStatement);
        this.bindArguments(preparedStatement, objectArray);
        this.applyBlockGuardPolicy(preparedStatement);
        this.attachCancellationSignal(cancellationSignal);
        {
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.mRecentOperations.failOperation(n, runtimeException);
                    throw runtimeException;
                }
            }
        }
        int n2 = SQLiteConnection.nativeExecuteForBlobFileDescriptor(this.mConnectionPtr, preparedStatement.mStatementPtr);
        ParcelFileDescriptor parcelFileDescriptor2 = n2 >= 0 ? (parcelFileDescriptor = ParcelFileDescriptor.adoptFd(n2)) : null;
        this.detachCancellationSignal(cancellationSignal);
        this.releasePreparedStatement(preparedStatement);
        return parcelFileDescriptor2;
        catch (Throwable throwable) {
            this.detachCancellationSignal(cancellationSignal);
            throw throwable;
        }
        finally {
            this.mRecentOperations.endOperation(n);
        }
    }

    /*
     * Loose catch block
     */
    public int executeForChangedRowCount(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        int n;
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int n2 = 0;
        int n3 = this.mRecentOperations.beginOperation("executeForChangedRowCount", string2, objectArray);
        PreparedStatement preparedStatement = this.acquirePreparedStatement(string2);
        this.throwIfStatementForbidden(preparedStatement);
        this.bindArguments(preparedStatement, objectArray);
        this.applyBlockGuardPolicy(preparedStatement);
        this.attachCancellationSignal(cancellationSignal);
        {
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.mRecentOperations.failOperation(n3, runtimeException);
                    throw runtimeException;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        n2 = n = SQLiteConnection.nativeExecuteForChangedRowCount(this.mConnectionPtr, preparedStatement.mStatementPtr);
        this.detachCancellationSignal(cancellationSignal);
        this.releasePreparedStatement(preparedStatement);
        return n2;
        catch (Throwable throwable) {
            this.detachCancellationSignal(cancellationSignal);
            throw throwable;
        }
        finally {
            if (this.mRecentOperations.endOperationDeferLog(n3)) {
                this.mRecentOperations.logOperation(n3, "changedRows=" + n2);
            }
        }
    }

    /*
     * Loose catch block
     */
    public int executeForCursorWindow(String string2, Object[] objectArray, CursorWindow cursorWindow, int n, int n2, boolean bl, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        if (cursorWindow == null) {
            throw new IllegalArgumentException("window must not be null.");
        }
        cursorWindow.acquireReference();
        int n3 = -1;
        int n4 = -1;
        int n5 = -1;
        int n6 = this.mRecentOperations.beginOperation("executeForCursorWindow", string2, objectArray);
        PreparedStatement preparedStatement = this.acquirePreparedStatement(string2);
        this.throwIfStatementForbidden(preparedStatement);
        this.bindArguments(preparedStatement, objectArray);
        this.applyBlockGuardPolicy(preparedStatement);
        this.attachCancellationSignal(cancellationSignal);
        {
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    try {
                        this.mRecentOperations.failOperation(n6, runtimeException);
                        throw runtimeException;
                    }
                    catch (Throwable throwable2) {
                        if (this.mRecentOperations.endOperationDeferLog(n6)) {
                            this.mRecentOperations.logOperation(n6, "window='" + cursorWindow + "', startPos=" + n + ", actualPos=" + n3 + ", filledRows=" + n5 + ", countedRows=" + n4);
                        }
                        throw throwable2;
                    }
                }
            }
        }
        long l = SQLiteConnection.nativeExecuteForCursorWindow(this.mConnectionPtr, preparedStatement.mStatementPtr, cursorWindow.mWindowPtr, n, n2, bl);
        n3 = (int)(l >> 32);
        n4 = (int)l;
        n5 = cursorWindow.getNumRows();
        cursorWindow.setStartPosition(n3);
        this.detachCancellationSignal(cancellationSignal);
        this.releasePreparedStatement(preparedStatement);
        if (this.mRecentOperations.endOperationDeferLog(n6)) {
            this.mRecentOperations.logOperation(n6, "window='" + cursorWindow + "', startPos=" + n + ", actualPos=" + n3 + ", filledRows=" + n5 + ", countedRows=" + n4);
        }
        return n4;
        catch (Throwable throwable) {
            this.detachCancellationSignal(cancellationSignal);
            throw throwable;
        }
        finally {
            cursorWindow.releaseReference();
        }
    }

    /*
     * Loose catch block
     */
    public long executeForLastInsertedRowId(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int n = this.mRecentOperations.beginOperation("executeForLastInsertedRowId", string2, objectArray);
        PreparedStatement preparedStatement = this.acquirePreparedStatement(string2);
        this.throwIfStatementForbidden(preparedStatement);
        this.bindArguments(preparedStatement, objectArray);
        this.applyBlockGuardPolicy(preparedStatement);
        this.attachCancellationSignal(cancellationSignal);
        {
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.mRecentOperations.failOperation(n, runtimeException);
                    throw runtimeException;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        long l = SQLiteConnection.nativeExecuteForLastInsertedRowId(this.mConnectionPtr, preparedStatement.mStatementPtr);
        this.detachCancellationSignal(cancellationSignal);
        this.releasePreparedStatement(preparedStatement);
        return l;
        catch (Throwable throwable) {
            this.detachCancellationSignal(cancellationSignal);
            throw throwable;
        }
        finally {
            this.mRecentOperations.endOperation(n);
        }
    }

    /*
     * Loose catch block
     */
    public long executeForLong(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int n = this.mRecentOperations.beginOperation("executeForLong", string2, objectArray);
        PreparedStatement preparedStatement = this.acquirePreparedStatement(string2);
        this.throwIfStatementForbidden(preparedStatement);
        this.bindArguments(preparedStatement, objectArray);
        this.applyBlockGuardPolicy(preparedStatement);
        this.attachCancellationSignal(cancellationSignal);
        {
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.mRecentOperations.failOperation(n, runtimeException);
                    throw runtimeException;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        long l = SQLiteConnection.nativeExecuteForLong(this.mConnectionPtr, preparedStatement.mStatementPtr);
        this.detachCancellationSignal(cancellationSignal);
        this.releasePreparedStatement(preparedStatement);
        return l;
        catch (Throwable throwable) {
            this.detachCancellationSignal(cancellationSignal);
            throw throwable;
        }
        finally {
            this.mRecentOperations.endOperation(n);
        }
    }

    /*
     * Loose catch block
     */
    public String executeForString(String string2, Object[] objectArray, CancellationSignal cancellationSignal) {
        if (string2 == null) {
            throw new IllegalArgumentException("sql must not be null.");
        }
        int n = this.mRecentOperations.beginOperation("executeForString", string2, objectArray);
        PreparedStatement preparedStatement = this.acquirePreparedStatement(string2);
        this.throwIfStatementForbidden(preparedStatement);
        this.bindArguments(preparedStatement, objectArray);
        this.applyBlockGuardPolicy(preparedStatement);
        this.attachCancellationSignal(cancellationSignal);
        {
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.mRecentOperations.failOperation(n, runtimeException);
                    throw runtimeException;
                }
                catch (Throwable throwable2) {
                    throw throwable2;
                }
            }
        }
        String string3 = SQLiteConnection.nativeExecuteForString(this.mConnectionPtr, preparedStatement.mStatementPtr);
        this.detachCancellationSignal(cancellationSignal);
        this.releasePreparedStatement(preparedStatement);
        return string3;
        catch (Throwable throwable) {
            this.detachCancellationSignal(cancellationSignal);
            throw throwable;
        }
        finally {
            this.mRecentOperations.endOperation(n);
        }
    }

    protected void finalize() throws Throwable {
        try {
            if (this.mPool != null && this.mConnectionPtr != 0L) {
                this.mPool.onConnectionLeaked();
            }
            this.dispose(true);
            return;
        }
        finally {
            super.finalize();
        }
    }

    public int getConnectionId() {
        return this.mConnectionId;
    }

    boolean isPreparedStatementInCache(String string2) {
        return this.mPreparedStatementCache.get(string2) != null;
    }

    public boolean isPrimaryConnection() {
        return this.mIsPrimaryConnection;
    }

    @Override
    public void onCancel() {
        SQLiteConnection.nativeCancel(this.mConnectionPtr);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void prepare(String string2, SQLiteStatementInfo sQLiteStatementInfo) {
        PreparedStatement preparedStatement;
        int n;
        block13: {
            if (string2 == null) {
                throw new IllegalArgumentException("sql must not be null.");
            }
            n = this.mRecentOperations.beginOperation("prepare", string2, null);
            preparedStatement = this.acquirePreparedStatement(string2);
            if (sQLiteStatementInfo == null) break block13;
            try {
                sQLiteStatementInfo.numParameters = preparedStatement.mNumParameters;
                sQLiteStatementInfo.readOnly = preparedStatement.mReadOnly;
                int n2 = SQLiteConnection.nativeGetColumnCount(this.mConnectionPtr, preparedStatement.mStatementPtr);
                if (n2 == 0) {
                    sQLiteStatementInfo.columnNames = EMPTY_STRING_ARRAY;
                    break block13;
                }
                sQLiteStatementInfo.columnNames = new String[n2];
                for (int i = 0; i < n2; ++i) {
                    sQLiteStatementInfo.columnNames[i] = SQLiteConnection.nativeGetColumnName(this.mConnectionPtr, preparedStatement.mStatementPtr, i);
                }
            }
            catch (Throwable throwable) {
                try {
                    this.releasePreparedStatement(preparedStatement);
                    throw throwable;
                }
                catch (RuntimeException runtimeException) {
                    this.mRecentOperations.failOperation(n, runtimeException);
                    throw runtimeException;
                }
            }
        }
        try {
            this.releasePreparedStatement(preparedStatement);
            return;
        }
        finally {
            this.mRecentOperations.endOperation(n);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    void reconfigure(SQLiteDatabaseConfiguration sQLiteDatabaseConfiguration) {
        this.mOnlyAllowReadOnlyOperations = false;
        int n = sQLiteDatabaseConfiguration.customFunctions.size();
        for (int i = 0; i < n; ++i) {
            SQLiteCustomFunction sQLiteCustomFunction = sQLiteDatabaseConfiguration.customFunctions.get(i);
            if (this.mConfiguration.customFunctions.contains(sQLiteCustomFunction)) continue;
            SQLiteConnection.nativeRegisterCustomFunction(this.mConnectionPtr, sQLiteCustomFunction);
        }
        boolean bl = sQLiteDatabaseConfiguration.foreignKeyConstraintsEnabled != this.mConfiguration.foreignKeyConstraintsEnabled;
        boolean bl2 = (0x20000000 & (sQLiteDatabaseConfiguration.openFlags ^ this.mConfiguration.openFlags)) != 0;
        boolean bl3 = !sQLiteDatabaseConfiguration.locale.equals(this.mConfiguration.locale);
        this.mConfiguration.updateParametersFrom(sQLiteDatabaseConfiguration);
        this.mPreparedStatementCache.resize(sQLiteDatabaseConfiguration.maxSqlCacheSize);
        if (bl) {
            this.setForeignKeyModeFromConfiguration();
        }
        if (bl2) {
            this.setWalModeFromConfiguration();
        }
        if (bl3) {
            this.setLocaleFromConfiguration();
        }
    }

    void setOnlyAllowReadOnlyOperations(boolean bl) {
        this.mOnlyAllowReadOnlyOperations = bl;
    }

    public String toString() {
        return "SQLiteConnection: " + this.mConfiguration.path + " (" + this.mConnectionId + ")";
    }

    private static final class Operation {
        private static final SimpleDateFormat sDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss.SSS");
        public ArrayList<Object> mBindArgs;
        public int mCookie;
        public long mEndTime;
        public Exception mException;
        public boolean mFinished;
        public String mKind;
        public String mSql;
        public long mStartTime;

        private Operation() {
        }

        private String getFormattedStartTime() {
            return sDateFormat.format(new Date(this.mStartTime));
        }

        private String getStatus() {
            if (!this.mFinished) {
                return "running";
            }
            if (this.mException != null) {
                return "failed";
            }
            return "succeeded";
        }

        /*
         * Enabled aggressive block sorting
         */
        public void describe(StringBuilder stringBuilder, boolean bl) {
            stringBuilder.append(this.mKind);
            if (this.mFinished) {
                stringBuilder.append(" took ").append(this.mEndTime - this.mStartTime).append("ms");
            } else {
                stringBuilder.append(" started ").append(System.currentTimeMillis() - this.mStartTime).append("ms ago");
            }
            stringBuilder.append(" - ").append(this.getStatus());
            if (this.mSql != null) {
                stringBuilder.append(", sql=\"").append(SQLiteConnection.trimSqlForDisplay(this.mSql)).append("\"");
            }
            if (bl && this.mBindArgs != null && this.mBindArgs.size() != 0) {
                stringBuilder.append(", bindArgs=[");
                int n = this.mBindArgs.size();
                for (int i = 0; i < n; ++i) {
                    Object object = this.mBindArgs.get(i);
                    if (i != 0) {
                        stringBuilder.append(", ");
                    }
                    if (object == null) {
                        stringBuilder.append("null");
                        continue;
                    }
                    if (object instanceof byte[]) {
                        stringBuilder.append("<byte[]>");
                        continue;
                    }
                    if (object instanceof String) {
                        stringBuilder.append("\"").append((String)object).append("\"");
                        continue;
                    }
                    stringBuilder.append(object);
                }
                stringBuilder.append("]");
            }
            if (this.mException != null) {
                stringBuilder.append(", exception=\"").append(this.mException.getMessage()).append("\"");
            }
        }
    }

    private static final class OperationLog {
        private static final int COOKIE_GENERATION_SHIFT = 8;
        private static final int COOKIE_INDEX_MASK = 255;
        private static final int MAX_RECENT_OPERATIONS = 20;
        private int mGeneration;
        private int mIndex;
        private final Operation[] mOperations = new Operation[20];

        private OperationLog() {
        }

        private boolean endOperationDeferLogLocked(int n) {
            Operation operation = this.getOperationLocked(n);
            if (operation != null) {
                operation.mEndTime = System.currentTimeMillis();
                operation.mFinished = true;
                return SQLiteDebug.DEBUG_LOG_SLOW_QUERIES && SQLiteDebug.shouldLogSlowQuery(operation.mEndTime - operation.mStartTime);
            }
            return false;
        }

        private Operation getOperationLocked(int n) {
            int n2 = n & 0xFF;
            Operation operation = this.mOperations[n2];
            if (operation.mCookie == n) {
                return operation;
            }
            return null;
        }

        private void logOperationLocked(int n, String string2) {
            Operation operation = this.getOperationLocked(n);
            StringBuilder stringBuilder = new StringBuilder();
            operation.describe(stringBuilder, false);
            if (string2 != null) {
                stringBuilder.append(", ").append(string2);
            }
            Log.d(SQLiteConnection.TAG, stringBuilder.toString());
        }

        private int newOperationCookieLocked(int n) {
            int n2 = this.mGeneration;
            this.mGeneration = n2 + 1;
            return n | n2 << 8;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public int beginOperation(String string2, String string3, Object[] objectArray) {
            Operation[] operationArray = this.mOperations;
            synchronized (operationArray) {
                int n = (1 + this.mIndex) % 20;
                Operation operation = this.mOperations[n];
                if (operation == null) {
                    this.mOperations[n] = operation = new Operation();
                } else {
                    operation.mFinished = false;
                    operation.mException = null;
                    if (operation.mBindArgs != null) {
                        operation.mBindArgs.clear();
                    }
                }
                operation.mStartTime = System.currentTimeMillis();
                operation.mKind = string2;
                operation.mSql = string3;
                if (objectArray != null) {
                    if (operation.mBindArgs == null) {
                        operation.mBindArgs = new ArrayList();
                    } else {
                        operation.mBindArgs.clear();
                    }
                    for (int i = 0; i < objectArray.length; ++i) {
                        Object object = objectArray[i];
                        if (object != null && object instanceof byte[]) {
                            operation.mBindArgs.add(EMPTY_BYTE_ARRAY);
                            continue;
                        }
                        operation.mBindArgs.add(object);
                    }
                }
                operation.mCookie = this.newOperationCookieLocked(n);
                this.mIndex = n;
                return operation.mCookie;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public String describeCurrentOperation() {
            Operation[] operationArray = this.mOperations;
            synchronized (operationArray) {
                Operation operation = this.mOperations[this.mIndex];
                if (operation == null) return null;
                if (operation.mFinished) return null;
                StringBuilder stringBuilder = new StringBuilder();
                operation.describe(stringBuilder, false);
                return stringBuilder.toString();
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void dump(Printer printer, boolean bl) {
            Operation[] operationArray = this.mOperations;
            synchronized (operationArray) {
                printer.println("  Most recently executed operations:");
                int n = this.mIndex;
                Operation operation = this.mOperations[n];
                if (operation == null) {
                    printer.println("    <none>");
                } else {
                    int n2 = 0;
                    do {
                        StringBuilder stringBuilder = new StringBuilder();
                        stringBuilder.append("    ").append(n2).append(": [");
                        stringBuilder.append(operation.getFormattedStartTime());
                        stringBuilder.append("] ");
                        operation.describe(stringBuilder, bl);
                        printer.println(stringBuilder.toString());
                        if (n > 0) {
                            --n;
                            continue;
                        }
                        n = 19;
                    } while ((operation = this.mOperations[n]) != null && ++n2 < 20);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void endOperation(int n) {
            Operation[] operationArray = this.mOperations;
            synchronized (operationArray) {
                if (this.endOperationDeferLogLocked(n)) {
                    this.logOperationLocked(n, null);
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public boolean endOperationDeferLog(int n) {
            Operation[] operationArray = this.mOperations;
            synchronized (operationArray) {
                return this.endOperationDeferLogLocked(n);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void failOperation(int n, Exception exception) {
            Operation[] operationArray = this.mOperations;
            synchronized (operationArray) {
                Operation operation = this.getOperationLocked(n);
                if (operation != null) {
                    operation.mException = exception;
                }
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void logOperation(int n, String string2) {
            Operation[] operationArray = this.mOperations;
            synchronized (operationArray) {
                this.logOperationLocked(n, string2);
                return;
            }
        }
    }

    private static final class PreparedStatement {
        public boolean mInCache;
        public boolean mInUse;
        public int mNumParameters;
        public PreparedStatement mPoolNext;
        public boolean mReadOnly;
        public String mSql;
        public long mStatementPtr;
        public int mType;

        private PreparedStatement() {
        }
    }

    private final class PreparedStatementCache
    extends LruCache<String, PreparedStatement> {
        public PreparedStatementCache(int n) {
            super(n);
        }

        public void dump(Printer printer) {
            printer.println("  Prepared statement cache:");
            Map map = this.snapshot();
            if (!map.isEmpty()) {
                int n = 0;
                for (Map.Entry entry : map.entrySet()) {
                    PreparedStatement preparedStatement = (PreparedStatement)entry.getValue();
                    if (preparedStatement.mInCache) {
                        String string2 = (String)entry.getKey();
                        printer.println("    " + n + ": statementPtr=0x" + Long.toHexString(preparedStatement.mStatementPtr) + ", numParameters=" + preparedStatement.mNumParameters + ", type=" + preparedStatement.mType + ", readOnly=" + preparedStatement.mReadOnly + ", sql=\"" + SQLiteConnection.trimSqlForDisplay(string2) + "\"");
                    }
                    ++n;
                }
            } else {
                printer.println("    <none>");
            }
        }

        @Override
        protected void entryRemoved(boolean bl, String string2, PreparedStatement preparedStatement, PreparedStatement preparedStatement2) {
            preparedStatement.mInCache = false;
            if (!preparedStatement.mInUse) {
                SQLiteConnection.this.finalizePreparedStatement(preparedStatement);
            }
        }
    }
}

