/*
 * Decompiled with CFR 0.152.
 */
package android.content.res;

import android.content.Context;
import android.content.res.IThemeService;
import android.content.res.ThemePack;
import android.os.RemoteException;
import android.os.ServiceManager;

public class ThemeManager {
    public static final String ASUS_THEME_LOG_TAG = ThemeManager.class.getSimpleName();
    public static final boolean DEBUG_ASUS_THEME = false;
    public static final String DEVICE_DEFAULT = "com.asus.res.defaulttheme";
    public static final String THEME_MODULE_INSTALL_DIR = "themepack-module";
    private static IThemeService sService;
    private Context mContext;

    public ThemeManager(Context context) {
        this.mContext = context;
    }

    private static IThemeService getService() {
        if (sService != null) {
            return sService;
        }
        sService = IThemeService.Stub.asInterface(ServiceManager.getService("themes"));
        return sService;
    }

    public ThemePack[] getThemePacks() {
        IThemeService iThemeService = ThemeManager.getService();
        try {
            ThemePack[] themePackArray = iThemeService.getThemePacks();
            return themePackArray;
        }
        catch (RemoteException remoteException) {
            return new ThemePack[0];
        }
    }

    public boolean isThemeApplying(String string2) {
        IThemeService iThemeService = ThemeManager.getService();
        try {
            boolean bl = iThemeService.isThemeApplying(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void requestThemeChange(String string2) {
        IThemeService iThemeService = ThemeManager.getService();
        try {
            iThemeService.requestThemeChange(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }
}

