/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.ComponentName;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.ApplicationInfo;
import android.content.pm.ComponentInfo;
import android.content.pm.PackageManager;
import android.content.pm.ProviderInfo;
import android.content.pm.ServiceInfo;
import android.graphics.drawable.Drawable;
import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Printer;
import android.util.Slog;
import java.text.Collator;
import java.util.Comparator;

public class ResolveInfo
implements Parcelable {
    public static final Parcelable.Creator<ResolveInfo> CREATOR = new Parcelable.Creator<ResolveInfo>(){

        @Override
        public ResolveInfo createFromParcel(Parcel parcel) {
            return new ResolveInfo(parcel);
        }

        public ResolveInfo[] newArray(int n) {
            return new ResolveInfo[n];
        }
    };
    private static final String TAG = "ResolveInfo";
    public ActivityInfo activityInfo;
    public IntentFilter filter;
    public int icon;
    public boolean isDefault;
    public int labelRes;
    public int match;
    public boolean noResourceId;
    public CharSequence nonLocalizedLabel;
    public int preferredOrder;
    public int priority;
    public ProviderInfo providerInfo;
    public String resolvePackageName;
    public ServiceInfo serviceInfo;
    public int specificIndex;
    public boolean system;
    public int targetUserId;

    public ResolveInfo() {
        this.specificIndex = -1;
        this.targetUserId = -2;
    }

    public ResolveInfo(ResolveInfo resolveInfo) {
        this.specificIndex = -1;
        this.activityInfo = resolveInfo.activityInfo;
        this.serviceInfo = resolveInfo.serviceInfo;
        this.providerInfo = resolveInfo.providerInfo;
        this.filter = resolveInfo.filter;
        this.priority = resolveInfo.priority;
        this.preferredOrder = resolveInfo.preferredOrder;
        this.match = resolveInfo.match;
        this.specificIndex = resolveInfo.specificIndex;
        this.labelRes = resolveInfo.labelRes;
        this.nonLocalizedLabel = resolveInfo.nonLocalizedLabel;
        this.icon = resolveInfo.icon;
        this.resolvePackageName = resolveInfo.resolvePackageName;
        this.system = resolveInfo.system;
        this.targetUserId = resolveInfo.targetUserId;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ResolveInfo(Parcel parcel) {
        boolean bl = true;
        this.specificIndex = -1;
        this.activityInfo = null;
        this.serviceInfo = null;
        this.providerInfo = null;
        switch (parcel.readInt()) {
            default: {
                Slog.w(TAG, "Missing ComponentInfo!");
                break;
            }
            case 1: {
                this.activityInfo = ActivityInfo.CREATOR.createFromParcel(parcel);
                break;
            }
            case 2: {
                this.serviceInfo = ServiceInfo.CREATOR.createFromParcel(parcel);
                break;
            }
            case 3: {
                this.providerInfo = ProviderInfo.CREATOR.createFromParcel(parcel);
            }
        }
        if (parcel.readInt() != 0) {
            this.filter = IntentFilter.CREATOR.createFromParcel(parcel);
        }
        this.priority = parcel.readInt();
        this.preferredOrder = parcel.readInt();
        this.match = parcel.readInt();
        this.specificIndex = parcel.readInt();
        this.labelRes = parcel.readInt();
        this.nonLocalizedLabel = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        this.icon = parcel.readInt();
        this.resolvePackageName = parcel.readString();
        this.targetUserId = parcel.readInt();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.system = bl2;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.noResourceId = bl;
    }

    private ComponentInfo getComponentInfo() {
        if (this.activityInfo != null) {
            return this.activityInfo;
        }
        if (this.serviceInfo != null) {
            return this.serviceInfo;
        }
        if (this.providerInfo != null) {
            return this.providerInfo;
        }
        throw new IllegalStateException("Missing ComponentInfo!");
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void dump(Printer printer, String string2) {
        if (this.filter != null) {
            printer.println(string2 + "Filter:");
            this.filter.dump(printer, string2 + "  ");
        }
        printer.println(string2 + "priority=" + this.priority + " preferredOrder=" + this.preferredOrder + " match=0x" + Integer.toHexString(this.match) + " specificIndex=" + this.specificIndex + " isDefault=" + this.isDefault);
        if (this.resolvePackageName != null) {
            printer.println(string2 + "resolvePackageName=" + this.resolvePackageName);
        }
        if (this.labelRes != 0 || this.nonLocalizedLabel != null || this.icon != 0) {
            printer.println(string2 + "labelRes=0x" + Integer.toHexString(this.labelRes) + " nonLocalizedLabel=" + this.nonLocalizedLabel + " icon=0x" + Integer.toHexString(this.icon));
        }
        if (this.activityInfo != null) {
            printer.println(string2 + "ActivityInfo:");
            this.activityInfo.dump(printer, string2 + "  ");
            return;
        } else {
            if (this.serviceInfo != null) {
                printer.println(string2 + "ServiceInfo:");
                this.serviceInfo.dump(printer, string2 + "  ");
                return;
            }
            if (this.providerInfo == null) return;
            printer.println(string2 + "ProviderInfo:");
            this.providerInfo.dump(printer, string2 + "  ");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final int getIconResource() {
        ComponentInfo componentInfo;
        block5: {
            block4: {
                if (this.noResourceId) break block4;
                if (this.icon != 0) {
                    return this.icon;
                }
                componentInfo = this.getComponentInfo();
                if (componentInfo != null) break block5;
            }
            return 0;
        }
        return componentInfo.getIconResource();
    }

    /*
     * Enabled aggressive block sorting
     */
    public Drawable loadIcon(PackageManager packageManager) {
        ComponentInfo componentInfo;
        block3: {
            Drawable drawable2;
            block2: {
                if (this.resolvePackageName != null && this.icon != 0 && (drawable2 = packageManager.getDrawable(this.resolvePackageName, this.icon, null)) != null) break block2;
                componentInfo = this.getComponentInfo();
                ApplicationInfo applicationInfo = componentInfo.applicationInfo;
                if (this.icon == 0 || (drawable2 = packageManager.getDrawable(componentInfo.packageName, this.icon, applicationInfo)) == null) break block3;
            }
            return drawable2;
        }
        return componentInfo.loadIcon(packageManager);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public CharSequence loadLabel(PackageManager packageManager) {
        CharSequence charSequence;
        CharSequence charSequence2;
        if (this.nonLocalizedLabel != null) {
            return this.nonLocalizedLabel;
        }
        if (this.resolvePackageName != null && this.labelRes != 0 && (charSequence2 = packageManager.getText(this.resolvePackageName, this.labelRes, null)) != null) {
            return charSequence2.toString().trim();
        }
        ComponentInfo componentInfo = this.getComponentInfo();
        ApplicationInfo applicationInfo = componentInfo.applicationInfo;
        if (this.labelRes != 0 && (charSequence = packageManager.getText(componentInfo.packageName, this.labelRes, applicationInfo)) != null) {
            return charSequence.toString().trim();
        }
        CharSequence charSequence3 = componentInfo.loadLabel(packageManager);
        if (charSequence3 == null) return charSequence3;
        return charSequence3.toString().trim();
    }

    public String toString() {
        ComponentInfo componentInfo = this.getComponentInfo();
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("ResolveInfo{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        stringBuilder.append(' ');
        ComponentName.appendShortString(stringBuilder, componentInfo.packageName, componentInfo.name);
        if (this.priority != 0) {
            stringBuilder.append(" p=");
            stringBuilder.append(this.priority);
        }
        if (this.preferredOrder != 0) {
            stringBuilder.append(" o=");
            stringBuilder.append(this.preferredOrder);
        }
        stringBuilder.append(" m=0x");
        stringBuilder.append(Integer.toHexString(this.match));
        if (this.targetUserId != -2) {
            stringBuilder.append(" targetUserId=");
            stringBuilder.append(this.targetUserId);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        if (this.activityInfo != null) {
            parcel.writeInt(n2);
            this.activityInfo.writeToParcel(parcel, n);
        } else if (this.serviceInfo != null) {
            parcel.writeInt(2);
            this.serviceInfo.writeToParcel(parcel, n);
        } else if (this.providerInfo != null) {
            parcel.writeInt(3);
            this.providerInfo.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        if (this.filter != null) {
            parcel.writeInt(n2);
            this.filter.writeToParcel(parcel, n);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.priority);
        parcel.writeInt(this.preferredOrder);
        parcel.writeInt(this.match);
        parcel.writeInt(this.specificIndex);
        parcel.writeInt(this.labelRes);
        TextUtils.writeToParcel(this.nonLocalizedLabel, parcel, n);
        parcel.writeInt(this.icon);
        parcel.writeString(this.resolvePackageName);
        parcel.writeInt(this.targetUserId);
        int n3 = this.system ? n2 : 0;
        parcel.writeInt(n3);
        if (!this.noResourceId) {
            n2 = 0;
        }
        parcel.writeInt(n2);
    }

    public static class DisplayNameComparator
    implements Comparator<ResolveInfo> {
        private final Collator mCollator = Collator.getInstance();
        private PackageManager mPM;

        public DisplayNameComparator(PackageManager packageManager) {
            this.mPM = packageManager;
            this.mCollator.setStrength(0);
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public final int compare(ResolveInfo resolveInfo, ResolveInfo resolveInfo2) {
            CharSequence charSequence;
            CharSequence charSequence2;
            block8: {
                block7: {
                    if (resolveInfo.targetUserId != -2) break block7;
                    if (resolveInfo2.targetUserId != -2) {
                        return -1;
                    }
                    if (resolveInfo.activityInfo == null || resolveInfo2.activityInfo == null) break block8;
                    ApplicationInfo applicationInfo = resolveInfo.activityInfo.applicationInfo;
                    ApplicationInfo applicationInfo2 = resolveInfo2.activityInfo.applicationInfo;
                    if ((4 & applicationInfo.flagsAsus) > 0 || (8 & applicationInfo.flagsAsus) > (8 & applicationInfo2.flagsAsus)) {
                        return -1;
                    }
                    if ((4 & applicationInfo2.flagsAsus) <= 0 && (8 & applicationInfo.flagsAsus) >= (8 & applicationInfo2.flagsAsus)) break block8;
                }
                return 1;
            }
            if ((charSequence2 = resolveInfo.loadLabel(this.mPM)) == null) {
                charSequence2 = resolveInfo.activityInfo.name;
            }
            if ((charSequence = resolveInfo2.loadLabel(this.mPM)) == null) {
                charSequence = resolveInfo2.activityInfo.name;
            }
            return this.mCollator.compare(charSequence2.toString(), charSequence.toString());
        }
    }
}

