/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageInstaller;
import android.content.pm.IPackageInstallerCallback;
import android.content.pm.IPackageInstallerSession;
import android.content.pm.PackageManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.FileBridge;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.Parcelable;
import android.os.RemoteException;
import android.util.ExceptionUtils;
import android.util.Log;
import com.android.internal.util.IndentingPrintWriter;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;

public class PackageInstaller {
    public static final String ACTION_CONFIRM_PERMISSIONS = "android.content.pm.action.CONFIRM_PERMISSIONS";
    public static final String ACTION_SESSION_DETAILS = "android.content.pm.action.SESSION_DETAILS";
    public static final String EXTRA_CALLBACK = "android.content.pm.extra.CALLBACK";
    public static final String EXTRA_LEGACY_BUNDLE = "android.content.pm.extra.LEGACY_BUNDLE";
    public static final String EXTRA_LEGACY_STATUS = "android.content.pm.extra.LEGACY_STATUS";
    public static final String EXTRA_OTHER_PACKAGE_NAME = "android.content.pm.extra.OTHER_PACKAGE_NAME";
    public static final String EXTRA_PACKAGE_NAME = "android.content.pm.extra.PACKAGE_NAME";
    @Deprecated
    public static final String EXTRA_PACKAGE_NAMES = "android.content.pm.extra.PACKAGE_NAMES";
    public static final String EXTRA_SESSION_ID = "android.content.pm.extra.SESSION_ID";
    public static final String EXTRA_STATUS = "android.content.pm.extra.STATUS";
    public static final String EXTRA_STATUS_MESSAGE = "android.content.pm.extra.STATUS_MESSAGE";
    public static final String EXTRA_STORAGE_PATH = "android.content.pm.extra.STORAGE_PATH";
    public static final int STATUS_FAILURE = 1;
    public static final int STATUS_FAILURE_ABORTED = 3;
    public static final int STATUS_FAILURE_BLOCKED = 2;
    public static final int STATUS_FAILURE_CONFLICT = 5;
    public static final int STATUS_FAILURE_INCOMPATIBLE = 7;
    public static final int STATUS_FAILURE_INVALID = 4;
    public static final int STATUS_FAILURE_STORAGE = 6;
    public static final int STATUS_PENDING_USER_ACTION = -1;
    public static final int STATUS_SUCCESS = 0;
    private static final String TAG = "PackageInstaller";
    private final Context mContext;
    private final ArrayList<SessionCallbackDelegate> mDelegates = new ArrayList();
    private final IPackageInstaller mInstaller;
    private final String mInstallerPackageName;
    private final PackageManager mPm;
    private final int mUserId;

    public PackageInstaller(Context context, PackageManager packageManager, IPackageInstaller iPackageInstaller, String string2, int n) {
        this.mContext = context;
        this.mPm = packageManager;
        this.mInstaller = iPackageInstaller;
        this.mInstallerPackageName = string2;
        this.mUserId = n;
    }

    public void abandonSession(int n) {
        try {
            this.mInstaller.abandonSession(n);
            return;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    @Deprecated
    public void addSessionCallback(SessionCallback sessionCallback) {
        this.registerSessionCallback(sessionCallback);
    }

    @Deprecated
    public void addSessionCallback(SessionCallback sessionCallback, Handler handler) {
        this.registerSessionCallback(sessionCallback, handler);
    }

    public int createSession(SessionParams sessionParams) throws IOException {
        try {
            int n = this.mInstaller.createSession(sessionParams, this.mInstallerPackageName, this.mUserId);
            return n;
        }
        catch (RuntimeException runtimeException) {
            ExceptionUtils.maybeUnwrapIOException(runtimeException);
            throw runtimeException;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    public List<SessionInfo> getAllSessions() {
        ApplicationInfo applicationInfo = this.mContext.getApplicationInfo();
        if ("com.google.android.googlequicksearchbox".equals(applicationInfo.packageName) && applicationInfo.versionCode <= 300400110) {
            Log.d(TAG, "Ignoring callback request from old prebuilt");
            return Collections.EMPTY_LIST;
        }
        try {
            List<SessionInfo> list = this.mInstaller.getAllSessions(this.mUserId).getList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    public List<SessionInfo> getMySessions() {
        try {
            List<SessionInfo> list = this.mInstaller.getMySessions(this.mInstallerPackageName, this.mUserId).getList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    public SessionInfo getSessionInfo(int n) {
        try {
            SessionInfo sessionInfo = this.mInstaller.getSessionInfo(n);
            return sessionInfo;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    public Session openSession(int n) throws IOException {
        try {
            Session session = new Session(this.mInstaller.openSession(n));
            return session;
        }
        catch (RuntimeException runtimeException) {
            ExceptionUtils.maybeUnwrapIOException(runtimeException);
            throw runtimeException;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    public void registerSessionCallback(SessionCallback sessionCallback) {
        this.registerSessionCallback(sessionCallback, new Handler());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void registerSessionCallback(SessionCallback sessionCallback, Handler handler) {
        ApplicationInfo applicationInfo = this.mContext.getApplicationInfo();
        if ("com.google.android.googlequicksearchbox".equals(applicationInfo.packageName) && applicationInfo.versionCode <= 300400110) {
            Log.d(TAG, "Ignoring callback request from old prebuilt");
            return;
        }
        ArrayList<SessionCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            SessionCallbackDelegate sessionCallbackDelegate = new SessionCallbackDelegate(sessionCallback, handler.getLooper());
            try {
                this.mInstaller.registerCallback(sessionCallbackDelegate, this.mUserId);
                this.mDelegates.add(sessionCallbackDelegate);
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
            return;
        }
    }

    @Deprecated
    public void removeSessionCallback(SessionCallback sessionCallback) {
        this.unregisterSessionCallback(sessionCallback);
    }

    public void setPermissionsResult(int n, boolean bl) {
        try {
            this.mInstaller.setPermissionsResult(n, bl);
            return;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    public void uninstall(String string2, IntentSender intentSender) {
        try {
            this.mInstaller.uninstall(string2, 0, intentSender, this.mUserId);
            return;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void unregisterSessionCallback(SessionCallback sessionCallback) {
        ArrayList<SessionCallbackDelegate> arrayList = this.mDelegates;
        synchronized (arrayList) {
            Iterator<SessionCallbackDelegate> iterator = this.mDelegates.iterator();
            while (iterator.hasNext()) {
                SessionCallbackDelegate sessionCallbackDelegate = iterator.next();
                SessionCallback sessionCallback2 = sessionCallbackDelegate.mCallback;
                if (sessionCallback2 != sessionCallback) continue;
                try {
                    this.mInstaller.unregisterCallback(sessionCallbackDelegate);
                    iterator.remove();
                }
                catch (RemoteException remoteException) {
                    throw remoteException.rethrowAsRuntimeException();
                }
            }
            return;
        }
    }

    public void updateSessionAppIcon(int n, Bitmap bitmap) {
        try {
            this.mInstaller.updateSessionAppIcon(n, bitmap);
            return;
        }
        catch (RemoteException remoteException) {
            throw remoteException.rethrowAsRuntimeException();
        }
    }

    /*
     * Unable to fully structure code
     */
    public void updateSessionAppLabel(int var1_1, CharSequence var2_2) {
        if (var2_2 != null) {
            var3_3 = var2_2.toString();
lbl4:
            // 2 sources

            while (true) {
                this.mInstaller.updateSessionAppLabel(var1_1, var3_3);
                return;
            }
        }
        var3_3 = null;
        ** while (true)
        catch (RemoteException var4_4) {
            throw var4_4.rethrowAsRuntimeException();
        }
    }

    public static class Session
    implements Closeable {
        private IPackageInstallerSession mSession;

        public Session(IPackageInstallerSession iPackageInstallerSession) {
            this.mSession = iPackageInstallerSession;
        }

        public void abandon() {
            try {
                this.mSession.abandon();
                return;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }

        public void addProgress(float f) {
            try {
                this.mSession.addClientProgress(f);
                return;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }

        @Override
        public void close() {
            try {
                this.mSession.close();
                return;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }

        public void commit(IntentSender intentSender) {
            try {
                this.mSession.commit(intentSender);
                return;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }

        public void fsync(OutputStream outputStream) throws IOException {
            if (outputStream instanceof FileBridge.FileBridgeOutputStream) {
                ((FileBridge.FileBridgeOutputStream)outputStream).fsync();
                return;
            }
            throw new IllegalArgumentException("Unrecognized stream");
        }

        public String[] getNames() throws IOException {
            try {
                String[] stringArray = this.mSession.getNames();
                return stringArray;
            }
            catch (RuntimeException runtimeException) {
                ExceptionUtils.maybeUnwrapIOException(runtimeException);
                throw runtimeException;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }

        public InputStream openRead(String string2) throws IOException {
            try {
                ParcelFileDescriptor.AutoCloseInputStream autoCloseInputStream = new ParcelFileDescriptor.AutoCloseInputStream(this.mSession.openRead(string2));
                return autoCloseInputStream;
            }
            catch (RuntimeException runtimeException) {
                ExceptionUtils.maybeUnwrapIOException(runtimeException);
                throw runtimeException;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }

        public OutputStream openWrite(String string2, long l, long l2) throws IOException {
            try {
                FileBridge.FileBridgeOutputStream fileBridgeOutputStream = new FileBridge.FileBridgeOutputStream(this.mSession.openWrite(string2, l, l2));
                return fileBridgeOutputStream;
            }
            catch (RuntimeException runtimeException) {
                ExceptionUtils.maybeUnwrapIOException(runtimeException);
                throw runtimeException;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }

        @Deprecated
        public void setProgress(float f) {
            this.setStagingProgress(f);
        }

        public void setStagingProgress(float f) {
            try {
                this.mSession.setClientProgress(f);
                return;
            }
            catch (RemoteException remoteException) {
                throw remoteException.rethrowAsRuntimeException();
            }
        }
    }

    public static abstract class SessionCallback {
        public abstract void onActiveChanged(int var1, boolean var2);

        public abstract void onBadgingChanged(int var1);

        public abstract void onCreated(int var1);

        public abstract void onFinished(int var1, boolean var2);

        public abstract void onProgressChanged(int var1, float var2);
    }

    private static class SessionCallbackDelegate
    extends IPackageInstallerCallback.Stub
    implements Handler.Callback {
        private static final int MSG_SESSION_ACTIVE_CHANGED = 3;
        private static final int MSG_SESSION_BADGING_CHANGED = 2;
        private static final int MSG_SESSION_CREATED = 1;
        private static final int MSG_SESSION_FINISHED = 5;
        private static final int MSG_SESSION_PROGRESS_CHANGED = 4;
        final SessionCallback mCallback;
        final Handler mHandler;

        public SessionCallbackDelegate(SessionCallback sessionCallback, Looper looper) {
            this.mCallback = sessionCallback;
            this.mHandler = new Handler(looper, this);
        }

        @Override
        public boolean handleMessage(Message message) {
            int n = message.arg1;
            switch (message.what) {
                default: {
                    return false;
                }
                case 1: {
                    this.mCallback.onCreated(n);
                    return true;
                }
                case 2: {
                    this.mCallback.onBadgingChanged(n);
                    return true;
                }
                case 3: {
                    int n2 = message.arg2;
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    this.mCallback.onActiveChanged(n, bl);
                    return true;
                }
                case 4: {
                    this.mCallback.onProgressChanged(n, ((Float)message.obj).floatValue());
                    return true;
                }
                case 5: 
            }
            SessionCallback sessionCallback = this.mCallback;
            int n3 = message.arg2;
            boolean bl = false;
            if (n3 != 0) {
                bl = true;
            }
            sessionCallback.onFinished(n, bl);
            return true;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSessionActiveChanged(int n, boolean bl) {
            Handler handler = this.mHandler;
            int n2 = bl ? 1 : 0;
            handler.obtainMessage(3, n, n2).sendToTarget();
        }

        @Override
        public void onSessionBadgingChanged(int n) {
            this.mHandler.obtainMessage(2, n, 0).sendToTarget();
        }

        @Override
        public void onSessionCreated(int n) {
            this.mHandler.obtainMessage(1, n, 0).sendToTarget();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void onSessionFinished(int n, boolean bl) {
            Handler handler = this.mHandler;
            int n2 = bl ? 1 : 0;
            handler.obtainMessage(5, n, n2).sendToTarget();
        }

        @Override
        public void onSessionProgressChanged(int n, float f) {
            this.mHandler.obtainMessage(4, n, 0, Float.valueOf(f)).sendToTarget();
        }
    }

    public static class SessionInfo
    implements Parcelable {
        public static final Parcelable.Creator<SessionInfo> CREATOR = new Parcelable.Creator<SessionInfo>(){

            @Override
            public SessionInfo createFromParcel(Parcel parcel) {
                return new SessionInfo(parcel);
            }

            public SessionInfo[] newArray(int n) {
                return new SessionInfo[n];
            }
        };
        public boolean active;
        public Bitmap appIcon;
        public CharSequence appLabel;
        public String appPackageName;
        public String installerPackageName;
        public int mode;
        public float progress;
        public String resolvedBaseCodePath;
        public boolean sealed;
        public int sessionId;
        public long sizeBytes;

        public SessionInfo() {
        }

        /*
         * Enabled aggressive block sorting
         */
        public SessionInfo(Parcel parcel) {
            boolean bl = true;
            this.sessionId = parcel.readInt();
            this.installerPackageName = parcel.readString();
            this.resolvedBaseCodePath = parcel.readString();
            this.progress = parcel.readFloat();
            boolean bl2 = parcel.readInt() != 0 ? bl : false;
            this.sealed = bl2;
            if (parcel.readInt() == 0) {
                bl = false;
            }
            this.active = bl;
            this.mode = parcel.readInt();
            this.sizeBytes = parcel.readLong();
            this.appPackageName = parcel.readString();
            this.appIcon = (Bitmap)parcel.readParcelable(null);
            this.appLabel = parcel.readString();
        }

        public Intent createDetailsIntent() {
            Intent intent = new Intent(PackageInstaller.ACTION_SESSION_DETAILS);
            intent.putExtra(PackageInstaller.EXTRA_SESSION_ID, this.sessionId);
            intent.setPackage(this.installerPackageName);
            intent.setFlags(0x10000000);
            return intent;
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Bitmap getAppIcon() {
            return this.appIcon;
        }

        public CharSequence getAppLabel() {
            return this.appLabel;
        }

        public String getAppPackageName() {
            return this.appPackageName;
        }

        @Deprecated
        public Intent getDetailsIntent() {
            return this.createDetailsIntent();
        }

        public String getInstallerPackageName() {
            return this.installerPackageName;
        }

        public float getProgress() {
            return this.progress;
        }

        public int getSessionId() {
            return this.sessionId;
        }

        public boolean isActive() {
            return this.active;
        }

        @Deprecated
        public boolean isOpen() {
            return this.isActive();
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            int n2 = 1;
            parcel.writeInt(this.sessionId);
            parcel.writeString(this.installerPackageName);
            parcel.writeString(this.resolvedBaseCodePath);
            parcel.writeFloat(this.progress);
            int n3 = this.sealed ? n2 : 0;
            parcel.writeInt(n3);
            if (!this.active) {
                n2 = 0;
            }
            parcel.writeInt(n2);
            parcel.writeInt(this.mode);
            parcel.writeLong(this.sizeBytes);
            parcel.writeString(this.appPackageName);
            parcel.writeParcelable(this.appIcon, n);
            String string2 = this.appLabel != null ? this.appLabel.toString() : null;
            parcel.writeString(string2);
        }
    }

    public static class SessionParams
    implements Parcelable {
        public static final Parcelable.Creator<SessionParams> CREATOR = new Parcelable.Creator<SessionParams>(){

            @Override
            public SessionParams createFromParcel(Parcel parcel) {
                return new SessionParams(parcel);
            }

            public SessionParams[] newArray(int n) {
                return new SessionParams[n];
            }
        };
        public static final int MODE_FULL_INSTALL = 1;
        public static final int MODE_INHERIT_EXISTING = 2;
        public static final int MODE_INVALID = -1;
        public String abiOverride;
        public Bitmap appIcon;
        public long appIconLastModified = -1L;
        public String appLabel;
        public String appPackageName;
        public int installFlags;
        public int installLocation = 0;
        public int mode = -1;
        public Uri originatingUri;
        public Uri referrerUri;
        public long sizeBytes = -1L;

        public SessionParams(int n) {
            this.mode = n;
        }

        public SessionParams(Parcel parcel) {
            this.mode = parcel.readInt();
            this.installFlags = parcel.readInt();
            this.installLocation = parcel.readInt();
            this.sizeBytes = parcel.readLong();
            this.appPackageName = parcel.readString();
            this.appIcon = (Bitmap)parcel.readParcelable(null);
            this.appLabel = parcel.readString();
            this.originatingUri = (Uri)parcel.readParcelable(null);
            this.referrerUri = (Uri)parcel.readParcelable(null);
            this.abiOverride = parcel.readString();
        }

        @Override
        public int describeContents() {
            return 0;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void dump(IndentingPrintWriter indentingPrintWriter) {
            indentingPrintWriter.printPair("mode", this.mode);
            indentingPrintWriter.printHexPair("installFlags", this.installFlags);
            indentingPrintWriter.printPair("installLocation", this.installLocation);
            indentingPrintWriter.printPair("sizeBytes", this.sizeBytes);
            indentingPrintWriter.printPair("appPackageName", this.appPackageName);
            boolean bl = this.appIcon != null;
            indentingPrintWriter.printPair("appIcon", bl);
            indentingPrintWriter.printPair("appLabel", this.appLabel);
            indentingPrintWriter.printPair("originatingUri", this.originatingUri);
            indentingPrintWriter.printPair("referrerUri", this.referrerUri);
            indentingPrintWriter.printPair("abiOverride", this.abiOverride);
            indentingPrintWriter.println();
        }

        public void setAppIcon(Bitmap bitmap) {
            this.appIcon = bitmap;
        }

        /*
         * Enabled aggressive block sorting
         */
        public void setAppLabel(CharSequence charSequence) {
            String string2 = charSequence != null ? charSequence.toString() : null;
            this.appLabel = string2;
        }

        public void setAppPackageName(String string2) {
            this.appPackageName = string2;
        }

        public void setInstallFlagsExternal() {
            this.installFlags = 8 | this.installFlags;
            this.installFlags = 0xFFFFFFEF & this.installFlags;
        }

        public void setInstallFlagsInternal() {
            this.installFlags = 0x10 | this.installFlags;
            this.installFlags = 0xFFFFFFF7 & this.installFlags;
        }

        public void setInstallLocation(int n) {
            this.installLocation = n;
        }

        public void setOriginatingUri(Uri uri) {
            this.originatingUri = uri;
        }

        public void setReferrerUri(Uri uri) {
            this.referrerUri = uri;
        }

        public void setSize(long l) {
            this.sizeBytes = l;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.mode);
            parcel.writeInt(this.installFlags);
            parcel.writeInt(this.installLocation);
            parcel.writeLong(this.sizeBytes);
            parcel.writeString(this.appPackageName);
            parcel.writeParcelable(this.appIcon, n);
            parcel.writeString(this.appLabel);
            parcel.writeParcelable(this.originatingUri, n);
            parcel.writeParcelable(this.referrerUri, n);
            parcel.writeString(this.abiOverride);
        }
    }
}

