/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.util.Slog;
import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Arrays;
import libcore.io.IoUtils;

public class ManifestDigest
implements Parcelable {
    public static final Parcelable.Creator<ManifestDigest> CREATOR = new Parcelable.Creator<ManifestDigest>(){

        @Override
        public ManifestDigest createFromParcel(Parcel parcel) {
            return new ManifestDigest(parcel);
        }

        public ManifestDigest[] newArray(int n) {
            return new ManifestDigest[n];
        }
    };
    private static final String DIGEST_ALGORITHM = "SHA-256";
    private static final String TAG = "ManifestDigest";
    private static final String TO_STRING_PREFIX = "ManifestDigest {mDigest=";
    private final byte[] mDigest;

    private ManifestDigest(Parcel parcel) {
        this.mDigest = parcel.createByteArray();
    }

    ManifestDigest(byte[] byArray) {
        this.mDigest = byArray;
    }

    /*
     * Loose catch block
     */
    static ManifestDigest fromInputStream(InputStream inputStream) {
        if (inputStream == null) {
            return null;
        }
        MessageDigest messageDigest = MessageDigest.getInstance(DIGEST_ALGORITHM);
        DigestInputStream digestInputStream = new DigestInputStream(new BufferedInputStream(inputStream), messageDigest);
        try {
            int n;
            byte[] byArray = new byte[8192];
            while ((n = digestInputStream.read(byArray, 0, byArray.length)) != -1) {
            }
        }
        catch (IOException iOException) {
            Slog.w(TAG, "Could not read manifest");
            return null;
        }
        finally {
            IoUtils.closeQuietly((AutoCloseable)digestInputStream);
        }
        IoUtils.closeQuietly((AutoCloseable)digestInputStream);
        return new ManifestDigest(messageDigest.digest());
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            throw new RuntimeException("SHA-256 must be available", noSuchAlgorithmException);
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        ManifestDigest manifestDigest;
        return object instanceof ManifestDigest && (this == (manifestDigest = (ManifestDigest)object) || Arrays.equals(this.mDigest, manifestDigest.mDigest));
    }

    public int hashCode() {
        return Arrays.hashCode(this.mDigest);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(1 + (TO_STRING_PREFIX.length() + 3 * this.mDigest.length));
        stringBuilder.append(TO_STRING_PREFIX);
        int n = this.mDigest.length;
        for (int i = 0; i < n; ++i) {
            IntegralToString.appendByteAsHex((StringBuilder)stringBuilder, (byte)this.mDigest[i], (boolean)false);
            stringBuilder.append(',');
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeByteArray(this.mDigest);
    }
}

