/*
 * Decompiled with CFR 0.152.
 */
package android.content.pm;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import android.util.Slog;
import java.security.InvalidAlgorithmParameterException;
import java.security.spec.AlgorithmParameterSpec;
import java.util.Arrays;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;

@Deprecated
public class ContainerEncryptionParams
implements Parcelable {
    public static final Parcelable.Creator<ContainerEncryptionParams> CREATOR = new Parcelable.Creator<ContainerEncryptionParams>(){

        @Override
        public ContainerEncryptionParams createFromParcel(Parcel parcel) {
            try {
                ContainerEncryptionParams containerEncryptionParams = new ContainerEncryptionParams(parcel);
                return containerEncryptionParams;
            }
            catch (InvalidAlgorithmParameterException invalidAlgorithmParameterException) {
                Slog.e(ContainerEncryptionParams.TAG, "Invalid algorithm parameters specified", invalidAlgorithmParameterException);
                return null;
            }
        }

        public ContainerEncryptionParams[] newArray(int n) {
            return new ContainerEncryptionParams[n];
        }
    };
    private static final int ENC_PARAMS_IV_PARAMETERS = 1;
    private static final int MAC_PARAMS_NONE = 1;
    protected static final String TAG = "ContainerEncryptionParams";
    private static final String TO_STRING_PREFIX = "ContainerEncryptionParams{";
    private final long mAuthenticatedDataStart;
    private final long mDataEnd;
    private final long mEncryptedDataStart;
    private final String mEncryptionAlgorithm;
    private final SecretKey mEncryptionKey;
    private final IvParameterSpec mEncryptionSpec;
    private final String mMacAlgorithm;
    private final SecretKey mMacKey;
    private final AlgorithmParameterSpec mMacSpec;
    private final byte[] mMacTag;

    private ContainerEncryptionParams(Parcel parcel) throws InvalidAlgorithmParameterException {
        this.mEncryptionAlgorithm = parcel.readString();
        int n = parcel.readInt();
        byte[] byArray = parcel.createByteArray();
        this.mEncryptionKey = (SecretKey)parcel.readSerializable();
        this.mMacAlgorithm = parcel.readString();
        int n2 = parcel.readInt();
        parcel.createByteArray();
        this.mMacKey = (SecretKey)parcel.readSerializable();
        this.mMacTag = parcel.createByteArray();
        this.mAuthenticatedDataStart = parcel.readLong();
        this.mEncryptedDataStart = parcel.readLong();
        this.mDataEnd = parcel.readLong();
        switch (n) {
            default: {
                throw new InvalidAlgorithmParameterException("Unknown parameter type " + n);
            }
            case 1: 
        }
        this.mEncryptionSpec = new IvParameterSpec(byArray);
        switch (n2) {
            default: {
                throw new InvalidAlgorithmParameterException("Unknown parameter type " + n2);
            }
            case 1: 
        }
        this.mMacSpec = null;
        if (this.mEncryptionKey == null) {
            throw new NullPointerException("encryptionKey == null");
        }
    }

    public ContainerEncryptionParams(String string2, AlgorithmParameterSpec algorithmParameterSpec, SecretKey secretKey) throws InvalidAlgorithmParameterException {
        this(string2, algorithmParameterSpec, secretKey, null, null, null, null, -1L, -1L, -1L);
    }

    public ContainerEncryptionParams(String string2, AlgorithmParameterSpec algorithmParameterSpec, SecretKey secretKey, String string3, AlgorithmParameterSpec algorithmParameterSpec2, SecretKey secretKey2, byte[] byArray, long l, long l2, long l3) throws InvalidAlgorithmParameterException {
        if (TextUtils.isEmpty(string2)) {
            throw new NullPointerException("algorithm == null");
        }
        if (algorithmParameterSpec == null) {
            throw new NullPointerException("encryptionSpec == null");
        }
        if (secretKey == null) {
            throw new NullPointerException("encryptionKey == null");
        }
        if (!TextUtils.isEmpty(string3) && secretKey2 == null) {
            throw new NullPointerException("macKey == null");
        }
        if (!(algorithmParameterSpec instanceof IvParameterSpec)) {
            throw new InvalidAlgorithmParameterException("Unknown parameter spec class; must be IvParameters");
        }
        this.mEncryptionAlgorithm = string2;
        this.mEncryptionSpec = (IvParameterSpec)algorithmParameterSpec;
        this.mEncryptionKey = secretKey;
        this.mMacAlgorithm = string3;
        this.mMacSpec = algorithmParameterSpec2;
        this.mMacKey = secretKey2;
        this.mMacTag = byArray;
        this.mAuthenticatedDataStart = l;
        this.mEncryptedDataStart = l2;
        this.mDataEnd = l3;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static final boolean isSecretKeyEqual(SecretKey secretKey, SecretKey secretKey2) {
        String string2 = secretKey.getFormat();
        String string3 = secretKey2.getFormat();
        if (string2 == null) {
            if (string2 != string3 || secretKey.getEncoded() != secretKey2.getEncoded()) return false;
            return true;
        }
        if (!string2.equals(secretKey2.getFormat())) {
            return false;
        }
        if (!Arrays.equals(secretKey.getEncoded(), secretKey2.getEncoded())) return false;
        return true;
    }

    @Override
    public int describeContents() {
        return 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean equals(Object object) {
        block8: {
            block7: {
                if (this == object) break block7;
                if (!(object instanceof ContainerEncryptionParams)) {
                    return false;
                }
                ContainerEncryptionParams containerEncryptionParams = (ContainerEncryptionParams)object;
                if (this.mAuthenticatedDataStart != containerEncryptionParams.mAuthenticatedDataStart || this.mEncryptedDataStart != containerEncryptionParams.mEncryptedDataStart || this.mDataEnd != containerEncryptionParams.mDataEnd) {
                    return false;
                }
                if (!this.mEncryptionAlgorithm.equals(containerEncryptionParams.mEncryptionAlgorithm) || !this.mMacAlgorithm.equals(containerEncryptionParams.mMacAlgorithm)) {
                    return false;
                }
                if (!ContainerEncryptionParams.isSecretKeyEqual(this.mEncryptionKey, containerEncryptionParams.mEncryptionKey) || !ContainerEncryptionParams.isSecretKeyEqual(this.mMacKey, containerEncryptionParams.mMacKey)) {
                    return false;
                }
                if (!Arrays.equals(this.mEncryptionSpec.getIV(), containerEncryptionParams.mEncryptionSpec.getIV()) || !Arrays.equals(this.mMacTag, containerEncryptionParams.mMacTag) || this.mMacSpec != containerEncryptionParams.mMacSpec) break block8;
            }
            return true;
        }
        return false;
    }

    public long getAuthenticatedDataStart() {
        return this.mAuthenticatedDataStart;
    }

    public long getDataEnd() {
        return this.mDataEnd;
    }

    public long getEncryptedDataStart() {
        return this.mEncryptedDataStart;
    }

    public String getEncryptionAlgorithm() {
        return this.mEncryptionAlgorithm;
    }

    public SecretKey getEncryptionKey() {
        return this.mEncryptionKey;
    }

    public AlgorithmParameterSpec getEncryptionSpec() {
        return this.mEncryptionSpec;
    }

    public String getMacAlgorithm() {
        return this.mMacAlgorithm;
    }

    public SecretKey getMacKey() {
        return this.mMacKey;
    }

    public AlgorithmParameterSpec getMacSpec() {
        return this.mMacSpec;
    }

    public byte[] getMacTag() {
        return this.mMacTag;
    }

    public int hashCode() {
        return (int)((long)((int)((long)((int)((long)(3 + 5 * this.mEncryptionAlgorithm.hashCode() + 7 * Arrays.hashCode(this.mEncryptionSpec.getIV()) + 11 * this.mEncryptionKey.hashCode() + 13 * this.mMacAlgorithm.hashCode() + 17 * this.mMacKey.hashCode() + 19 * Arrays.hashCode(this.mMacTag)) + 23L * this.mAuthenticatedDataStart)) + 29L * this.mEncryptedDataStart)) + 31L * this.mDataEnd);
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(TO_STRING_PREFIX);
        stringBuilder.append("mEncryptionAlgorithm=\"");
        stringBuilder.append(this.mEncryptionAlgorithm);
        stringBuilder.append("\",");
        stringBuilder.append("mEncryptionSpec=");
        stringBuilder.append(this.mEncryptionSpec.toString());
        stringBuilder.append("mEncryptionKey=");
        stringBuilder.append(this.mEncryptionKey.toString());
        stringBuilder.append("mMacAlgorithm=\"");
        stringBuilder.append(this.mMacAlgorithm);
        stringBuilder.append("\",");
        stringBuilder.append("mMacSpec=");
        stringBuilder.append(this.mMacSpec.toString());
        stringBuilder.append("mMacKey=");
        stringBuilder.append(this.mMacKey.toString());
        stringBuilder.append(",mAuthenticatedDataStart=");
        stringBuilder.append(this.mAuthenticatedDataStart);
        stringBuilder.append(",mEncryptedDataStart=");
        stringBuilder.append(this.mEncryptedDataStart);
        stringBuilder.append(",mDataEnd=");
        stringBuilder.append(this.mDataEnd);
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeString(this.mEncryptionAlgorithm);
        parcel.writeInt(1);
        parcel.writeByteArray(this.mEncryptionSpec.getIV());
        parcel.writeSerializable(this.mEncryptionKey);
        parcel.writeString(this.mMacAlgorithm);
        parcel.writeInt(1);
        parcel.writeByteArray(new byte[0]);
        parcel.writeSerializable(this.mMacKey);
        parcel.writeByteArray(this.mMacTag);
        parcel.writeLong(this.mAuthenticatedDataStart);
        parcel.writeLong(this.mEncryptedDataStart);
        parcel.writeLong(this.mDataEnd);
    }
}

