/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.content.ContentResolver;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;

public class SyncRequest
implements Parcelable {
    public static final Parcelable.Creator<SyncRequest> CREATOR = new Parcelable.Creator<SyncRequest>(){

        @Override
        public SyncRequest createFromParcel(Parcel parcel) {
            return new SyncRequest(parcel);
        }

        public SyncRequest[] newArray(int n) {
            return new SyncRequest[n];
        }
    };
    private static final String TAG = "SyncRequest";
    private final Account mAccountToSync;
    private final String mAuthority;
    private final boolean mDisallowMetered;
    private final Bundle mExtras;
    private final boolean mIsAuthority;
    private final boolean mIsExpedited;
    private final boolean mIsPeriodic;
    private final long mSyncFlexTimeSecs;
    private final long mSyncRunTimeSecs;

    /*
     * Enabled aggressive block sorting
     */
    protected SyncRequest(Builder builder) {
        int n = 1;
        this.mSyncFlexTimeSecs = builder.mSyncFlexTimeSecs;
        this.mSyncRunTimeSecs = builder.mSyncRunTimeSecs;
        this.mAccountToSync = builder.mAccount;
        this.mAuthority = builder.mAuthority;
        int n2 = builder.mSyncType == n ? n : 0;
        this.mIsPeriodic = n2;
        if (builder.mSyncTarget != 2) {
            n = 0;
        }
        this.mIsAuthority = n;
        this.mIsExpedited = builder.mExpedited;
        this.mExtras = new Bundle(builder.mCustomExtras);
        this.mExtras.putAll(builder.mSyncConfigExtras);
        this.mDisallowMetered = builder.mDisallowMetered;
    }

    /*
     * Enabled aggressive block sorting
     */
    private SyncRequest(Parcel parcel) {
        boolean bl = true;
        this.mExtras = parcel.readBundle();
        this.mSyncFlexTimeSecs = parcel.readLong();
        this.mSyncRunTimeSecs = parcel.readLong();
        boolean bl2 = parcel.readInt() != 0 ? bl : false;
        this.mIsPeriodic = bl2;
        boolean bl3 = parcel.readInt() != 0 ? bl : false;
        this.mDisallowMetered = bl3;
        boolean bl4 = parcel.readInt() != 0 ? bl : false;
        this.mIsAuthority = bl4;
        if (parcel.readInt() == 0) {
            bl = false;
        }
        this.mIsExpedited = bl;
        this.mAccountToSync = (Account)parcel.readParcelable(null);
        this.mAuthority = parcel.readString();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public Account getAccount() {
        return this.mAccountToSync;
    }

    public Bundle getBundle() {
        return this.mExtras;
    }

    public String getProvider() {
        return this.mAuthority;
    }

    public long getSyncFlexTime() {
        return this.mSyncFlexTimeSecs;
    }

    public long getSyncRunTime() {
        return this.mSyncRunTimeSecs;
    }

    public boolean isExpedited() {
        return this.mIsExpedited;
    }

    public boolean isPeriodic() {
        return this.mIsPeriodic;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        int n2 = 1;
        parcel.writeBundle(this.mExtras);
        parcel.writeLong(this.mSyncFlexTimeSecs);
        parcel.writeLong(this.mSyncRunTimeSecs);
        int n3 = this.mIsPeriodic ? n2 : 0;
        parcel.writeInt(n3);
        int n4 = this.mDisallowMetered ? n2 : 0;
        parcel.writeInt(n4);
        int n5 = this.mIsAuthority ? n2 : 0;
        parcel.writeInt(n5);
        if (!this.mIsExpedited) {
            n2 = 0;
        }
        parcel.writeInt(n2);
        parcel.writeParcelable(this.mAccountToSync, n);
        parcel.writeString(this.mAuthority);
    }

    public static class Builder {
        private static final int SYNC_TARGET_ADAPTER = 2;
        private static final int SYNC_TARGET_UNKNOWN = 0;
        private static final int SYNC_TYPE_ONCE = 2;
        private static final int SYNC_TYPE_PERIODIC = 1;
        private static final int SYNC_TYPE_UNKNOWN;
        private Account mAccount;
        private String mAuthority;
        private Bundle mCustomExtras;
        private boolean mDisallowMetered;
        private boolean mExpedited;
        private boolean mIgnoreBackoff;
        private boolean mIgnoreSettings;
        private boolean mIsManual;
        private boolean mNoRetry;
        private Bundle mSyncConfigExtras;
        private long mSyncFlexTimeSecs;
        private long mSyncRunTimeSecs;
        private int mSyncTarget = 0;
        private int mSyncType = 0;

        private void setupInterval(long l, long l2) {
            if (l2 > l) {
                throw new IllegalArgumentException("Specified run time for the sync must be after the specified flex time.");
            }
            this.mSyncRunTimeSecs = l;
            this.mSyncFlexTimeSecs = l2;
        }

        public SyncRequest build() {
            ContentResolver.validateSyncExtrasBundle(this.mCustomExtras);
            if (this.mCustomExtras == null) {
                this.mCustomExtras = new Bundle();
            }
            this.mSyncConfigExtras = new Bundle();
            if (this.mIgnoreBackoff) {
                this.mSyncConfigExtras.putBoolean("ignore_backoff", true);
            }
            if (this.mDisallowMetered) {
                this.mSyncConfigExtras.putBoolean("allow_metered", true);
            }
            if (this.mIgnoreSettings) {
                this.mSyncConfigExtras.putBoolean("ignore_settings", true);
            }
            if (this.mNoRetry) {
                this.mSyncConfigExtras.putBoolean("do_not_retry", true);
            }
            if (this.mExpedited) {
                this.mSyncConfigExtras.putBoolean("expedited", true);
            }
            if (this.mIsManual) {
                this.mSyncConfigExtras.putBoolean("ignore_backoff", true);
                this.mSyncConfigExtras.putBoolean("ignore_settings", true);
            }
            if (this.mSyncType == 1 && (ContentResolver.invalidPeriodicExtras(this.mCustomExtras) || ContentResolver.invalidPeriodicExtras(this.mSyncConfigExtras))) {
                throw new IllegalArgumentException("Illegal extras were set");
            }
            if (this.mSyncTarget == 0) {
                throw new IllegalArgumentException("Must specify an adapter with setSyncAdapter(Account, String");
            }
            return new SyncRequest(this);
        }

        public Builder setDisallowMetered(boolean bl) {
            if (this.mIgnoreSettings && bl) {
                throw new IllegalArgumentException("setDisallowMetered(true) after havingspecified that settings are ignored.");
            }
            this.mDisallowMetered = bl;
            return this;
        }

        public Builder setExpedited(boolean bl) {
            this.mExpedited = bl;
            return this;
        }

        public Builder setExtras(Bundle bundle) {
            this.mCustomExtras = bundle;
            return this;
        }

        public Builder setIgnoreBackoff(boolean bl) {
            this.mIgnoreBackoff = bl;
            return this;
        }

        public Builder setIgnoreSettings(boolean bl) {
            if (this.mDisallowMetered && bl) {
                throw new IllegalArgumentException("setIgnoreSettings(true) after having specified sync settings with this builder.");
            }
            this.mIgnoreSettings = bl;
            return this;
        }

        public Builder setManual(boolean bl) {
            this.mIsManual = bl;
            return this;
        }

        public Builder setNoRetry(boolean bl) {
            this.mNoRetry = bl;
            return this;
        }

        public Builder setSyncAdapter(Account account, String string2) {
            if (this.mSyncTarget != 0) {
                throw new IllegalArgumentException("Sync target has already been defined.");
            }
            if (string2 != null && string2.length() == 0) {
                throw new IllegalArgumentException("Authority must be non-empty");
            }
            this.mSyncTarget = 2;
            this.mAccount = account;
            this.mAuthority = string2;
            return this;
        }

        public Builder syncOnce() {
            if (this.mSyncType != 0) {
                throw new IllegalArgumentException("Sync type has already been defined.");
            }
            this.mSyncType = 2;
            this.setupInterval(0L, 0L);
            return this;
        }

        public Builder syncPeriodic(long l, long l2) {
            if (this.mSyncType != 0) {
                throw new IllegalArgumentException("Sync type has already been defined.");
            }
            this.mSyncType = 1;
            this.setupInterval(l, l2);
            return this;
        }
    }
}

