/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.accounts.Account;
import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.content.ContentProvider;
import android.content.ContentProviderClient;
import android.content.ContentProviderOperation;
import android.content.ContentProviderResult;
import android.content.ContentValues;
import android.content.Context;
import android.content.IContentProvider;
import android.content.IContentService;
import android.content.ISyncStatusObserver;
import android.content.Intent;
import android.content.OperationApplicationException;
import android.content.PeriodicSync;
import android.content.SyncAdapterType;
import android.content.SyncInfo;
import android.content.SyncRequest;
import android.content.SyncStatusInfo;
import android.content.SyncStatusObserver;
import android.content.UriPermission;
import android.content.pm.PackageManager;
import android.content.res.AssetFileDescriptor;
import android.content.res.Resources;
import android.database.ContentObserver;
import android.database.CrossProcessCursorWrapper;
import android.database.Cursor;
import android.database.IContentObserver;
import android.net.Uri;
import android.os.Bundle;
import android.os.CancellationSignal;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import dalvik.system.CloseGuard;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Random;

public abstract class ContentResolver {
    public static final Intent ACTION_SYNC_CONN_STATUS_CHANGED = new Intent("com.android.sync.SYNC_CONN_STATUS_CHANGED");
    public static final String ANY_CURSOR_ITEM_TYPE = "vnd.android.cursor.item/*";
    public static final String CONTENT_SERVICE_NAME = "content";
    public static final String CURSOR_DIR_BASE_TYPE = "vnd.android.cursor.dir";
    public static final String CURSOR_ITEM_BASE_TYPE = "vnd.android.cursor.item";
    private static final boolean ENABLE_CONTENT_SAMPLE = false;
    public static final String EXTRA_SIZE = "android.content.extra.SIZE";
    public static final String SCHEME_ANDROID_RESOURCE = "android.resource";
    public static final String SCHEME_CONTENT = "content";
    public static final String SCHEME_FILE = "file";
    private static final int SLOW_THRESHOLD_MILLIS = 500;
    public static final int SYNC_ERROR_AUTHENTICATION = 2;
    public static final int SYNC_ERROR_CONFLICT = 5;
    public static final int SYNC_ERROR_INTERNAL = 8;
    public static final int SYNC_ERROR_IO = 3;
    private static final String[] SYNC_ERROR_NAMES = new String[]{"already-in-progress", "authentication-error", "io-error", "parse-error", "conflict", "too-many-deletions", "too-many-retries", "internal-error"};
    public static final int SYNC_ERROR_PARSE = 4;
    public static final int SYNC_ERROR_SYNC_ALREADY_IN_PROGRESS = 1;
    public static final int SYNC_ERROR_TOO_MANY_DELETIONS = 6;
    public static final int SYNC_ERROR_TOO_MANY_RETRIES = 7;
    @Deprecated
    public static final String SYNC_EXTRAS_ACCOUNT = "account";
    public static final String SYNC_EXTRAS_DISALLOW_METERED = "allow_metered";
    public static final String SYNC_EXTRAS_DISCARD_LOCAL_DELETIONS = "discard_deletions";
    public static final String SYNC_EXTRAS_DO_NOT_RETRY = "do_not_retry";
    public static final String SYNC_EXTRAS_EXPECTED_DOWNLOAD = "expected_download";
    public static final String SYNC_EXTRAS_EXPECTED_UPLOAD = "expected_upload";
    public static final String SYNC_EXTRAS_EXPEDITED = "expedited";
    @Deprecated
    public static final String SYNC_EXTRAS_FORCE = "force";
    public static final String SYNC_EXTRAS_IGNORE_BACKOFF = "ignore_backoff";
    public static final String SYNC_EXTRAS_IGNORE_SETTINGS = "ignore_settings";
    public static final String SYNC_EXTRAS_INITIALIZE = "initialize";
    public static final String SYNC_EXTRAS_MANUAL = "force";
    public static final String SYNC_EXTRAS_OVERRIDE_TOO_MANY_DELETIONS = "deletions_override";
    public static final String SYNC_EXTRAS_PRIORITY = "sync_priority";
    public static final String SYNC_EXTRAS_UPLOAD = "upload";
    public static final int SYNC_OBSERVER_TYPE_ACTIVE = 4;
    public static final int SYNC_OBSERVER_TYPE_ALL = Integer.MAX_VALUE;
    public static final int SYNC_OBSERVER_TYPE_PENDING = 2;
    public static final int SYNC_OBSERVER_TYPE_SETTINGS = 1;
    public static final int SYNC_OBSERVER_TYPE_STATUS = 8;
    private static final String TAG = "ContentResolver";
    private static IContentService sContentService;
    private final Context mContext;
    final String mPackageName;
    private final Random mRandom = new Random();

    /*
     * Enabled aggressive block sorting
     */
    public ContentResolver(Context context) {
        if (context == null) {
            context = ActivityThread.currentApplication();
        }
        this.mContext = context;
        this.mPackageName = this.mContext.getOpPackageName();
    }

    public static void addPeriodicSync(Account account, String string2, Bundle bundle, long l) {
        ContentResolver.validateSyncExtrasBundle(bundle);
        if (bundle.getBoolean("force", false) || bundle.getBoolean(SYNC_EXTRAS_DO_NOT_RETRY, false) || bundle.getBoolean(SYNC_EXTRAS_IGNORE_BACKOFF, false) || bundle.getBoolean(SYNC_EXTRAS_IGNORE_SETTINGS, false) || bundle.getBoolean(SYNC_EXTRAS_INITIALIZE, false) || bundle.getBoolean("force", false) || bundle.getBoolean(SYNC_EXTRAS_EXPEDITED, false)) {
            throw new IllegalArgumentException("illegal extras were set");
        }
        try {
            ContentResolver.getContentService().addPeriodicSync(account, string2, bundle, l);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static Object addStatusChangeListener(int n, final SyncStatusObserver syncStatusObserver) {
        if (syncStatusObserver == null) {
            throw new IllegalArgumentException("you passed in a null callback");
        }
        try {
            ISyncStatusObserver.Stub stub = new ISyncStatusObserver.Stub(){

                @Override
                public void onStatusChanged(int n) throws RemoteException {
                    syncStatusObserver.onStatusChanged(n);
                }
            };
            ContentResolver.getContentService().addStatusChangeListener(n, stub);
            return stub;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static void cancelSync(Account account, String string2) {
        try {
            ContentResolver.getContentService().cancelSync(account, string2, null);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void cancelSync(SyncRequest syncRequest) {
        if (syncRequest == null) {
            throw new IllegalArgumentException("request cannot be null");
        }
        try {
            ContentResolver.getContentService().cancelRequest(syncRequest);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void cancelSyncAsUser(Account account, String string2, int n) {
        try {
            ContentResolver.getContentService().cancelSyncAsUser(account, string2, null, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static IContentService getContentService() {
        if (sContentService != null) {
            return sContentService;
        }
        sContentService = IContentService.Stub.asInterface(ServiceManager.getService("content"));
        return sContentService;
    }

    @Deprecated
    public static SyncInfo getCurrentSync() {
        List<SyncInfo> list;
        block3: {
            try {
                list = ContentResolver.getContentService().getCurrentSyncs();
                if (!list.isEmpty()) break block3;
                return null;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("the ContentService should always be reachable", remoteException);
            }
        }
        SyncInfo syncInfo = list.get(0);
        return syncInfo;
    }

    public static List<SyncInfo> getCurrentSyncs() {
        try {
            List<SyncInfo> list = ContentResolver.getContentService().getCurrentSyncs();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static List<SyncInfo> getCurrentSyncsAsUser(int n) {
        try {
            List<SyncInfo> list = ContentResolver.getContentService().getCurrentSyncsAsUser(n);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static int getIsSyncable(Account account, String string2) {
        try {
            int n = ContentResolver.getContentService().getIsSyncable(account, string2);
            return n;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static int getIsSyncableAsUser(Account account, String string2, int n) {
        try {
            int n2 = ContentResolver.getContentService().getIsSyncableAsUser(account, string2, n);
            return n2;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean getMasterSyncAutomatically() {
        try {
            boolean bl = ContentResolver.getContentService().getMasterSyncAutomatically();
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean getMasterSyncAutomaticallyAsUser(int n) {
        try {
            boolean bl = ContentResolver.getContentService().getMasterSyncAutomaticallyAsUser(n);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static List<PeriodicSync> getPeriodicSyncs(Account account, String string2) {
        try {
            List<PeriodicSync> list = ContentResolver.getContentService().getPeriodicSyncs(account, string2, null);
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static SyncAdapterType[] getSyncAdapterTypes() {
        try {
            SyncAdapterType[] syncAdapterTypeArray = ContentResolver.getContentService().getSyncAdapterTypes();
            return syncAdapterTypeArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static SyncAdapterType[] getSyncAdapterTypesAsUser(int n) {
        try {
            SyncAdapterType[] syncAdapterTypeArray = ContentResolver.getContentService().getSyncAdapterTypesAsUser(n);
            return syncAdapterTypeArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean getSyncAutomatically(Account account, String string2) {
        try {
            boolean bl = ContentResolver.getContentService().getSyncAutomatically(account, string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean getSyncAutomaticallyAsUser(Account account, String string2, int n) {
        try {
            boolean bl = ContentResolver.getContentService().getSyncAutomaticallyAsUser(account, string2, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static SyncStatusInfo getSyncStatus(Account account, String string2) {
        try {
            SyncStatusInfo syncStatusInfo = ContentResolver.getContentService().getSyncStatus(account, string2, null);
            return syncStatusInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static SyncStatusInfo getSyncStatusAsUser(Account account, String string2, int n) {
        try {
            SyncStatusInfo syncStatusInfo = ContentResolver.getContentService().getSyncStatusAsUser(account, string2, null, n);
            return syncStatusInfo;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean invalidPeriodicExtras(Bundle bundle) {
        boolean bl;
        block3: {
            block2: {
                if (bundle.getBoolean("force", false) || bundle.getBoolean(SYNC_EXTRAS_DO_NOT_RETRY, false) || bundle.getBoolean(SYNC_EXTRAS_IGNORE_BACKOFF, false) || bundle.getBoolean(SYNC_EXTRAS_IGNORE_SETTINGS, false) || bundle.getBoolean(SYNC_EXTRAS_INITIALIZE, false) || bundle.getBoolean("force", false)) break block2;
                boolean bl2 = bundle.getBoolean(SYNC_EXTRAS_EXPEDITED, false);
                bl = false;
                if (!bl2) break block3;
            }
            bl = true;
        }
        return bl;
    }

    public static boolean isSyncActive(Account account, String string2) {
        if (account == null) {
            throw new IllegalArgumentException("account must not be null");
        }
        if (string2 == null) {
            throw new IllegalArgumentException("authority must not be null");
        }
        try {
            boolean bl = ContentResolver.getContentService().isSyncActive(account, string2, null);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static boolean isSyncPending(Account account, String string2) {
        return ContentResolver.isSyncPendingAsUser(account, string2, UserHandle.myUserId());
    }

    public static boolean isSyncPendingAsUser(Account account, String string2, int n) {
        try {
            boolean bl = ContentResolver.getContentService().isSyncPendingAsUser(account, string2, null, n);
            return bl;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    private void maybeLogQueryToEventLog(long l, Uri uri, String[] stringArray, String string2, String string3) {
    }

    private void maybeLogUpdateToEventLog(long l, Uri uri, String string2, String string3) {
    }

    public static void removePeriodicSync(Account account, String string2, Bundle bundle) {
        ContentResolver.validateSyncExtrasBundle(bundle);
        try {
            ContentResolver.getContentService().removePeriodicSync(account, string2, bundle);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("the ContentService should always be reachable", remoteException);
        }
    }

    public static void removeStatusChangeListener(Object object) {
        if (object == null) {
            throw new IllegalArgumentException("you passed in a null handle");
        }
        try {
            ContentResolver.getContentService().removeStatusChangeListener((ISyncStatusObserver.Stub)object);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void requestSync(Account account, String string2, Bundle bundle) {
        ContentResolver.requestSyncAsUser(account, string2, UserHandle.myUserId(), bundle);
    }

    public static void requestSync(SyncRequest syncRequest) {
        try {
            ContentResolver.getContentService().sync(syncRequest);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void requestSyncAsUser(Account account, String string2, int n, Bundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Must specify extras.");
        }
        SyncRequest syncRequest = new SyncRequest.Builder().setSyncAdapter(account, string2).setExtras(bundle).syncOnce().build();
        try {
            ContentResolver.getContentService().syncAsUser(syncRequest, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    private int samplePercentForDuration(long l) {
        if (l >= 500L) {
            return 100;
        }
        return 1 + (int)(100L * l / 500L);
    }

    public static void setIsSyncable(Account account, String string2, int n) {
        try {
            ContentResolver.getContentService().setIsSyncable(account, string2, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void setMasterSyncAutomatically(boolean bl) {
        ContentResolver.setMasterSyncAutomaticallyAsUser(bl, UserHandle.myUserId());
    }

    public static void setMasterSyncAutomaticallyAsUser(boolean bl, int n) {
        try {
            ContentResolver.getContentService().setMasterSyncAutomaticallyAsUser(bl, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static void setSyncAutomatically(Account account, String string2, boolean bl) {
        ContentResolver.setSyncAutomaticallyAsUser(account, string2, bl, UserHandle.myUserId());
    }

    public static void setSyncAutomaticallyAsUser(Account account, String string2, boolean bl, int n) {
        try {
            ContentResolver.getContentService().setSyncAutomaticallyAsUser(account, string2, bl, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public static int syncErrorStringToInt(String string2) {
        int n = SYNC_ERROR_NAMES.length;
        for (int i = 0; i < n; ++i) {
            if (!SYNC_ERROR_NAMES[i].equals(string2)) continue;
            return i + 1;
        }
        if (string2 != null) {
            try {
                int n2 = Integer.parseInt(string2);
                return n2;
            }
            catch (NumberFormatException numberFormatException) {
                Log.d(TAG, "error parsing sync error: " + string2);
            }
        }
        return 0;
    }

    public static String syncErrorToString(int n) {
        if (n < 1 || n > SYNC_ERROR_NAMES.length) {
            return String.valueOf(n);
        }
        return SYNC_ERROR_NAMES[n - 1];
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static void validateSyncExtrasBundle(Bundle bundle) {
        try {
            Object object;
            Iterator<String> iterator = bundle.keySet().iterator();
            do {
                if (!iterator.hasNext()) return;
            } while ((object = bundle.get(iterator.next())) == null || object instanceof Long || object instanceof Integer || object instanceof Boolean || object instanceof Float || object instanceof Double || object instanceof String || object instanceof Account);
            throw new IllegalArgumentException("unexpected value type: " + object.getClass().getName());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw illegalArgumentException;
        }
        catch (RuntimeException runtimeException) {
            throw new IllegalArgumentException("error unparceling Bundle", runtimeException);
        }
    }

    public final ContentProviderClient acquireContentProviderClient(Uri uri) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider != null) {
            return new ContentProviderClient(this, iContentProvider, true);
        }
        return null;
    }

    public final ContentProviderClient acquireContentProviderClient(String string2) {
        IContentProvider iContentProvider = this.acquireProvider(string2);
        if (iContentProvider != null) {
            return new ContentProviderClient(this, iContentProvider, true);
        }
        return null;
    }

    protected IContentProvider acquireExistingProvider(Context context, String string2) {
        return this.acquireProvider(context, string2);
    }

    /*
     * Enabled aggressive block sorting
     */
    public final IContentProvider acquireExistingProvider(Uri uri) {
        String string2;
        if (!"content".equals(uri.getScheme()) || (string2 = uri.getAuthority()) == null) {
            return null;
        }
        return this.acquireExistingProvider(this.mContext, string2);
    }

    protected abstract IContentProvider acquireProvider(Context var1, String var2);

    /*
     * Enabled aggressive block sorting
     */
    public final IContentProvider acquireProvider(Uri uri) {
        String string2;
        if (!"content".equals(uri.getScheme()) || (string2 = uri.getAuthority()) == null) {
            return null;
        }
        return this.acquireProvider(this.mContext, string2);
    }

    public final IContentProvider acquireProvider(String string2) {
        if (string2 == null) {
            return null;
        }
        return this.acquireProvider(this.mContext, string2);
    }

    public final ContentProviderClient acquireUnstableContentProviderClient(Uri uri) {
        IContentProvider iContentProvider = this.acquireUnstableProvider(uri);
        if (iContentProvider != null) {
            return new ContentProviderClient(this, iContentProvider, false);
        }
        return null;
    }

    public final ContentProviderClient acquireUnstableContentProviderClient(String string2) {
        IContentProvider iContentProvider = this.acquireUnstableProvider(string2);
        if (iContentProvider != null) {
            return new ContentProviderClient(this, iContentProvider, false);
        }
        return null;
    }

    protected abstract IContentProvider acquireUnstableProvider(Context var1, String var2);

    /*
     * Enabled aggressive block sorting
     */
    public final IContentProvider acquireUnstableProvider(Uri uri) {
        if (!"content".equals(uri.getScheme()) || uri.getAuthority() == null) {
            return null;
        }
        return this.acquireUnstableProvider(this.mContext, uri.getAuthority());
    }

    public final IContentProvider acquireUnstableProvider(String string2) {
        if (string2 == null) {
            return null;
        }
        return this.acquireUnstableProvider(this.mContext, string2);
    }

    public void appNotRespondingViaProvider(IContentProvider iContentProvider) {
        throw new UnsupportedOperationException("appNotRespondingViaProvider");
    }

    public ContentProviderResult[] applyBatch(String string2, ArrayList<ContentProviderOperation> arrayList) throws RemoteException, OperationApplicationException {
        ContentProviderClient contentProviderClient = this.acquireContentProviderClient(string2);
        if (contentProviderClient == null) {
            throw new IllegalArgumentException("Unknown authority " + string2);
        }
        try {
            ContentProviderResult[] contentProviderResultArray = contentProviderClient.applyBatch(arrayList);
            return contentProviderResultArray;
        }
        finally {
            contentProviderClient.release();
        }
    }

    public final int bulkInsert(Uri uri, ContentValues[] contentValuesArray) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            throw new IllegalArgumentException("Unknown URL " + uri);
        }
        try {
            long l = SystemClock.uptimeMillis();
            int n = iContentProvider.bulkInsert(this.mPackageName, uri, contentValuesArray);
            this.maybeLogUpdateToEventLog(SystemClock.uptimeMillis() - l, uri, "bulkinsert", null);
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    public final Bundle call(Uri uri, String string2, String string3, Bundle bundle) {
        if (uri == null) {
            throw new NullPointerException("uri == null");
        }
        if (string2 == null) {
            throw new NullPointerException("method == null");
        }
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            Bundle bundle2 = iContentProvider.call(this.mPackageName, string2, string3, bundle);
            return bundle2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public void cancelSync(Uri uri) {
        String string2 = uri != null ? uri.getAuthority() : null;
        ContentResolver.cancelSync(null, string2);
    }

    public final Uri canonicalize(Uri uri) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            return null;
        }
        try {
            Uri uri2 = iContentProvider.canonicalize(this.mPackageName, uri);
            return uri2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    public final int delete(Uri uri, String string2, String[] stringArray) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            throw new IllegalArgumentException("Unknown URL " + uri);
        }
        try {
            long l = SystemClock.uptimeMillis();
            int n = iContentProvider.delete(this.mPackageName, uri, string2, stringArray);
            this.maybeLogUpdateToEventLog(SystemClock.uptimeMillis() - l, uri, "delete", string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    public List<UriPermission> getOutgoingPersistedUriPermissions() {
        try {
            List<UriPermission> list = ActivityManagerNative.getDefault().getPersistedUriPermissions(this.mPackageName, false).getList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Activity manager has died", remoteException);
        }
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    public List<UriPermission> getPersistedUriPermissions() {
        try {
            List<UriPermission> list = ActivityManagerNative.getDefault().getPersistedUriPermissions(this.mPackageName, true).getList();
            return list;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("Activity manager has died", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public OpenResourceIdResult getResourceId(Uri uri) throws FileNotFoundException {
        int n;
        List<String> list;
        Resources resources;
        String string2 = uri.getAuthority();
        if (TextUtils.isEmpty(string2)) {
            throw new FileNotFoundException("No authority: " + uri);
        }
        try {
            resources = this.mContext.getPackageManager().getResourcesForApplication(string2);
            list = uri.getPathSegments();
            if (list == null) {
                throw new FileNotFoundException("No path: " + uri);
            }
        }
        catch (PackageManager.NameNotFoundException nameNotFoundException) {
            throw new FileNotFoundException("No package found for authority: " + uri);
        }
        int n2 = list.size();
        if (n2 == 1) {
            try {
                int n3;
                n = n3 = Integer.parseInt(list.get(0));
            }
            catch (NumberFormatException numberFormatException) {
                throw new FileNotFoundException("Single path segment is not a resource ID: " + uri);
            }
        } else {
            if (n2 != 2) {
                throw new FileNotFoundException("More than two path segments: " + uri);
            }
            n = resources.getIdentifier(list.get(1), list.get(0), string2);
        }
        if (n == 0) {
            throw new FileNotFoundException("No resource found for: " + uri);
        }
        OpenResourceIdResult openResourceIdResult = new OpenResourceIdResult();
        openResourceIdResult.r = resources;
        openResourceIdResult.id = n;
        return openResourceIdResult;
    }

    public String[] getStreamTypes(Uri uri, String string2) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            return null;
        }
        try {
            String[] stringArray = iContentProvider.getStreamTypes(uri, string2);
            return stringArray;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final String getType(Uri uri) {
        String string2;
        IContentProvider iContentProvider = this.acquireExistingProvider(uri);
        if (iContentProvider != null) {
            try {
                String string3;
                string2 = string3 = iContentProvider.getType(uri);
                this.releaseProvider(iContentProvider);
            }
            catch (RemoteException remoteException) {
                this.releaseProvider(iContentProvider);
                return null;
            }
            catch (Exception exception) {
                Log.w(TAG, "Failed to get type for: " + uri + " (" + exception.getMessage() + ")");
                return null;
            }
            finally {
                this.releaseProvider(iContentProvider);
            }
            return string2;
        }
        boolean bl = "content".equals(uri.getScheme());
        string2 = null;
        if (!bl) return string2;
        try {
            return ActivityManagerNative.getDefault().getProviderMimeType(ContentProvider.getUriWithoutUserId(uri), this.resolveUserId(uri));
        }
        catch (RemoteException remoteException) {
            return null;
        }
        catch (Exception exception) {
            Log.w(TAG, "Failed to get type for: " + uri + " (" + exception.getMessage() + ")");
            return null;
        }
    }

    public final Uri insert(Uri uri, ContentValues contentValues) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            throw new IllegalArgumentException("Unknown URL " + uri);
        }
        try {
            long l = SystemClock.uptimeMillis();
            Uri uri2 = iContentProvider.insert(this.mPackageName, uri, contentValues);
            this.maybeLogUpdateToEventLog(SystemClock.uptimeMillis() - l, uri, "insert", null);
            return uri2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver) {
        this.notifyChange(uri, contentObserver, true);
    }

    public void notifyChange(Uri uri, ContentObserver contentObserver, boolean bl) {
        this.notifyChange(uri, contentObserver, bl, UserHandle.myUserId());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void notifyChange(Uri uri, ContentObserver contentObserver, boolean bl, int n) {
        try {
            IContentObserver iContentObserver;
            IContentService iContentService = ContentResolver.getContentService();
            IContentObserver iContentObserver2 = contentObserver == null ? null : (iContentObserver = contentObserver.getContentObserver());
            boolean bl2 = contentObserver != null && contentObserver.deliverSelfNotifications();
            iContentService.notifyChange(uri, iContentObserver2, bl2, bl, n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final AssetFileDescriptor openAssetFileDescriptor(Uri uri, String string2) throws FileNotFoundException {
        return this.openAssetFileDescriptor(uri, string2, null);
    }

    /*
     * Exception decompiling
     */
    public final AssetFileDescriptor openAssetFileDescriptor(Uri var1_1, String var2_2, CancellationSignal var3_3) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 6[TRYBLOCK] [15, 17, 16 : 424->445)] android.os.RemoteException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final ParcelFileDescriptor openFileDescriptor(Uri uri, String string2) throws FileNotFoundException {
        return this.openFileDescriptor(uri, string2, null);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final ParcelFileDescriptor openFileDescriptor(Uri uri, String string2, CancellationSignal cancellationSignal) throws FileNotFoundException {
        AssetFileDescriptor assetFileDescriptor = this.openAssetFileDescriptor(uri, string2, cancellationSignal);
        if (assetFileDescriptor == null) {
            return null;
        }
        if (assetFileDescriptor.getDeclaredLength() < 0L) {
            return assetFileDescriptor.getParcelFileDescriptor();
        }
        try {
            assetFileDescriptor.close();
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Not a whole file");
        }
        throw new FileNotFoundException("Not a whole file");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final InputStream openInputStream(Uri uri) throws FileNotFoundException {
        String string2 = uri.getScheme();
        if (SCHEME_ANDROID_RESOURCE.equals(string2)) {
            OpenResourceIdResult openResourceIdResult = this.getResourceId(uri);
            try {
                return openResourceIdResult.r.openRawResource(openResourceIdResult.id);
            }
            catch (Resources.NotFoundException notFoundException) {
                throw new FileNotFoundException("Resource does not exist: " + uri);
            }
        }
        if (SCHEME_FILE.equals(string2)) {
            return new FileInputStream(uri.getPath());
        }
        AssetFileDescriptor assetFileDescriptor = this.openAssetFileDescriptor(uri, "r", null);
        FileInputStream fileInputStream = null;
        if (assetFileDescriptor == null) return fileInputStream;
        try {
            FileInputStream fileInputStream2 = assetFileDescriptor.createInputStream();
            return fileInputStream2;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    public final OutputStream openOutputStream(Uri uri) throws FileNotFoundException {
        return this.openOutputStream(uri, "w");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final OutputStream openOutputStream(Uri uri, String string2) throws FileNotFoundException {
        AssetFileDescriptor assetFileDescriptor = this.openAssetFileDescriptor(uri, string2, null);
        FileOutputStream fileOutputStream = null;
        if (assetFileDescriptor == null) return fileOutputStream;
        try {
            FileOutputStream fileOutputStream2 = assetFileDescriptor.createOutputStream();
            return fileOutputStream2;
        }
        catch (IOException iOException) {
            throw new FileNotFoundException("Unable to create stream");
        }
    }

    public final AssetFileDescriptor openTypedAssetFileDescriptor(Uri uri, String string2, Bundle bundle) throws FileNotFoundException {
        return this.openTypedAssetFileDescriptor(uri, string2, bundle, null);
    }

    /*
     * Exception decompiling
     */
    public final AssetFileDescriptor openTypedAssetFileDescriptor(Uri var1_1, String var2_2, Bundle var3_3, CancellationSignal var4_4) throws FileNotFoundException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 5[TRYBLOCK] [14, 16, 15 : 259->277)] android.os.RemoteException
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final Cursor query(Uri uri, String[] stringArray, String string2, String[] stringArray2, String string3) {
        return this.query(uri, stringArray, string2, stringArray2, string3, null);
    }

    /*
     * Exception decompiling
     */
    public final Cursor query(Uri var1_1, String[] var2_2, String var3_3, String[] var4_4, String var5_5, CancellationSignal var6_6) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [1[TRYBLOCK], 7[CATCHBLOCK]], but top level block is 4[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public final void registerContentObserver(Uri uri, boolean bl, ContentObserver contentObserver) {
        this.registerContentObserver(uri, bl, contentObserver, UserHandle.myUserId());
    }

    public final void registerContentObserver(Uri uri, boolean bl, ContentObserver contentObserver, int n) {
        try {
            ContentResolver.getContentService().registerContentObserver(uri, bl, contentObserver.getContentObserver(), n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void releasePersistableUriPermission(Uri uri, int n) {
        try {
            ActivityManagerNative.getDefault().releasePersistableUriPermission(ContentProvider.getUriWithoutUserId(uri), n, this.resolveUserId(uri));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public abstract boolean releaseProvider(IContentProvider var1);

    public abstract boolean releaseUnstableProvider(IContentProvider var1);

    public int resolveUserId(Uri uri) {
        return ContentProvider.getUserIdFromUri(uri, this.mContext.getUserId());
    }

    /*
     * Enabled aggressive block sorting
     */
    @Deprecated
    public void startSync(Uri uri, Bundle bundle) {
        Account account = null;
        if (bundle != null) {
            String string2 = bundle.getString(SYNC_EXTRAS_ACCOUNT);
            boolean bl = TextUtils.isEmpty(string2);
            account = null;
            if (!bl) {
                account = new Account(string2, "com.google");
            }
            bundle.remove(SYNC_EXTRAS_ACCOUNT);
        }
        String string3 = uri != null ? uri.getAuthority() : null;
        ContentResolver.requestSync(account, string3, bundle);
    }

    public void takePersistableUriPermission(Uri uri, int n) {
        try {
            ActivityManagerNative.getDefault().takePersistableUriPermission(ContentProvider.getUriWithoutUserId(uri), n, this.resolveUserId(uri));
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public final Uri uncanonicalize(Uri uri) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            return null;
        }
        try {
            Uri uri2 = iContentProvider.uncanonicalize(this.mPackageName, uri);
            return uri2;
        }
        catch (RemoteException remoteException) {
            return null;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void unregisterContentObserver(ContentObserver contentObserver) {
        IContentObserver iContentObserver;
        try {
            iContentObserver = contentObserver.releaseContentObserver();
            if (iContentObserver == null) return;
        }
        catch (RemoteException remoteException) {
            return;
        }
        ContentResolver.getContentService().unregisterContentObserver(iContentObserver);
    }

    public abstract void unstableProviderDied(IContentProvider var1);

    public final int update(Uri uri, ContentValues contentValues, String string2, String[] stringArray) {
        IContentProvider iContentProvider = this.acquireProvider(uri);
        if (iContentProvider == null) {
            throw new IllegalArgumentException("Unknown URI " + uri);
        }
        try {
            long l = SystemClock.uptimeMillis();
            int n = iContentProvider.update(this.mPackageName, uri, contentValues, string2, stringArray);
            this.maybeLogUpdateToEventLog(SystemClock.uptimeMillis() - l, uri, "update", string2);
            return n;
        }
        catch (RemoteException remoteException) {
            return -1;
        }
        finally {
            this.releaseProvider(iContentProvider);
        }
    }

    private final class CursorWrapperInner
    extends CrossProcessCursorWrapper {
        public static final String TAG = "CursorWrapperInner";
        private final CloseGuard mCloseGuard;
        private final IContentProvider mContentProvider;
        private boolean mProviderReleased;

        CursorWrapperInner(Cursor cursor, IContentProvider iContentProvider) {
            super(cursor);
            this.mCloseGuard = CloseGuard.get();
            this.mContentProvider = iContentProvider;
            this.mCloseGuard.open("close");
        }

        @Override
        public void close() {
            super.close();
            ContentResolver.this.releaseProvider(this.mContentProvider);
            this.mProviderReleased = true;
            if (this.mCloseGuard != null) {
                this.mCloseGuard.close();
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mCloseGuard != null) {
                    this.mCloseGuard.warnIfOpen();
                }
                if (!this.mProviderReleased && this.mContentProvider != null) {
                    Log.w(TAG, "Cursor finalized without prior close()");
                    ContentResolver.this.releaseProvider(this.mContentProvider);
                }
                return;
            }
            finally {
                super.finalize();
            }
        }
    }

    public class OpenResourceIdResult {
        public int id;
        public Resources r;
    }

    private final class ParcelFileDescriptorInner
    extends ParcelFileDescriptor {
        private final IContentProvider mContentProvider;
        private boolean mProviderReleased;

        ParcelFileDescriptorInner(ParcelFileDescriptor parcelFileDescriptor, IContentProvider iContentProvider) {
            super(parcelFileDescriptor);
            this.mContentProvider = iContentProvider;
        }

        @Override
        public void releaseResources() {
            if (!this.mProviderReleased) {
                ContentResolver.this.releaseProvider(this.mContentProvider);
                this.mProviderReleased = true;
            }
        }
    }
}

