/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ContentProvider;
import android.net.Uri;
import android.os.Parcel;
import android.os.Parcelable;

public class ContentProviderResult
implements Parcelable {
    public static final Parcelable.Creator<ContentProviderResult> CREATOR = new Parcelable.Creator<ContentProviderResult>(){

        @Override
        public ContentProviderResult createFromParcel(Parcel parcel) {
            return new ContentProviderResult(parcel);
        }

        public ContentProviderResult[] newArray(int n) {
            return new ContentProviderResult[n];
        }
    };
    public final Integer count;
    public final Uri uri;

    public ContentProviderResult(int n) {
        this.count = n;
        this.uri = null;
    }

    public ContentProviderResult(ContentProviderResult contentProviderResult, int n) {
        this.uri = ContentProvider.maybeAddUserId(contentProviderResult.uri, n);
        this.count = contentProviderResult.count;
    }

    public ContentProviderResult(Uri uri) {
        if (uri == null) {
            throw new IllegalArgumentException("uri must not be null");
        }
        this.uri = uri;
        this.count = null;
    }

    public ContentProviderResult(Parcel parcel) {
        if (parcel.readInt() == 1) {
            this.count = parcel.readInt();
            this.uri = null;
            return;
        }
        this.count = null;
        this.uri = Uri.CREATOR.createFromParcel(parcel);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String toString() {
        if (this.uri != null) {
            return "ContentProviderResult(uri=" + this.uri.toString() + ")";
        }
        return "ContentProviderResult(count=" + this.count + ")";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        if (this.uri == null) {
            parcel.writeInt(1);
            parcel.writeInt(this.count);
            return;
        }
        parcel.writeInt(2);
        this.uri.writeToParcel(parcel, 0);
    }
}

