/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.content.ClipData;
import android.content.ClipDescription;
import android.content.Context;
import android.content.IClipboard;
import android.content.IOnPrimaryClipChangedListener;
import android.os.Handler;
import android.os.Message;
import android.os.RemoteException;
import android.os.ServiceManager;
import java.util.ArrayList;

public class ClipboardManager
extends android.text.ClipboardManager {
    static final int MSG_REPORT_PRIMARY_CLIP_CHANGED = 1;
    private static IClipboard sService;
    private static final Object sStaticLock;
    private final Context mContext;
    private final Handler mHandler;
    private final ArrayList<OnPrimaryClipChangedListener> mPrimaryClipChangedListeners = new ArrayList();
    private final IOnPrimaryClipChangedListener.Stub mPrimaryClipChangedServiceListener = new IOnPrimaryClipChangedListener.Stub(){

        @Override
        public void dispatchPrimaryClipChanged() {
            ClipboardManager.this.mHandler.sendEmptyMessage(1);
        }
    };

    static {
        sStaticLock = new Object();
    }

    public ClipboardManager(Context context, Handler handler) {
        this.mHandler = new Handler(){

            @Override
            public void handleMessage(Message message) {
                switch (message.what) {
                    default: {
                        return;
                    }
                    case 1: 
                }
                ClipboardManager.this.reportPrimaryClipChanged();
            }
        };
        this.mContext = context;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static IClipboard getService() {
        Object object = sStaticLock;
        synchronized (object) {
            if (sService == null) return sService = IClipboard.Stub.asInterface(ServiceManager.getService("clipboard"));
            return sService;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addPrimaryClipChangedListener(OnPrimaryClipChangedListener onPrimaryClipChangedListener) {
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            int n = this.mPrimaryClipChangedListeners.size();
            if (n == 0) {
                try {
                    ClipboardManager.getService().addPrimaryClipChangedListener(this.mPrimaryClipChangedServiceListener, this.mContext.getOpPackageName());
                }
                catch (RemoteException remoteException) {}
            }
            this.mPrimaryClipChangedListeners.add(onPrimaryClipChangedListener);
            return;
        }
    }

    public ClipData getPrimaryClip() {
        try {
            ClipData clipData = ClipboardManager.getService().getPrimaryClip(this.mContext.getOpPackageName());
            return clipData;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public ClipDescription getPrimaryClipDescription() {
        try {
            ClipDescription clipDescription = ClipboardManager.getService().getPrimaryClipDescription(this.mContext.getOpPackageName());
            return clipDescription;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    @Override
    public CharSequence getText() {
        ClipData clipData = this.getPrimaryClip();
        if (clipData != null && clipData.getItemCount() > 0) {
            return clipData.getItemAt(0).coerceToText(this.mContext);
        }
        return null;
    }

    public boolean hasPrimaryClip() {
        try {
            boolean bl = ClipboardManager.getService().hasPrimaryClip(this.mContext.getOpPackageName());
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    @Override
    public boolean hasText() {
        try {
            boolean bl = ClipboardManager.getService().hasClipboardText(this.mContext.getOpPackageName());
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removePrimaryClipChangedListener(OnPrimaryClipChangedListener onPrimaryClipChangedListener) {
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            this.mPrimaryClipChangedListeners.remove(onPrimaryClipChangedListener);
            int n = this.mPrimaryClipChangedListeners.size();
            if (n == 0) {
                try {
                    ClipboardManager.getService().removePrimaryClipChangedListener(this.mPrimaryClipChangedServiceListener);
                }
                catch (RemoteException remoteException) {}
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void reportPrimaryClipChanged() {
        Object[] objectArray;
        ArrayList<OnPrimaryClipChangedListener> arrayList = this.mPrimaryClipChangedListeners;
        synchronized (arrayList) {
            if (this.mPrimaryClipChangedListeners.size() <= 0) {
                return;
            }
            objectArray = this.mPrimaryClipChangedListeners.toArray();
        }
        int n = 0;
        while (n < objectArray.length) {
            ((OnPrimaryClipChangedListener)objectArray[n]).onPrimaryClipChanged();
            ++n;
        }
        return;
    }

    /*
     * Unable to fully structure code
     */
    public void setPrimaryClip(ClipData var1_1) {
        if (var1_1 == null) ** GOTO lbl4
        try {
            var1_1.prepareToLeaveProcess();
lbl4:
            // 2 sources

            ClipboardManager.getService().setPrimaryClip(var1_1, this.mContext.getOpPackageName());
            return;
        }
        catch (RemoteException var2_2) {
            return;
        }
    }

    @Override
    public void setText(CharSequence charSequence) {
        this.setPrimaryClip(ClipData.newPlainText(null, charSequence));
    }

    public static interface OnPrimaryClipChangedListener {
        public void onPrimaryClipChanged();
    }
}

