/*
 * Decompiled with CFR 0.152.
 */
package android.content;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.QueuedWork;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.Log;

public abstract class BroadcastReceiver {
    private boolean mDebugUnregister;
    private PendingResult mPendingResult;

    public final void abortBroadcast() {
        this.checkSynchronousHint();
        this.mPendingResult.mAbortBroadcast = true;
    }

    void checkSynchronousHint() {
        if (this.mPendingResult == null) {
            throw new IllegalStateException("Call while result is not pending");
        }
        if (this.mPendingResult.mOrderedHint || this.mPendingResult.mInitialStickyHint) {
            return;
        }
        RuntimeException runtimeException = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
        runtimeException.fillInStackTrace();
        Log.e("BroadcastReceiver", runtimeException.getMessage(), runtimeException);
    }

    public final void clearAbortBroadcast() {
        if (this.mPendingResult != null) {
            this.mPendingResult.mAbortBroadcast = false;
        }
    }

    public final boolean getAbortBroadcast() {
        if (this.mPendingResult != null) {
            return this.mPendingResult.mAbortBroadcast;
        }
        return false;
    }

    public final boolean getDebugUnregister() {
        return this.mDebugUnregister;
    }

    public final PendingResult getPendingResult() {
        return this.mPendingResult;
    }

    public final int getResultCode() {
        if (this.mPendingResult != null) {
            return this.mPendingResult.mResultCode;
        }
        return 0;
    }

    public final String getResultData() {
        if (this.mPendingResult != null) {
            return this.mPendingResult.mResultData;
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final Bundle getResultExtras(boolean bl) {
        Bundle bundle;
        if (this.mPendingResult == null) {
            return null;
        }
        Bundle bundle2 = this.mPendingResult.mResultExtras;
        if (!bl) return bundle2;
        if (bundle2 != null) return bundle2;
        PendingResult pendingResult = this.mPendingResult;
        pendingResult.mResultExtras = bundle = new Bundle();
        return bundle;
    }

    public int getSendingUserId() {
        return this.mPendingResult.mSendingUser;
    }

    public final PendingResult goAsync() {
        PendingResult pendingResult = this.mPendingResult;
        this.mPendingResult = null;
        return pendingResult;
    }

    public final boolean isInitialStickyBroadcast() {
        if (this.mPendingResult != null) {
            return this.mPendingResult.mInitialStickyHint;
        }
        return false;
    }

    public final boolean isOrderedBroadcast() {
        if (this.mPendingResult != null) {
            return this.mPendingResult.mOrderedHint;
        }
        return false;
    }

    public abstract void onReceive(Context var1, Intent var2);

    public IBinder peekService(Context context, Intent intent) {
        IActivityManager iActivityManager = ActivityManagerNative.getDefault();
        try {
            intent.prepareToLeaveProcess();
            IBinder iBinder = iActivityManager.peekService(intent, intent.resolveTypeIfNeeded(context.getContentResolver()));
            return iBinder;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public final void setDebugUnregister(boolean bl) {
        this.mDebugUnregister = bl;
    }

    public final void setOrderedHint(boolean bl) {
    }

    public final void setPendingResult(PendingResult pendingResult) {
        this.mPendingResult = pendingResult;
    }

    public final void setResult(int n, String string2, Bundle bundle) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultCode = n;
        this.mPendingResult.mResultData = string2;
        this.mPendingResult.mResultExtras = bundle;
    }

    public final void setResultCode(int n) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultCode = n;
    }

    public final void setResultData(String string2) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultData = string2;
    }

    public final void setResultExtras(Bundle bundle) {
        this.checkSynchronousHint();
        this.mPendingResult.mResultExtras = bundle;
    }

    public static class PendingResult {
        public static final int TYPE_COMPONENT = 0;
        public static final int TYPE_REGISTERED = 1;
        public static final int TYPE_UNREGISTERED = 2;
        boolean mAbortBroadcast;
        boolean mFinished;
        final boolean mInitialStickyHint;
        final boolean mOrderedHint;
        int mResultCode;
        String mResultData;
        Bundle mResultExtras;
        final int mSendingUser;
        final IBinder mToken;
        final int mType;

        public PendingResult(int n, String string2, Bundle bundle, int n2, boolean bl, boolean bl2, IBinder iBinder, int n3) {
            this.mResultCode = n;
            this.mResultData = string2;
            this.mResultExtras = bundle;
            this.mType = n2;
            this.mOrderedHint = bl;
            this.mInitialStickyHint = bl2;
            this.mToken = iBinder;
            this.mSendingUser = n3;
        }

        public final void abortBroadcast() {
            this.checkSynchronousHint();
            this.mAbortBroadcast = true;
        }

        void checkSynchronousHint() {
            if (this.mOrderedHint || this.mInitialStickyHint) {
                return;
            }
            RuntimeException runtimeException = new RuntimeException("BroadcastReceiver trying to return result during a non-ordered broadcast");
            runtimeException.fillInStackTrace();
            Log.e("BroadcastReceiver", runtimeException.getMessage(), runtimeException);
        }

        public final void clearAbortBroadcast() {
            this.mAbortBroadcast = false;
        }

        /*
         * Enabled aggressive block sorting
         */
        public final void finish() {
            if (this.mType == 0) {
                final IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                if (!QueuedWork.hasPendingWork()) {
                    this.sendFinished(iActivityManager);
                    return;
                }
                QueuedWork.singleThreadExecutor().execute(new Runnable(){

                    @Override
                    public void run() {
                        PendingResult.this.sendFinished(iActivityManager);
                    }
                });
                return;
            } else {
                if (!this.mOrderedHint || this.mType == 2) return;
                this.sendFinished(ActivityManagerNative.getDefault());
                return;
            }
        }

        public final boolean getAbortBroadcast() {
            return this.mAbortBroadcast;
        }

        public final int getResultCode() {
            return this.mResultCode;
        }

        public final String getResultData() {
            return this.mResultData;
        }

        public final Bundle getResultExtras(boolean bl) {
            Bundle bundle = this.mResultExtras;
            if (!bl) {
                return bundle;
            }
            if (bundle == null) {
                this.mResultExtras = bundle = new Bundle();
            }
            return bundle;
        }

        public int getSendingUserId() {
            return this.mSendingUser;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void sendFinished(IActivityManager iActivityManager) {
            synchronized (this) {
                block8: {
                    if (this.mFinished) {
                        throw new IllegalStateException("Broadcast already finished");
                    }
                    this.mFinished = true;
                    try {
                        if (this.mResultExtras != null) {
                            this.mResultExtras.setAllowFds(false);
                        }
                        if (this.mOrderedHint) {
                            iActivityManager.finishReceiver(this.mToken, this.mResultCode, this.mResultData, this.mResultExtras, this.mAbortBroadcast);
                            break block8;
                        }
                        iActivityManager.finishReceiver(this.mToken, 0, null, null, false);
                    }
                    catch (RemoteException remoteException) {}
                }
                return;
            }
        }

        public void setExtrasClassLoader(ClassLoader classLoader) {
            if (this.mResultExtras != null) {
                this.mResultExtras.setClassLoader(classLoader);
            }
        }

        public final void setResult(int n, String string2, Bundle bundle) {
            this.checkSynchronousHint();
            this.mResultCode = n;
            this.mResultData = string2;
            this.mResultExtras = bundle;
        }

        public final void setResultCode(int n) {
            this.checkSynchronousHint();
            this.mResultCode = n;
        }

        public final void setResultData(String string2) {
            this.checkSynchronousHint();
            this.mResultData = string2;
        }

        public final void setResultExtras(Bundle bundle) {
            this.checkSynchronousHint();
            this.mResultExtras = bundle;
        }
    }
}

