/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothActivityEnergyInfo;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.IBluetoothCallback;
import android.os.Binder;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.ParcelFileDescriptor;
import android.os.ParcelUuid;
import android.os.Parcelable;
import android.os.RemoteException;

public interface IBluetooth
extends IInterface {
    public boolean cancelBondProcess(BluetoothDevice var1) throws RemoteException;

    public boolean cancelDiscovery() throws RemoteException;

    public boolean configHciSnoopLog(boolean var1) throws RemoteException;

    public ParcelFileDescriptor connectSocket(BluetoothDevice var1, int var2, ParcelUuid var3, int var4, int var5) throws RemoteException;

    public boolean createBond(BluetoothDevice var1, int var2) throws RemoteException;

    public ParcelFileDescriptor createSocketChannel(int var1, String var2, ParcelUuid var3, int var4, int var5) throws RemoteException;

    public boolean disable() throws RemoteException;

    public boolean disableRadio(int var1) throws RemoteException;

    public boolean enable() throws RemoteException;

    public boolean enableNoAutoConnect() throws RemoteException;

    public boolean enableRadio(int var1) throws RemoteException;

    public boolean fetchRemoteMasInstances(BluetoothDevice var1) throws RemoteException;

    public boolean fetchRemoteUuids(BluetoothDevice var1) throws RemoteException;

    public void getActivityEnergyInfoFromController() throws RemoteException;

    public int getAdapterConnectionState() throws RemoteException;

    public String getAddress() throws RemoteException;

    public int getBondState(BluetoothDevice var1) throws RemoteException;

    public BluetoothDevice[] getBondedDevices() throws RemoteException;

    public int getDiscoverableTimeout() throws RemoteException;

    public int getMessageAccessPermission(BluetoothDevice var1) throws RemoteException;

    public String getName() throws RemoteException;

    public int getPhonebookAccessPermission(BluetoothDevice var1) throws RemoteException;

    public int getProfileConnectionState(int var1) throws RemoteException;

    public String getRemoteAlias(BluetoothDevice var1) throws RemoteException;

    public int getRemoteClass(BluetoothDevice var1) throws RemoteException;

    public String getRemoteName(BluetoothDevice var1) throws RemoteException;

    public int getRemoteType(BluetoothDevice var1) throws RemoteException;

    public ParcelUuid[] getRemoteUuids(BluetoothDevice var1) throws RemoteException;

    public int getScanMode() throws RemoteException;

    public int getState() throws RemoteException;

    public ParcelUuid[] getUuids() throws RemoteException;

    public boolean isActivityAndEnergyReportingSupported() throws RemoteException;

    public boolean isConnected(BluetoothDevice var1) throws RemoteException;

    public boolean isDiscovering() throws RemoteException;

    public boolean isEnabled() throws RemoteException;

    public boolean isMultiAdvertisementSupported() throws RemoteException;

    public boolean isOffloadedFilteringSupported() throws RemoteException;

    public boolean isOffloadedScanBatchingSupported() throws RemoteException;

    public boolean isRadioEnabled() throws RemoteException;

    public void registerCallback(IBluetoothCallback var1) throws RemoteException;

    public boolean removeBond(BluetoothDevice var1) throws RemoteException;

    public BluetoothActivityEnergyInfo reportActivityInfo() throws RemoteException;

    public void sendConnectionStateChange(BluetoothDevice var1, int var2, int var3, int var4) throws RemoteException;

    public boolean setDiscoverableTimeout(int var1) throws RemoteException;

    public boolean setMessageAccessPermission(BluetoothDevice var1, int var2) throws RemoteException;

    public boolean setName(String var1) throws RemoteException;

    public boolean setPairingConfirmation(BluetoothDevice var1, boolean var2) throws RemoteException;

    public boolean setPasskey(BluetoothDevice var1, boolean var2, int var3, byte[] var4) throws RemoteException;

    public boolean setPhonebookAccessPermission(BluetoothDevice var1, int var2) throws RemoteException;

    public boolean setPin(BluetoothDevice var1, boolean var2, int var3, byte[] var4) throws RemoteException;

    public boolean setRemoteAlias(BluetoothDevice var1, String var2) throws RemoteException;

    public boolean setScanMode(int var1, int var2) throws RemoteException;

    public boolean startDiscovery() throws RemoteException;

    public void unregisterCallback(IBluetoothCallback var1) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements IBluetooth {
        private static final String DESCRIPTOR = "android.bluetooth.IBluetooth";
        static final int TRANSACTION_cancelBondProcess = 24;
        static final int TRANSACTION_cancelDiscovery = 18;
        static final int TRANSACTION_configHciSnoopLog = 48;
        static final int TRANSACTION_connectSocket = 46;
        static final int TRANSACTION_createBond = 23;
        static final int TRANSACTION_createSocketChannel = 47;
        static final int TRANSACTION_disable = 5;
        static final int TRANSACTION_disableRadio = 8;
        static final int TRANSACTION_enable = 3;
        static final int TRANSACTION_enableNoAutoConnect = 4;
        static final int TRANSACTION_enableRadio = 7;
        static final int TRANSACTION_fetchRemoteMasInstances = 35;
        static final int TRANSACTION_fetchRemoteUuids = 34;
        static final int TRANSACTION_getActivityEnergyInfoFromController = 53;
        static final int TRANSACTION_getAdapterConnectionState = 20;
        static final int TRANSACTION_getAddress = 9;
        static final int TRANSACTION_getBondState = 26;
        static final int TRANSACTION_getBondedDevices = 22;
        static final int TRANSACTION_getDiscoverableTimeout = 15;
        static final int TRANSACTION_getMessageAccessPermission = 41;
        static final int TRANSACTION_getName = 12;
        static final int TRANSACTION_getPhonebookAccessPermission = 39;
        static final int TRANSACTION_getProfileConnectionState = 21;
        static final int TRANSACTION_getRemoteAlias = 30;
        static final int TRANSACTION_getRemoteClass = 32;
        static final int TRANSACTION_getRemoteName = 28;
        static final int TRANSACTION_getRemoteType = 29;
        static final int TRANSACTION_getRemoteUuids = 33;
        static final int TRANSACTION_getScanMode = 13;
        static final int TRANSACTION_getState = 2;
        static final int TRANSACTION_getUuids = 10;
        static final int TRANSACTION_isActivityAndEnergyReportingSupported = 52;
        static final int TRANSACTION_isConnected = 27;
        static final int TRANSACTION_isDiscovering = 19;
        static final int TRANSACTION_isEnabled = 1;
        static final int TRANSACTION_isMultiAdvertisementSupported = 49;
        static final int TRANSACTION_isOffloadedFilteringSupported = 50;
        static final int TRANSACTION_isOffloadedScanBatchingSupported = 51;
        static final int TRANSACTION_isRadioEnabled = 6;
        static final int TRANSACTION_registerCallback = 44;
        static final int TRANSACTION_removeBond = 25;
        static final int TRANSACTION_reportActivityInfo = 54;
        static final int TRANSACTION_sendConnectionStateChange = 43;
        static final int TRANSACTION_setDiscoverableTimeout = 16;
        static final int TRANSACTION_setMessageAccessPermission = 42;
        static final int TRANSACTION_setName = 11;
        static final int TRANSACTION_setPairingConfirmation = 38;
        static final int TRANSACTION_setPasskey = 37;
        static final int TRANSACTION_setPhonebookAccessPermission = 40;
        static final int TRANSACTION_setPin = 36;
        static final int TRANSACTION_setRemoteAlias = 31;
        static final int TRANSACTION_setScanMode = 14;
        static final int TRANSACTION_startDiscovery = 17;
        static final int TRANSACTION_unregisterCallback = 45;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static IBluetooth asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof IBluetooth) {
                return (IBluetooth)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isEnabled();
                    parcel2.writeNoException();
                    int n3 = bl ? 1 : 0;
                    parcel2.writeInt(n3);
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n4 = this.getState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n4);
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.enable();
                    parcel2.writeNoException();
                    int n5 = 0;
                    if (bl) {
                        n5 = 1;
                    }
                    parcel2.writeInt(n5);
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.enableNoAutoConnect();
                    parcel2.writeNoException();
                    int n6 = 0;
                    if (bl) {
                        n6 = 1;
                    }
                    parcel2.writeInt(n6);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.disable();
                    parcel2.writeNoException();
                    int n7 = 0;
                    if (bl) {
                        n7 = 1;
                    }
                    parcel2.writeInt(n7);
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isRadioEnabled();
                    parcel2.writeNoException();
                    int n8 = 0;
                    if (bl) {
                        n8 = 1;
                    }
                    parcel2.writeInt(n8);
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.enableRadio(parcel.readInt());
                    parcel2.writeNoException();
                    int n9 = 0;
                    if (bl) {
                        n9 = 1;
                    }
                    parcel2.writeInt(n9);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.disableRadio(parcel.readInt());
                    parcel2.writeNoException();
                    int n10 = 0;
                    if (bl) {
                        n10 = 1;
                    }
                    parcel2.writeInt(n10);
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = this.getAddress();
                    parcel2.writeNoException();
                    parcel2.writeString(string2);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getUuids();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setName(parcel.readString());
                    parcel2.writeNoException();
                    int n11 = 0;
                    if (bl) {
                        n11 = 1;
                    }
                    parcel2.writeInt(n11);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string3 = this.getName();
                    parcel2.writeNoException();
                    parcel2.writeString(string3);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n12 = this.getScanMode();
                    parcel2.writeNoException();
                    parcel2.writeInt(n12);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setScanMode(parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    int n13 = 0;
                    if (bl) {
                        n13 = 1;
                    }
                    parcel2.writeInt(n13);
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n14 = this.getDiscoverableTimeout();
                    parcel2.writeNoException();
                    parcel2.writeInt(n14);
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.setDiscoverableTimeout(parcel.readInt());
                    parcel2.writeNoException();
                    int n15 = 0;
                    if (bl) {
                        n15 = 1;
                    }
                    parcel2.writeInt(n15);
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.startDiscovery();
                    parcel2.writeNoException();
                    int n16 = 0;
                    if (bl) {
                        n16 = 1;
                    }
                    parcel2.writeInt(n16);
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.cancelDiscovery();
                    parcel2.writeNoException();
                    int n17 = 0;
                    if (bl) {
                        n17 = 1;
                    }
                    parcel2.writeInt(n17);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isDiscovering();
                    parcel2.writeNoException();
                    int n18 = 0;
                    if (bl) {
                        n18 = 1;
                    }
                    parcel2.writeInt(n18);
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n19 = this.getAdapterConnectionState();
                    parcel2.writeNoException();
                    parcel2.writeInt(n19);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n20 = this.getProfileConnectionState(parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n20);
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getBondedDevices();
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.createBond(bluetoothDevice, parcel.readInt());
                    parcel2.writeNoException();
                    int n21 = 0;
                    if (bl) {
                        n21 = 1;
                    }
                    parcel2.writeInt(n21);
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.cancelBondProcess(bluetoothDevice);
                    parcel2.writeNoException();
                    int n22 = 0;
                    if (bl) {
                        n22 = 1;
                    }
                    parcel2.writeInt(n22);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.removeBond(bluetoothDevice);
                    parcel2.writeNoException();
                    int n23 = 0;
                    if (bl) {
                        n23 = 1;
                    }
                    parcel2.writeInt(n23);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    int n24 = this.getBondState(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeInt(n24);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.isConnected(bluetoothDevice);
                    parcel2.writeNoException();
                    int n25 = 0;
                    if (bl) {
                        n25 = 1;
                    }
                    parcel2.writeInt(n25);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    String string4 = this.getRemoteName(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeString(string4);
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    int n26 = this.getRemoteType(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeInt(n26);
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    String string5 = this.getRemoteAlias(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeString(string5);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.setRemoteAlias(bluetoothDevice, parcel.readString());
                    parcel2.writeNoException();
                    int n27 = 0;
                    if (bl) {
                        n27 = 1;
                    }
                    parcel2.writeInt(n27);
                    return true;
                }
                case 32: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    int n28 = this.getRemoteClass(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeInt(n28);
                    return true;
                }
                case 33: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    Parcelable[] parcelableArray = this.getRemoteUuids(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 34: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.fetchRemoteUuids(bluetoothDevice);
                    parcel2.writeNoException();
                    int n29 = 0;
                    if (bl) {
                        n29 = 1;
                    }
                    parcel2.writeInt(n29);
                    return true;
                }
                case 35: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.fetchRemoteMasInstances(bluetoothDevice);
                    parcel2.writeNoException();
                    int n30 = 0;
                    if (bl) {
                        n30 = 1;
                    }
                    parcel2.writeInt(n30);
                    return true;
                }
                case 36: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl2 = this.setPin(bluetoothDevice, bl, parcel.readInt(), parcel.createByteArray());
                    parcel2.writeNoException();
                    int n31 = 0;
                    if (bl2) {
                        n31 = 1;
                    }
                    parcel2.writeInt(n31);
                    return true;
                }
                case 37: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl3 = this.setPasskey(bluetoothDevice, bl, parcel.readInt(), parcel.createByteArray());
                    parcel2.writeNoException();
                    int n32 = 0;
                    if (bl3) {
                        n32 = 1;
                    }
                    parcel2.writeInt(n32);
                    return true;
                }
                case 38: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = parcel.readInt() != 0;
                    boolean bl4 = this.setPairingConfirmation(bluetoothDevice, bl);
                    parcel2.writeNoException();
                    int n33 = 0;
                    if (bl4) {
                        n33 = 1;
                    }
                    parcel2.writeInt(n33);
                    return true;
                }
                case 39: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    int n34 = this.getPhonebookAccessPermission(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeInt(n34);
                    return true;
                }
                case 40: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.setPhonebookAccessPermission(bluetoothDevice, parcel.readInt());
                    parcel2.writeNoException();
                    int n35 = 0;
                    if (bl) {
                        n35 = 1;
                    }
                    parcel2.writeInt(n35);
                    return true;
                }
                case 41: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    int n36 = this.getMessageAccessPermission(bluetoothDevice);
                    parcel2.writeNoException();
                    parcel2.writeInt(n36);
                    return true;
                }
                case 42: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.setMessageAccessPermission(bluetoothDevice, parcel.readInt());
                    parcel2.writeNoException();
                    int n37 = 0;
                    if (bl) {
                        n37 = 1;
                    }
                    parcel2.writeInt(n37);
                    return true;
                }
                case 43: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    this.sendConnectionStateChange(bluetoothDevice, parcel.readInt(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 44: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.registerCallback(IBluetoothCallback.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 45: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterCallback(IBluetoothCallback.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 46: {
                    parcel.enforceInterface(DESCRIPTOR);
                    BluetoothDevice bluetoothDevice = parcel.readInt() != 0 ? BluetoothDevice.CREATOR.createFromParcel(parcel) : null;
                    int n38 = parcel.readInt();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    ParcelFileDescriptor parcelFileDescriptor = this.connectSocket(bluetoothDevice, n38, parcelUuid, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (parcelFileDescriptor != null) {
                        parcel2.writeInt(1);
                        parcelFileDescriptor.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 47: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n39 = parcel.readInt();
                    String string6 = parcel.readString();
                    ParcelUuid parcelUuid = parcel.readInt() != 0 ? ParcelUuid.CREATOR.createFromParcel(parcel) : null;
                    ParcelFileDescriptor parcelFileDescriptor = this.createSocketChannel(n39, string6, parcelUuid, parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    if (parcelFileDescriptor != null) {
                        parcel2.writeInt(1);
                        parcelFileDescriptor.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 48: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = parcel.readInt() != 0;
                    boolean bl5 = this.configHciSnoopLog(bl);
                    parcel2.writeNoException();
                    int n40 = 0;
                    if (bl5) {
                        n40 = 1;
                    }
                    parcel2.writeInt(n40);
                    return true;
                }
                case 49: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isMultiAdvertisementSupported();
                    parcel2.writeNoException();
                    int n41 = 0;
                    if (bl) {
                        n41 = 1;
                    }
                    parcel2.writeInt(n41);
                    return true;
                }
                case 50: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isOffloadedFilteringSupported();
                    parcel2.writeNoException();
                    int n42 = 0;
                    if (bl) {
                        n42 = 1;
                    }
                    parcel2.writeInt(n42);
                    return true;
                }
                case 51: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isOffloadedScanBatchingSupported();
                    parcel2.writeNoException();
                    int n43 = 0;
                    if (bl) {
                        n43 = 1;
                    }
                    parcel2.writeInt(n43);
                    return true;
                }
                case 52: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.isActivityAndEnergyReportingSupported();
                    parcel2.writeNoException();
                    int n44 = 0;
                    if (bl) {
                        n44 = 1;
                    }
                    parcel2.writeInt(n44);
                    return true;
                }
                case 53: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.getActivityEnergyInfoFromController();
                    parcel2.writeNoException();
                    return true;
                }
                case 54: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            BluetoothActivityEnergyInfo bluetoothActivityEnergyInfo = this.reportActivityInfo();
            parcel2.writeNoException();
            if (bluetoothActivityEnergyInfo != null) {
                parcel2.writeInt(1);
                bluetoothActivityEnergyInfo.writeToParcel(parcel2, 1);
                return true;
            }
            parcel2.writeInt(0);
            return true;
        }

        private static class Proxy
        implements IBluetooth {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean cancelBondProcess(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(24, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean cancelDiscovery() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean configHciSnoopLog(boolean bl) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl2;
                block3: {
                    block2: {
                        bl2 = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            boolean bl3 = bl ? bl2 : false;
                            parcel2.writeInt(bl3 ? 1 : 0);
                            this.mRemote.transact(48, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl2 = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParcelFileDescriptor connectSocket(BluetoothDevice bluetoothDevice, int n, ParcelUuid parcelUuid, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(46, parcel, parcel2, 0);
                    parcel2.readException();
                    ParcelFileDescriptor parcelFileDescriptor = parcel2.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel2) : null;
                    return parcelFileDescriptor;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean createBond(BluetoothDevice bluetoothDevice, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n);
                            this.mRemote.transact(23, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParcelFileDescriptor createSocketChannel(int n, String string2, ParcelUuid parcelUuid, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeString(string2);
                    if (parcelUuid != null) {
                        parcel.writeInt(1);
                        parcelUuid.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(47, parcel, parcel2, 0);
                    parcel2.readException();
                    ParcelFileDescriptor parcelFileDescriptor = parcel2.readInt() != 0 ? ParcelFileDescriptor.CREATOR.createFromParcel(parcel2) : null;
                    return parcelFileDescriptor;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean disable() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean disableRadio(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean enable() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean enableNoAutoConnect() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean enableRadio(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean fetchRemoteMasInstances(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(35, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean fetchRemoteUuids(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(34, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public void getActivityEnergyInfoFromController() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(53, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getAdapterConnectionState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getAddress() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getBondState(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public BluetoothDevice[] getBondedDevices() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    BluetoothDevice[] bluetoothDeviceArray = parcel2.createTypedArray(BluetoothDevice.CREATOR);
                    return bluetoothDeviceArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getDiscoverableTimeout() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getMessageAccessPermission(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(41, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public String getName() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getPhonebookAccessPermission(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(39, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getProfileConnectionState(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getRemoteAlias(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(30, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getRemoteClass(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public String getRemoteName(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(28, parcel, parcel2, 0);
                    parcel2.readException();
                    String string2 = parcel2.readString();
                    return string2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getRemoteType(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(29, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParcelUuid[] getRemoteUuids(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(33, parcel, parcel2, 0);
                    parcel2.readException();
                    ParcelUuid[] parcelUuidArray = parcel2.createTypedArray(ParcelUuid.CREATOR);
                    return parcelUuidArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getScanMode() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getState() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    return n;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public ParcelUuid[] getUuids() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    ParcelUuid[] parcelUuidArray = parcel2.createTypedArray(ParcelUuid.CREATOR);
                    return parcelUuidArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean isActivityAndEnergyReportingSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(52, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isConnected(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(27, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean isDiscovering() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean isEnabled() throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block3: {
                    block2: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            this.mRemote.transact(1, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block2;
                            break block3;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean isMultiAdvertisementSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(49, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isOffloadedFilteringSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(50, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isOffloadedScanBatchingSupported() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(51, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean isRadioEnabled() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(6, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerCallback(IBluetoothCallback iBluetoothCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iBluetoothCallback != null ? iBluetoothCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(44, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean removeBond(BluetoothDevice bluetoothDevice) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(25, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public BluetoothActivityEnergyInfo reportActivityInfo() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(54, parcel, parcel2, 0);
                    parcel2.readException();
                    BluetoothActivityEnergyInfo bluetoothActivityEnergyInfo = parcel2.readInt() != 0 ? BluetoothActivityEnergyInfo.CREATOR.createFromParcel(parcel2) : null;
                    return bluetoothActivityEnergyInfo;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void sendConnectionStateChange(BluetoothDevice bluetoothDevice, int n, int n2, int n3) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    parcel.writeInt(n3);
                    this.mRemote.transact(43, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public boolean setDiscoverableTimeout(int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setMessageAccessPermission(BluetoothDevice bluetoothDevice, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n);
                            this.mRemote.transact(42, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean setName(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setPairingConfirmation(BluetoothDevice bluetoothDevice, boolean bl) throws RemoteException {
                boolean bl2 = true;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                boolean bl3 = bl ? bl2 : false;
                parcel.writeInt(bl3 ? 1 : 0);
                this.mRemote.transact(38, parcel, parcel2, 0);
                parcel2.readException();
                int n = parcel2.readInt();
                if (n == 0) {
                    bl2 = false;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setPasskey(BluetoothDevice bluetoothDevice, boolean bl, int n, byte[] byArray) throws RemoteException {
                boolean bl2 = true;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                boolean bl3 = bl ? bl2 : false;
                parcel.writeInt(bl3 ? 1 : 0);
                parcel.writeInt(n);
                parcel.writeByteArray(byArray);
                this.mRemote.transact(37, parcel, parcel2, 0);
                parcel2.readException();
                int n2 = parcel2.readInt();
                if (n2 == 0) {
                    bl2 = false;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setPhonebookAccessPermission(BluetoothDevice bluetoothDevice, int n) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeInt(n);
                            this.mRemote.transact(40, parcel2, parcel, 0);
                            parcel.readException();
                            int n2 = parcel.readInt();
                            if (n2 == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setPin(BluetoothDevice bluetoothDevice, boolean bl, int n, byte[] byArray) throws RemoteException {
                boolean bl2 = true;
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (bluetoothDevice != null) {
                        parcel.writeInt(1);
                        bluetoothDevice.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
                boolean bl3 = bl ? bl2 : false;
                parcel.writeInt(bl3 ? 1 : 0);
                parcel.writeInt(n);
                parcel.writeByteArray(byArray);
                this.mRemote.transact(36, parcel, parcel2, 0);
                parcel2.readException();
                int n2 = parcel2.readInt();
                if (n2 == 0) {
                    bl2 = false;
                }
                parcel2.recycle();
                parcel.recycle();
                return bl2;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setRemoteAlias(BluetoothDevice bluetoothDevice, String string2) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bluetoothDevice != null) {
                                parcel2.writeInt(1);
                                bluetoothDevice.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            parcel2.writeString(string2);
                            this.mRemote.transact(31, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            @Override
            public boolean setScanMode(int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    int n3 = parcel2.readInt();
                    boolean bl = false;
                    if (n3 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public boolean startDiscovery() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    boolean bl = false;
                    if (n != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterCallback(IBluetoothCallback iBluetoothCallback) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iBluetoothCallback != null ? iBluetoothCallback.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(45, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

