/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothPan;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothPan
implements BluetoothProfile {
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.pan.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_TETHER_ENABLING_STATE_CHANGED = "android.bluetooth.pan.profile.action.TETHER_ENABLING_STATE_CHANGED";
    private static final boolean DBG = true;
    public static final String EXTRA_LOCAL_ROLE = "android.bluetooth.pan.extra.LOCAL_ROLE";
    public static final int LOCAL_NAP_ROLE = 1;
    public static final int LOCAL_PANU_ROLE = 2;
    public static final int PAN_CONNECT_FAILED_ALREADY_CONNECTED = 1001;
    public static final int PAN_CONNECT_FAILED_ATTEMPT_FAILED = 1002;
    public static final int PAN_DISCONNECT_FAILED_NOT_CONNECTED = 1000;
    public static final int PAN_OPERATION_GENERIC_FAILURE = 1003;
    public static final int PAN_OPERATION_SUCCESS = 1004;
    public static final int PAN_ROLE_NONE = 0;
    public static final int REMOTE_NAP_ROLE = 1;
    public static final int REMOTE_PANU_ROLE = 2;
    private static final String TAG = "BluetoothPan";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final ServiceConnection mConnection;
    private Context mContext;
    private IBluetoothPan mPanService;
    private BluetoothProfile.ServiceListener mServiceListener;
    private final IBluetoothStateChangeCallback mStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) throws RemoteException {
            if (bl) {
                Log.d(BluetoothPan.TAG, "onBluetoothStateChange(on) call bindService");
                BluetoothPan.this.doBind();
                return;
            }
            ServiceConnection serviceConnection = BluetoothPan.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    BluetoothPan.access$102(BluetoothPan.this, null);
                    BluetoothPan.this.mContext.unbindService(BluetoothPan.this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(BluetoothPan.TAG, "", exception);
                }
                return;
            }
        }
    };

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothPan(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.mConnection = new ServiceConnection(){

            @Override
            public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
                Log.d(BluetoothPan.TAG, "BluetoothPAN Proxy object connected");
                BluetoothPan.access$102(BluetoothPan.this, IBluetoothPan.Stub.asInterface(iBinder));
                if (BluetoothPan.this.mServiceListener != null) {
                    BluetoothPan.this.mServiceListener.onServiceConnected(5, BluetoothPan.this);
                }
            }

            @Override
            public void onServiceDisconnected(ComponentName componentName) {
                Log.d(BluetoothPan.TAG, "BluetoothPAN Proxy object disconnected");
                BluetoothPan.access$102(BluetoothPan.this, null);
                if (BluetoothPan.this.mServiceListener != null) {
                    BluetoothPan.this.mServiceListener.onServiceDisconnected(5);
                }
            }
        };
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        try {
            this.mAdapter.getBluetoothManager().registerStateChangeCallback(this.mStateChangeCallback);
        }
        catch (RemoteException remoteException) {
            Log.w(TAG, "Unable to register BluetoothStateChangeCallback", remoteException);
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothPan access$102(BluetoothPan bluetoothPan, IBluetoothPan iBluetoothPan) {
        bluetoothPan.mPanService = iBluetoothPan;
        return iBluetoothPan;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.unregisterStateChangeCallback(this.mStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.w(TAG, "Unable to unregister BluetoothStateChangeCallback", remoteException);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            IBluetoothPan iBluetoothPan = this.mPanService;
            if (iBluetoothPan != null) {
                try {
                    this.mPanService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
        }
        this.mServiceListener = null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connect(BluetoothDevice bluetoothDevice) {
        BluetoothPan.log("connect(" + bluetoothDevice + ")");
        if (this.mPanService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mPanService.connect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothPan iBluetoothPan = this.mPanService;
        boolean bl = false;
        if (iBluetoothPan != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        BluetoothPan.log("disconnect(" + bluetoothDevice + ")");
        if (this.mPanService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mPanService.disconnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothPan iBluetoothPan = this.mPanService;
        boolean bl = false;
        if (iBluetoothPan != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothPan.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth Pan Service with " + intent);
            return false;
        }
        return true;
    }

    protected void finalize() {
        this.close();
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mPanService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mPanService.getConnectedDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mPanService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        if (this.mPanService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mPanService.getConnectionState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothPan iBluetoothPan = this.mPanService;
        int n = 0;
        if (iBluetoothPan != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        if (this.mPanService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mPanService.getDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mPanService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    public boolean isTetheringOn() {
        try {
            boolean bl = this.mPanService.isTetheringOn();
            return bl;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return false;
        }
    }

    public void setBluetoothTethering(boolean bl) {
        BluetoothPan.log("setBluetoothTethering(" + bl + ")");
        try {
            this.mPanService.setBluetoothTethering(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
            return;
        }
    }
}

