/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothGattServer;
import android.bluetooth.BluetoothGattServerCallback;
import android.bluetooth.IBluetoothGatt;
import android.content.Context;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

public final class BluetoothManager {
    private static final boolean DBG = true;
    private static final String TAG = "BluetoothManager";
    private static final boolean VDBG = true;
    private final BluetoothAdapter mAdapter;

    public BluetoothManager(Context context) {
        if (context.getApplicationContext() == null) {
            throw new IllegalArgumentException("context not associated with any application (using a mock context?)");
        }
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
    }

    public BluetoothAdapter getAdapter() {
        return this.mAdapter;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<BluetoothDevice> getConnectedDevices(int n) {
        List<BluetoothDevice> list;
        void var3_4;
        IBluetoothGatt iBluetoothGatt;
        block5: {
            Log.d(TAG, "getConnectedDevices");
            if (n != 7 && n != 8) {
                throw new IllegalArgumentException("Profile not supported: " + n);
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            try {
                iBluetoothGatt = this.mAdapter.getBluetoothManager().getBluetoothGatt();
                if (iBluetoothGatt != null) break block5;
                return arrayList;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
                return var3_4;
            }
        }
        List<BluetoothDevice> list2 = list = iBluetoothGatt.getDevicesMatchingConnectionStates(new int[]{2});
        return var3_4;
    }

    public int getConnectionState(BluetoothDevice bluetoothDevice, int n) {
        Log.d(TAG, "getConnectionState()");
        Iterator<BluetoothDevice> iterator = this.getConnectedDevices(n).iterator();
        while (iterator.hasNext()) {
            if (!bluetoothDevice.equals(iterator.next())) continue;
            return 2;
        }
        return 0;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int n, int[] nArray) {
        List<BluetoothDevice> list;
        void var4_5;
        IBluetoothGatt iBluetoothGatt;
        block5: {
            Log.d(TAG, "getDevicesMatchingConnectionStates");
            if (n != 7 && n != 8) {
                throw new IllegalArgumentException("Profile not supported: " + n);
            }
            ArrayList<BluetoothDevice> arrayList = new ArrayList<BluetoothDevice>();
            try {
                iBluetoothGatt = this.mAdapter.getBluetoothManager().getBluetoothGatt();
                if (iBluetoothGatt != null) break block5;
                return arrayList;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
                return var4_5;
            }
        }
        List<BluetoothDevice> list2 = list = iBluetoothGatt.getDevicesMatchingConnectionStates(nArray);
        return var4_5;
    }

    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback bluetoothGattServerCallback) {
        return this.openGattServer(context, bluetoothGattServerCallback, 0);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public BluetoothGattServer openGattServer(Context context, BluetoothGattServerCallback bluetoothGattServerCallback, int n) {
        IBluetoothGatt iBluetoothGatt;
        block5: {
            if (context == null) throw new IllegalArgumentException("null parameter: " + context + " " + bluetoothGattServerCallback);
            if (bluetoothGattServerCallback == null) {
                throw new IllegalArgumentException("null parameter: " + context + " " + bluetoothGattServerCallback);
            }
            try {
                iBluetoothGatt = this.mAdapter.getBluetoothManager().getBluetoothGatt();
                if (iBluetoothGatt != null) break block5;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
                return null;
            }
            Log.e(TAG, "Fail to get GATT Server connection");
            return null;
        }
        BluetoothGattServer bluetoothGattServer = new BluetoothGattServer(context, iBluetoothGatt, n);
        boolean bl = bluetoothGattServer.registerCallback(bluetoothGattServerCallback);
        if (!bl) return null;
        return bluetoothGattServer;
    }
}

