/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothGattDescriptor;
import android.bluetooth.BluetoothGattService;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public class BluetoothGattCharacteristic {
    public static final int FORMAT_FLOAT = 52;
    public static final int FORMAT_SFLOAT = 50;
    public static final int FORMAT_SINT16 = 34;
    public static final int FORMAT_SINT32 = 36;
    public static final int FORMAT_SINT8 = 33;
    public static final int FORMAT_UINT16 = 18;
    public static final int FORMAT_UINT32 = 20;
    public static final int FORMAT_UINT8 = 17;
    public static final int PERMISSION_READ = 1;
    public static final int PERMISSION_READ_ENCRYPTED = 2;
    public static final int PERMISSION_READ_ENCRYPTED_MITM = 4;
    public static final int PERMISSION_WRITE = 16;
    public static final int PERMISSION_WRITE_ENCRYPTED = 32;
    public static final int PERMISSION_WRITE_ENCRYPTED_MITM = 64;
    public static final int PERMISSION_WRITE_SIGNED = 128;
    public static final int PERMISSION_WRITE_SIGNED_MITM = 256;
    public static final int PROPERTY_BROADCAST = 1;
    public static final int PROPERTY_EXTENDED_PROPS = 128;
    public static final int PROPERTY_INDICATE = 32;
    public static final int PROPERTY_NOTIFY = 16;
    public static final int PROPERTY_READ = 2;
    public static final int PROPERTY_SIGNED_WRITE = 64;
    public static final int PROPERTY_WRITE = 8;
    public static final int PROPERTY_WRITE_NO_RESPONSE = 4;
    public static final int WRITE_TYPE_DEFAULT = 2;
    public static final int WRITE_TYPE_NO_RESPONSE = 1;
    public static final int WRITE_TYPE_SIGNED = 4;
    protected List<BluetoothGattDescriptor> mDescriptors;
    protected int mInstance;
    protected int mKeySize = 16;
    protected int mPermissions;
    protected int mProperties;
    protected BluetoothGattService mService;
    protected UUID mUuid;
    protected byte[] mValue;
    protected int mWriteType;

    BluetoothGattCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID, int n, int n2, int n3) {
        this.initCharacteristic(bluetoothGattService, uUID, n, n2, n3);
    }

    public BluetoothGattCharacteristic(UUID uUID, int n, int n2) {
        this.initCharacteristic(null, uUID, 0, n, n2);
    }

    private float bytesToFloat(byte by, byte by2) {
        int n = this.unsignedToSigned(this.unsignedByteToInt(by) + ((0xF & this.unsignedByteToInt(by2)) << 8), 12);
        int n2 = this.unsignedToSigned(this.unsignedByteToInt(by2) >> 4, 4);
        return (float)((double)n * Math.pow(10.0, n2));
    }

    private float bytesToFloat(byte by, byte by2, byte by3, byte by4) {
        return (float)((double)this.unsignedToSigned(this.unsignedByteToInt(by) + (this.unsignedByteToInt(by2) << 8) + (this.unsignedByteToInt(by3) << 16), 24) * Math.pow(10.0, by4));
    }

    private int getTypeLen(int n) {
        return n & 0xF;
    }

    private void initCharacteristic(BluetoothGattService bluetoothGattService, UUID uUID, int n, int n2, int n3) {
        this.mUuid = uUID;
        this.mInstance = n;
        this.mProperties = n2;
        this.mPermissions = n3;
        this.mService = bluetoothGattService;
        this.mValue = null;
        this.mDescriptors = new ArrayList<BluetoothGattDescriptor>();
        if ((4 & this.mProperties) != 0) {
            this.mWriteType = 1;
            return;
        }
        this.mWriteType = 2;
    }

    private int intToSignedBits(int n, int n2) {
        if (n < 0) {
            n = (1 << n2 - 1) + (n & -1 + (1 << n2 - 1));
        }
        return n;
    }

    private int unsignedByteToInt(byte by) {
        return by & 0xFF;
    }

    private int unsignedBytesToInt(byte by, byte by2) {
        return this.unsignedByteToInt(by) + (this.unsignedByteToInt(by2) << 8);
    }

    private int unsignedBytesToInt(byte by, byte by2, byte by3, byte by4) {
        return this.unsignedByteToInt(by) + (this.unsignedByteToInt(by2) << 8) + (this.unsignedByteToInt(by3) << 16) + (this.unsignedByteToInt(by4) << 24);
    }

    private int unsignedToSigned(int n, int n2) {
        if ((n & 1 << n2 - 1) != 0) {
            n = -1 * ((1 << n2 - 1) - (n & -1 + (1 << n2 - 1)));
        }
        return n;
    }

    public boolean addDescriptor(BluetoothGattDescriptor bluetoothGattDescriptor) {
        this.mDescriptors.add(bluetoothGattDescriptor);
        bluetoothGattDescriptor.setCharacteristic(this);
        return true;
    }

    public BluetoothGattDescriptor getDescriptor(UUID uUID) {
        for (BluetoothGattDescriptor bluetoothGattDescriptor : this.mDescriptors) {
            if (!bluetoothGattDescriptor.getUuid().equals(uUID)) continue;
            return bluetoothGattDescriptor;
        }
        return null;
    }

    BluetoothGattDescriptor getDescriptor(UUID uUID, int n) {
        for (BluetoothGattDescriptor bluetoothGattDescriptor : this.mDescriptors) {
            if (!bluetoothGattDescriptor.getUuid().equals(uUID) || bluetoothGattDescriptor.getInstanceId() != n) continue;
            return bluetoothGattDescriptor;
        }
        return null;
    }

    public List<BluetoothGattDescriptor> getDescriptors() {
        return this.mDescriptors;
    }

    public Float getFloatValue(int n, int n2) {
        if (n2 + this.getTypeLen(n) > this.mValue.length) {
            return null;
        }
        switch (n) {
            default: {
                return null;
            }
            case 50: {
                return Float.valueOf(this.bytesToFloat(this.mValue[n2], this.mValue[n2 + 1]));
            }
            case 52: 
        }
        return Float.valueOf(this.bytesToFloat(this.mValue[n2], this.mValue[n2 + 1], this.mValue[n2 + 2], this.mValue[n2 + 3]));
    }

    public int getInstanceId() {
        return this.mInstance;
    }

    public Integer getIntValue(int n, int n2) {
        if (n2 + this.getTypeLen(n) > this.mValue.length) {
            return null;
        }
        switch (n) {
            default: {
                return null;
            }
            case 17: {
                return this.unsignedByteToInt(this.mValue[n2]);
            }
            case 18: {
                return this.unsignedBytesToInt(this.mValue[n2], this.mValue[n2 + 1]);
            }
            case 20: {
                return this.unsignedBytesToInt(this.mValue[n2], this.mValue[n2 + 1], this.mValue[n2 + 2], this.mValue[n2 + 3]);
            }
            case 33: {
                return this.unsignedToSigned(this.unsignedByteToInt(this.mValue[n2]), 8);
            }
            case 34: {
                return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[n2], this.mValue[n2 + 1]), 16);
            }
            case 36: 
        }
        return this.unsignedToSigned(this.unsignedBytesToInt(this.mValue[n2], this.mValue[n2 + 1], this.mValue[n2 + 2], this.mValue[n2 + 3]), 32);
    }

    int getKeySize() {
        return this.mKeySize;
    }

    public int getPermissions() {
        return this.mPermissions;
    }

    public int getProperties() {
        return this.mProperties;
    }

    public BluetoothGattService getService() {
        return this.mService;
    }

    public String getStringValue(int n) {
        if (n > this.mValue.length) {
            return null;
        }
        byte[] byArray = new byte[this.mValue.length - n];
        for (int i = 0; i != this.mValue.length - n; ++i) {
            byArray[i] = this.mValue[n + i];
        }
        return new String(byArray);
    }

    public UUID getUuid() {
        return this.mUuid;
    }

    public byte[] getValue() {
        return this.mValue;
    }

    public int getWriteType() {
        return this.mWriteType;
    }

    public void setKeySize(int n) {
        this.mKeySize = n;
    }

    void setService(BluetoothGattService bluetoothGattService) {
        this.mService = bluetoothGattService;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean setValue(int n, int n2, int n3) {
        int n4 = n3 + this.getTypeLen(n2);
        if (this.mValue == null) {
            this.mValue = new byte[n4];
        }
        if (n4 > this.mValue.length) {
            return false;
        }
        switch (n2) {
            default: {
                return false;
            }
            case 33: {
                n = this.intToSignedBits(n, 8);
            }
            case 17: {
                this.mValue[n3] = (byte)(n & 0xFF);
                return true;
            }
            case 34: {
                n = this.intToSignedBits(n, 16);
            }
            case 18: {
                byte[] byArray = this.mValue;
                int n5 = n3 + 1;
                byArray[n3] = (byte)(n & 0xFF);
                this.mValue[n5] = (byte)(0xFF & n >> 8);
                return true;
            }
            case 36: {
                n = this.intToSignedBits(n, 32);
                break;
            }
            case 20: 
        }
        byte[] byArray = this.mValue;
        int n6 = n3 + 1;
        byArray[n3] = (byte)(n & 0xFF);
        byte[] byArray2 = this.mValue;
        int n7 = n6 + 1;
        byArray2[n6] = (byte)(0xFF & n >> 8);
        byte[] byArray3 = this.mValue;
        int n8 = n7 + 1;
        byArray3[n7] = (byte)(0xFF & n >> 16);
        this.mValue[n8] = (byte)(0xFF & n >> 24);
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setValue(int n, int n2, int n3, int n4) {
        int n5 = n4 + this.getTypeLen(n3);
        if (this.mValue == null) {
            this.mValue = new byte[n5];
        }
        if (n5 > this.mValue.length) {
            return false;
        }
        switch (n3) {
            default: {
                return false;
            }
            case 50: {
                int n6 = this.intToSignedBits(n, 12);
                int n7 = this.intToSignedBits(n2, 4);
                byte[] byArray = this.mValue;
                int n8 = n4 + 1;
                byArray[n4] = (byte)(n6 & 0xFF);
                this.mValue[n8] = (byte)(0xF & n6 >> 8);
                byte[] byArray2 = this.mValue;
                byArray2[n8] = (byte)(byArray2[n8] + (byte)((n7 & 0xF) << 4));
                return true;
            }
            case 52: 
        }
        int n9 = this.intToSignedBits(n, 24);
        int n10 = this.intToSignedBits(n2, 8);
        byte[] byArray = this.mValue;
        int n11 = n4 + 1;
        byArray[n4] = (byte)(n9 & 0xFF);
        byte[] byArray3 = this.mValue;
        int n12 = n11 + 1;
        byArray3[n11] = (byte)(0xFF & n9 >> 8);
        byte[] byArray4 = this.mValue;
        int n13 = n12 + 1;
        byArray4[n12] = (byte)(0xFF & n9 >> 16);
        byte[] byArray5 = this.mValue;
        byArray5[n13] = (byte)(byArray5[n13] + (byte)(n10 & 0xFF));
        return true;
    }

    public boolean setValue(String string2) {
        this.mValue = string2.getBytes();
        return true;
    }

    public boolean setValue(byte[] byArray) {
        this.mValue = byArray;
        return true;
    }

    public void setWriteType(int n) {
        this.mWriteType = n;
    }
}

