/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.os.Parcel;
import android.os.Parcelable;

public final class BluetoothActivityEnergyInfo
implements Parcelable {
    public static final int BT_STACK_STATE_INVALID = 0;
    public static final int BT_STACK_STATE_STATE_ACTIVE = 1;
    public static final int BT_STACK_STATE_STATE_IDLE = 3;
    public static final int BT_STACK_STATE_STATE_SCANNING = 2;
    public static final Parcelable.Creator<BluetoothActivityEnergyInfo> CREATOR = new Parcelable.Creator<BluetoothActivityEnergyInfo>(){

        @Override
        public BluetoothActivityEnergyInfo createFromParcel(Parcel parcel) {
            return new BluetoothActivityEnergyInfo(parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt(), parcel.readInt());
        }

        public BluetoothActivityEnergyInfo[] newArray(int n) {
            return new BluetoothActivityEnergyInfo[n];
        }
    };
    private final int mBluetoothStackState;
    private final int mControllerEnergyUsed;
    private final int mControllerIdleTimeMs;
    private final int mControllerRxTimeMs;
    private final int mControllerTxTimeMs;
    private final long timestamp;

    public BluetoothActivityEnergyInfo(int n, int n2, int n3, int n4, int n5) {
        this.mBluetoothStackState = n;
        this.mControllerTxTimeMs = n2;
        this.mControllerRxTimeMs = n3;
        this.mControllerIdleTimeMs = n4;
        this.mControllerEnergyUsed = n5;
        this.timestamp = System.currentTimeMillis();
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public int getBluetoothStackState() {
        return this.mBluetoothStackState;
    }

    public int getControllerEnergyUsed() {
        return this.mControllerEnergyUsed;
    }

    public int getControllerIdleTimeMillis() {
        return this.mControllerIdleTimeMs;
    }

    public int getControllerRxTimeMillis() {
        return this.mControllerRxTimeMs;
    }

    public int getControllerTxTimeMillis() {
        return this.mControllerTxTimeMs;
    }

    public long getTimeStamp() {
        return this.timestamp;
    }

    public boolean isValid() {
        return this.getControllerTxTimeMillis() != 0 || this.getControllerRxTimeMillis() != 0 || this.getControllerIdleTimeMillis() != 0;
    }

    public String toString() {
        return "BluetoothActivityEnergyInfo{ timestamp=" + this.timestamp + " mBluetoothStackState=" + this.mBluetoothStackState + " mControllerTxTimeMs=" + this.mControllerTxTimeMs + " mControllerRxTimeMs=" + this.mControllerRxTimeMs + " mControllerIdleTimeMs=" + this.mControllerIdleTimeMs + " mControllerEnergyUsed=" + this.mControllerEnergyUsed + " }";
    }

    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(this.mBluetoothStackState);
        parcel.writeInt(this.mControllerTxTimeMs);
        parcel.writeInt(this.mControllerRxTimeMs);
        parcel.writeInt(this.mControllerIdleTimeMs);
        parcel.writeInt(this.mControllerEnergyUsed);
    }
}

