/*
 * Decompiled with CFR 0.152.
 */
package android.bluetooth;

import android.bluetooth.BluetoothAdapter;
import android.bluetooth.BluetoothDevice;
import android.bluetooth.BluetoothProfile;
import android.bluetooth.BluetoothUuid;
import android.bluetooth.IBluetoothA2dp;
import android.bluetooth.IBluetoothManager;
import android.bluetooth.IBluetoothStateChangeCallback;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.ServiceConnection;
import android.os.IBinder;
import android.os.ParcelUuid;
import android.os.Process;
import android.os.RemoteException;
import android.util.Log;
import java.util.ArrayList;
import java.util.List;

public final class BluetoothA2dp
implements BluetoothProfile {
    public static final String ACTION_AVRCP_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.AVRCP_CONNECTION_STATE_CHANGED";
    public static final String ACTION_CONNECTION_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.CONNECTION_STATE_CHANGED";
    public static final String ACTION_PLAYING_STATE_CHANGED = "android.bluetooth.a2dp.profile.action.PLAYING_STATE_CHANGED";
    private static final boolean DBG = true;
    public static final int STATE_NOT_PLAYING = 11;
    public static final int STATE_PLAYING = 10;
    private static final String TAG = "BluetoothA2dp";
    private static final boolean VDBG;
    private BluetoothAdapter mAdapter;
    private final IBluetoothStateChangeCallback mBluetoothStateChangeCallback = new IBluetoothStateChangeCallback.Stub(){

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onBluetoothStateChange(boolean bl) {
            Log.d(BluetoothA2dp.TAG, "onBluetoothStateChange: up=" + bl);
            if (!bl) {
                ServiceConnection serviceConnection = BluetoothA2dp.this.mConnection;
                synchronized (serviceConnection) {
                    try {
                        BluetoothA2dp.access$102(BluetoothA2dp.this, null);
                        BluetoothA2dp.this.mContext.unbindService(BluetoothA2dp.this.mConnection);
                    }
                    catch (Exception exception) {
                        Log.e(BluetoothA2dp.TAG, "", exception);
                    }
                    return;
                }
            }
            ServiceConnection serviceConnection = BluetoothA2dp.this.mConnection;
            synchronized (serviceConnection) {
                try {
                    if (BluetoothA2dp.this.mService == null) {
                        BluetoothA2dp.this.doBind();
                    }
                }
                catch (Exception exception) {
                    Log.e(BluetoothA2dp.TAG, "", exception);
                }
                return;
            }
        }
    };
    private final ServiceConnection mConnection = new ServiceConnection(){

        @Override
        public void onServiceConnected(ComponentName componentName, IBinder iBinder) {
            Log.d(BluetoothA2dp.TAG, "Proxy object connected");
            BluetoothA2dp.access$102(BluetoothA2dp.this, IBluetoothA2dp.Stub.asInterface(iBinder));
            if (BluetoothA2dp.this.mServiceListener != null) {
                BluetoothA2dp.this.mServiceListener.onServiceConnected(2, BluetoothA2dp.this);
            }
        }

        @Override
        public void onServiceDisconnected(ComponentName componentName) {
            Log.d(BluetoothA2dp.TAG, "Proxy object disconnected");
            BluetoothA2dp.access$102(BluetoothA2dp.this, null);
            if (BluetoothA2dp.this.mServiceListener != null) {
                BluetoothA2dp.this.mServiceListener.onServiceDisconnected(2);
            }
        }
    };
    private Context mContext;
    private IBluetoothA2dp mService;
    private BluetoothProfile.ServiceListener mServiceListener;

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    BluetoothA2dp(Context context, BluetoothProfile.ServiceListener serviceListener) {
        this.mContext = context;
        this.mServiceListener = serviceListener;
        this.mAdapter = BluetoothAdapter.getDefaultAdapter();
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.registerStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "", remoteException);
            }
        }
        this.doBind();
    }

    static /* synthetic */ IBluetoothA2dp access$102(BluetoothA2dp bluetoothA2dp, IBluetoothA2dp iBluetoothA2dp) {
        bluetoothA2dp.mService = iBluetoothA2dp;
        return iBluetoothA2dp;
    }

    private boolean isEnabled() {
        return this.mAdapter.getState() == 12;
    }

    /*
     * Enabled aggressive block sorting
     */
    private boolean isValidDevice(BluetoothDevice bluetoothDevice) {
        return bluetoothDevice != null && BluetoothAdapter.checkBluetoothAddress(bluetoothDevice.getAddress());
    }

    private static void log(String string2) {
        Log.d(TAG, string2);
    }

    public static String stateToString(int n) {
        switch (n) {
            default: {
                return "<unknown state " + n + ">";
            }
            case 0: {
                return "disconnected";
            }
            case 1: {
                return "connecting";
            }
            case 2: {
                return "connected";
            }
            case 3: {
                return "disconnecting";
            }
            case 10: {
                return "playing";
            }
            case 11: 
        }
        return "not playing";
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void adjustAvrcpAbsoluteVolume(int n) {
        Log.d(TAG, "adjustAvrcpAbsoluteVolume");
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.adjustAvrcpAbsoluteVolume(n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error talking to BT service in adjustAvrcpAbsoluteVolume()", remoteException);
                return;
            }
        } else {
            if (this.mService != null) return;
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void close() {
        this.mServiceListener = null;
        IBluetoothManager iBluetoothManager = this.mAdapter.getBluetoothManager();
        if (iBluetoothManager != null) {
            try {
                iBluetoothManager.unregisterStateChangeCallback(this.mBluetoothStateChangeCallback);
            }
            catch (Exception exception) {
                Log.e(TAG, "", exception);
            }
        }
        ServiceConnection serviceConnection = this.mConnection;
        synchronized (serviceConnection) {
            IBluetoothA2dp iBluetoothA2dp = this.mService;
            if (iBluetoothA2dp != null) {
                try {
                    this.mService = null;
                    this.mContext.unbindService(this.mConnection);
                }
                catch (Exception exception) {
                    Log.e(TAG, "", exception);
                }
            }
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean connect(BluetoothDevice bluetoothDevice) {
        BluetoothA2dp.log("connect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.connect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothA2dp iBluetoothA2dp = this.mService;
        boolean bl = false;
        if (iBluetoothA2dp != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean disconnect(BluetoothDevice bluetoothDevice) {
        BluetoothA2dp.log("disconnect(" + bluetoothDevice + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.disconnect(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothA2dp iBluetoothA2dp = this.mService;
        boolean bl = false;
        if (iBluetoothA2dp != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    boolean doBind() {
        Intent intent = new Intent(IBluetoothA2dp.class.getName());
        ComponentName componentName = intent.resolveSystemService(this.mContext.getPackageManager(), 0);
        intent.setComponent(componentName);
        if (componentName == null || !this.mContext.bindServiceAsUser(intent, this.mConnection, 0, Process.myUserHandle())) {
            Log.e(TAG, "Could not bind to Bluetooth A2DP Service with " + intent);
            return false;
        }
        return true;
    }

    public void finalize() {
        this.close();
    }

    @Override
    public List<BluetoothDevice> getConnectedDevices() {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getConnectedDevices();
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public int getConnectionState(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getConnectionState(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothA2dp iBluetoothA2dp = this.mService;
        int n = 0;
        if (iBluetoothA2dp != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    @Override
    public List<BluetoothDevice> getDevicesMatchingConnectionStates(int[] nArray) {
        if (this.mService != null && this.isEnabled()) {
            try {
                List<BluetoothDevice> list = this.mService.getDevicesMatchingConnectionStates(nArray);
                return list;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return new ArrayList<BluetoothDevice>();
            }
        }
        if (this.mService == null) {
            Log.w(TAG, "Proxy not attached to service");
        }
        return new ArrayList<BluetoothDevice>();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int getPriority(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                int n = this.mService.getPriority(bluetoothDevice);
                return n;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return 0;
            }
        }
        IBluetoothA2dp iBluetoothA2dp = this.mService;
        int n = 0;
        if (iBluetoothA2dp != null) return n;
        Log.w(TAG, "Proxy not attached to service");
        return 0;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isA2dpPlaying(BluetoothDevice bluetoothDevice) {
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            try {
                boolean bl = this.mService.isA2dpPlaying(bluetoothDevice);
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        IBluetoothA2dp iBluetoothA2dp = this.mService;
        boolean bl = false;
        if (iBluetoothA2dp != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean isAvrcpAbsoluteVolumeSupported() {
        Log.d(TAG, "isAvrcpAbsoluteVolumeSupported");
        if (this.mService != null && this.isEnabled()) {
            try {
                boolean bl = this.mService.isAvrcpAbsoluteVolumeSupported();
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error talking to BT service in isAvrcpAbsoluteVolumeSupported()", remoteException);
                return false;
            }
        }
        IBluetoothA2dp iBluetoothA2dp = this.mService;
        boolean bl = false;
        if (iBluetoothA2dp != null) return bl;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void setAvrcpAbsoluteVolume(int n) {
        Log.d(TAG, "setAvrcpAbsoluteVolume");
        if (this.mService != null && this.isEnabled()) {
            try {
                this.mService.setAvrcpAbsoluteVolume(n);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Error talking to BT service in setAvrcpAbsoluteVolume()", remoteException);
                return;
            }
        } else {
            if (this.mService != null) return;
            Log.w(TAG, "Proxy not attached to service");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean setPriority(BluetoothDevice bluetoothDevice, int n) {
        BluetoothA2dp.log("setPriority(" + bluetoothDevice + ", " + n + ")");
        if (this.mService != null && this.isEnabled() && this.isValidDevice(bluetoothDevice)) {
            if (n != 0 && n != 100) {
                return false;
            }
            try {
                return this.mService.setPriority(bluetoothDevice, n);
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "Stack:" + Log.getStackTraceString(new Throwable()));
                return false;
            }
        }
        if (this.mService != null) return false;
        Log.w(TAG, "Proxy not attached to service");
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    public boolean shouldSendVolumeKeys(BluetoothDevice bluetoothDevice) {
        ParcelUuid[] parcelUuidArray;
        if (this.isEnabled() && this.isValidDevice(bluetoothDevice) && (parcelUuidArray = bluetoothDevice.getUuids()) != null) {
            int n = parcelUuidArray.length;
            for (int i = 0; i < n; ++i) {
                if (!BluetoothUuid.isAvrcpTarget(parcelUuidArray[i])) continue;
                return true;
            }
        }
        return false;
    }
}

