/*
 * Decompiled with CFR 0.152.
 */
package android.appwidget;

import android.app.Activity;
import android.appwidget.AppWidgetHostView;
import android.appwidget.AppWidgetProviderInfo;
import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.IntentSender;
import android.os.Binder;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.os.Message;
import android.os.Process;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.widget.RemoteViews;
import com.android.internal.appwidget.IAppWidgetHost;
import com.android.internal.appwidget.IAppWidgetService;
import java.util.ArrayList;
import java.util.HashMap;

public class AppWidgetHost {
    static final int HANDLE_PROVIDERS_CHANGED = 3;
    static final int HANDLE_PROVIDER_CHANGED = 2;
    static final int HANDLE_UPDATE = 1;
    static final int HANDLE_VIEW_DATA_CHANGED = 4;
    static IAppWidgetService sService;
    static final Object sServiceLock;
    Callbacks mCallbacks = new Callbacks();
    Context mContext;
    private DisplayMetrics mDisplayMetrics;
    Handler mHandler;
    int mHostId;
    private RemoteViews.OnClickHandler mOnClickHandler;
    final HashMap<Integer, AppWidgetHostView> mViews = new HashMap();

    static {
        sServiceLock = new Object();
    }

    public AppWidgetHost(Context context, int n) {
        this(context, n, null, context.getMainLooper());
    }

    public AppWidgetHost(Context context, int n, RemoteViews.OnClickHandler onClickHandler, Looper looper) {
        this.mContext = context;
        this.mHostId = n;
        this.mOnClickHandler = onClickHandler;
        this.mHandler = new UpdateHandler(looper);
        this.mDisplayMetrics = context.getResources().getDisplayMetrics();
        AppWidgetHost.bindService();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static void bindService() {
        Object object = sServiceLock;
        synchronized (object) {
            if (sService == null) {
                sService = IAppWidgetService.Stub.asInterface(ServiceManager.getService("appwidget"));
            }
            return;
        }
    }

    public static void deleteAllHosts() {
        try {
            sService.deleteAllHosts();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    private boolean isLocalBinder() {
        return Process.myPid() == Binder.getCallingPid();
    }

    public int allocateAppWidgetId() {
        try {
            int n = sService.allocateAppWidgetId(this.mContext.getOpPackageName(), this.mHostId);
            return n;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    protected void clearViews() {
        this.mViews.clear();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final AppWidgetHostView createView(Context context, int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        AppWidgetHostView appWidgetHostView = this.onCreateView(this.mContext, n, appWidgetProviderInfo);
        appWidgetHostView.setOnClickHandler(this.mOnClickHandler);
        appWidgetHostView.setAppWidget(n, appWidgetProviderInfo);
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            this.mViews.put(n, appWidgetHostView);
        }
        try {
            RemoteViews remoteViews = sService.getAppWidgetViews(this.mContext.getOpPackageName(), n);
            appWidgetHostView.updateAppWidget(remoteViews);
            return appWidgetHostView;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void deleteAppWidgetId(int n) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        synchronized (hashMap) {
            this.mViews.remove(n);
            try {
                sService.deleteAppWidgetId(this.mContext.getOpPackageName(), n);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("system server dead?", remoteException);
            }
        }
    }

    public void deleteHost() {
        try {
            sService.deleteHost(this.mContext.getOpPackageName(), this.mHostId);
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public int[] getAppWidgetIds() {
        try {
            if (sService == null) {
                AppWidgetHost.bindService();
            }
            int[] nArray = sService.getAppWidgetIdsForHost(this.mContext.getOpPackageName(), this.mHostId);
            return nArray;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    protected AppWidgetHostView onCreateView(Context context, int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        return new AppWidgetHostView(context, this.mOnClickHandler);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    protected void onProviderChanged(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
        appWidgetProviderInfo.minWidth = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minWidth, this.mDisplayMetrics);
        appWidgetProviderInfo.minHeight = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minHeight, this.mDisplayMetrics);
        appWidgetProviderInfo.minResizeWidth = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minResizeWidth, this.mDisplayMetrics);
        appWidgetProviderInfo.minResizeHeight = TypedValue.complexToDimensionPixelSize(appWidgetProviderInfo.minResizeHeight, this.mDisplayMetrics);
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        // MONITORENTER : hashMap
        AppWidgetHostView appWidgetHostView = this.mViews.get(n);
        // MONITOREXIT : hashMap
        if (appWidgetHostView == null) return;
        appWidgetHostView.resetAppWidget(appWidgetProviderInfo);
    }

    protected void onProvidersChanged() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public final void startAppWidgetConfigureActivityForResult(Activity activity, int n, int n2, int n3, Bundle bundle) {
        IntentSender intentSender = sService.createAppWidgetConfigIntentSender(this.mContext.getOpPackageName(), n, n2);
        if (intentSender == null) throw new ActivityNotFoundException();
        try {
            activity.startIntentSenderForResult(intentSender, n3, null, 0, 0, 0, bundle);
            return;
        }
        catch (IntentSender.SendIntentException sendIntentException) {
            throw new ActivityNotFoundException();
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    public void startListening() {
        int[] nArray;
        ArrayList<RemoteViews> arrayList = new ArrayList<RemoteViews>();
        try {
            nArray = sService.startListening(this.mCallbacks, this.mContext.getOpPackageName(), this.mHostId, arrayList);
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            this.updateAppWidgetView(nArray[i], arrayList.get(i));
        }
    }

    public void stopListening() {
        try {
            sService.stopListening(this.mContext.getOpPackageName(), this.mHostId);
            this.clearViews();
            return;
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("system server dead?", remoteException);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void updateAppWidgetView(int n, RemoteViews remoteViews) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        // MONITORENTER : hashMap
        AppWidgetHostView appWidgetHostView = this.mViews.get(n);
        // MONITOREXIT : hashMap
        if (appWidgetHostView == null) return;
        appWidgetHostView.updateAppWidget(remoteViews);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    void viewDataChanged(int n, int n2) {
        HashMap<Integer, AppWidgetHostView> hashMap = this.mViews;
        // MONITORENTER : hashMap
        AppWidgetHostView appWidgetHostView = this.mViews.get(n);
        // MONITOREXIT : hashMap
        if (appWidgetHostView == null) return;
        appWidgetHostView.viewDataChanged(n2);
    }

    class Callbacks
    extends IAppWidgetHost.Stub {
        Callbacks() {
        }

        @Override
        public void providerChanged(int n, AppWidgetProviderInfo appWidgetProviderInfo) {
            if (AppWidgetHost.this.isLocalBinder() && appWidgetProviderInfo != null) {
                appWidgetProviderInfo = appWidgetProviderInfo.clone();
            }
            AppWidgetHost.this.mHandler.obtainMessage(2, n, 0, appWidgetProviderInfo).sendToTarget();
        }

        @Override
        public void providersChanged() {
            AppWidgetHost.this.mHandler.obtainMessage(3).sendToTarget();
        }

        @Override
        public void updateAppWidget(int n, RemoteViews remoteViews) {
            if (AppWidgetHost.this.isLocalBinder() && remoteViews != null) {
                remoteViews = remoteViews.clone();
            }
            AppWidgetHost.this.mHandler.obtainMessage(1, n, 0, remoteViews).sendToTarget();
        }

        @Override
        public void viewDataChanged(int n, int n2) {
            AppWidgetHost.this.mHandler.obtainMessage(4, n, n2).sendToTarget();
        }
    }

    class UpdateHandler
    extends Handler {
        public UpdateHandler(Looper looper) {
            super(looper);
        }

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: {
                    AppWidgetHost.this.updateAppWidgetView(message.arg1, (RemoteViews)message.obj);
                    return;
                }
                case 2: {
                    AppWidgetHost.this.onProviderChanged(message.arg1, (AppWidgetProviderInfo)message.obj);
                    return;
                }
                case 3: {
                    AppWidgetHost.this.onProvidersChanged();
                    return;
                }
                case 4: 
            }
            AppWidgetHost.this.viewDataChanged(message.arg1, message.arg2);
        }
    }
}

