/*
 * Decompiled with CFR 0.152.
 */
package android.app.job;

import android.app.Service;
import android.app.job.IJobCallback;
import android.app.job.IJobService;
import android.app.job.JobParameters;
import android.content.Intent;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.Message;
import android.os.RemoteException;
import android.util.Log;
import com.android.internal.annotations.GuardedBy;

public abstract class JobService
extends Service {
    public static final String PERMISSION_BIND = "android.permission.BIND_JOB_SERVICE";
    private static final String TAG = "JobService";
    private final int MSG_EXECUTE_JOB;
    private final int MSG_JOB_FINISHED;
    private final int MSG_STOP_JOB;
    IJobService mBinder;
    @GuardedBy(value="mHandlerLock")
    JobHandler mHandler;
    private final Object mHandlerLock = new Object();

    public JobService() {
        this.MSG_EXECUTE_JOB = 0;
        this.MSG_STOP_JOB = 1;
        this.MSG_JOB_FINISHED = 2;
        this.mBinder = new IJobService.Stub(){

            @Override
            public void startJob(JobParameters jobParameters) {
                JobService.this.ensureHandler();
                Message.obtain(JobService.this.mHandler, 0, jobParameters).sendToTarget();
            }

            @Override
            public void stopJob(JobParameters jobParameters) {
                JobService.this.ensureHandler();
                Message.obtain(JobService.this.mHandler, 1, jobParameters).sendToTarget();
            }
        };
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    void ensureHandler() {
        Object object = this.mHandlerLock;
        synchronized (object) {
            if (this.mHandler == null) {
                this.mHandler = new JobHandler(this.getMainLooper());
            }
            return;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public final void jobFinished(JobParameters jobParameters, boolean bl) {
        this.ensureHandler();
        Message message = Message.obtain(this.mHandler, 2, jobParameters);
        int n = bl ? 1 : 0;
        message.arg2 = n;
        message.sendToTarget();
    }

    @Override
    public final IBinder onBind(Intent intent) {
        return this.mBinder.asBinder();
    }

    public abstract boolean onStartJob(JobParameters var1);

    public abstract boolean onStopJob(JobParameters var1);

    class JobHandler
    extends Handler {
        JobHandler(Looper looper) {
            super(looper);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void ackStartMessage(JobParameters jobParameters, boolean bl) {
            IJobCallback iJobCallback = jobParameters.getCallback();
            int n = jobParameters.getJobId();
            if (iJobCallback != null) {
                try {
                    iJobCallback.acknowledgeStartMessage(n, bl);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(JobService.TAG, "System unreachable for starting job.");
                    return;
                }
            } else {
                if (!Log.isLoggable(JobService.TAG, 3)) return;
                Log.d(JobService.TAG, "Attempting to ack a job that has already been processed.");
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private void ackStopMessage(JobParameters jobParameters, boolean bl) {
            IJobCallback iJobCallback = jobParameters.getCallback();
            int n = jobParameters.getJobId();
            if (iJobCallback != null) {
                try {
                    iJobCallback.acknowledgeStopMessage(n, bl);
                    return;
                }
                catch (RemoteException remoteException) {
                    Log.e(JobService.TAG, "System unreachable for stopping job.");
                    return;
                }
            } else {
                if (!Log.isLoggable(JobService.TAG, 3)) return;
                Log.d(JobService.TAG, "Attempting to ack a job that has already been processed.");
                return;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void handleMessage(Message message) {
            IJobCallback iJobCallback;
            int n = 1;
            JobParameters jobParameters = (JobParameters)message.obj;
            switch (message.what) {
                default: {
                    Log.e(JobService.TAG, "Unrecognised message received.");
                    return;
                }
                case 0: {
                    try {
                        this.ackStartMessage(jobParameters, JobService.this.onStartJob(jobParameters));
                        return;
                    }
                    catch (Exception exception) {
                        Log.e(JobService.TAG, "Error while executing job: " + jobParameters.getJobId());
                        throw new RuntimeException(exception);
                    }
                }
                case 1: {
                    try {
                        this.ackStopMessage(jobParameters, JobService.this.onStopJob(jobParameters));
                        return;
                    }
                    catch (Exception exception) {
                        Log.e(JobService.TAG, "Application unable to handle onStopJob.", exception);
                        throw new RuntimeException(exception);
                    }
                }
                case 2: 
            }
            if (message.arg2 != n) {
                n = 0;
            }
            if ((iJobCallback = jobParameters.getCallback()) == null) {
                Log.e(JobService.TAG, "finishJob() called for a nonexistent job id.");
                return;
            }
            try {
                iJobCallback.jobFinished(jobParameters.getJobId(), n != 0);
                return;
            }
            catch (RemoteException remoteException) {
                Log.e(JobService.TAG, "Error reporting job finish to system: binder has goneaway.");
                return;
            }
        }
    }
}

