/*
 * Decompiled with CFR 0.152.
 */
package android.app.backup;

import android.app.backup.IBackupManager;
import android.app.backup.IRestoreSession;
import android.app.backup.RestoreObserver;
import android.app.backup.RestoreSession;
import android.content.Context;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;

public class BackupManager {
    private static final String TAG = "BackupManager";
    private static IBackupManager sService;
    private Context mContext;

    public BackupManager(Context context) {
        this.mContext = context;
    }

    private static void checkServiceBinder() {
        if (sService == null) {
            sService = IBackupManager.Stub.asInterface(ServiceManager.getService("backup"));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void dataChanged(String string2) {
        BackupManager.checkServiceBinder();
        if (sService == null) return;
        try {
            sService.dataChanged(string2);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "dataChanged(pkg) couldn't connect");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void backupNow() {
        BackupManager.checkServiceBinder();
        if (sService == null) return;
        try {
            sService.backupNow();
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "backupNow() couldn't connect");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public RestoreSession beginRestoreSession() {
        IRestoreSession iRestoreSession;
        BackupManager.checkServiceBinder();
        IBackupManager iBackupManager = sService;
        RestoreSession restoreSession = null;
        if (iBackupManager == null) return restoreSession;
        try {
            iRestoreSession = sService.beginRestoreSession(null, null);
            restoreSession = null;
            if (iRestoreSession == null) return restoreSession;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "beginRestoreSession() couldn't connect");
            return null;
        }
        RestoreSession restoreSession2 = new RestoreSession(this.mContext, iRestoreSession);
        return restoreSession2;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void dataChanged() {
        BackupManager.checkServiceBinder();
        if (sService == null) return;
        try {
            sService.dataChanged(this.mContext.getPackageName());
            return;
        }
        catch (RemoteException remoteException) {
            Log.d(TAG, "dataChanged() couldn't connect");
            return;
        }
    }

    public String getCurrentTransport() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                String string2 = sService.getCurrentTransport();
                return string2;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "getCurrentTransport() couldn't connect");
            }
        }
        return null;
    }

    public boolean isBackupEnabled() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                boolean bl = sService.isBackupEnabled();
                return bl;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "isBackupEnabled() couldn't connect");
            }
        }
        return false;
    }

    public String[] listAllTransports() {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                String[] stringArray = sService.listAllTransports();
                return stringArray;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "listAllTransports() couldn't connect");
            }
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public int requestRestore(RestoreObserver var1_1) {
        var2_2 = -1;
        BackupManager.checkServiceBinder();
        if (BackupManager.sService != null) {
            block14: {
                var3_3 = null;
                var7_4 = BackupManager.sService.beginRestoreSession(this.mContext.getPackageName(), null);
                var3_3 = null;
                if (var7_4 == null) break block14;
                var8_5 = new RestoreSession(this.mContext, var7_4);
                var2_2 = var10_6 = var8_5.restorePackage(this.mContext.getPackageName(), var1_1);
                var3_3 = var8_5;
            }
            if (var3_3 != null) {
                var3_3.endRestoreSession();
            }
        }
        return var2_2;
        catch (RemoteException var5_7) lbl-1000:
        // 2 sources

        {
            while (true) {
                try {
                    Log.e("BackupManager", "restoreSelf() unable to contact service");
                    if (var3_3 == null) ** continue;
                    var3_3.endRestoreSession();
                    return var2_2;
                }
                catch (Throwable var4_8) lbl-1000:
                // 2 sources

                {
                    while (true) {
                        if (var3_3 != null) {
                            var3_3.endRestoreSession();
                        }
                        throw var4_9;
                    }
                }
                break;
            }
        }
        catch (Throwable var4_10) {
            var3_3 = var8_5;
            ** continue;
        }
        catch (RemoteException var9_11) {
            var3_3 = var8_5;
            ** continue;
        }
    }

    public String selectBackupTransport(String string2) {
        BackupManager.checkServiceBinder();
        if (sService != null) {
            try {
                String string3 = sService.selectBackupTransport(string2);
                return string3;
            }
            catch (RemoteException remoteException) {
                Log.e(TAG, "selectBackupTransport() couldn't connect");
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setAutoRestore(boolean bl) {
        BackupManager.checkServiceBinder();
        if (sService == null) return;
        try {
            sService.setAutoRestore(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "setAutoRestore() couldn't connect");
            return;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void setBackupEnabled(boolean bl) {
        BackupManager.checkServiceBinder();
        if (sService == null) return;
        try {
            sService.setBackupEnabled(bl);
            return;
        }
        catch (RemoteException remoteException) {
            Log.e(TAG, "setBackupEnabled() couldn't connect");
            return;
        }
    }
}

