/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.IWallpaperManager;
import android.app.IWallpaperManagerCallback;
import android.app.WallpaperInfo;
import android.app.WallpaperUtilities;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Canvas;
import android.graphics.ColorFilter;
import android.graphics.Matrix;
import android.graphics.Paint;
import android.graphics.PorterDuff;
import android.graphics.PorterDuffXfermode;
import android.graphics.Rect;
import android.graphics.RectF;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Looper;
import android.os.ParcelFileDescriptor;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.WindowManager;
import android.view.WindowManagerGlobal;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class WallpaperManager {
    public static final String ACTION_CHANGE_LIVE_WALLPAPER = "android.service.wallpaper.CHANGE_LIVE_WALLPAPER";
    public static final String ACTION_CROP_AND_SET_WALLPAPER = "android.service.wallpaper.CROP_AND_SET_WALLPAPER";
    public static final String ACTION_LIVE_WALLPAPER_CHOOSER = "android.service.wallpaper.LIVE_WALLPAPER_CHOOSER";
    public static final String COMMAND_DROP = "android.home.drop";
    public static final String COMMAND_SECONDARY_TAP = "android.wallpaper.secondaryTap";
    public static final String COMMAND_TAP = "android.wallpaper.tap";
    private static boolean DEBUG = false;
    public static final String EXTRA_LIVE_WALLPAPER_COMPONENT = "android.service.wallpaper.extra.LIVE_WALLPAPER_COMPONENT";
    private static final String PROP_WALLPAPER = "ro.config.wallpaper";
    private static final String PROP_WALLPAPER_COMPONENT = "ro.config.wallpaper_component";
    private static String TAG = "WallpaperManager";
    public static final String WALLPAPER_PREVIEW_META_DATA = "android.wallpaper.preview";
    private static Globals sGlobals;
    private static final Object sSync;
    private final Context mContext;
    private float mWallpaperXStep = -1.0f;
    private float mWallpaperYStep = -1.0f;

    static {
        DEBUG = false;
        sSync = new Object[0];
    }

    WallpaperManager(Context context, Handler handler) {
        this.mContext = context;
        WallpaperManager.initGlobals(context.getMainLooper());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static Bitmap generateBitmap(Context context, Bitmap bitmap, int n, int n2) {
        if (bitmap == null) {
            return null;
        }
        WindowManager windowManager = (WindowManager)context.getSystemService("window");
        DisplayMetrics displayMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(displayMetrics);
        bitmap.setDensity(displayMetrics.noncompatDensityDpi);
        if (n <= 0) return bitmap;
        if (n2 <= 0) return bitmap;
        if (bitmap.getWidth() == n) {
            if (bitmap.getHeight() == n2) return bitmap;
        }
        try {
            Bitmap bitmap2 = Bitmap.createBitmap(n, n2, Bitmap.Config.ARGB_8888);
            bitmap2.setDensity(displayMetrics.noncompatDensityDpi);
            Canvas canvas = new Canvas(bitmap2);
            Rect rect = new Rect();
            rect.right = bitmap.getWidth();
            rect.bottom = bitmap.getHeight();
            int n3 = n - rect.right;
            int n4 = n2 - rect.bottom;
            if (n3 > 0 || n4 > 0) {
                float f;
                if (n3 > n4) {
                    f = (float)n / (float)rect.right;
                } else {
                    float f2 = n2;
                    int n5 = rect.bottom;
                    f = f2 / (float)n5;
                }
                rect.right = (int)(f * (float)rect.right);
                rect.bottom = (int)(f * (float)rect.bottom);
                n3 = n - rect.right;
                n4 = n2 - rect.bottom;
            }
            rect.offset(n3 / 2, n4 / 2);
            Paint paint = new Paint();
            paint.setFilterBitmap(true);
            paint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
            canvas.drawBitmap(bitmap, null, rect, paint);
            bitmap.recycle();
            canvas.setBitmap(null);
            return bitmap2;
        }
        catch (OutOfMemoryError outOfMemoryError) {
            Log.w(TAG, "Can't generate default bitmap", outOfMemoryError);
            return bitmap;
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public static ComponentName getDefaultWallpaperComponent(Context context) {
        String string2;
        ComponentName componentName;
        String string3 = SystemProperties.get(PROP_WALLPAPER_COMPONENT);
        if (!TextUtils.isEmpty(string3) && (componentName = ComponentName.unflattenFromString(string3)) != null || !TextUtils.isEmpty(string2 = context.getString(17039394)) && (componentName = ComponentName.unflattenFromString(string2)) != null) {
            return componentName;
        }
        return null;
    }

    public static WallpaperManager getInstance(Context context) {
        return (WallpaperManager)context.getSystemService("wallpaper");
    }

    private static RectF getMaxCropRect(int n, int n2, int n3, int n4, float f, float f2) {
        RectF rectF = new RectF();
        if ((float)n / (float)n2 > (float)n3 / (float)n4) {
            rectF.top = 0.0f;
            rectF.bottom = n2;
            float f3 = (float)n3 * ((float)n2 / (float)n4);
            rectF.left = f * ((float)n - f3);
            rectF.right = f3 + rectF.left;
            return rectF;
        }
        rectF.left = 0.0f;
        rectF.right = n;
        float f4 = (float)n4 * ((float)n / (float)n3);
        rectF.top = f2 * ((float)n2 - f4);
        rectF.bottom = f4 + rectF.top;
        return rectF;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    static void initGlobals(Looper looper) {
        Object object = sSync;
        synchronized (object) {
            if (sGlobals == null) {
                sGlobals = new Globals(looper);
            }
            return;
        }
    }

    public static InputStream openDefaultWallpaper(Context context) {
        File file;
        int n;
        Resources resources;
        int n2;
        String string2 = WallpaperUtilities.getADFDefaultWallpaperFilePath(context);
        if (!TextUtils.isEmpty(string2)) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                return bufferedInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.v(TAG, "File not found: " + string2);
            }
        }
        if ((n2 = WallpaperUtilities.getDefaultWallpaperResId(resources = WallpaperUtilities.getLauncherResources(context.getResources()), "com.asus.LauncherRes")) != 0) {
            return resources.openRawResource(n2);
        }
        String string3 = WallpaperUtilities.getEtcResDefaultWallpaperFilePath(context);
        if (!TextUtils.isEmpty(string3)) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
                return bufferedInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.v(TAG, "File not found: " + string3);
            }
        }
        if ((n = WallpaperUtilities.getDefaultWallpaperResId(context.getResources(), "android")) != 0) {
            return context.getResources().openRawResource(n);
        }
        String string4 = SystemProperties.get(PROP_WALLPAPER);
        if (!TextUtils.isEmpty(string4) && (file = new File(string4)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                return fileInputStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return context.getResources().openRawResource(17302384);
    }

    public static InputStream openDefaultWallpaperForLockscreen(Context context) {
        File file;
        int n;
        Resources resources;
        int n2;
        String string2 = WallpaperUtilities.getADFDefaultWallpaperFilePath(context);
        if (!TextUtils.isEmpty(string2)) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string2));
                return bufferedInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.v(TAG, "File not found: " + string2);
            }
        }
        if ((n2 = (resources = WallpaperUtilities.getLauncherResources(context.getResources())).getIdentifier("default_wallpaper_1a", "drawable", "com.asus.LauncherRes")) != 0) {
            return resources.openRawResource(n2);
        }
        String string3 = WallpaperUtilities.getEtcResDefaultWallpaperFilePathForLockscreen(context);
        if (!TextUtils.isEmpty(string3)) {
            try {
                BufferedInputStream bufferedInputStream = new BufferedInputStream(new FileInputStream(string3));
                return bufferedInputStream;
            }
            catch (FileNotFoundException fileNotFoundException) {
                Log.v(TAG, "File not found: " + string3);
            }
        }
        if ((n = context.getResources().getIdentifier("default_wallpaper_1a", "drawable", "android")) != 0) {
            return context.getResources().openRawResource(n);
        }
        String string4 = SystemProperties.get(PROP_WALLPAPER);
        if (!TextUtils.isEmpty(string4) && (file = new File(string4)).exists()) {
            try {
                FileInputStream fileInputStream = new FileInputStream(file);
                return fileInputStream;
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
        return context.getResources().openRawResource(17302384);
    }

    private void setWallpaper(InputStream inputStream, FileOutputStream fileOutputStream) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
        }
    }

    private void setWallpaper(InputStream inputStream, FileOutputStream fileOutputStream, FileOutputStream fileOutputStream2) throws IOException {
        int n;
        byte[] byArray = new byte[32768];
        while ((n = inputStream.read(byArray)) > 0) {
            fileOutputStream.write(byArray, 0, n);
            fileOutputStream2.write(byArray, 0, n);
        }
    }

    private void updateWallpaperSetting(int n) {
        try {
            sGlobals.mService.updateWallpaperSetting(n);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void clear() throws IOException {
        this.setStream(WallpaperManager.openDefaultWallpaper(this.mContext));
    }

    public void clearWallpaperOffsets(IBinder iBinder) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(iBinder, -1.0f, -1.0f, -1.0f, -1.0f);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void forgetLoadedLockscreenWallpaper() {
        sGlobals.forgetLoadedLockscreenWallpaper();
    }

    public void forgetLoadedWallpaper() {
        sGlobals.forgetLoadedWallpaper();
    }

    public Bitmap getBitmap() {
        return sGlobals.peekWallpaperBitmap(this.mContext, true);
    }

    public Drawable getBuiltInDrawable() {
        return this.getBuiltInDrawable(0, 0, false, 0.0f, 0.0f);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Drawable getBuiltInDrawable(int n, int n2, boolean bl, float f, float f2) {
        BitmapRegionDecoder bitmapRegionDecoder;
        Rect rect;
        int n3;
        int n4;
        BufferedInputStream bufferedInputStream;
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return null;
        }
        Resources resources = this.mContext.getResources();
        float f3 = Math.max(0.0f, Math.min(1.0f, f));
        float f4 = Math.max(0.0f, Math.min(1.0f, f2));
        BufferedInputStream bufferedInputStream2 = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext));
        if (bufferedInputStream2 == null) {
            Log.e(TAG, "default wallpaper input stream is null");
            return null;
        }
        if (n <= 0 || n2 <= 0) {
            return new BitmapDrawable(resources, BitmapFactory.decodeStream(bufferedInputStream2, null, null));
        }
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inJustDecodeBounds = true;
        BitmapFactory.decodeStream(bufferedInputStream2, null, options);
        if (options.outWidth != 0 && options.outHeight != 0) {
            RectF rectF;
            int n5 = options.outWidth;
            int n6 = options.outHeight;
            bufferedInputStream = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext));
            n4 = Math.min(n5, n);
            n3 = Math.min(n6, n2);
            if (bl) {
                rectF = WallpaperManager.getMaxCropRect(n5, n6, n4, n3, f3, f4);
            } else {
                float f5 = f3 * (float)(n5 - n4);
                float f6 = f5 + (float)n4;
                float f7 = f4 * (float)(n6 - n3);
                rectF = new RectF(f5, f7, f6, f7 + (float)n3);
            }
            rect = new Rect();
            rectF.roundOut(rect);
            if (rect.width() <= 0 || rect.height() <= 0) {
                Log.w(TAG, "crop has bad values for full size image");
                return null;
            }
        } else {
            Log.e(TAG, "default wallpaper dimensions are 0");
            return null;
        }
        int n7 = Math.min(rect.width() / n4, rect.height() / n3);
        try {
            BitmapRegionDecoder bitmapRegionDecoder2;
            bitmapRegionDecoder = bitmapRegionDecoder2 = BitmapRegionDecoder.newInstance(bufferedInputStream, true);
        }
        catch (IOException iOException) {
            Log.w(TAG, "cannot open region decoder for default wallpaper");
            bitmapRegionDecoder = null;
        }
        Bitmap bitmap = null;
        if (bitmapRegionDecoder != null) {
            BitmapFactory.Options options2 = new BitmapFactory.Options();
            if (n7 > 1) {
                options2.inSampleSize = n7;
            }
            bitmap = bitmapRegionDecoder.decodeRegion(rect, options2);
            bitmapRegionDecoder.recycle();
        }
        if (bitmap == null) {
            BufferedInputStream bufferedInputStream3 = new BufferedInputStream(WallpaperManager.openDefaultWallpaper(this.mContext));
            Bitmap bitmap2 = null;
            if (bufferedInputStream3 != null) {
                BitmapFactory.Options options3 = new BitmapFactory.Options();
                if (n7 > 1) {
                    options3.inSampleSize = n7;
                }
                bitmap2 = BitmapFactory.decodeStream(bufferedInputStream3, null, options3);
            }
            if (bitmap2 != null) {
                int n8 = rect.left;
                int n9 = rect.top;
                int n10 = rect.width();
                int n11 = rect.height();
                bitmap = Bitmap.createBitmap(bitmap2, n8, n9, n10, n11);
            }
        }
        if (bitmap == null) {
            Log.w(TAG, "cannot decode default wallpaper");
            return null;
        }
        if (n4 > 0 && n3 > 0 && (bitmap.getWidth() != n4 || bitmap.getHeight() != n3)) {
            Matrix matrix = new Matrix();
            RectF rectF = new RectF(0.0f, 0.0f, bitmap.getWidth(), bitmap.getHeight());
            RectF rectF2 = new RectF(0.0f, 0.0f, n4, n3);
            matrix.setRectToRect(rectF, rectF2, Matrix.ScaleToFit.FILL);
            Bitmap bitmap3 = Bitmap.createBitmap((int)rectF2.width(), (int)rectF2.height(), Bitmap.Config.ARGB_8888);
            if (bitmap3 != null) {
                Canvas canvas = new Canvas(bitmap3);
                Paint paint = new Paint();
                paint.setFilterBitmap(true);
                canvas.drawBitmap(bitmap, matrix, paint);
                bitmap = bitmap3;
            }
        }
        return new BitmapDrawable(resources, bitmap);
    }

    /*
     * Enabled aggressive block sorting
     */
    public Intent getCropAndSetWallpaperIntent(Uri uri) {
        block7: {
            Intent intent;
            block5: {
                PackageManager packageManager;
                block6: {
                    if (uri == null) {
                        throw new IllegalArgumentException("Image URI must not be null");
                    }
                    if (!"content".equals(uri.getScheme())) {
                        throw new IllegalArgumentException("Image URI must be of the content scheme type");
                    }
                    packageManager = this.mContext.getPackageManager();
                    intent = new Intent(ACTION_CROP_AND_SET_WALLPAPER, uri);
                    intent.addFlags(1);
                    intent.setPackage("com.asus.launcher");
                    if (packageManager.queryIntentActivities(intent, 0).size() > 0) break block5;
                    ResolveInfo resolveInfo = packageManager.resolveActivity(new Intent("android.intent.action.MAIN").addCategory("android.intent.category.HOME"), 65536);
                    if (resolveInfo == null) break block6;
                    intent.setPackage(resolveInfo.activityInfo.packageName);
                    if (packageManager.queryIntentActivities(intent, 0).size() > 0) break block5;
                }
                intent.setPackage("com.android.wallpapercropper");
                if (packageManager.queryIntentActivities(intent, 0).size() <= 0) break block7;
            }
            return intent;
        }
        throw new IllegalArgumentException("Cannot use passed URI to set wallpaper; check that the type returned by ContentProvider matches image/*");
    }

    public int getDesiredMinimumHeight() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return 0;
        }
        try {
            int n = sGlobals.mService.getHeightHint();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public int getDesiredMinimumWidth() {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return 0;
        }
        try {
            int n = sGlobals.mService.getWidthHint();
            return n;
        }
        catch (RemoteException remoteException) {
            return 0;
        }
    }

    public Drawable getDrawable() {
        Bitmap bitmap = sGlobals.peekWallpaperBitmap(this.mContext, true);
        if (bitmap != null) {
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.mContext.getResources(), bitmap);
            ((Drawable)bitmapDrawable).setDither(false);
            return bitmapDrawable;
        }
        return null;
    }

    public Drawable getFastDrawable() {
        Bitmap bitmap = sGlobals.peekWallpaperBitmap(this.mContext, true);
        if (bitmap != null) {
            return new FastBitmapDrawable(bitmap);
        }
        return null;
    }

    public IWallpaperManager getIWallpaperManager() {
        return sGlobals.mService;
    }

    public Drawable getLockscreenWallpaper() {
        Log.d(TAG, "getLockscreenWallpaper");
        Bitmap bitmap = sGlobals.peekLockscreenWallpaperBitmap(this.mContext);
        if (bitmap != null) {
            return new BitmapDrawable(bitmap);
        }
        return null;
    }

    public Drawable getLockscreenWallpaper(int n, int n2) {
        Log.v(TAG, "getLockscreenWallpaper");
        Bitmap bitmap = sGlobals.peekLockscreenWallpaperBitmap(this.mContext, n, n2);
        if (bitmap != null) {
            return new BitmapDrawable(bitmap);
        }
        return null;
    }

    public WallpaperInfo getWallpaperInfo() {
        block3: {
            try {
                if (sGlobals.mService != null) break block3;
                Log.w(TAG, "WallpaperService not running");
                return null;
            }
            catch (RemoteException remoteException) {
                return null;
            }
        }
        WallpaperInfo wallpaperInfo = sGlobals.mService.getWallpaperInfo();
        return wallpaperInfo;
    }

    public boolean hasResourceWallpaper(int n) {
        if (sGlobals.mService == null) {
            Log.w(TAG, "WallpaperService not running");
            return false;
        }
        try {
            Resources resources = this.mContext.getResources();
            String string2 = "res:" + resources.getResourceName(n);
            boolean bl = sGlobals.mService.hasNamedWallpaper(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public Drawable peekDrawable() {
        Bitmap bitmap = sGlobals.peekWallpaperBitmap(this.mContext, false);
        if (bitmap != null) {
            BitmapDrawable bitmapDrawable = new BitmapDrawable(this.mContext.getResources(), bitmap);
            ((Drawable)bitmapDrawable).setDither(false);
            return bitmapDrawable;
        }
        return null;
    }

    public Drawable peekFastDrawable() {
        Bitmap bitmap = sGlobals.peekWallpaperBitmap(this.mContext, false);
        if (bitmap != null) {
            return new FastBitmapDrawable(bitmap);
        }
        return null;
    }

    public void resetLockWallpaper() throws IOException {
        if (WallpaperUtilities.isZf2List()) {
            this.setStream(WallpaperManager.openDefaultWallpaperForLockscreen(this.mContext), 1);
            return;
        }
        this.setStream(WallpaperManager.openDefaultWallpaper(this.mContext), 1);
    }

    public void sendWallpaperCommand(IBinder iBinder, String string2, int n, int n2, int n3, Bundle bundle) {
        try {
            WindowManagerGlobal.getWindowSession().sendWallpaperCommand(iBinder, string2, n, n2, n3, bundle, false);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setBitmap(Bitmap bitmap) throws IOException {
        this.setBitmap(bitmap, 0);
    }

    /*
     * Unable to fully structure code
     */
    public void setBitmap(Bitmap var1_1, int var2_2) throws IOException {
        block40: {
            block38: {
                if (Globals.access$200(WallpaperManager.sGlobals) == null) {
                    Log.w(WallpaperManager.TAG, "WallpaperService not running");
lbl4:
                    // 5 sources

                    return;
                }
                if (var2_2 != 0 && var2_2 != 2) break block40;
                var12_3 = Globals.access$200(WallpaperManager.sGlobals).setWallpaper(null);
                if (var12_3 == null) ** GOTO lbl4
                var13_4 = null;
                var14_5 = new ParcelFileDescriptor.AutoCloseOutputStream(var12_3);
                var1_1.compress(Bitmap.CompressFormat.PNG, 90, var14_5);
                if (var14_5 == null) break block38;
                var14_5.close();
            }
lbl20:
            // 5 sources

            while (true) {
                block41: {
                    block39: {
                        if (var2_2 != 2) break block41;
                        var5_6 = Globals.access$200(WallpaperManager.sGlobals).setWallpaper(null);
                        if (var5_6 == null) ** GOTO lbl4
                        var6_7 = Globals.access$200(WallpaperManager.sGlobals).setWallpaperforLockscreen();
                        if (var6_7 == null) ** GOTO lbl4
                        var7_8 = null;
                        var8_9 = null;
                        var9_10 = new ParcelFileDescriptor.AutoCloseInputStream(var5_6);
                        var10_11 = new ParcelFileDescriptor.AutoCloseOutputStream(var6_7);
                        this.setWallpaper(var9_10, var10_11);
                        if (var10_11 == null) break block39;
                        var10_11.close();
                    }
                    if (var9_10 != null) {
                        var9_10.close();
                    }
                }
lbl44:
                // 2 sources

                while (true) {
                    this.updateWallpaperSetting(var2_2);
                    return;
                }
                break;
            }
            catch (Throwable var15_12) lbl-1000:
            // 2 sources

            {
                while (true) {
                    if (var13_4 == null) ** GOTO lbl52
                    try {
                        var13_4.close();
lbl52:
                        // 2 sources

                        throw var15_13;
                    }
                    catch (RemoteException var3_15) {
                    }
                    break;
                }
            }
        }
        if (var2_2 != 1) ** GOTO lbl20
        var18_16 = Globals.access$200(WallpaperManager.sGlobals).setWallpaperforLockscreen();
        if (var18_16 != null) ** break;
        ** continue;
        var19_17 = new ParcelFileDescriptor.AutoCloseOutputStream(var18_16);
        var1_1.compress(Bitmap.CompressFormat.PNG, 90, var19_17);
        if (var19_17 == null) ** GOTO lbl20
        try {
            var19_17.close();
        }
        catch (RemoteException var17_27) {}
lbl70:
        // 2 sources

        while (true) {
            if (var21_21 == null) ** GOTO lbl74
            var21_21.close();
lbl74:
            // 2 sources

            throw var20_18;
            break;
        }
        catch (Throwable var11_22) lbl-1000:
        // 3 sources

        {
            while (true) {
                if (var8_9 != null) {
                    var8_9.close();
                }
                if (var7_8 == null) ** GOTO lbl83
                try {
                    var7_8.close();
lbl83:
                    // 2 sources

                    throw var11_23;
                }
                catch (RemoteException var4_26) {
                    ** continue;
                }
                break;
            }
        }
        catch (Throwable var11_24) {
            var7_8 = var9_10;
            var8_9 = null;
            ** GOTO lbl-1000
        }
        catch (Throwable var11_25) {
            var8_9 = var10_11;
            var7_8 = var9_10;
            ** continue;
        }
        catch (Throwable var20_19) {
            var21_21 = var19_17;
        }
        ** GOTO lbl70
        catch (Throwable var15_14) {
            var13_4 = var14_5;
            ** continue;
        }
        ** while (true)
        catch (Throwable var20_20) {
            var21_21 = null;
            ** continue;
        }
    }

    public void setDisplayOffset(IBinder iBinder, int n, int n2) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperDisplayOffset(iBinder, n, n2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setDisplayPadding(Rect rect) {
        try {
            if (sGlobals.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return;
            }
            sGlobals.mService.setDisplayPadding(rect);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setResource(int n) throws IOException {
        this.setResource(n, 0);
    }

    /*
     * Unable to fully structure code
     */
    public void setResource(int var1_1, int var2_2) throws IOException {
        block23: {
            if (Globals.access$200(WallpaperManager.sGlobals) == null) {
                Log.w(WallpaperManager.TAG, "WallpaperService not running");
                return;
            }
            if (var2_2 == 0 || var2_2 == 2) {
                var10_3 = this.mContext.getResources();
                var11_4 = Globals.access$200(WallpaperManager.sGlobals).setWallpaper("res:" + var10_3.getResourceName(var1_1));
                if (var11_4 == null) break block23;
                var12_5 = null;
                var13_6 = new ParcelFileDescriptor.AutoCloseOutputStream(var11_4);
                this.setWallpaper(var10_3.openRawResource(var1_1), var13_6);
                if (var13_6 == null) break block23;
                var13_6.close();
            }
        }
lbl19:
        // 2 sources

        while (true) {
            block24: {
                if (var2_2 == 1 || var2_2 == 2) {
                    var5_7 = this.mContext.getResources();
                    var6_8 = Globals.access$200(WallpaperManager.sGlobals).setWallpaperforLockscreen();
                    if (var6_8 == null) break block24;
                    var7_9 = null;
                    var8_10 = new ParcelFileDescriptor.AutoCloseOutputStream(var6_8);
                    this.setWallpaper(var5_7.openRawResource(var1_1), var8_10);
                    if (var8_10 == null) break block24;
                    var8_10.close();
                }
            }
lbl34:
            // 2 sources

            while (true) {
                this.updateWallpaperSetting(var2_2);
                return;
            }
            break;
        }
        catch (Throwable var14_11) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var12_5 == null) ** GOTO lbl42
                try {
                    var12_5.close();
lbl42:
                    // 2 sources

                    throw var14_12;
                }
                catch (RemoteException var3_14) {
                    ** continue;
                }
                break;
            }
        }
        catch (Throwable var9_15) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var7_9 == null) ** GOTO lbl50
                try {
                    var7_9.close();
lbl50:
                    // 2 sources

                    throw var9_16;
                }
                catch (RemoteException var4_18) {
                    ** continue;
                }
                break;
            }
        }
        catch (Throwable var9_17) {
            var7_9 = var8_10;
            ** continue;
        }
        catch (Throwable var14_13) {
            var12_5 = var13_6;
            ** continue;
        }
    }

    public void setStream(InputStream inputStream) throws IOException {
        this.setStream(inputStream, 0);
    }

    /*
     * Unable to fully structure code
     */
    public void setStream(InputStream var1_1, int var2_2) throws IOException {
        block39: {
            if (Globals.access$200(WallpaperManager.sGlobals) == null) {
                Log.w(WallpaperManager.TAG, "WallpaperService not running");
lbl4:
                // 4 sources

                return;
            }
            if (var2_2 != 0) break block39;
            var17_3 = Globals.access$200(WallpaperManager.sGlobals).setWallpaper(null);
            if (var17_3 == null) ** GOTO lbl4
            var18_4 = null;
            var19_5 = new ParcelFileDescriptor.AutoCloseOutputStream(var17_3);
            this.setWallpaper(var1_1, var19_5);
            if (var19_5 == null) break block39;
            var19_5.close();
        }
lbl19:
        // 2 sources

        while (true) {
            block40: {
                if (var2_2 != 1) break block40;
                var12_6 = Globals.access$200(WallpaperManager.sGlobals).setWallpaperforLockscreen();
                if (var12_6 == null) ** GOTO lbl4
                var13_7 = null;
                var14_8 = new ParcelFileDescriptor.AutoCloseOutputStream(var12_6);
                this.setWallpaper(var1_1, var14_8);
                if (var14_8 == null) break block40;
                var14_8.close();
            }
lbl33:
            // 2 sources

            while (true) {
                if (var2_2 == 2) {
                    block41: {
                        var4_9 = Globals.access$200(WallpaperManager.sGlobals).setWallpaper(null);
                        var5_10 = Globals.access$200(WallpaperManager.sGlobals).setWallpaperforLockscreen();
                        if (var4_9 != null && var5_10 != null) ** break;
                        ** continue;
                        var6_11 = null;
                        var7_12 = null;
                        var8_13 = new ParcelFileDescriptor.AutoCloseOutputStream(var4_9);
                        var9_14 = new ParcelFileDescriptor.AutoCloseOutputStream(var5_10);
                        this.setWallpaper(var1_1, var8_13, var9_14);
                        if (var8_13 == null) break block41;
                        var8_13.close();
                    }
                    if (var9_14 != null) {
                        var9_14.close();
                    }
                }
lbl55:
                // 6 sources

                while (true) {
                    this.updateWallpaperSetting(var2_2);
                    return;
                }
                break;
            }
            break;
        }
        catch (Throwable var20_15) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var18_4 == null) ** GOTO lbl63
                try {
                    var18_4.close();
lbl63:
                    // 2 sources

                    throw var20_16;
                }
                catch (RemoteException var16_18) {
                    ** continue;
                }
                break;
            }
        }
        catch (Throwable var15_19) lbl-1000:
        // 2 sources

        {
            while (true) {
                if (var13_7 == null) ** GOTO lbl71
                try {
                    var13_7.close();
lbl71:
                    // 2 sources

                    throw var15_20;
                }
                catch (RemoteException var11_22) {
                    ** continue;
                }
                break;
            }
        }
        catch (Throwable var10_23) lbl-1000:
        // 3 sources

        {
            while (true) {
                if (var6_11 != null) {
                    var6_11.close();
                }
                if (var7_12 == null) ** GOTO lbl82
                try {
                    var7_12.close();
lbl82:
                    // 2 sources

                    throw var10_24;
                }
                catch (RemoteException var3_27) {
                    ** continue;
                }
                break;
            }
        }
        catch (Throwable var10_25) {
            var6_11 = var8_13;
            var7_12 = null;
            ** GOTO lbl-1000
        }
        catch (Throwable var10_26) {
            var7_12 = var9_14;
            var6_11 = var8_13;
            ** continue;
        }
        catch (Throwable var15_21) {
            var13_7 = var14_8;
            ** continue;
        }
        catch (Throwable var20_17) {
            var18_4 = var19_5;
            ** continue;
        }
    }

    public void setWallpaperOffsetSteps(float f, float f2) {
        this.mWallpaperXStep = f;
        this.mWallpaperYStep = f2;
    }

    public void setWallpaperOffsets(IBinder iBinder, float f, float f2) {
        try {
            WindowManagerGlobal.getWindowSession().setWallpaperPosition(iBinder, f, f2, this.mWallpaperXStep, this.mWallpaperYStep);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    /*
     * Exception decompiling
     */
    public void suggestDesiredDimensions(int var1_1, int var2_2) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [0[TRYBLOCK]], but top level block is 5[UNCONDITIONALDOLOOP]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public void upgradeLockscreenWallpaper() {
        sGlobals.upgradeLockscreenWallpaper();
    }

    static class FastBitmapDrawable
    extends Drawable {
        private final Bitmap mBitmap;
        private int mDrawLeft;
        private int mDrawTop;
        private final int mHeight;
        private final Paint mPaint;
        private final int mWidth;

        private FastBitmapDrawable(Bitmap bitmap) {
            this.mBitmap = bitmap;
            this.mWidth = bitmap.getWidth();
            this.mHeight = bitmap.getHeight();
            this.setBounds(0, 0, this.mWidth, this.mHeight);
            this.mPaint = new Paint();
            this.mPaint.setXfermode(new PorterDuffXfermode(PorterDuff.Mode.SRC));
        }

        @Override
        public void draw(Canvas canvas) {
            canvas.drawBitmap(this.mBitmap, this.mDrawLeft, this.mDrawTop, this.mPaint);
        }

        @Override
        public int getIntrinsicHeight() {
            return this.mHeight;
        }

        @Override
        public int getIntrinsicWidth() {
            return this.mWidth;
        }

        @Override
        public int getMinimumHeight() {
            return this.mHeight;
        }

        @Override
        public int getMinimumWidth() {
            return this.mWidth;
        }

        @Override
        public int getOpacity() {
            return -1;
        }

        @Override
        public void setAlpha(int n) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setBounds(int n, int n2, int n3, int n4) {
            this.mDrawLeft = n + (n3 - n - this.mWidth) / 2;
            this.mDrawTop = n2 + (n4 - n2 - this.mHeight) / 2;
        }

        @Override
        public void setColorFilter(ColorFilter colorFilter) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setDither(boolean bl) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }

        @Override
        public void setFilterBitmap(boolean bl) {
            throw new UnsupportedOperationException("Not supported with this drawable");
        }
    }

    static class Globals
    extends IWallpaperManagerCallback.Stub {
        private static final int MSG_CLEAR_LOCKSCREEN_WALLPAPER = 2;
        private static final int MSG_CLEAR_WALLPAPER = 1;
        private Bitmap mDefaultWallpaper;
        private Bitmap mLockscreenWallpaper;
        private IWallpaperManager mService = IWallpaperManager.Stub.asInterface(ServiceManager.getService("wallpaper"));
        private Bitmap mWallpaper;

        Globals(Looper looper) {
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        private Bitmap getCurrentWallpaperLocked(Context context) {
            if (this.mService == null) {
                Log.w(TAG, "WallpaperService not running");
                return null;
            }
            Bundle bundle = new Bundle();
            ParcelFileDescriptor parcelFileDescriptor = this.mService.getWallpaper(this, bundle);
            if (parcelFileDescriptor == null) return null;
            {
                catch (RemoteException remoteException) {
                    return null;
                }
            }
            BitmapFactory.Options options = new BitmapFactory.Options();
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor(parcelFileDescriptor.getFileDescriptor(), null, options);
            parcelFileDescriptor.close();
            return bitmap;
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w(TAG, "Can't decode file", outOfMemoryError);
                {
                    catch (Throwable throwable) {
                        try {
                            parcelFileDescriptor.close();
                        }
                        catch (IOException iOException) {
                            throw throwable;
                        }
                        throw throwable;
                    }
                }
                try {
                    parcelFileDescriptor.close();
                    return null;
                }
                catch (IOException iOException) {
                    return null;
                }
            }
            catch (IOException iOException) {
                return bitmap;
            }
        }

        /*
         * Loose catch block
         */
        private Bitmap getDefaultWallpaperLocked(Context context) {
            InputStream inputStream = WallpaperManager.openDefaultWallpaper(context);
            Bitmap bitmap = null;
            if (inputStream != null) {
                Bitmap bitmap2;
                bitmap = bitmap2 = BitmapFactory.decodeStream(inputStream, null, new BitmapFactory.Options());
                inputStream.close();
            }
            return bitmap;
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w(TAG, "Can't decode stream", outOfMemoryError);
                return null;
            }
            catch (IOException iOException) {
                return bitmap;
            }
            finally {
                inputStream.close();
            }
        }

        public void forgetLoadedLockscreenWallpaper() {
            this.mLockscreenWallpaper = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public void forgetLoadedWallpaper() {
            synchronized (this) {
                this.mWallpaper = null;
                this.mDefaultWallpaper = null;
                return;
            }
        }

        @Override
        public void onLockscreenWallpaperChanged() {
            this.mLockscreenWallpaper = null;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public void onWallpaperChanged() {
            synchronized (this) {
                this.mWallpaper = null;
                this.mDefaultWallpaper = null;
                return;
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Bitmap peekLockscreenWallpaperBitmap(Context context) {
            if (this.mLockscreenWallpaper != null) {
                Log.d(TAG, "use cached lockscreen wallpaper");
                return this.mLockscreenWallpaper;
            }
            this.mLockscreenWallpaper = null;
            ParcelFileDescriptor parcelFileDescriptor = this.mService.getLockscreenWallpaper(this);
            if (parcelFileDescriptor == null) return this.mLockscreenWallpaper;
            int n = sGlobals.mService.getWidthHint();
            int n2 = sGlobals.mService.getHeightHint();
            Log.d(TAG, "peekLockscreenWallpaperBitmap width:" + n + " height:" + n2);
            BitmapFactory.Options options = new BitmapFactory.Options();
            Bitmap bitmap = BitmapFactory.decodeFileDescriptor(parcelFileDescriptor.getFileDescriptor(), null, options);
            int n3 = bitmap.getWidth();
            int n4 = bitmap.getHeight();
            float f = Math.max((float)n / (float)n3, (float)n2 / (float)n4);
            int n5 = Math.round(f * (float)n3);
            int n6 = Math.round(f * (float)n4);
            Log.d(TAG, "image width:" + n + " height:" + n2);
            Log.d(TAG, "scale: " + f + " bgWidth:" + n5 + " bgHeight:" + n6);
            this.mLockscreenWallpaper = WallpaperManager.generateBitmap(context, bitmap, n5, n6);
            parcelFileDescriptor.close();
            return this.mLockscreenWallpaper;
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w(TAG, "Can't decode file", outOfMemoryError);
                {
                    catch (Throwable throwable) {
                        try {
                            parcelFileDescriptor.close();
                        }
                        catch (IOException iOException) {
                            throw throwable;
                        }
                        throw throwable;
                    }
                }
                try {
                    try {
                        parcelFileDescriptor.close();
                        return this.mLockscreenWallpaper;
                    }
                    catch (IOException iOException) {
                        return this.mLockscreenWallpaper;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    Log.w(TAG, "No memory load current wallpaper", outOfMemoryError2);
                    return this.mLockscreenWallpaper;
                }
                catch (IOException iOException) {
                    return this.mLockscreenWallpaper;
                }
                catch (RemoteException remoteException) {
                    return this.mLockscreenWallpaper;
                }
            }
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Bitmap peekLockscreenWallpaperBitmap(Context context, int n, int n2) {
            if (this.mLockscreenWallpaper != null) {
                Log.v(TAG, "use cached lockscreen wallpaper");
                return this.mLockscreenWallpaper;
            }
            this.mLockscreenWallpaper = null;
            ParcelFileDescriptor parcelFileDescriptor = this.mService.getLockscreenWallpaper(this);
            if (parcelFileDescriptor == null) return this.mLockscreenWallpaper;
            Log.v(TAG, "peekLockscreenWallpaperBitmap getWidthHint():" + sGlobals.mService.getWidthHint() + ", getHeightHint():" + sGlobals.mService.getHeightHint());
            if (n == 0) {
                n = sGlobals.mService.getWidthHint();
            }
            if (n2 == 0) {
                n2 = sGlobals.mService.getHeightHint();
            }
            Log.v(TAG, "peekLockscreenWallpaperBitmap with var width:" + n + " height:" + n2);
            BitmapFactory.Options options = new BitmapFactory.Options();
            this.mLockscreenWallpaper = WallpaperManager.generateBitmap(context, BitmapFactory.decodeFileDescriptor(parcelFileDescriptor.getFileDescriptor(), null, options), n, n2);
            parcelFileDescriptor.close();
            return this.mLockscreenWallpaper;
            catch (OutOfMemoryError outOfMemoryError) {
                Log.w(TAG, "Can't decode file", outOfMemoryError);
                {
                    catch (Throwable throwable) {
                        try {
                            parcelFileDescriptor.close();
                        }
                        catch (IOException iOException) {
                            throw throwable;
                        }
                        throw throwable;
                    }
                }
                try {
                    try {
                        parcelFileDescriptor.close();
                        return this.mLockscreenWallpaper;
                    }
                    catch (IOException iOException) {
                        return this.mLockscreenWallpaper;
                    }
                }
                catch (OutOfMemoryError outOfMemoryError2) {
                    Log.w(TAG, "No memory load current wallpaper", outOfMemoryError2);
                    return this.mLockscreenWallpaper;
                }
                catch (IOException iOException) {
                    return this.mLockscreenWallpaper;
                }
                catch (RemoteException remoteException) {
                    return this.mLockscreenWallpaper;
                }
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public Bitmap peekWallpaperBitmap(Context context, boolean bl) {
            synchronized (this) {
                if (this.mWallpaper != null) {
                    return this.mWallpaper;
                }
                if (this.mDefaultWallpaper != null) {
                    return this.mDefaultWallpaper;
                }
                this.mWallpaper = null;
                try {
                    this.mWallpaper = this.getCurrentWallpaperLocked(context);
                }
                catch (OutOfMemoryError outOfMemoryError) {
                    Log.w(TAG, "No memory load current wallpaper", outOfMemoryError);
                }
                if (!bl) return this.mWallpaper;
                if (this.mWallpaper == null) {
                    this.mDefaultWallpaper = this.getDefaultWallpaperLocked(context);
                    return this.mDefaultWallpaper;
                }
                this.mDefaultWallpaper = null;
                return this.mWallpaper;
            }
        }

        public void upgradeLockscreenWallpaper() {
            try {
                this.mService.upgradeLockscreenWallpaper();
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }
    }
}

