/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Dialog;
import android.content.Context;
import android.content.res.Resources;
import android.hardware.display.DisplayManager;
import android.os.Handler;
import android.os.Message;
import android.util.DisplayMetrics;
import android.util.Log;
import android.util.TypedValue;
import android.view.ContextThemeWrapper;
import android.view.Display;
import android.view.WindowManagerImpl;

public class Presentation
extends Dialog {
    private static final int MSG_CANCEL = 1;
    private static final String TAG = "Presentation";
    private final Display mDisplay;
    private final DisplayManager.DisplayListener mDisplayListener = new DisplayManager.DisplayListener(){

        @Override
        public void onDisplayAdded(int n) {
        }

        @Override
        public void onDisplayChanged(int n) {
            if (n == Presentation.this.mDisplay.getDisplayId()) {
                Presentation.this.handleDisplayChanged();
            }
        }

        @Override
        public void onDisplayRemoved(int n) {
            if (n == Presentation.this.mDisplay.getDisplayId()) {
                Presentation.this.handleDisplayRemoved();
            }
        }
    };
    private final DisplayManager mDisplayManager;
    private final Handler mHandler = new Handler(){

        @Override
        public void handleMessage(Message message) {
            switch (message.what) {
                default: {
                    return;
                }
                case 1: 
            }
            Presentation.this.cancel();
        }
    };

    public Presentation(Context context, Display display) {
        this(context, display, 0);
    }

    public Presentation(Context context, Display display, int n) {
        super(Presentation.createPresentationContext(context, display, n), n, false);
        this.mDisplay = display;
        this.mDisplayManager = (DisplayManager)this.getContext().getSystemService("display");
        this.getWindow().setGravity(119);
        this.setCanceledOnTouchOutside(false);
    }

    private static Context createPresentationContext(Context context, Display display, int n) {
        if (context == null) {
            throw new IllegalArgumentException("outerContext must not be null");
        }
        if (display == null) {
            throw new IllegalArgumentException("display must not be null");
        }
        Context context2 = context.createDisplayContext(display);
        if (n == 0) {
            TypedValue typedValue = new TypedValue();
            context2.getTheme().resolveAttribute(16843712, typedValue, true);
            n = typedValue.resourceId;
        }
        return new ContextThemeWrapper(context2, n, ((WindowManagerImpl)context.getSystemService("window")).createPresentationWindowManager(display)){
            final /* synthetic */ WindowManagerImpl val$displayWindowManager;
            {
                this.val$displayWindowManager = windowManagerImpl;
                super(context, n);
            }

            @Override
            public Object getSystemService(String string2) {
                if ("window".equals(string2)) {
                    return this.val$displayWindowManager;
                }
                return super.getSystemService(string2);
            }
        };
    }

    private void handleDisplayChanged() {
        this.onDisplayChanged();
        if (!this.isConfigurationStillValid()) {
            this.cancel();
        }
    }

    private void handleDisplayRemoved() {
        this.onDisplayRemoved();
        this.cancel();
    }

    private boolean isConfigurationStillValid() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        this.mDisplay.getMetrics(displayMetrics);
        return displayMetrics.equalsPhysical(this.getResources().getDisplayMetrics());
    }

    public Display getDisplay() {
        return this.mDisplay;
    }

    public Resources getResources() {
        return this.getContext().getResources();
    }

    public void onDisplayChanged() {
    }

    public void onDisplayRemoved() {
    }

    @Override
    protected void onStart() {
        super.onStart();
        this.mDisplayManager.registerDisplayListener(this.mDisplayListener, this.mHandler);
        if (!this.isConfigurationStillValid()) {
            Log.i(TAG, "Presentation is being immediately dismissed because the display metrics have changed since it was created.");
            this.mHandler.sendEmptyMessage(1);
        }
    }

    @Override
    protected void onStop() {
        this.mDisplayManager.unregisterDisplayListener(this.mDisplayListener);
        super.onStop();
    }

    @Override
    public void show() {
        super.show();
    }
}

