/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.PendingIntent;
import android.app.RemoteInput;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.PorterDuff;
import android.graphics.drawable.Drawable;
import android.media.AudioAttributes;
import android.media.session.MediaSession;
import android.net.Uri;
import android.os.BadParcelableException;
import android.os.Bundle;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.SystemClock;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.Log;
import android.util.MathUtils;
import android.widget.RemoteViews;
import com.android.internal.util.NotificationColorUtil;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

public class Notification
implements Parcelable {
    public static final AudioAttributes AUDIO_ATTRIBUTES_DEFAULT = new AudioAttributes.Builder().setContentType(4).setUsage(5).build();
    public static final String CATEGORY_ALARM = "alarm";
    public static final String CATEGORY_CALL = "call";
    public static final String CATEGORY_EMAIL = "email";
    public static final String CATEGORY_ERROR = "err";
    public static final String CATEGORY_EVENT = "event";
    public static final String CATEGORY_MESSAGE = "msg";
    public static final String CATEGORY_PROGRESS = "progress";
    public static final String CATEGORY_PROMO = "promo";
    public static final String CATEGORY_RECOMMENDATION = "recommendation";
    public static final String CATEGORY_SERVICE = "service";
    public static final String CATEGORY_SOCIAL = "social";
    public static final String CATEGORY_STATUS = "status";
    public static final String CATEGORY_SYSTEM = "sys";
    public static final String CATEGORY_TRANSPORT = "transport";
    public static final int COLOR_DEFAULT = 0;
    public static final Parcelable.Creator<Notification> CREATOR = new Parcelable.Creator<Notification>(){

        @Override
        public Notification createFromParcel(Parcel parcel) {
            return new Notification(parcel);
        }

        public Notification[] newArray(int n) {
            return new Notification[n];
        }
    };
    public static final int DEFAULT_ALL = -1;
    public static final int DEFAULT_LIGHTS = 4;
    public static final int DEFAULT_SOUND = 1;
    public static final int DEFAULT_VIBRATE = 2;
    public static final String EXTRA_ALLOW_DURING_SETUP = "android.allowDuringSetup";
    public static final String EXTRA_AS_HEADS_UP = "headsup";
    public static final String EXTRA_BACKGROUND_IMAGE_URI = "android.backgroundImageUri";
    public static final String EXTRA_BIG_TEXT = "android.bigText";
    public static final String EXTRA_COMPACT_ACTIONS = "android.compactActions";
    public static final String EXTRA_INFO_TEXT = "android.infoText";
    public static final String EXTRA_LARGE_ICON = "android.largeIcon";
    public static final String EXTRA_LARGE_ICON_BIG = "android.largeIcon.big";
    public static final String EXTRA_MEDIA_SESSION = "android.mediaSession";
    public static final String EXTRA_ORIGINATING_USERID = "android.originatingUserId";
    public static final String EXTRA_PEOPLE = "android.people";
    public static final String EXTRA_PICTURE = "android.picture";
    public static final String EXTRA_PROGRESS = "android.progress";
    public static final String EXTRA_PROGRESS_INDETERMINATE = "android.progressIndeterminate";
    public static final String EXTRA_PROGRESS_MAX = "android.progressMax";
    public static final String EXTRA_SHOW_CHRONOMETER = "android.showChronometer";
    public static final String EXTRA_SHOW_WHEN = "android.showWhen";
    public static final String EXTRA_SMALL_ICON = "android.icon";
    public static final String EXTRA_SUB_TEXT = "android.subText";
    public static final String EXTRA_SUMMARY_TEXT = "android.summaryText";
    public static final String EXTRA_TEMPLATE = "android.template";
    public static final String EXTRA_TEXT = "android.text";
    public static final String EXTRA_TEXT_LINES = "android.textLines";
    public static final String EXTRA_TITLE = "android.title";
    public static final String EXTRA_TITLE_BIG = "android.title.big";
    public static final int FLAG_AUTO_CANCEL = 16;
    public static final int FLAG_FOREGROUND_SERVICE = 64;
    public static final int FLAG_GROUP_SUMMARY = 512;
    public static final int FLAG_HIGH_PRIORITY = 128;
    public static final int FLAG_INSISTENT = 4;
    public static final int FLAG_LOCAL_ONLY = 256;
    public static final int FLAG_NO_CLEAR = 32;
    public static final int FLAG_ONGOING_EVENT = 2;
    public static final int FLAG_ONLY_ALERT_ONCE = 8;
    public static final int FLAG_SHOW_LIGHTS = 1;
    public static final int HEADS_UP_ALLOWED = 1;
    public static final int HEADS_UP_NEVER = 0;
    public static final int HEADS_UP_REQUESTED = 2;
    public static final String INTENT_CATEGORY_NOTIFICATION_PREFERENCES = "android.intent.category.NOTIFICATION_PREFERENCES";
    private static final int MAX_CHARSEQUENCE_LENGTH = 5120;
    public static final int PRIORITY_DEFAULT = 0;
    public static final int PRIORITY_HIGH = 1;
    public static final int PRIORITY_LOW = -1;
    public static final int PRIORITY_MAX = 2;
    public static final int PRIORITY_MIN = -2;
    @Deprecated
    public static final int STREAM_DEFAULT = -1;
    private static final String TAG = "Notification";
    public static final int VISIBILITY_PRIVATE = 0;
    public static final int VISIBILITY_PUBLIC = 1;
    public static final int VISIBILITY_SECRET = -1;
    public Action[] actions;
    public AudioAttributes audioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
    @Deprecated
    public int audioStreamType = -1;
    public RemoteViews bigContentView;
    public String category;
    public int color = 0;
    public PendingIntent contentIntent;
    public RemoteViews contentView;
    public int defaults;
    public PendingIntent deleteIntent;
    public Bundle extras = new Bundle();
    public int flags;
    public PendingIntent fullScreenIntent;
    public RemoteViews headsUpContentView;
    public int icon;
    public int iconLevel;
    public Bitmap largeIcon;
    public int ledARGB;
    public int ledOffMS;
    public int ledOnMS;
    private String mGroupKey;
    private String mSortKey;
    public int number;
    public int priority;
    public Notification publicVersion;
    public Uri sound;
    public CharSequence tickerText;
    @Deprecated
    public RemoteViews tickerView;
    public long[] vibrate;
    public int visibility;
    public long when;

    public Notification() {
        this.when = System.currentTimeMillis();
        this.priority = 0;
    }

    @Deprecated
    public Notification(int n, CharSequence charSequence, long l) {
        this.icon = n;
        this.tickerText = charSequence;
        this.when = l;
    }

    public Notification(Context context, int n, CharSequence charSequence, long l, CharSequence charSequence2, CharSequence charSequence3, Intent intent) {
        this.when = l;
        this.icon = n;
        this.tickerText = charSequence;
        this.setLatestEventInfo(context, charSequence2, charSequence3, PendingIntent.getActivity(context, 0, intent, 0));
    }

    public Notification(Parcel parcel) {
        parcel.readInt();
        this.when = parcel.readLong();
        this.icon = parcel.readInt();
        this.number = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.contentIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.deleteIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerText = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.tickerView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.contentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.largeIcon = Bitmap.CREATOR.createFromParcel(parcel);
        }
        this.defaults = parcel.readInt();
        this.flags = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.sound = Uri.CREATOR.createFromParcel(parcel);
        }
        this.audioStreamType = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.audioAttributes = AudioAttributes.CREATOR.createFromParcel(parcel);
        }
        this.vibrate = parcel.createLongArray();
        this.ledARGB = parcel.readInt();
        this.ledOnMS = parcel.readInt();
        this.ledOffMS = parcel.readInt();
        this.iconLevel = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.fullScreenIntent = PendingIntent.CREATOR.createFromParcel(parcel);
        }
        this.priority = parcel.readInt();
        this.category = parcel.readString();
        this.mGroupKey = parcel.readString();
        this.mSortKey = parcel.readString();
        this.extras = parcel.readBundle();
        this.actions = parcel.createTypedArray(Action.CREATOR);
        if (parcel.readInt() != 0) {
            this.bigContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        if (parcel.readInt() != 0) {
            this.headsUpContentView = RemoteViews.CREATOR.createFromParcel(parcel);
        }
        this.visibility = parcel.readInt();
        if (parcel.readInt() != 0) {
            this.publicVersion = CREATOR.createFromParcel(parcel);
        }
        this.color = parcel.readInt();
    }

    static /* synthetic */ String access$402(Notification notification, String string2) {
        notification.mGroupKey = string2;
        return string2;
    }

    static /* synthetic */ String access$502(Notification notification, String string2) {
        notification.mSortKey = string2;
        return string2;
    }

    private static Notification[] getNotificationArrayFromBundle(Bundle bundle, String string2) {
        Parcelable[] parcelableArray = bundle.getParcelableArray(string2);
        if (parcelableArray instanceof Notification[] || parcelableArray == null) {
            return (Notification[])parcelableArray;
        }
        Parcelable[] parcelableArray2 = (Notification[])Arrays.copyOf(parcelableArray, parcelableArray.length, Notification[].class);
        bundle.putParcelableArray(string2, parcelableArray2);
        return parcelableArray2;
    }

    /*
     * Enabled aggressive block sorting
     */
    public static CharSequence safeCharSequence(CharSequence charSequence) {
        block5: {
            block4: {
                if (charSequence == null) break block4;
                if (charSequence.length() > 5120) {
                    charSequence = charSequence.subSequence(0, 5120);
                }
                if (charSequence instanceof Parcelable) break block5;
            }
            return charSequence;
        }
        Log.e(TAG, "warning: " + charSequence.getClass().getCanonicalName() + " instance is a custom Parcelable and not allowed in Notification");
        return charSequence.toString();
    }

    public static String visibilityToString(int n) {
        switch (n) {
            default: {
                return "UNKNOWN(" + String.valueOf(n) + ")";
            }
            case 0: {
                return "PRIVATE";
            }
            case 1: {
                return "PUBLIC";
            }
            case -1: 
        }
        return "SECRET";
    }

    public Notification clone() {
        Notification notification = new Notification();
        this.cloneInto(notification, true);
        return notification;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void cloneInto(Notification notification, boolean bl) {
        long[] lArray;
        notification.when = this.when;
        notification.icon = this.icon;
        notification.number = this.number;
        notification.contentIntent = this.contentIntent;
        notification.deleteIntent = this.deleteIntent;
        notification.fullScreenIntent = this.fullScreenIntent;
        if (this.tickerText != null) {
            notification.tickerText = this.tickerText.toString();
        }
        if (bl && this.tickerView != null) {
            notification.tickerView = this.tickerView.clone();
        }
        if (bl && this.contentView != null) {
            notification.contentView = this.contentView.clone();
        }
        if (bl && this.largeIcon != null) {
            notification.largeIcon = Bitmap.createBitmap(this.largeIcon);
        }
        notification.iconLevel = this.iconLevel;
        notification.sound = this.sound;
        notification.audioStreamType = this.audioStreamType;
        if (this.audioAttributes != null) {
            notification.audioAttributes = new AudioAttributes.Builder(this.audioAttributes).build();
        }
        if ((lArray = this.vibrate) != null) {
            int n = lArray.length;
            long[] lArray2 = new long[n];
            notification.vibrate = lArray2;
            System.arraycopy((long[])lArray, (int)0, (long[])lArray2, (int)0, (int)n);
        }
        notification.ledARGB = this.ledARGB;
        notification.ledOnMS = this.ledOnMS;
        notification.ledOffMS = this.ledOffMS;
        notification.defaults = this.defaults;
        notification.flags = this.flags;
        notification.priority = this.priority;
        notification.category = this.category;
        notification.mGroupKey = this.mGroupKey;
        notification.mSortKey = this.mSortKey;
        if (this.extras != null) {
            try {
                notification.extras = new Bundle(this.extras);
                notification.extras.size();
            }
            catch (BadParcelableException badParcelableException) {
                Log.e(TAG, "could not unparcel extras from notification: " + this, badParcelableException);
                notification.extras = null;
            }
        }
        if (this.actions != null) {
            notification.actions = new Action[this.actions.length];
            for (int i = 0; i < this.actions.length; ++i) {
                notification.actions[i] = this.actions[i].clone();
            }
        }
        if (bl && this.bigContentView != null) {
            notification.bigContentView = this.bigContentView.clone();
        }
        if (bl && this.headsUpContentView != null) {
            notification.headsUpContentView = this.headsUpContentView.clone();
        }
        notification.visibility = this.visibility;
        if (this.publicVersion != null) {
            notification.publicVersion = new Notification();
            this.publicVersion.cloneInto(notification.publicVersion, bl);
        }
        notification.color = this.color;
        if (!bl) {
            notification.lightenPayload();
        }
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public String getGroup() {
        return this.mGroupKey;
    }

    public String getSortKey() {
        return this.mSortKey;
    }

    public boolean isGroupChild() {
        return this.mGroupKey != null && (0x200 & this.flags) == 0;
    }

    public boolean isGroupSummary() {
        return this.mGroupKey != null && (0x200 & this.flags) != 0;
    }

    public boolean isValid() {
        return this.contentView != null || this.extras.getBoolean("android.rebuild.contentView");
    }

    public final void lightenPayload() {
        this.tickerView = null;
        this.contentView = null;
        this.bigContentView = null;
        this.headsUpContentView = null;
        this.largeIcon = null;
        if (this.extras != null) {
            this.extras.remove(EXTRA_LARGE_ICON);
            this.extras.remove(EXTRA_LARGE_ICON_BIG);
            this.extras.remove(EXTRA_PICTURE);
            this.extras.remove(EXTRA_BIG_TEXT);
            this.extras.remove("android.rebuild");
        }
    }

    @Deprecated
    public void setLatestEventInfo(Context context, CharSequence charSequence, CharSequence charSequence2, PendingIntent pendingIntent) {
        Builder builder = new Builder(context);
        builder.setWhen(this.when);
        builder.setSmallIcon(this.icon);
        builder.setPriority(this.priority);
        builder.setTicker(this.tickerText);
        builder.setNumber(this.number);
        builder.setColor(this.color);
        Builder.access$302(builder, this.flags);
        builder.setSound(this.sound, this.audioStreamType);
        builder.setDefaults(this.defaults);
        builder.setVibrate(this.vibrate);
        if (charSequence != null) {
            builder.setContentTitle(charSequence);
        }
        if (charSequence2 != null) {
            builder.setContentText(charSequence2);
        }
        builder.setContentIntent(pendingIntent);
        builder.buildInto(this);
    }

    /*
     * Enabled aggressive block sorting
     */
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Notification(pri=");
        stringBuilder.append(this.priority);
        stringBuilder.append(" contentView=");
        if (this.contentView != null) {
            stringBuilder.append(this.contentView.getPackage());
            stringBuilder.append("/0x");
            stringBuilder.append(Integer.toHexString(this.contentView.getLayoutId()));
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(" vibrate=");
        if ((2 & this.defaults) != 0) {
            stringBuilder.append("default");
        } else if (this.vibrate != null) {
            int n = -1 + this.vibrate.length;
            stringBuilder.append("[");
            for (int i = 0; i < n; ++i) {
                stringBuilder.append(this.vibrate[i]);
                stringBuilder.append(',');
            }
            if (n != -1) {
                stringBuilder.append(this.vibrate[n]);
            }
            stringBuilder.append("]");
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(" sound=");
        if ((1 & this.defaults) != 0) {
            stringBuilder.append("default");
        } else if (this.sound != null) {
            stringBuilder.append(this.sound.toString());
        } else {
            stringBuilder.append("null");
        }
        stringBuilder.append(" defaults=0x");
        stringBuilder.append(Integer.toHexString(this.defaults));
        stringBuilder.append(" flags=0x");
        stringBuilder.append(Integer.toHexString(this.flags));
        Object[] objectArray = new Object[]{this.color};
        stringBuilder.append(String.format(" color=0x%08x", objectArray));
        if (this.category != null) {
            stringBuilder.append(" category=");
            stringBuilder.append(this.category);
        }
        if (this.mGroupKey != null) {
            stringBuilder.append(" groupKey=");
            stringBuilder.append(this.mGroupKey);
        }
        if (this.mSortKey != null) {
            stringBuilder.append(" sortKey=");
            stringBuilder.append(this.mSortKey);
        }
        if (this.actions != null) {
            stringBuilder.append(" actions=");
            stringBuilder.append(this.actions.length);
        }
        stringBuilder.append(" vis=");
        stringBuilder.append(Notification.visibilityToString(this.visibility));
        if (this.publicVersion != null) {
            stringBuilder.append(" publicVersion=");
            stringBuilder.append(this.publicVersion.toString());
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void writeToParcel(Parcel parcel, int n) {
        parcel.writeInt(1);
        parcel.writeLong(this.when);
        parcel.writeInt(this.icon);
        parcel.writeInt(this.number);
        if (this.contentIntent != null) {
            parcel.writeInt(1);
            this.contentIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.deleteIntent != null) {
            parcel.writeInt(1);
            this.deleteIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerText != null) {
            parcel.writeInt(1);
            TextUtils.writeToParcel(this.tickerText, parcel, n);
        } else {
            parcel.writeInt(0);
        }
        if (this.tickerView != null) {
            parcel.writeInt(1);
            this.tickerView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.contentView != null) {
            parcel.writeInt(1);
            this.contentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.largeIcon != null) {
            parcel.writeInt(1);
            this.largeIcon.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.defaults);
        parcel.writeInt(this.flags);
        if (this.sound != null) {
            parcel.writeInt(1);
            this.sound.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.audioStreamType);
        if (this.audioAttributes != null) {
            parcel.writeInt(1);
            this.audioAttributes.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeLongArray(this.vibrate);
        parcel.writeInt(this.ledARGB);
        parcel.writeInt(this.ledOnMS);
        parcel.writeInt(this.ledOffMS);
        parcel.writeInt(this.iconLevel);
        if (this.fullScreenIntent != null) {
            parcel.writeInt(1);
            this.fullScreenIntent.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.priority);
        parcel.writeString(this.category);
        parcel.writeString(this.mGroupKey);
        parcel.writeString(this.mSortKey);
        parcel.writeBundle(this.extras);
        parcel.writeTypedArray(this.actions, 0);
        if (this.bigContentView != null) {
            parcel.writeInt(1);
            this.bigContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        if (this.headsUpContentView != null) {
            parcel.writeInt(1);
            this.headsUpContentView.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.visibility);
        if (this.publicVersion != null) {
            parcel.writeInt(1);
            this.publicVersion.writeToParcel(parcel, 0);
        } else {
            parcel.writeInt(0);
        }
        parcel.writeInt(this.color);
    }

    public static class Action
    implements Parcelable {
        public static final Parcelable.Creator<Action> CREATOR = new Parcelable.Creator<Action>(){

            @Override
            public Action createFromParcel(Parcel parcel) {
                return new Action(parcel);
            }

            public Action[] newArray(int n) {
                return new Action[n];
            }
        };
        public PendingIntent actionIntent;
        public int icon;
        private final Bundle mExtras;
        private final RemoteInput[] mRemoteInputs;
        public CharSequence title;

        public Action(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            this(n, charSequence, pendingIntent, new Bundle(), null);
        }

        /*
         * Enabled aggressive block sorting
         */
        private Action(int n, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
            this.icon = n;
            this.title = charSequence;
            this.actionIntent = pendingIntent;
            if (bundle == null) {
                bundle = new Bundle();
            }
            this.mExtras = bundle;
            this.mRemoteInputs = remoteInputArray;
        }

        private Action(Parcel parcel) {
            this.icon = parcel.readInt();
            this.title = TextUtils.CHAR_SEQUENCE_CREATOR.createFromParcel(parcel);
            if (parcel.readInt() == 1) {
                this.actionIntent = PendingIntent.CREATOR.createFromParcel(parcel);
            }
            this.mExtras = parcel.readBundle();
            this.mRemoteInputs = parcel.createTypedArray(RemoteInput.CREATOR);
        }

        public Action clone() {
            return new Action(this.icon, this.title, this.actionIntent, new Bundle(this.mExtras), this.getRemoteInputs());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public Bundle getExtras() {
            return this.mExtras;
        }

        public RemoteInput[] getRemoteInputs() {
            return this.mRemoteInputs;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeInt(this.icon);
            TextUtils.writeToParcel(this.title, parcel, n);
            if (this.actionIntent != null) {
                parcel.writeInt(1);
                this.actionIntent.writeToParcel(parcel, n);
            } else {
                parcel.writeInt(0);
            }
            parcel.writeBundle(this.mExtras);
            parcel.writeTypedArray(this.mRemoteInputs, n);
        }

        public static final class Builder {
            private final Bundle mExtras;
            private final int mIcon;
            private final PendingIntent mIntent;
            private ArrayList<RemoteInput> mRemoteInputs;
            private final CharSequence mTitle;

            public Builder(int n, CharSequence charSequence, PendingIntent pendingIntent) {
                this(n, charSequence, pendingIntent, new Bundle(), null);
            }

            private Builder(int n, CharSequence charSequence, PendingIntent pendingIntent, Bundle bundle, RemoteInput[] remoteInputArray) {
                this.mIcon = n;
                this.mTitle = charSequence;
                this.mIntent = pendingIntent;
                this.mExtras = bundle;
                if (remoteInputArray != null) {
                    this.mRemoteInputs = new ArrayList(remoteInputArray.length);
                    Collections.addAll(this.mRemoteInputs, remoteInputArray);
                }
            }

            public Builder(Action action) {
                this(action.icon, action.title, action.actionIntent, new Bundle(action.mExtras), action.getRemoteInputs());
            }

            public Builder addExtras(Bundle bundle) {
                if (bundle != null) {
                    this.mExtras.putAll(bundle);
                }
                return this;
            }

            public Builder addRemoteInput(RemoteInput remoteInput) {
                if (this.mRemoteInputs == null) {
                    this.mRemoteInputs = new ArrayList();
                }
                this.mRemoteInputs.add(remoteInput);
                return this;
            }

            /*
             * Enabled force condition propagation
             * Lifted jumps to return sites
             */
            public Action build() {
                RemoteInput[] remoteInputArray;
                if (this.mRemoteInputs != null) {
                    remoteInputArray = this.mRemoteInputs.toArray(new RemoteInput[this.mRemoteInputs.size()]);
                    return new Action(this.mIcon, this.mTitle, this.mIntent, this.mExtras, remoteInputArray);
                }
                remoteInputArray = null;
                return new Action(this.mIcon, this.mTitle, this.mIntent, this.mExtras, remoteInputArray);
            }

            public Builder extend(Extender extender) {
                extender.extend(this);
                return this;
            }

            public Bundle getExtras() {
                return this.mExtras;
            }
        }

        public static interface Extender {
            public Builder extend(Builder var1);
        }

        public static final class WearableExtender
        implements Extender {
            private static final int DEFAULT_FLAGS = 1;
            private static final String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
            private static final int FLAG_AVAILABLE_OFFLINE = 1;
            private static final String KEY_FLAGS = "flags";
            private int mFlags = 1;

            public WearableExtender() {
            }

            public WearableExtender(Action action) {
                Bundle bundle = action.getExtras().getBundle(EXTRA_WEARABLE_EXTENSIONS);
                if (bundle != null) {
                    this.mFlags = bundle.getInt(KEY_FLAGS, 1);
                }
            }

            private void setFlag(int n, boolean bl) {
                if (bl) {
                    this.mFlags = n | this.mFlags;
                    return;
                }
                this.mFlags &= ~n;
            }

            public WearableExtender clone() {
                WearableExtender wearableExtender = new WearableExtender();
                wearableExtender.mFlags = this.mFlags;
                return wearableExtender;
            }

            @Override
            public Builder extend(Builder builder) {
                Bundle bundle = new Bundle();
                if (this.mFlags != 1) {
                    bundle.putInt(KEY_FLAGS, this.mFlags);
                }
                builder.getExtras().putBundle(EXTRA_WEARABLE_EXTENSIONS, bundle);
                return builder;
            }

            public boolean isAvailableOffline() {
                return (1 & this.mFlags) != 0;
            }

            public WearableExtender setAvailableOffline(boolean bl) {
                this.setFlag(1, bl);
                return this;
            }
        }
    }

    public static class BigPictureStyle
    extends Style {
        private Bitmap mBigLargeIcon;
        private boolean mBigLargeIconSet = false;
        private Bitmap mPicture;

        public BigPictureStyle() {
        }

        public BigPictureStyle(Builder builder) {
            this.setBuilder(builder);
        }

        /*
         * Enabled aggressive block sorting
         */
        private RemoteViews makeBigContentView() {
            RemoteViews remoteViews = this.getStandardView(this.mBuilder.getBigPictureLayoutResource());
            remoteViews.setImageViewBitmap(16909180, this.mPicture);
            this.applyTopPadding(remoteViews);
            boolean bl = this.mBuilder.mSubText != null && this.mBuilder.mContentText != null;
            Builder builder = this.mBuilder;
            int n = bl ? 16909193 : 16909196;
            builder.addProfileBadge(remoteViews, n);
            return remoteViews;
        }

        @Override
        public void addExtras(Bundle bundle) {
            super.addExtras(bundle);
            if (this.mBigLargeIconSet) {
                bundle.putParcelable(Notification.EXTRA_LARGE_ICON_BIG, this.mBigLargeIcon);
            }
            bundle.putParcelable(Notification.EXTRA_PICTURE, this.mPicture);
        }

        public BigPictureStyle bigLargeIcon(Bitmap bitmap) {
            this.mBigLargeIconSet = true;
            this.mBigLargeIcon = bitmap;
            return this;
        }

        public BigPictureStyle bigPicture(Bitmap bitmap) {
            this.mPicture = bitmap;
            return this;
        }

        @Override
        public void populateBigContentView(Notification notification) {
            this.mBuilder.setBuilderBigContentView(notification, this.makeBigContentView());
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            super.restoreFromExtras(bundle);
            if (bundle.containsKey(Notification.EXTRA_LARGE_ICON_BIG)) {
                this.mBigLargeIcon = (Bitmap)bundle.getParcelable(Notification.EXTRA_LARGE_ICON_BIG);
            }
            this.mPicture = (Bitmap)bundle.getParcelable(Notification.EXTRA_PICTURE);
        }

        public BigPictureStyle setBigContentTitle(CharSequence charSequence) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(charSequence));
            return this;
        }

        public BigPictureStyle setSummaryText(CharSequence charSequence) {
            this.internalSetSummaryText(Notification.safeCharSequence(charSequence));
            return this;
        }
    }

    public static class BigTextStyle
    extends Style {
        private static final int LINES_CONSUMED_BY_ACTIONS = 3;
        private static final int LINES_CONSUMED_BY_SUMMARY = 2;
        private static final int MAX_LINES = 13;
        private CharSequence mBigText;

        public BigTextStyle() {
        }

        public BigTextStyle(Builder builder) {
            this.setBuilder(builder);
        }

        /*
         * Enabled aggressive block sorting
         */
        private int calculateMaxLines() {
            int n = 13;
            boolean bl = this.mBuilder.mActions.size() > 0;
            CharSequence charSequence = this.mSummaryTextSet ? this.mSummaryText : this.mBuilder.mSubText;
            boolean bl2 = charSequence != null;
            if (bl) {
                n -= 3;
            }
            if (bl2) {
                n -= 2;
            }
            if (!this.mBuilder.mHasThreeLines) {
                --n;
            }
            return n;
        }

        private RemoteViews makeBigContentView() {
            CharSequence charSequence = this.mBuilder.mContentText;
            Builder.access$1302(this.mBuilder, null);
            RemoteViews remoteViews = this.getStandardView(this.mBuilder.getBigTextLayoutResource());
            Builder.access$1302(this.mBuilder, charSequence);
            remoteViews.setTextViewText(16909176, this.mBuilder.processLegacyText(this.mBigText));
            remoteViews.setViewVisibility(16909176, 0);
            remoteViews.setInt(16909176, "setMaxLines", this.calculateMaxLines());
            remoteViews.setViewVisibility(16908309, 8);
            this.applyTopPadding(remoteViews);
            this.mBuilder.shrinkLine3Text(remoteViews);
            this.mBuilder.addProfileBadge(remoteViews, 16909177);
            return remoteViews;
        }

        @Override
        public void addExtras(Bundle bundle) {
            super.addExtras(bundle);
            bundle.putCharSequence(Notification.EXTRA_BIG_TEXT, this.mBigText);
        }

        public BigTextStyle bigText(CharSequence charSequence) {
            this.mBigText = Notification.safeCharSequence(charSequence);
            return this;
        }

        @Override
        public void populateBigContentView(Notification notification) {
            this.mBuilder.setBuilderBigContentView(notification, this.makeBigContentView());
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            super.restoreFromExtras(bundle);
            this.mBigText = bundle.getCharSequence(Notification.EXTRA_BIG_TEXT);
        }

        public BigTextStyle setBigContentTitle(CharSequence charSequence) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(charSequence));
            return this;
        }

        public BigTextStyle setSummaryText(CharSequence charSequence) {
            this.internalSetSummaryText(Notification.safeCharSequence(charSequence));
            return this;
        }
    }

    public static class Builder {
        public static final String EXTRA_NEEDS_REBUILD = "android.rebuild";
        public static final String EXTRA_REBUILD_BIG_CONTENT_VIEW = "android.rebuild.bigView";
        public static final String EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.bigViewActionCount";
        public static final String EXTRA_REBUILD_CONTENT_VIEW = "android.rebuild.contentView";
        public static final String EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.contentViewActionCount";
        private static final String EXTRA_REBUILD_CONTEXT_APPLICATION_INFO = "android.rebuild.applicationInfo";
        public static final String EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW = "android.rebuild.hudView";
        public static final String EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT = "android.rebuild.hudViewActionCount";
        public static final String EXTRA_REBUILD_LARGE_ICON = "android.rebuild.largeIcon";
        private static final float LARGE_TEXT_SCALE = 1.3f;
        private static final int MAX_ACTION_BUTTONS = 3;
        private static final boolean STRIP_AND_REBUILD = true;
        private ArrayList<Action> mActions = new ArrayList(3);
        private AudioAttributes mAudioAttributes;
        private int mAudioStreamType;
        private String mCategory;
        private int mColor = 0;
        private final NotificationColorUtil mColorUtil;
        private CharSequence mContentInfo;
        private PendingIntent mContentIntent;
        private CharSequence mContentText;
        private CharSequence mContentTitle;
        private RemoteViews mContentView;
        private Context mContext;
        private int mDefaults;
        private PendingIntent mDeleteIntent;
        private Bundle mExtras;
        private int mFlags;
        private PendingIntent mFullScreenIntent;
        private String mGroupKey;
        private boolean mHasThreeLines;
        private Bitmap mLargeIcon;
        private int mLedArgb;
        private int mLedOffMs;
        private int mLedOnMs;
        private int mNumber;
        private int mOriginatingUserId;
        private ArrayList<String> mPeople;
        private int mPriority;
        private int mProgress;
        private boolean mProgressIndeterminate;
        private int mProgressMax;
        private Notification mPublicVersion = null;
        private Bundle mRebuildBundle = new Bundle();
        private Notification mRebuildNotification = null;
        private boolean mShowWhen = true;
        private int mSmallIcon;
        private int mSmallIconLevel;
        private String mSortKey;
        private Uri mSound;
        private Style mStyle;
        private CharSequence mSubText;
        private CharSequence mTickerText;
        private RemoteViews mTickerView;
        private boolean mUseChronometer;
        private long[] mVibrate;
        private int mVisibility = 0;
        private long mWhen;

        public Builder(Context context) {
            this.mContext = context;
            this.mWhen = System.currentTimeMillis();
            this.mAudioStreamType = -1;
            this.mAudioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
            this.mPriority = 0;
            this.mPeople = new ArrayList();
            int n = context.getApplicationInfo().targetSdkVersion;
            NotificationColorUtil notificationColorUtil = null;
            if (n < 21) {
                notificationColorUtil = NotificationColorUtil.getInstance(this.mContext);
            }
            this.mColorUtil = notificationColorUtil;
        }

        /*
         * Loose catch block
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Lifted jumps to return sites
         */
        private Builder(Context context, Notification notification) {
            this(context);
            this.mRebuildNotification = notification;
            this.restoreFromNotification(notification);
            Bundle bundle = notification.extras;
            String string2 = bundle.getString(Notification.EXTRA_TEMPLATE);
            boolean bl = TextUtils.isEmpty(string2);
            Style style2 = null;
            if (!bl) {
                Class<? extends Style> clazz = Builder.getNotificationStyleClass(string2);
                if (clazz == null) {
                    Log.d(Notification.TAG, "Unknown style class: " + clazz);
                    return;
                }
                style2 = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                style2.restoreFromExtras(bundle);
            }
            if (style2 == null) return;
            this.setStyle(style2);
            return;
            catch (Throwable throwable) {
                Log.e(Notification.TAG, "Could not create Style", throwable);
                return;
            }
        }

        static /* synthetic */ CharSequence access$1302(Builder builder, CharSequence charSequence) {
            builder.mContentText = charSequence;
            return charSequence;
        }

        static /* synthetic */ int access$302(Builder builder, int n) {
            builder.mFlags = n;
            return n;
        }

        static /* synthetic */ CharSequence access$602(Builder builder, CharSequence charSequence) {
            builder.mContentTitle = charSequence;
            return charSequence;
        }

        private boolean addProfileBadge(RemoteViews remoteViews, int n) {
            Bitmap bitmap = this.getProfileBadge();
            remoteViews.setViewVisibility(16909177, 8);
            remoteViews.setViewVisibility(16909193, 8);
            remoteViews.setViewVisibility(16909196, 8);
            boolean bl = false;
            if (bitmap != null) {
                remoteViews.setImageViewBitmap(n, bitmap);
                remoteViews.setViewVisibility(n, 0);
                if (n == 16909196) {
                    remoteViews.setViewVisibility(16909194, 0);
                }
                bl = true;
            }
            return bl;
        }

        private void applyLargeIconBackground(RemoteViews remoteViews) {
            remoteViews.setInt(16908294, "setBackgroundResource", 17302995);
            remoteViews.setDrawableParameters(16908294, true, -1, this.resolveColor(), PorterDuff.Mode.SRC_ATOP, -1);
            int n = this.mContext.getResources().getDimensionPixelSize(17104985);
            remoteViews.setViewPadding(16908294, n, n, n, n);
        }

        private RemoteViews applyStandardTemplate(int n) {
            return this.applyStandardTemplate(n, true);
        }

        /*
         * Enabled aggressive block sorting
         */
        private RemoteViews applyStandardTemplate(int n, boolean bl) {
            boolean bl2;
            boolean bl3;
            BuilderRemoteViews builderRemoteViews = new BuilderRemoteViews(this.mContext.getApplicationInfo(), n);
            this.resetStandardTemplate(builderRemoteViews);
            if (this.mLargeIcon != null) {
                builderRemoteViews.setImageViewBitmap(16908294, this.mLargeIcon);
                this.processLargeLegacyIcon(this.mLargeIcon, builderRemoteViews);
                builderRemoteViews.setImageViewResource(16908340, this.mSmallIcon);
                builderRemoteViews.setViewVisibility(16908340, 0);
                this.processSmallRightIcon(this.mSmallIcon, builderRemoteViews);
            } else {
                builderRemoteViews.setImageViewResource(16908294, this.mSmallIcon);
                builderRemoteViews.setViewVisibility(16908294, 0);
                this.processSmallIconAsLarge(this.mSmallIcon, builderRemoteViews);
            }
            if (this.mContentTitle != null) {
                builderRemoteViews.setTextViewText(16908310, this.processLegacyText(this.mContentTitle));
            }
            CharSequence charSequence = this.mContentText;
            boolean bl4 = false;
            if (charSequence != null) {
                builderRemoteViews.setTextViewText(16908394, this.processLegacyText(this.mContentText));
                bl4 = true;
            }
            if (this.mContentInfo != null) {
                builderRemoteViews.setTextViewText(16909195, this.processLegacyText(this.mContentInfo));
                builderRemoteViews.setViewVisibility(16909195, 0);
                bl4 = true;
            } else if (this.mNumber > 0) {
                int n2 = this.mContext.getResources().getInteger(17694723);
                if (this.mNumber > n2) {
                    builderRemoteViews.setTextViewText(16909195, this.processLegacyText(this.mContext.getResources().getString(17039383)));
                } else {
                    builderRemoteViews.setTextViewText(16909195, this.processLegacyText(NumberFormat.getIntegerInstance().format(this.mNumber)));
                }
                builderRemoteViews.setViewVisibility(16909195, 0);
                bl4 = true;
            } else {
                builderRemoteViews.setViewVisibility(16909195, 8);
            }
            if (this.mSubText != null) {
                builderRemoteViews.setTextViewText(16908394, this.processLegacyText(this.mSubText));
                if (this.mContentText != null) {
                    builderRemoteViews.setTextViewText(16908309, this.processLegacyText(this.mContentText));
                    builderRemoteViews.setViewVisibility(16908309, 0);
                    bl3 = true;
                    bl2 = true;
                } else {
                    builderRemoteViews.setViewVisibility(16908309, 8);
                    bl2 = false;
                    bl3 = false;
                }
            } else {
                builderRemoteViews.setViewVisibility(16908309, 8);
                if (bl && (this.mProgressMax != 0 || this.mProgressIndeterminate)) {
                    builderRemoteViews.setViewVisibility(16908301, 0);
                    builderRemoteViews.setProgressBar(16908301, this.mProgressMax, this.mProgress, this.mProgressIndeterminate);
                    bl3 = true;
                    bl2 = false;
                } else {
                    builderRemoteViews.setViewVisibility(16908301, 8);
                    bl2 = false;
                    bl3 = false;
                }
            }
            if (bl3) {
                this.shrinkLine3Text(builderRemoteViews);
            }
            if (this.showsTimeOrChronometer()) {
                if (this.mUseChronometer) {
                    builderRemoteViews.setViewVisibility(16909191, 0);
                    builderRemoteViews.setLong(16909191, "setBase", this.mWhen + (SystemClock.elapsedRealtime() - System.currentTimeMillis()));
                    builderRemoteViews.setBoolean(16909191, "setStarted", true);
                } else {
                    builderRemoteViews.setViewVisibility(16908417, 0);
                    builderRemoteViews.setLong(16908417, "setTime", this.mWhen);
                }
            }
            builderRemoteViews.setViewPadding(16909192, 0, Builder.calculateTopPadding(this.mContext, this.mHasThreeLines, this.mContext.getResources().getConfiguration().fontScale), 0, 0);
            int n3 = bl2 ? 16909193 : 16909196;
            if (this.addProfileBadge(builderRemoteViews, n3) && !bl2) {
                bl4 = true;
            }
            int n4 = bl4 ? 0 : 8;
            builderRemoteViews.setViewVisibility(16909194, n4);
            int n5 = bl4 ? 0 : 8;
            builderRemoteViews.setViewVisibility(16909181, n5);
            return builderRemoteViews;
        }

        private RemoteViews applyStandardTemplateWithActions(int n) {
            RemoteViews remoteViews = this.applyStandardTemplate(n);
            this.resetStandardTemplateWithActions(remoteViews);
            int n2 = this.mActions.size();
            if (n2 > 0) {
                remoteViews.setViewVisibility(16909170, 0);
                remoteViews.setViewVisibility(16909178, 0);
                if (n2 > 3) {
                    n2 = 3;
                }
                for (int i = 0; i < n2; ++i) {
                    remoteViews.addView(16909170, this.generateActionButton(this.mActions.get(i)));
                }
            }
            return remoteViews;
        }

        /*
         * Enabled aggressive block sorting
         */
        public static int calculateTopPadding(Context context, boolean bl, float f) {
            Resources resources = context.getResources();
            int n = bl ? 17104982 : 0x1050055;
            int n2 = resources.getDimensionPixelSize(n);
            Resources resources2 = context.getResources();
            int n3 = bl ? 17104984 : 17104983;
            int n4 = resources2.getDimensionPixelSize(n3);
            float f2 = (MathUtils.constrain(f, 1.0f, 1.3f) - 1.0f) / 0.29999995f;
            return Math.round((1.0f - f2) * (float)n2 + f2 * (float)n4);
        }

        /*
         * Enabled aggressive block sorting
         */
        private RemoteViews generateActionButton(Action action) {
            boolean bl = action.actionIntent == null;
            String string2 = this.mContext.getPackageName();
            int n = bl ? this.getActionTombstoneLayoutResource() : this.getActionLayoutResource();
            RemoteViews remoteViews = new RemoteViews(string2, n);
            remoteViews.setTextViewCompoundDrawablesRelative(16909171, action.icon, 0, 0, 0);
            remoteViews.setTextViewText(16909171, this.processLegacyText(action.title));
            if (!bl) {
                remoteViews.setOnClickPendingIntent(16909171, action.actionIntent);
            }
            remoteViews.setContentDescription(16909171, action.title);
            this.processLegacyAction(action, remoteViews);
            return remoteViews;
        }

        private int getActionLayoutResource() {
            return 17367182;
        }

        private int getActionTombstoneLayoutResource() {
            return 0x1090090;
        }

        private int getBaseLayoutResource() {
            return 17367187;
        }

        private int getBigBaseLayoutResource() {
            return 17367188;
        }

        private int getBigPictureLayoutResource() {
            return 17367191;
        }

        private int getBigTextLayoutResource() {
            return 17367192;
        }

        private int getInboxLayoutResource() {
            return 0x1090099;
        }

        private static Class<? extends Style> getNotificationStyleClass(String string2) {
            for (Class clazz : new Class[]{BigTextStyle.class, BigPictureStyle.class, InboxStyle.class, MediaStyle.class}) {
                if (!string2.equals(clazz.getName())) continue;
                return clazz;
            }
            return null;
        }

        private Bitmap getProfileBadge() {
            Drawable drawable2 = this.getProfileBadgeDrawable();
            if (drawable2 == null) {
                return null;
            }
            int n = this.mContext.getResources().getDimensionPixelSize(17104986);
            Bitmap bitmap = Bitmap.createBitmap(n, n, Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bitmap);
            drawable2.setBounds(0, 0, n, n);
            drawable2.draw(canvas);
            return bitmap;
        }

        private Drawable getProfileBadgeDrawable() {
            return this.mContext.getPackageManager().getUserBadgeForDensity(new UserHandle(this.mOriginatingUserId), 0);
        }

        /*
         * Enabled aggressive block sorting
         */
        private boolean hasThreeLines() {
            boolean bl = this.mSubText != null && this.mContentText != null;
            boolean bl2 = this.mStyle == null || this.mStyle.hasProgress();
            boolean bl3 = this.getProfileBadgeDrawable() != null && !bl;
            boolean bl4 = this.mContentText != null || this.mContentInfo != null || this.mNumber > 0 || bl3;
            if (this.mSubText == null || this.mContentText == null) {
                if (!bl2) return false;
                if (this.mSubText != null) return false;
                if (this.mProgressMax == 0) {
                    if (!this.mProgressIndeterminate) return false;
                }
            }
            boolean bl5 = true;
            if (!bl5) return false;
            if (!bl4) return false;
            return true;
        }

        private boolean isLegacy() {
            return this.mColorUtil != null;
        }

        private RemoteViews makeBigContentView() {
            if (this.mActions.size() == 0) {
                return null;
            }
            return this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
        }

        private RemoteViews makeContentView() {
            if (this.mContentView != null) {
                return this.mContentView;
            }
            return this.applyStandardTemplate(this.getBaseLayoutResource());
        }

        private RemoteViews makeHeadsUpContentView() {
            if (this.mActions.size() == 0) {
                return null;
            }
            return this.applyStandardTemplateWithActions(this.getBigBaseLayoutResource());
        }

        private RemoteViews makeTickerView() {
            if (this.mTickerView != null) {
                return this.mTickerView;
            }
            return null;
        }

        private void processLargeLegacyIcon(Bitmap bitmap, RemoteViews remoteViews) {
            if (this.isLegacy() && this.mColorUtil.isGrayscaleIcon(bitmap)) {
                this.applyLargeIconBackground(remoteViews);
                return;
            }
            this.removeLargeIconBackground(remoteViews);
        }

        private void processLegacyAction(Action action, RemoteViews remoteViews) {
            if (!this.isLegacy() || this.mColorUtil.isGrayscaleIcon(this.mContext, action.icon)) {
                remoteViews.setTextViewCompoundDrawablesRelativeColorFilter(16909171, 0, this.mContext.getResources().getColor(17170512), PorterDuff.Mode.MULTIPLY);
            }
        }

        private CharSequence processLegacyText(CharSequence charSequence) {
            if (this.isLegacy()) {
                charSequence = this.mColorUtil.invertCharSequenceColors(charSequence);
            }
            return charSequence;
        }

        private void processSmallIconAsLarge(int n, RemoteViews remoteViews) {
            if (!this.isLegacy() || this.mColorUtil.isGrayscaleIcon(this.mContext, n)) {
                this.applyLargeIconBackground(remoteViews);
            }
        }

        private void processSmallRightIcon(int n, RemoteViews remoteViews) {
            if (!this.isLegacy() || this.mColorUtil.isGrayscaleIcon(this.mContext, n)) {
                remoteViews.setDrawableParameters(16908340, false, -1, -1, PorterDuff.Mode.SRC_ATOP, -1);
                remoteViews.setInt(16908340, "setBackgroundResource", 17302995);
                remoteViews.setDrawableParameters(16908340, true, -1, this.resolveColor(), PorterDuff.Mode.SRC_ATOP, -1);
            }
        }

        private Notification rebuild() {
            if (this.mRebuildNotification == null) {
                throw new IllegalStateException("rebuild() only valid when in 'rebuild' mode.");
            }
            this.mHasThreeLines = this.hasThreeLines();
            Bundle bundle = this.mRebuildNotification.extras;
            if (bundle.getBoolean(EXTRA_REBUILD_LARGE_ICON)) {
                this.mRebuildNotification.largeIcon = (Bitmap)bundle.getParcelable(Notification.EXTRA_LARGE_ICON);
            }
            bundle.remove(EXTRA_REBUILD_LARGE_ICON);
            if (bundle.getBoolean(EXTRA_REBUILD_CONTENT_VIEW)) {
                this.setBuilderContentView(this.mRebuildNotification, this.makeContentView());
                if (this.mStyle != null) {
                    this.mStyle.populateContentView(this.mRebuildNotification);
                }
            }
            bundle.remove(EXTRA_REBUILD_CONTENT_VIEW);
            if (bundle.getBoolean(EXTRA_REBUILD_BIG_CONTENT_VIEW)) {
                this.setBuilderBigContentView(this.mRebuildNotification, this.makeBigContentView());
                if (this.mStyle != null) {
                    this.mStyle.populateBigContentView(this.mRebuildNotification);
                }
            }
            bundle.remove(EXTRA_REBUILD_BIG_CONTENT_VIEW);
            if (bundle.getBoolean(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW)) {
                this.setBuilderHeadsUpContentView(this.mRebuildNotification, this.makeHeadsUpContentView());
                if (this.mStyle != null) {
                    this.mStyle.populateHeadsUpContentView(this.mRebuildNotification);
                }
            }
            bundle.remove(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW);
            this.mHasThreeLines = false;
            return this.mRebuildNotification;
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static Notification rebuild(Context context, Notification notification) {
            Context context2;
            Bundle bundle = notification.extras;
            if (!bundle.getBoolean(EXTRA_NEEDS_REBUILD)) {
                return notification;
            }
            bundle.remove(EXTRA_NEEDS_REBUILD);
            ApplicationInfo applicationInfo = (ApplicationInfo)bundle.getParcelable(EXTRA_REBUILD_CONTEXT_APPLICATION_INFO);
            try {
                Context context3;
                context2 = context3 = context.createApplicationContext(applicationInfo, 4);
                return new Builder(context2, notification).rebuild();
            }
            catch (PackageManager.NameNotFoundException nameNotFoundException) {
                Log.e(Notification.TAG, "ApplicationInfo " + applicationInfo + " not found");
                context2 = context;
                return new Builder(context2, notification).rebuild();
            }
        }

        private void removeLargeIconBackground(RemoteViews remoteViews) {
            remoteViews.setInt(16908294, "setBackgroundResource", 0);
        }

        private void resetStandardTemplate(RemoteViews remoteViews) {
            this.removeLargeIconBackground(remoteViews);
            remoteViews.setViewPadding(16908294, 0, 0, 0, 0);
            remoteViews.setImageViewResource(16908294, 0);
            remoteViews.setInt(16908294, "setBackgroundResource", 0);
            remoteViews.setViewVisibility(16908340, 8);
            remoteViews.setInt(16908340, "setBackgroundResource", 0);
            remoteViews.setImageViewResource(16908340, 0);
            remoteViews.setImageViewResource(16908294, 0);
            remoteViews.setTextViewText(16908310, null);
            remoteViews.setTextViewText(16908394, null);
            this.unshrinkLine3Text(remoteViews);
            remoteViews.setTextViewText(16908309, null);
            remoteViews.setViewVisibility(16908309, 8);
            remoteViews.setViewVisibility(16909195, 8);
            remoteViews.setViewVisibility(16908417, 8);
            remoteViews.setViewVisibility(16909194, 8);
            remoteViews.setViewVisibility(16909181, 8);
            remoteViews.setViewVisibility(16908301, 8);
            remoteViews.setViewVisibility(16909191, 8);
            remoteViews.setViewVisibility(16908417, 8);
        }

        private void resetStandardTemplateWithActions(RemoteViews remoteViews) {
            remoteViews.setViewVisibility(16909170, 8);
            remoteViews.setViewVisibility(16909178, 8);
            remoteViews.removeAllViews(16909170);
        }

        private int resolveColor() {
            if (this.mColor == 0) {
                return this.mContext.getResources().getColor(17170511);
            }
            return this.mColor;
        }

        private void restoreFromNotification(Notification notification) {
            this.mWhen = notification.when;
            this.mSmallIcon = notification.icon;
            this.mSmallIconLevel = notification.iconLevel;
            this.mNumber = notification.number;
            this.mColor = notification.color;
            this.mContentView = notification.contentView;
            this.mDeleteIntent = notification.deleteIntent;
            this.mFullScreenIntent = notification.fullScreenIntent;
            this.mTickerText = notification.tickerText;
            this.mTickerView = notification.tickerView;
            this.mLargeIcon = notification.largeIcon;
            this.mSound = notification.sound;
            this.mAudioStreamType = notification.audioStreamType;
            this.mAudioAttributes = notification.audioAttributes;
            this.mVibrate = notification.vibrate;
            this.mLedArgb = notification.ledARGB;
            this.mLedOnMs = notification.ledOnMS;
            this.mLedOffMs = notification.ledOffMS;
            this.mDefaults = notification.defaults;
            this.mFlags = notification.flags;
            this.mCategory = notification.category;
            this.mGroupKey = notification.mGroupKey;
            this.mSortKey = notification.mSortKey;
            this.mPriority = notification.priority;
            this.mActions.clear();
            if (notification.actions != null) {
                Collections.addAll(this.mActions, notification.actions);
            }
            this.mVisibility = notification.visibility;
            this.mPublicVersion = notification.publicVersion;
            Bundle bundle = notification.extras;
            this.mOriginatingUserId = bundle.getInt(Notification.EXTRA_ORIGINATING_USERID);
            this.mContentTitle = bundle.getCharSequence(Notification.EXTRA_TITLE);
            this.mContentText = bundle.getCharSequence(Notification.EXTRA_TEXT);
            this.mSubText = bundle.getCharSequence(Notification.EXTRA_SUB_TEXT);
            this.mContentInfo = bundle.getCharSequence(Notification.EXTRA_INFO_TEXT);
            this.mSmallIcon = bundle.getInt(Notification.EXTRA_SMALL_ICON);
            this.mProgress = bundle.getInt(Notification.EXTRA_PROGRESS);
            this.mProgressMax = bundle.getInt(Notification.EXTRA_PROGRESS_MAX);
            this.mProgressIndeterminate = bundle.getBoolean(Notification.EXTRA_PROGRESS_INDETERMINATE);
            this.mUseChronometer = bundle.getBoolean(Notification.EXTRA_SHOW_CHRONOMETER);
            this.mShowWhen = bundle.getBoolean(Notification.EXTRA_SHOW_WHEN);
            if (bundle.containsKey(Notification.EXTRA_LARGE_ICON)) {
                this.mLargeIcon = (Bitmap)bundle.getParcelable(Notification.EXTRA_LARGE_ICON);
            }
            if (bundle.containsKey(Notification.EXTRA_PEOPLE)) {
                this.mPeople.clear();
                Collections.addAll(this.mPeople, bundle.getStringArray(Notification.EXTRA_PEOPLE));
            }
        }

        private int sanitizeColor() {
            if (this.mColor != 0) {
                this.mColor = 0xFF000000 | this.mColor;
            }
            return this.mColor;
        }

        private void setBuilderBigContentView(Notification notification, RemoteViews remoteViews) {
            notification.bigContentView = remoteViews;
            if (remoteViews instanceof BuilderRemoteViews) {
                this.mRebuildBundle.putInt(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT, remoteViews.getSequenceNumber());
            }
        }

        private void setBuilderContentView(Notification notification, RemoteViews remoteViews) {
            notification.contentView = remoteViews;
            if (remoteViews instanceof BuilderRemoteViews) {
                this.mRebuildBundle.putInt(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT, remoteViews.getSequenceNumber());
            }
        }

        private void setBuilderHeadsUpContentView(Notification notification, RemoteViews remoteViews) {
            notification.headsUpContentView = remoteViews;
            if (remoteViews instanceof BuilderRemoteViews) {
                this.mRebuildBundle.putInt(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT, remoteViews.getSequenceNumber());
            }
        }

        private void setFlag(int n, boolean bl) {
            if (bl) {
                this.mFlags = n | this.mFlags;
                return;
            }
            this.mFlags &= ~n;
        }

        private boolean showsTimeOrChronometer() {
            return this.mWhen != 0L && this.mShowWhen;
        }

        private void shrinkLine3Text(RemoteViews remoteViews) {
            remoteViews.setTextViewTextSize(16908394, 0, this.mContext.getResources().getDimensionPixelSize(17104980));
        }

        /*
         * Enabled aggressive block sorting
         */
        public static void stripForDelivery(Notification notification) {
            String string2 = notification.extras.getString(Notification.EXTRA_TEMPLATE);
            boolean bl = TextUtils.isEmpty(string2) || Builder.getNotificationStyleClass(string2) != null;
            Bitmap bitmap = notification.largeIcon;
            boolean bl2 = false;
            if (bitmap != null) {
                boolean bl3 = notification.extras.containsKey(Notification.EXTRA_LARGE_ICON);
                bl2 = false;
                if (bl3) {
                    notification.largeIcon = null;
                    notification.extras.putBoolean(EXTRA_REBUILD_LARGE_ICON, true);
                    bl2 = true;
                }
            }
            if (bl && notification.contentView instanceof BuilderRemoteViews && notification.extras.getInt(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT, -1) == notification.contentView.getSequenceNumber()) {
                notification.contentView = null;
                notification.extras.putBoolean(EXTRA_REBUILD_CONTENT_VIEW, true);
                notification.extras.remove(EXTRA_REBUILD_CONTENT_VIEW_ACTION_COUNT);
                bl2 = true;
            }
            if (bl && notification.bigContentView instanceof BuilderRemoteViews && notification.extras.getInt(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT, -1) == notification.bigContentView.getSequenceNumber()) {
                notification.bigContentView = null;
                notification.extras.putBoolean(EXTRA_REBUILD_BIG_CONTENT_VIEW, true);
                notification.extras.remove(EXTRA_REBUILD_BIG_CONTENT_VIEW_ACTION_COUNT);
                bl2 = true;
            }
            if (bl && notification.headsUpContentView instanceof BuilderRemoteViews && notification.extras.getInt(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT, -1) == notification.headsUpContentView.getSequenceNumber()) {
                notification.headsUpContentView = null;
                notification.extras.putBoolean(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW, true);
                notification.extras.remove(EXTRA_REBUILD_HEADS_UP_CONTENT_VIEW_ACTION_COUNT);
                bl2 = true;
            }
            if (bl2) {
                notification.extras.putBoolean(EXTRA_NEEDS_REBUILD, true);
            }
        }

        private void unshrinkLine3Text(RemoteViews remoteViews) {
            remoteViews.setTextViewTextSize(16908394, 0, this.mContext.getResources().getDimensionPixelSize(17104978));
        }

        public Builder addAction(int n, CharSequence charSequence, PendingIntent pendingIntent) {
            this.mActions.add(new Action(n, Notification.safeCharSequence(charSequence), pendingIntent));
            return this;
        }

        public Builder addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        public Builder addExtras(Bundle bundle) {
            block3: {
                block2: {
                    if (bundle == null) break block2;
                    if (this.mExtras != null) break block3;
                    this.mExtras = new Bundle(bundle);
                }
                return this;
            }
            this.mExtras.putAll(bundle);
            return this;
        }

        public Builder addPerson(String string2) {
            this.mPeople.add(string2);
            return this;
        }

        public Notification build() {
            this.mOriginatingUserId = this.mContext.getUserId();
            this.mHasThreeLines = this.hasThreeLines();
            Notification notification = this.buildUnstyled();
            if (this.mStyle != null) {
                notification = this.mStyle.buildStyled(notification);
            }
            if (this.mExtras != null) {
                notification.extras.putAll(this.mExtras);
            }
            if (this.mRebuildBundle.size() > 0) {
                notification.extras.putAll(this.mRebuildBundle);
                this.mRebuildBundle.clear();
            }
            this.populateExtras(notification.extras);
            if (this.mStyle != null) {
                this.mStyle.addExtras(notification.extras);
            }
            this.mHasThreeLines = false;
            return notification;
        }

        public Notification buildInto(Notification notification) {
            this.build().cloneInto(notification, true);
            return notification;
        }

        public Notification buildUnstyled() {
            Notification notification = new Notification();
            notification.when = this.mWhen;
            notification.icon = this.mSmallIcon;
            notification.iconLevel = this.mSmallIconLevel;
            notification.number = this.mNumber;
            notification.color = this.sanitizeColor();
            this.setBuilderContentView(notification, this.makeContentView());
            notification.contentIntent = this.mContentIntent;
            notification.deleteIntent = this.mDeleteIntent;
            notification.fullScreenIntent = this.mFullScreenIntent;
            notification.tickerText = this.mTickerText;
            notification.tickerView = this.makeTickerView();
            notification.largeIcon = this.mLargeIcon;
            notification.sound = this.mSound;
            notification.audioStreamType = this.mAudioStreamType;
            notification.audioAttributes = this.mAudioAttributes;
            notification.vibrate = this.mVibrate;
            notification.ledARGB = this.mLedArgb;
            notification.ledOnMS = this.mLedOnMs;
            notification.ledOffMS = this.mLedOffMs;
            notification.defaults = this.mDefaults;
            notification.flags = this.mFlags;
            this.setBuilderBigContentView(notification, this.makeBigContentView());
            this.setBuilderHeadsUpContentView(notification, this.makeHeadsUpContentView());
            if (this.mLedOnMs != 0 || this.mLedOffMs != 0) {
                notification.flags = 1 | notification.flags;
            }
            if ((4 & this.mDefaults) != 0) {
                notification.flags = 1 | notification.flags;
            }
            notification.category = this.mCategory;
            Notification.access$402(notification, this.mGroupKey);
            Notification.access$502(notification, this.mSortKey);
            notification.priority = this.mPriority;
            if (this.mActions.size() > 0) {
                notification.actions = new Action[this.mActions.size()];
                this.mActions.toArray(notification.actions);
            }
            notification.visibility = this.mVisibility;
            if (this.mPublicVersion != null) {
                notification.publicVersion = new Notification();
                this.mPublicVersion.cloneInto(notification.publicVersion, true);
            }
            return notification;
        }

        public Builder extend(Extender extender) {
            extender.extend(this);
            return this;
        }

        public Bundle getExtras() {
            if (this.mExtras == null) {
                this.mExtras = new Bundle();
            }
            return this.mExtras;
        }

        @Deprecated
        public Notification getNotification() {
            return this.build();
        }

        public void populateExtras(Bundle bundle) {
            bundle.putInt(Notification.EXTRA_ORIGINATING_USERID, this.mOriginatingUserId);
            bundle.putParcelable(EXTRA_REBUILD_CONTEXT_APPLICATION_INFO, this.mContext.getApplicationInfo());
            bundle.putCharSequence(Notification.EXTRA_TITLE, this.mContentTitle);
            bundle.putCharSequence(Notification.EXTRA_TEXT, this.mContentText);
            bundle.putCharSequence(Notification.EXTRA_SUB_TEXT, this.mSubText);
            bundle.putCharSequence(Notification.EXTRA_INFO_TEXT, this.mContentInfo);
            bundle.putInt(Notification.EXTRA_SMALL_ICON, this.mSmallIcon);
            bundle.putInt(Notification.EXTRA_PROGRESS, this.mProgress);
            bundle.putInt(Notification.EXTRA_PROGRESS_MAX, this.mProgressMax);
            bundle.putBoolean(Notification.EXTRA_PROGRESS_INDETERMINATE, this.mProgressIndeterminate);
            bundle.putBoolean(Notification.EXTRA_SHOW_CHRONOMETER, this.mUseChronometer);
            bundle.putBoolean(Notification.EXTRA_SHOW_WHEN, this.mShowWhen);
            if (this.mLargeIcon != null) {
                bundle.putParcelable(Notification.EXTRA_LARGE_ICON, this.mLargeIcon);
            }
            if (!this.mPeople.isEmpty()) {
                bundle.putStringArray(Notification.EXTRA_PEOPLE, this.mPeople.toArray(new String[this.mPeople.size()]));
            }
        }

        public Builder setAutoCancel(boolean bl) {
            this.setFlag(16, bl);
            return this;
        }

        public Builder setCategory(String string2) {
            this.mCategory = string2;
            return this;
        }

        public Builder setColor(int n) {
            this.mColor = n;
            return this;
        }

        public Builder setContent(RemoteViews remoteViews) {
            this.mContentView = remoteViews;
            return this;
        }

        public Builder setContentInfo(CharSequence charSequence) {
            this.mContentInfo = Notification.safeCharSequence(charSequence);
            return this;
        }

        public Builder setContentIntent(PendingIntent pendingIntent) {
            this.mContentIntent = pendingIntent;
            return this;
        }

        public Builder setContentText(CharSequence charSequence) {
            this.mContentText = Notification.safeCharSequence(charSequence);
            return this;
        }

        public Builder setContentTitle(CharSequence charSequence) {
            this.mContentTitle = Notification.safeCharSequence(charSequence);
            return this;
        }

        public Builder setDefaults(int n) {
            this.mDefaults = n;
            return this;
        }

        public Builder setDeleteIntent(PendingIntent pendingIntent) {
            this.mDeleteIntent = pendingIntent;
            return this;
        }

        public Builder setExtras(Bundle bundle) {
            this.mExtras = bundle;
            return this;
        }

        public Builder setFullScreenIntent(PendingIntent pendingIntent, boolean bl) {
            this.mFullScreenIntent = pendingIntent;
            this.setFlag(128, bl);
            return this;
        }

        public Builder setGroup(String string2) {
            this.mGroupKey = string2;
            return this;
        }

        public Builder setGroupSummary(boolean bl) {
            this.setFlag(512, bl);
            return this;
        }

        public Builder setLargeIcon(Bitmap bitmap) {
            this.mLargeIcon = bitmap;
            return this;
        }

        public Builder setLights(int n, int n2, int n3) {
            this.mLedArgb = n;
            this.mLedOnMs = n2;
            this.mLedOffMs = n3;
            return this;
        }

        public Builder setLocalOnly(boolean bl) {
            this.setFlag(256, bl);
            return this;
        }

        public Builder setNumber(int n) {
            this.mNumber = n;
            return this;
        }

        public Builder setOngoing(boolean bl) {
            this.setFlag(2, bl);
            return this;
        }

        public Builder setOnlyAlertOnce(boolean bl) {
            this.setFlag(8, bl);
            return this;
        }

        public Builder setPriority(int n) {
            this.mPriority = n;
            return this;
        }

        public Builder setProgress(int n, int n2, boolean bl) {
            this.mProgressMax = n;
            this.mProgress = n2;
            this.mProgressIndeterminate = bl;
            return this;
        }

        public Builder setPublicVersion(Notification notification) {
            this.mPublicVersion = notification;
            return this;
        }

        public Builder setShowWhen(boolean bl) {
            this.mShowWhen = bl;
            return this;
        }

        public Builder setSmallIcon(int n) {
            this.mSmallIcon = n;
            return this;
        }

        public Builder setSmallIcon(int n, int n2) {
            this.mSmallIcon = n;
            this.mSmallIconLevel = n2;
            return this;
        }

        public Builder setSortKey(String string2) {
            this.mSortKey = string2;
            return this;
        }

        public Builder setSound(Uri uri) {
            this.mSound = uri;
            this.mAudioAttributes = AUDIO_ATTRIBUTES_DEFAULT;
            return this;
        }

        @Deprecated
        public Builder setSound(Uri uri, int n) {
            this.mSound = uri;
            this.mAudioStreamType = n;
            return this;
        }

        public Builder setSound(Uri uri, AudioAttributes audioAttributes) {
            this.mSound = uri;
            this.mAudioAttributes = audioAttributes;
            return this;
        }

        public Builder setStyle(Style style2) {
            if (this.mStyle != style2) {
                this.mStyle = style2;
                if (this.mStyle != null) {
                    this.mStyle.setBuilder(this);
                }
            }
            return this;
        }

        public Builder setSubText(CharSequence charSequence) {
            this.mSubText = Notification.safeCharSequence(charSequence);
            return this;
        }

        public Builder setTicker(CharSequence charSequence) {
            this.mTickerText = Notification.safeCharSequence(charSequence);
            return this;
        }

        @Deprecated
        public Builder setTicker(CharSequence charSequence, RemoteViews remoteViews) {
            this.mTickerText = Notification.safeCharSequence(charSequence);
            this.mTickerView = remoteViews;
            return this;
        }

        public Builder setUsesChronometer(boolean bl) {
            this.mUseChronometer = bl;
            return this;
        }

        public Builder setVibrate(long[] lArray) {
            this.mVibrate = lArray;
            return this;
        }

        public Builder setVisibility(int n) {
            this.mVisibility = n;
            return this;
        }

        public Builder setWhen(long l) {
            this.mWhen = l;
            return this;
        }
    }

    private static class BuilderRemoteViews
    extends RemoteViews {
        public BuilderRemoteViews(ApplicationInfo applicationInfo, int n) {
            super(applicationInfo, n);
        }

        public BuilderRemoteViews(Parcel parcel) {
            super(parcel);
        }

        @Override
        public BuilderRemoteViews clone() {
            Parcel parcel = Parcel.obtain();
            this.writeToParcel(parcel, 0);
            parcel.setDataPosition(0);
            BuilderRemoteViews builderRemoteViews = new BuilderRemoteViews(parcel);
            parcel.recycle();
            return builderRemoteViews;
        }
    }

    public static interface Extender {
        public Builder extend(Builder var1);
    }

    public static class InboxStyle
    extends Style {
        private ArrayList<CharSequence> mTexts = new ArrayList(5);

        public InboxStyle() {
        }

        public InboxStyle(Builder builder) {
            this.setBuilder(builder);
        }

        /*
         * Enabled aggressive block sorting
         */
        private RemoteViews makeBigContentView() {
            CharSequence charSequence = this.mBuilder.mContentText;
            Builder.access$1302(this.mBuilder, null);
            RemoteViews remoteViews = this.getStandardView(this.mBuilder.getInboxLayoutResource());
            Builder.access$1302(this.mBuilder, charSequence);
            remoteViews.setViewVisibility(16908309, 8);
            int[] nArray = new int[]{16909182, 16909183, 16909184, 16909185, 16909186, 16909187, 16909188};
            int n = nArray.length;
            for (int i = 0; i < n; ++i) {
                remoteViews.setViewVisibility(nArray[i], 8);
            }
            boolean bl = ((Builder)this.mBuilder).mContext.getResources().getConfiguration().fontScale > 1.0f;
            float f = this.mBuilder.mContext.getResources().getDimensionPixelSize(17104980);
            for (int i = 0; i < this.mTexts.size() && i < nArray.length; ++i) {
                CharSequence charSequence2 = this.mTexts.get(i);
                if (charSequence2 == null || charSequence2.equals("")) continue;
                remoteViews.setViewVisibility(nArray[i], 0);
                remoteViews.setTextViewText(nArray[i], this.mBuilder.processLegacyText(charSequence2));
                if (!bl) continue;
                remoteViews.setTextViewTextSize(nArray[i], 0, f);
            }
            int n2 = this.mTexts.size() > 0 ? 0 : 8;
            remoteViews.setViewVisibility(16909190, n2);
            int n3 = this.mTexts.size() > nArray.length ? 0 : 8;
            remoteViews.setViewVisibility(16909189, n3);
            this.applyTopPadding(remoteViews);
            this.mBuilder.shrinkLine3Text(remoteViews);
            this.mBuilder.addProfileBadge(remoteViews, 16909177);
            return remoteViews;
        }

        @Override
        public void addExtras(Bundle bundle) {
            super.addExtras(bundle);
            CharSequence[] charSequenceArray = new CharSequence[this.mTexts.size()];
            bundle.putCharSequenceArray(Notification.EXTRA_TEXT_LINES, this.mTexts.toArray(charSequenceArray));
        }

        public InboxStyle addLine(CharSequence charSequence) {
            this.mTexts.add(Notification.safeCharSequence(charSequence));
            return this;
        }

        @Override
        public void populateBigContentView(Notification notification) {
            this.mBuilder.setBuilderBigContentView(notification, this.makeBigContentView());
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            super.restoreFromExtras(bundle);
            this.mTexts.clear();
            if (bundle.containsKey(Notification.EXTRA_TEXT_LINES)) {
                Collections.addAll(this.mTexts, bundle.getCharSequenceArray(Notification.EXTRA_TEXT_LINES));
            }
        }

        public InboxStyle setBigContentTitle(CharSequence charSequence) {
            this.internalSetBigContentTitle(Notification.safeCharSequence(charSequence));
            return this;
        }

        public InboxStyle setSummaryText(CharSequence charSequence) {
            this.internalSetSummaryText(Notification.safeCharSequence(charSequence));
            return this;
        }
    }

    public static class MediaStyle
    extends Style {
        static final int MAX_MEDIA_BUTTONS = 5;
        static final int MAX_MEDIA_BUTTONS_IN_COMPACT = 3;
        private int[] mActionsToShowInCompact = null;
        private MediaSession.Token mToken;

        public MediaStyle() {
        }

        public MediaStyle(Builder builder) {
            this.setBuilder(builder);
        }

        /*
         * Enabled aggressive block sorting
         */
        private RemoteViews generateMediaActionButton(Action action) {
            boolean bl = action.actionIntent == null;
            RemoteViews remoteViews = new RemoteViews(this.mBuilder.mContext.getPackageName(), 0x1090091);
            remoteViews.setImageViewResource(16909171, action.icon);
            remoteViews.setDrawableParameters(16909171, false, -1, -1, PorterDuff.Mode.SRC_ATOP, -1);
            if (!bl) {
                remoteViews.setOnClickPendingIntent(16909171, action.actionIntent);
            }
            remoteViews.setContentDescription(16909171, action.title);
            return remoteViews;
        }

        private int getBigLayoutResource(int n) {
            if (n <= 3) {
                return 17367190;
            }
            return 17367189;
        }

        private void hideRightIcon(RemoteViews remoteViews) {
            remoteViews.setViewVisibility(16908340, 8);
        }

        private RemoteViews makeMediaBigContentView() {
            int n = Math.min(this.mBuilder.mActions.size(), 5);
            RemoteViews remoteViews = this.mBuilder.applyStandardTemplate(this.getBigLayoutResource(n), false);
            if (n > 0) {
                remoteViews.removeAllViews(16909179);
                for (int i = 0; i < n; ++i) {
                    remoteViews.addView(16909179, this.generateMediaActionButton((Action)this.mBuilder.mActions.get(i)));
                }
            }
            this.styleText(remoteViews);
            this.hideRightIcon(remoteViews);
            this.applyTopPadding(remoteViews);
            remoteViews.setViewVisibility(16908301, 8);
            return remoteViews;
        }

        /*
         * Enabled aggressive block sorting
         */
        private RemoteViews makeMediaContentView() {
            RemoteViews remoteViews = this.mBuilder.applyStandardTemplate(17367194, false);
            int n = this.mBuilder.mActions.size();
            int n2 = this.mActionsToShowInCompact == null ? 0 : Math.min(this.mActionsToShowInCompact.length, 3);
            if (n2 > 0) {
                remoteViews.removeAllViews(16909179);
                for (int i = 0; i < n2; ++i) {
                    if (i >= n) {
                        Object[] objectArray = new Object[]{i, n - 1};
                        throw new IllegalArgumentException(String.format("setShowActionsInCompactView: action %d out of bounds (max %d)", objectArray));
                    }
                    remoteViews.addView(16909179, this.generateMediaActionButton((Action)this.mBuilder.mActions.get(this.mActionsToShowInCompact[i])));
                }
            }
            this.styleText(remoteViews);
            this.hideRightIcon(remoteViews);
            return remoteViews;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void styleText(RemoteViews remoteViews) {
            int n = this.mBuilder.mContext.getResources().getColor(17170513);
            int n2 = this.mBuilder.mContext.getResources().getColor(17170514);
            remoteViews.setTextColor(16908310, n);
            if (this.mBuilder.showsTimeOrChronometer()) {
                if (this.mBuilder.mUseChronometer) {
                    remoteViews.setTextColor(16909191, n2);
                } else {
                    remoteViews.setTextColor(16908417, n2);
                }
            }
            remoteViews.setTextColor(16908309, n2);
            remoteViews.setTextColor(16908394, n2);
            remoteViews.setTextColor(16909195, n2);
        }

        @Override
        public void addExtras(Bundle bundle) {
            super.addExtras(bundle);
            if (this.mToken != null) {
                bundle.putParcelable(Notification.EXTRA_MEDIA_SESSION, this.mToken);
            }
            if (this.mActionsToShowInCompact != null) {
                bundle.putIntArray(Notification.EXTRA_COMPACT_ACTIONS, this.mActionsToShowInCompact);
            }
        }

        @Override
        public Notification buildStyled(Notification notification) {
            super.buildStyled(notification);
            if (notification.category == null) {
                notification.category = Notification.CATEGORY_TRANSPORT;
            }
            return notification;
        }

        @Override
        protected boolean hasProgress() {
            return false;
        }

        @Override
        public void populateBigContentView(Notification notification) {
            this.mBuilder.setBuilderBigContentView(notification, this.makeMediaBigContentView());
        }

        @Override
        public void populateContentView(Notification notification) {
            this.mBuilder.setBuilderContentView(notification, this.makeMediaContentView());
        }

        @Override
        protected void restoreFromExtras(Bundle bundle) {
            super.restoreFromExtras(bundle);
            if (bundle.containsKey(Notification.EXTRA_MEDIA_SESSION)) {
                this.mToken = (MediaSession.Token)bundle.getParcelable(Notification.EXTRA_MEDIA_SESSION);
            }
            if (bundle.containsKey(Notification.EXTRA_COMPACT_ACTIONS)) {
                this.mActionsToShowInCompact = bundle.getIntArray(Notification.EXTRA_COMPACT_ACTIONS);
            }
        }

        public MediaStyle setMediaSession(MediaSession.Token token) {
            this.mToken = token;
            return this;
        }

        public MediaStyle setShowActionsInCompactView(int ... nArray) {
            this.mActionsToShowInCompact = nArray;
            return this;
        }
    }

    public static abstract class Style {
        private CharSequence mBigContentTitle;
        protected Builder mBuilder;
        protected CharSequence mSummaryText = null;
        protected boolean mSummaryTextSet = false;

        public void addExtras(Bundle bundle) {
            if (this.mSummaryTextSet) {
                bundle.putCharSequence(Notification.EXTRA_SUMMARY_TEXT, this.mSummaryText);
            }
            if (this.mBigContentTitle != null) {
                bundle.putCharSequence(Notification.EXTRA_TITLE_BIG, this.mBigContentTitle);
            }
            bundle.putString(Notification.EXTRA_TEMPLATE, this.getClass().getName());
        }

        protected void applyTopPadding(RemoteViews remoteViews) {
            remoteViews.setViewPadding(16909192, 0, Builder.calculateTopPadding(this.mBuilder.mContext, this.mBuilder.mHasThreeLines, ((Builder)this.mBuilder).mContext.getResources().getConfiguration().fontScale), 0, 0);
        }

        public Notification build() {
            this.checkBuilder();
            return this.mBuilder.build();
        }

        public Notification buildStyled(Notification notification) {
            this.populateTickerView(notification);
            this.populateContentView(notification);
            this.populateBigContentView(notification);
            this.populateHeadsUpContentView(notification);
            return notification;
        }

        protected void checkBuilder() {
            if (this.mBuilder == null) {
                throw new IllegalArgumentException("Style requires a valid Builder object");
            }
        }

        /*
         * Enabled aggressive block sorting
         */
        protected RemoteViews getStandardView(int n) {
            this.checkBuilder();
            CharSequence charSequence = this.mBuilder.mContentTitle;
            if (this.mBigContentTitle != null) {
                this.mBuilder.setContentTitle(this.mBigContentTitle);
            }
            RemoteViews remoteViews = this.mBuilder.applyStandardTemplateWithActions(n);
            Builder.access$602(this.mBuilder, charSequence);
            if (this.mBigContentTitle != null && this.mBigContentTitle.equals("")) {
                remoteViews.setViewVisibility(16909192, 8);
            } else {
                remoteViews.setViewVisibility(16909192, 0);
            }
            CharSequence charSequence2 = this.mSummaryTextSet ? this.mSummaryText : this.mBuilder.mSubText;
            if (charSequence2 != null) {
                remoteViews.setTextViewText(16908394, this.mBuilder.processLegacyText(charSequence2));
                remoteViews.setViewVisibility(16909181, 0);
                remoteViews.setViewVisibility(16909194, 0);
                return remoteViews;
            }
            remoteViews.setTextViewText(16908394, "");
            remoteViews.setViewVisibility(16909181, 8);
            remoteViews.setViewVisibility(16909194, 8);
            return remoteViews;
        }

        protected boolean hasProgress() {
            return true;
        }

        protected void internalSetBigContentTitle(CharSequence charSequence) {
            this.mBigContentTitle = charSequence;
        }

        protected void internalSetSummaryText(CharSequence charSequence) {
            this.mSummaryText = charSequence;
            this.mSummaryTextSet = true;
        }

        protected void populateBigContentView(Notification notification) {
        }

        protected void populateContentView(Notification notification) {
        }

        protected void populateHeadsUpContentView(Notification notification) {
        }

        protected void populateTickerView(Notification notification) {
        }

        protected void restoreFromExtras(Bundle bundle) {
            if (bundle.containsKey(Notification.EXTRA_SUMMARY_TEXT)) {
                this.mSummaryText = bundle.getCharSequence(Notification.EXTRA_SUMMARY_TEXT);
                this.mSummaryTextSet = true;
            }
            if (bundle.containsKey(Notification.EXTRA_TITLE_BIG)) {
                this.mBigContentTitle = bundle.getCharSequence(Notification.EXTRA_TITLE_BIG);
            }
        }

        public void setBuilder(Builder builder) {
            if (this.mBuilder != builder) {
                this.mBuilder = builder;
                if (this.mBuilder != null) {
                    this.mBuilder.setStyle(this);
                }
            }
        }
    }

    public static final class WearableExtender
    implements Extender {
        private static final int DEFAULT_CONTENT_ICON_GRAVITY = 0x800005;
        private static final int DEFAULT_FLAGS = 1;
        private static final int DEFAULT_GRAVITY = 80;
        private static final String EXTRA_WEARABLE_EXTENSIONS = "android.wearable.EXTENSIONS";
        private static final int FLAG_CONTENT_INTENT_AVAILABLE_OFFLINE = 1;
        private static final int FLAG_HINT_HIDE_ICON = 2;
        private static final int FLAG_HINT_SHOW_BACKGROUND_ONLY = 4;
        private static final int FLAG_START_SCROLL_BOTTOM = 8;
        private static final String KEY_ACTIONS = "actions";
        private static final String KEY_BACKGROUND = "background";
        private static final String KEY_CONTENT_ACTION_INDEX = "contentActionIndex";
        private static final String KEY_CONTENT_ICON = "contentIcon";
        private static final String KEY_CONTENT_ICON_GRAVITY = "contentIconGravity";
        private static final String KEY_CUSTOM_CONTENT_HEIGHT = "customContentHeight";
        private static final String KEY_CUSTOM_SIZE_PRESET = "customSizePreset";
        private static final String KEY_DISPLAY_INTENT = "displayIntent";
        private static final String KEY_FLAGS = "flags";
        private static final String KEY_GRAVITY = "gravity";
        private static final String KEY_PAGES = "pages";
        public static final int SIZE_DEFAULT = 0;
        public static final int SIZE_FULL_SCREEN = 5;
        public static final int SIZE_LARGE = 4;
        public static final int SIZE_MEDIUM = 3;
        public static final int SIZE_SMALL = 2;
        public static final int SIZE_XSMALL = 1;
        public static final int UNSET_ACTION_INDEX = -1;
        private ArrayList<Action> mActions = new ArrayList();
        private Bitmap mBackground;
        private int mContentActionIndex = -1;
        private int mContentIcon;
        private int mContentIconGravity = 0x800005;
        private int mCustomContentHeight;
        private int mCustomSizePreset = 0;
        private PendingIntent mDisplayIntent;
        private int mFlags = 1;
        private int mGravity = 80;
        private ArrayList<Notification> mPages = new ArrayList();

        public WearableExtender() {
        }

        public WearableExtender(Notification notification) {
            Bundle bundle = notification.extras.getBundle(EXTRA_WEARABLE_EXTENSIONS);
            if (bundle != null) {
                ArrayList arrayList = bundle.getParcelableArrayList(KEY_ACTIONS);
                if (arrayList != null) {
                    this.mActions.addAll(arrayList);
                }
                this.mFlags = bundle.getInt(KEY_FLAGS, 1);
                this.mDisplayIntent = (PendingIntent)bundle.getParcelable(KEY_DISPLAY_INTENT);
                Notification[] notificationArray = Notification.getNotificationArrayFromBundle(bundle, KEY_PAGES);
                if (notificationArray != null) {
                    Collections.addAll(this.mPages, notificationArray);
                }
                this.mBackground = (Bitmap)bundle.getParcelable(KEY_BACKGROUND);
                this.mContentIcon = bundle.getInt(KEY_CONTENT_ICON);
                this.mContentIconGravity = bundle.getInt(KEY_CONTENT_ICON_GRAVITY, 0x800005);
                this.mContentActionIndex = bundle.getInt(KEY_CONTENT_ACTION_INDEX, -1);
                this.mCustomSizePreset = bundle.getInt(KEY_CUSTOM_SIZE_PRESET, 0);
                this.mCustomContentHeight = bundle.getInt(KEY_CUSTOM_CONTENT_HEIGHT);
                this.mGravity = bundle.getInt(KEY_GRAVITY, 80);
            }
        }

        private void setFlag(int n, boolean bl) {
            if (bl) {
                this.mFlags = n | this.mFlags;
                return;
            }
            this.mFlags &= ~n;
        }

        public WearableExtender addAction(Action action) {
            this.mActions.add(action);
            return this;
        }

        public WearableExtender addActions(List<Action> list) {
            this.mActions.addAll(list);
            return this;
        }

        public WearableExtender addPage(Notification notification) {
            this.mPages.add(notification);
            return this;
        }

        public WearableExtender addPages(List<Notification> list) {
            this.mPages.addAll(list);
            return this;
        }

        public WearableExtender clearActions() {
            this.mActions.clear();
            return this;
        }

        public WearableExtender clearPages() {
            this.mPages.clear();
            return this;
        }

        public WearableExtender clone() {
            WearableExtender wearableExtender = new WearableExtender();
            wearableExtender.mActions = new ArrayList<Action>(this.mActions);
            wearableExtender.mFlags = this.mFlags;
            wearableExtender.mDisplayIntent = this.mDisplayIntent;
            wearableExtender.mPages = new ArrayList<Notification>(this.mPages);
            wearableExtender.mBackground = this.mBackground;
            wearableExtender.mContentIcon = this.mContentIcon;
            wearableExtender.mContentIconGravity = this.mContentIconGravity;
            wearableExtender.mContentActionIndex = this.mContentActionIndex;
            wearableExtender.mCustomSizePreset = this.mCustomSizePreset;
            wearableExtender.mCustomContentHeight = this.mCustomContentHeight;
            wearableExtender.mGravity = this.mGravity;
            return wearableExtender;
        }

        @Override
        public Builder extend(Builder builder) {
            Bundle bundle = new Bundle();
            if (!this.mActions.isEmpty()) {
                bundle.putParcelableArrayList(KEY_ACTIONS, this.mActions);
            }
            if (this.mFlags != 1) {
                bundle.putInt(KEY_FLAGS, this.mFlags);
            }
            if (this.mDisplayIntent != null) {
                bundle.putParcelable(KEY_DISPLAY_INTENT, this.mDisplayIntent);
            }
            if (!this.mPages.isEmpty()) {
                bundle.putParcelableArray(KEY_PAGES, this.mPages.toArray(new Notification[this.mPages.size()]));
            }
            if (this.mBackground != null) {
                bundle.putParcelable(KEY_BACKGROUND, this.mBackground);
            }
            if (this.mContentIcon != 0) {
                bundle.putInt(KEY_CONTENT_ICON, this.mContentIcon);
            }
            if (this.mContentIconGravity != 0x800005) {
                bundle.putInt(KEY_CONTENT_ICON_GRAVITY, this.mContentIconGravity);
            }
            if (this.mContentActionIndex != -1) {
                bundle.putInt(KEY_CONTENT_ACTION_INDEX, this.mContentActionIndex);
            }
            if (this.mCustomSizePreset != 0) {
                bundle.putInt(KEY_CUSTOM_SIZE_PRESET, this.mCustomSizePreset);
            }
            if (this.mCustomContentHeight != 0) {
                bundle.putInt(KEY_CUSTOM_CONTENT_HEIGHT, this.mCustomContentHeight);
            }
            if (this.mGravity != 80) {
                bundle.putInt(KEY_GRAVITY, this.mGravity);
            }
            builder.getExtras().putBundle(EXTRA_WEARABLE_EXTENSIONS, bundle);
            return builder;
        }

        public List<Action> getActions() {
            return this.mActions;
        }

        public Bitmap getBackground() {
            return this.mBackground;
        }

        public int getContentAction() {
            return this.mContentActionIndex;
        }

        public int getContentIcon() {
            return this.mContentIcon;
        }

        public int getContentIconGravity() {
            return this.mContentIconGravity;
        }

        public boolean getContentIntentAvailableOffline() {
            return (1 & this.mFlags) != 0;
        }

        public int getCustomContentHeight() {
            return this.mCustomContentHeight;
        }

        public int getCustomSizePreset() {
            return this.mCustomSizePreset;
        }

        public PendingIntent getDisplayIntent() {
            return this.mDisplayIntent;
        }

        public int getGravity() {
            return this.mGravity;
        }

        public boolean getHintHideIcon() {
            return (2 & this.mFlags) != 0;
        }

        public boolean getHintShowBackgroundOnly() {
            return (4 & this.mFlags) != 0;
        }

        public List<Notification> getPages() {
            return this.mPages;
        }

        public boolean getStartScrollBottom() {
            return (8 & this.mFlags) != 0;
        }

        public WearableExtender setBackground(Bitmap bitmap) {
            this.mBackground = bitmap;
            return this;
        }

        public WearableExtender setContentAction(int n) {
            this.mContentActionIndex = n;
            return this;
        }

        public WearableExtender setContentIcon(int n) {
            this.mContentIcon = n;
            return this;
        }

        public WearableExtender setContentIconGravity(int n) {
            this.mContentIconGravity = n;
            return this;
        }

        public WearableExtender setContentIntentAvailableOffline(boolean bl) {
            this.setFlag(1, bl);
            return this;
        }

        public WearableExtender setCustomContentHeight(int n) {
            this.mCustomContentHeight = n;
            return this;
        }

        public WearableExtender setCustomSizePreset(int n) {
            this.mCustomSizePreset = n;
            return this;
        }

        public WearableExtender setDisplayIntent(PendingIntent pendingIntent) {
            this.mDisplayIntent = pendingIntent;
            return this;
        }

        public WearableExtender setGravity(int n) {
            this.mGravity = n;
            return this;
        }

        public WearableExtender setHintHideIcon(boolean bl) {
            this.setFlag(2, bl);
            return this;
        }

        public WearableExtender setHintShowBackgroundOnly(boolean bl) {
            this.setFlag(4, bl);
            return this;
        }

        public WearableExtender setStartScrollBottom(boolean bl) {
            this.setFlag(8, bl);
            return this;
        }
    }
}

