/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.res.TypedArray;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.media.MediaRouter;
import android.text.TextUtils;
import android.util.AttributeSet;
import android.view.View;
import android.widget.Toast;
import com.android.internal.R;
import com.android.internal.app.MediaRouteDialogPresenter;

public class MediaRouteButton
extends View {
    private static final int[] ACTIVATED_STATE_SET;
    private static final int[] CHECKED_STATE_SET;
    private boolean mAttachedToWindow;
    private final MediaRouterCallback mCallback;
    private boolean mCheatSheetEnabled;
    private View.OnClickListener mExtendedSettingsClickListener;
    private boolean mIsConnecting;
    private int mMinHeight;
    private int mMinWidth;
    private boolean mRemoteActive;
    private Drawable mRemoteIndicator;
    private int mRouteTypes;
    private final MediaRouter mRouter;

    static {
        CHECKED_STATE_SET = new int[]{0x10100A0};
        ACTIVATED_STATE_SET = new int[]{16843518};
    }

    public MediaRouteButton(Context context) {
        this(context, null);
    }

    public MediaRouteButton(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 16843693);
    }

    public MediaRouteButton(Context context, AttributeSet attributeSet, int n) {
        this(context, attributeSet, n, 0);
    }

    public MediaRouteButton(Context context, AttributeSet attributeSet, int n, int n2) {
        super(context, attributeSet, n, n2);
        this.mRouter = (MediaRouter)context.getSystemService("media_router");
        this.mCallback = new MediaRouterCallback();
        TypedArray typedArray = context.obtainStyledAttributes(attributeSet, R.styleable.MediaRouteButton, n, n2);
        this.setRemoteIndicatorDrawable(typedArray.getDrawable(3));
        this.mMinWidth = typedArray.getDimensionPixelSize(0, 0);
        this.mMinHeight = typedArray.getDimensionPixelSize(1, 0);
        int n3 = typedArray.getInteger(2, 1);
        typedArray.recycle();
        this.setClickable(true);
        this.setLongClickable(true);
        this.setRouteTypes(n3);
    }

    private Activity getActivity() {
        Context context = this.getContext();
        while (context instanceof ContextWrapper) {
            if (context instanceof Activity) {
                return (Activity)context;
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        throw new IllegalStateException("The MediaRouteButton's Context is not an Activity.");
    }

    /*
     * Enabled aggressive block sorting
     */
    private void refreshRoute() {
        if (this.mAttachedToWindow) {
            MediaRouter.RouteInfo routeInfo = this.mRouter.getSelectedRoute();
            boolean bl = !routeInfo.isDefault() && routeInfo.matchesTypes(this.mRouteTypes);
            boolean bl2 = false;
            if (bl) {
                boolean bl3 = routeInfo.isConnecting();
                bl2 = false;
                if (bl3) {
                    bl2 = true;
                }
            }
            boolean bl4 = this.mRemoteActive;
            boolean bl5 = false;
            if (bl4 != bl) {
                this.mRemoteActive = bl;
                bl5 = true;
            }
            if (this.mIsConnecting != bl2) {
                this.mIsConnecting = bl2;
                bl5 = true;
            }
            if (bl5) {
                this.refreshDrawableState();
            }
            this.setEnabled(this.mRouter.isRouteAvailable(this.mRouteTypes, 1));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setRemoteIndicatorDrawable(Drawable drawable2) {
        if (this.mRemoteIndicator != null) {
            this.mRemoteIndicator.setCallback(null);
            this.unscheduleDrawable(this.mRemoteIndicator);
        }
        this.mRemoteIndicator = drawable2;
        if (drawable2 != null) {
            drawable2.setCallback(this);
            drawable2.setState(this.getDrawableState());
            boolean bl = this.getVisibility() == 0;
            drawable2.setVisible(bl, false);
        }
        this.refreshDrawableState();
    }

    @Override
    protected void drawableStateChanged() {
        super.drawableStateChanged();
        if (this.mRemoteIndicator != null) {
            int[] nArray = this.getDrawableState();
            this.mRemoteIndicator.setState(nArray);
            this.invalidate();
        }
    }

    public int getRouteTypes() {
        return this.mRouteTypes;
    }

    @Override
    public void jumpDrawablesToCurrentState() {
        super.jumpDrawablesToCurrentState();
        if (this.mRemoteIndicator != null) {
            this.mRemoteIndicator.jumpToCurrentState();
        }
    }

    @Override
    public void onAttachedToWindow() {
        super.onAttachedToWindow();
        this.mAttachedToWindow = true;
        if (this.mRouteTypes != 0) {
            this.mRouter.addCallback(this.mRouteTypes, this.mCallback, 8);
        }
        this.refreshRoute();
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected int[] onCreateDrawableState(int n) {
        int[] nArray = super.onCreateDrawableState(n + 1);
        if (this.mIsConnecting) {
            MediaRouteButton.mergeDrawableStates(nArray, CHECKED_STATE_SET);
            return nArray;
        } else {
            if (!this.mRemoteActive) return nArray;
            MediaRouteButton.mergeDrawableStates(nArray, ACTIVATED_STATE_SET);
            return nArray;
        }
    }

    @Override
    public void onDetachedFromWindow() {
        this.mAttachedToWindow = false;
        if (this.mRouteTypes != 0) {
            this.mRouter.removeCallback(this.mCallback);
        }
        super.onDetachedFromWindow();
    }

    @Override
    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (this.mRemoteIndicator == null) {
            return;
        }
        int n = this.getPaddingLeft();
        int n2 = this.getWidth() - this.getPaddingRight();
        int n3 = this.getPaddingTop();
        int n4 = this.getHeight() - this.getPaddingBottom();
        int n5 = this.mRemoteIndicator.getIntrinsicWidth();
        int n6 = this.mRemoteIndicator.getIntrinsicHeight();
        int n7 = n + (n2 - n - n5) / 2;
        int n8 = n3 + (n4 - n3 - n6) / 2;
        this.mRemoteIndicator.setBounds(n7, n8, n7 + n5, n8 + n6);
        this.mRemoteIndicator.draw(canvas);
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    protected void onMeasure(int n, int n2) {
        int n3;
        int n4;
        int n5 = View.MeasureSpec.getSize(n);
        int n6 = View.MeasureSpec.getSize(n2);
        int n7 = View.MeasureSpec.getMode(n);
        int n8 = View.MeasureSpec.getMode(n2);
        int n9 = this.mMinWidth;
        int n10 = this.mRemoteIndicator != null ? this.mRemoteIndicator.getIntrinsicWidth() : 0;
        int n11 = Math.max(n9, n10);
        int n12 = this.mMinHeight;
        Drawable drawable2 = this.mRemoteIndicator;
        int n13 = 0;
        if (drawable2 != null) {
            n13 = this.mRemoteIndicator.getIntrinsicHeight();
        }
        int n14 = Math.max(n12, n13);
        switch (n7) {
            default: {
                n4 = n11 + this.getPaddingLeft() + this.getPaddingRight();
                break;
            }
            case 0x40000000: {
                n4 = n5;
                break;
            }
            case -2147483648: {
                n4 = Math.min(n5, n11 + this.getPaddingLeft() + this.getPaddingRight());
            }
        }
        switch (n8) {
            default: {
                n3 = n14 + this.getPaddingTop() + this.getPaddingBottom();
                break;
            }
            case 0x40000000: {
                n3 = n6;
                break;
            }
            case -2147483648: {
                n3 = Math.min(n6, n14 + this.getPaddingTop() + this.getPaddingBottom());
            }
        }
        this.setMeasuredDimension(n4, n3);
    }

    @Override
    public boolean performClick() {
        boolean bl;
        block5: {
            block4: {
                boolean bl2 = super.performClick();
                if (!bl2) {
                    this.playSoundEffect(0);
                }
                if (this.showDialogInternal()) break block4;
                bl = false;
                if (!bl2) break block5;
            }
            bl = true;
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean performLongClick() {
        if (super.performLongClick()) {
            return true;
        }
        if (!this.mCheatSheetEnabled) {
            return false;
        }
        CharSequence charSequence = this.getContentDescription();
        if (TextUtils.isEmpty(charSequence)) {
            return false;
        }
        int[] nArray = new int[2];
        Rect rect = new Rect();
        this.getLocationOnScreen(nArray);
        this.getWindowVisibleDisplayFrame(rect);
        Context context = this.getContext();
        int n = this.getWidth();
        int n2 = this.getHeight();
        int n3 = nArray[1] + n2 / 2;
        int n4 = context.getResources().getDisplayMetrics().widthPixels;
        Toast toast = Toast.makeText(context, charSequence, 0);
        if (n3 < rect.height()) {
            toast.setGravity(8388661, n4 - nArray[0] - n / 2, n2);
        } else {
            toast.setGravity(81, 0, n2);
        }
        toast.show();
        this.performHapticFeedback(0);
        return true;
    }

    void setCheatSheetEnabled(boolean bl) {
        this.mCheatSheetEnabled = bl;
    }

    public void setExtendedSettingsClickListener(View.OnClickListener onClickListener) {
        this.mExtendedSettingsClickListener = onClickListener;
    }

    public void setRouteTypes(int n) {
        if (this.mRouteTypes != n) {
            if (this.mAttachedToWindow && this.mRouteTypes != 0) {
                this.mRouter.removeCallback(this.mCallback);
            }
            this.mRouteTypes = n;
            if (this.mAttachedToWindow && n != 0) {
                this.mRouter.addCallback(n, this.mCallback, 8);
            }
            this.refreshRoute();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void setVisibility(int n) {
        super.setVisibility(n);
        if (this.mRemoteIndicator != null) {
            Drawable drawable2 = this.mRemoteIndicator;
            boolean bl = this.getVisibility() == 0;
            drawable2.setVisible(bl, false);
        }
    }

    public void showDialog() {
        this.showDialogInternal();
    }

    /*
     * Enabled aggressive block sorting
     */
    boolean showDialogInternal() {
        return this.mAttachedToWindow && MediaRouteDialogPresenter.showDialogFragment(this.getActivity(), this.mRouteTypes, this.mExtendedSettingsClickListener) != null;
    }

    @Override
    protected boolean verifyDrawable(Drawable drawable2) {
        return super.verifyDrawable(drawable2) || drawable2 == this.mRemoteIndicator;
    }

    private final class MediaRouterCallback
    extends MediaRouter.SimpleCallback {
        private MediaRouterCallback() {
        }

        @Override
        public void onRouteAdded(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaRouteButton.this.refreshRoute();
        }

        @Override
        public void onRouteChanged(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaRouteButton.this.refreshRoute();
        }

        @Override
        public void onRouteGrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup, int n) {
            MediaRouteButton.this.refreshRoute();
        }

        @Override
        public void onRouteRemoved(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo) {
            MediaRouteButton.this.refreshRoute();
        }

        @Override
        public void onRouteSelected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            MediaRouteButton.this.refreshRoute();
        }

        @Override
        public void onRouteUngrouped(MediaRouter mediaRouter, MediaRouter.RouteInfo routeInfo, MediaRouter.RouteGroup routeGroup) {
            MediaRouteButton.this.refreshRoute();
        }

        @Override
        public void onRouteUnselected(MediaRouter mediaRouter, int n, MediaRouter.RouteInfo routeInfo) {
            MediaRouteButton.this.refreshRoute();
        }
    }
}

