/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ActivityManagerNative;
import android.app.ActivityThread;
import android.app.Application;
import android.app.ApplicationLoaders;
import android.app.ContextImpl;
import android.app.IActivityManager;
import android.app.IServiceConnection;
import android.app.Instrumentation;
import android.app.IntentReceiverLeaked;
import android.app.ServiceConnectionLeaked;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.IIntentReceiver;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.pm.ApplicationInfo;
import android.content.pm.IPackageManager;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.content.res.AssetManager;
import android.content.res.CompatibilityInfo;
import android.content.res.Resources;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Process;
import android.os.RemoteException;
import android.os.StrictMode;
import android.os.Trace;
import android.os.UserHandle;
import android.text.TextUtils;
import android.util.ArrayMap;
import android.util.Log;
import android.util.Slog;
import android.util.SparseArray;
import android.view.DisplayAdjustments;
import dalvik.system.VMRuntime;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Objects;

public final class LoadedApk {
    static final /* synthetic */ boolean $assertionsDisabled = false;
    private static final String TAG = "LoadedApk";
    private final ActivityThread mActivityThread;
    private final String mAppDir;
    private Application mApplication;
    private ApplicationInfo mApplicationInfo;
    private final ClassLoader mBaseClassLoader;
    private ClassLoader mClassLoader;
    int mClientCount = 0;
    private final String mDataDir;
    private final File mDataDirFile;
    private final DisplayAdjustments mDisplayAdjustments = new DisplayAdjustments();
    private final boolean mIncludeCode;
    private final String mLibDir;
    private final String[] mOverlayDirs;
    final String mPackageName;
    private final ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mReceivers = new ArrayMap();
    private final boolean mRegisterPackage;
    private final String mResDir;
    Resources mResources;
    private final boolean mSecurityViolation;
    private final ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mServices;
    private final String[] mSharedLibraries;
    private final String[] mSplitAppDirs;
    private final String[] mSplitResDirs;
    private final ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> mUnboundServices;
    private final ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> mUnregisteredReceivers = new ArrayMap();

    /*
     * Enabled aggressive block sorting
     */
    static {
        boolean bl = !LoadedApk.class.desiredAssertionStatus();
        $assertionsDisabled = bl;
    }

    LoadedApk(ActivityThread activityThread) {
        this.mServices = new ArrayMap();
        this.mUnboundServices = new ArrayMap();
        this.mActivityThread = activityThread;
        this.mApplicationInfo = new ApplicationInfo();
        this.mApplicationInfo.packageName = "android";
        this.mPackageName = "android";
        this.mAppDir = null;
        this.mResDir = null;
        this.mSplitAppDirs = null;
        this.mSplitResDirs = null;
        this.mOverlayDirs = null;
        this.mSharedLibraries = null;
        this.mDataDir = null;
        this.mDataDirFile = null;
        this.mLibDir = null;
        this.mBaseClassLoader = null;
        this.mSecurityViolation = false;
        this.mIncludeCode = true;
        this.mRegisterPackage = false;
        this.mClassLoader = ClassLoader.getSystemClassLoader();
        this.mResources = Resources.getSystem();
    }

    /*
     * Enabled aggressive block sorting
     */
    public LoadedApk(ActivityThread activityThread, ApplicationInfo applicationInfo, CompatibilityInfo compatibilityInfo, ClassLoader classLoader, boolean bl, boolean bl2, boolean bl3) {
        this.mServices = new ArrayMap();
        this.mUnboundServices = new ArrayMap();
        int n = Process.myUid();
        ApplicationInfo applicationInfo2 = LoadedApk.adjustNativeLibraryPaths(applicationInfo);
        this.mActivityThread = activityThread;
        this.mApplicationInfo = applicationInfo2;
        this.mPackageName = applicationInfo2.packageName;
        this.mAppDir = applicationInfo2.sourceDir;
        String string2 = applicationInfo2.uid == n ? applicationInfo2.sourceDir : applicationInfo2.publicSourceDir;
        this.mResDir = string2;
        this.mSplitAppDirs = applicationInfo2.splitSourceDirs;
        String[] stringArray = applicationInfo2.uid == n ? applicationInfo2.splitSourceDirs : applicationInfo2.splitPublicSourceDirs;
        this.mSplitResDirs = stringArray;
        this.mOverlayDirs = applicationInfo2.resourceDirs;
        if (!UserHandle.isSameUser(applicationInfo2.uid, n) && !Process.isIsolated()) {
            applicationInfo2.dataDir = PackageManager.getDataDirForUser(UserHandle.getUserId(n), this.mPackageName);
        }
        this.mSharedLibraries = applicationInfo2.sharedLibraryFiles;
        this.mDataDir = applicationInfo2.dataDir;
        File file = this.mDataDir != null ? new File(this.mDataDir) : null;
        this.mDataDirFile = file;
        this.mLibDir = applicationInfo2.nativeLibraryDir;
        this.mBaseClassLoader = classLoader;
        this.mSecurityViolation = bl;
        this.mIncludeCode = bl2;
        this.mRegisterPackage = bl3;
        this.mDisplayAdjustments.setCompatibilityInfo(compatibilityInfo);
    }

    private static ApplicationInfo adjustNativeLibraryPaths(ApplicationInfo applicationInfo) {
        if (applicationInfo.primaryCpuAbi != null && applicationInfo.secondaryCpuAbi != null && VMRuntime.getRuntime().vmInstructionSet().equals(VMRuntime.getInstructionSet((String)applicationInfo.secondaryCpuAbi))) {
            ApplicationInfo applicationInfo2 = new ApplicationInfo(applicationInfo);
            applicationInfo2.nativeLibraryDir = applicationInfo2.secondaryNativeLibraryDir;
            return applicationInfo2;
        }
        return applicationInfo;
    }

    private static String[] getLibrariesFor(String string2) {
        ApplicationInfo applicationInfo;
        try {
            applicationInfo = ActivityThread.getPackageManager().getApplicationInfo(string2, 1024, UserHandle.myUserId());
            if (applicationInfo == null) {
                return null;
            }
        }
        catch (RemoteException remoteException) {
            throw new AssertionError((Object)remoteException);
        }
        return applicationInfo.sharedLibraryFiles;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void initializeJavaContextClassLoader() {
        PackageInfo packageInfo;
        IPackageManager iPackageManager = ActivityThread.getPackageManager();
        try {
            packageInfo = iPackageManager.getPackageInfo(this.mPackageName, 0, UserHandle.myUserId());
            if (packageInfo == null) {
                throw new IllegalStateException("Unable to get package info for " + this.mPackageName + "; is package not installed?");
            }
        }
        catch (RemoteException remoteException) {
            throw new IllegalStateException("Unable to get package info for " + this.mPackageName + "; is system dying?", remoteException);
        }
        boolean bl = packageInfo.sharedUserId != null;
        boolean bl2 = packageInfo.applicationInfo != null && !this.mPackageName.equals(packageInfo.applicationInfo.processName);
        boolean bl3 = bl || bl2;
        ClassLoader classLoader = bl3 ? new WarningContextClassLoader() : this.mClassLoader;
        Thread.currentThread().setContextClassLoader(classLoader);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void rewriteRValues(ClassLoader classLoader, String string2, int n) {
        void var11_12;
        Method method;
        Class<?> clazz;
        try {
            clazz = classLoader.loadClass(string2 + ".R");
        }
        catch (ClassNotFoundException classNotFoundException) {
            Log.i(TAG, "No resource references to update in package " + string2);
            return;
        }
        try {
            Class[] classArray = new Class[]{Integer.TYPE};
            method = clazz.getMethod("onResourcesLoaded", classArray);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            return;
        }
        try {
            Object[] objectArray = new Object[]{n};
            method.invoke(null, objectArray);
            return;
        }
        catch (IllegalAccessException illegalAccessException) {
            IllegalAccessException illegalAccessException2 = illegalAccessException;
            throw new RuntimeException("Failed to rewrite resource references for " + string2, (Throwable)var11_12);
        }
        catch (InvocationTargetException invocationTargetException) {
            Throwable throwable = invocationTargetException.getCause();
            throw new RuntimeException("Failed to rewrite resource references for " + string2, (Throwable)var11_12);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IIntentReceiver forgetReceiverDispatcher(Context context, BroadcastReceiver broadcastReceiver) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ReceiverDispatcher receiverDispatcher;
            ReceiverDispatcher receiverDispatcher2;
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> arrayMap2 = this.mReceivers.get(context);
            if (arrayMap2 != null && (receiverDispatcher2 = arrayMap2.get(broadcastReceiver)) != null) {
                arrayMap2.remove(broadcastReceiver);
                if (arrayMap2.size() == 0) {
                    this.mReceivers.remove(context);
                }
                if (broadcastReceiver.getDebugUnregister()) {
                    ArrayMap<BroadcastReceiver, ReceiverDispatcher> arrayMap3 = this.mUnregisteredReceivers.get(context);
                    if (arrayMap3 == null) {
                        arrayMap3 = new ArrayMap();
                        this.mUnregisteredReceivers.put(context, arrayMap3);
                    }
                    IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Originally unregistered here:");
                    illegalArgumentException.fillInStackTrace();
                    receiverDispatcher2.setUnregisterLocation(illegalArgumentException);
                    arrayMap3.put(broadcastReceiver, receiverDispatcher2);
                }
                receiverDispatcher2.mForgotten = true;
                return receiverDispatcher2.getIIntentReceiver();
            }
            ArrayMap<BroadcastReceiver, ReceiverDispatcher> arrayMap4 = this.mUnregisteredReceivers.get(context);
            if (arrayMap4 != null && (receiverDispatcher = arrayMap4.get(broadcastReceiver)) != null) {
                RuntimeException runtimeException = receiverDispatcher.getUnregisterLocation();
                throw new IllegalArgumentException("Unregistering Receiver " + broadcastReceiver + " that was already unregistered", runtimeException);
            }
            if (context != null) throw new IllegalArgumentException("Receiver not registered: " + broadcastReceiver);
            throw new IllegalStateException("Unbinding Receiver " + broadcastReceiver + " from Context that is no longer in use: " + context);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IServiceConnection forgetServiceDispatcher(Context context, ServiceConnection serviceConnection) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ServiceDispatcher serviceDispatcher;
            ServiceDispatcher serviceDispatcher2;
            ArrayMap<ServiceConnection, ServiceDispatcher> arrayMap2 = this.mServices.get(context);
            if (arrayMap2 != null && (serviceDispatcher2 = arrayMap2.get(serviceConnection)) != null) {
                arrayMap2.remove(serviceConnection);
                serviceDispatcher2.doForget();
                if (arrayMap2.size() == 0) {
                    this.mServices.remove(context);
                }
                if ((2 & serviceDispatcher2.getFlags()) == 0) return serviceDispatcher2.getIServiceConnection();
                ArrayMap<ServiceConnection, ServiceDispatcher> arrayMap3 = this.mUnboundServices.get(context);
                if (arrayMap3 == null) {
                    arrayMap3 = new ArrayMap();
                    this.mUnboundServices.put(context, arrayMap3);
                }
                IllegalArgumentException illegalArgumentException = new IllegalArgumentException("Originally unbound here:");
                illegalArgumentException.fillInStackTrace();
                serviceDispatcher2.setUnbindLocation(illegalArgumentException);
                arrayMap3.put(serviceConnection, serviceDispatcher2);
                return serviceDispatcher2.getIServiceConnection();
            }
            ArrayMap<ServiceConnection, ServiceDispatcher> arrayMap4 = this.mUnboundServices.get(context);
            if (arrayMap4 != null && (serviceDispatcher = arrayMap4.get(serviceConnection)) != null) {
                RuntimeException runtimeException = serviceDispatcher.getUnbindLocation();
                throw new IllegalArgumentException("Unbinding Service " + serviceConnection + " that was already unbound", runtimeException);
            }
            if (context != null) throw new IllegalArgumentException("Service not registered: " + serviceConnection);
            throw new IllegalStateException("Unbinding Service " + serviceConnection + " from Context that is no longer in use: " + context);
        }
    }

    public String getAppDir() {
        return this.mAppDir;
    }

    Application getApplication() {
        return this.mApplication;
    }

    public ApplicationInfo getApplicationInfo() {
        return this.mApplicationInfo;
    }

    public AssetManager getAssets(ActivityThread activityThread) {
        return this.getResources(activityThread).getAssets();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public ClassLoader getClassLoader() {
        synchronized (this) {
            String[] stringArray;
            ArrayList<String> arrayList;
            ArrayList<Object> arrayList2;
            block24: {
                String string2;
                String[] stringArray2;
                String string3;
                String string4;
                String[] stringArray3;
                String string5;
                String string6;
                block23: {
                    block21: {
                        block22: {
                            if (this.mClassLoader != null) {
                                return this.mClassLoader;
                            }
                            if (!this.mIncludeCode || this.mPackageName.equals("android")) break block22;
                            if (!Objects.equals(this.mPackageName, ActivityThread.currentPackageName())) {
                                String string7 = VMRuntime.getRuntime().vmInstructionSet();
                                try {
                                    ActivityThread.getPackageManager().performDexOptIfNeeded(this.mPackageName, string7);
                                }
                                catch (RemoteException remoteException) {}
                            }
                            arrayList2 = new ArrayList<Object>();
                            arrayList = new ArrayList<String>();
                            boolean bl = this.mRegisterPackage;
                            if (!bl) break block21;
                            try {
                                ActivityManagerNative.getDefault().addPackageDependency(this.mPackageName);
                                break block21;
                            }
                            catch (RemoteException remoteException) {}
                        }
                        this.mClassLoader = this.mBaseClassLoader == null ? ClassLoader.getSystemClassLoader() : this.mBaseClassLoader;
                        return this.mClassLoader;
                    }
                    arrayList2.add(this.mAppDir);
                    if (this.mSplitAppDirs != null) {
                        Collections.addAll(arrayList2, this.mSplitAppDirs);
                    }
                    arrayList.add(this.mLibDir);
                    string6 = this.mActivityThread.mInstrumentationPackageName;
                    string5 = this.mActivityThread.mInstrumentationAppDir;
                    stringArray3 = this.mActivityThread.mInstrumentationSplitAppDirs;
                    string4 = this.mActivityThread.mInstrumentationLibDir;
                    string3 = this.mActivityThread.mInstrumentedAppDir;
                    stringArray2 = this.mActivityThread.mInstrumentedSplitAppDirs;
                    string2 = this.mActivityThread.mInstrumentedLibDir;
                    if (this.mAppDir.equals(string5)) break block23;
                    boolean bl = this.mAppDir.equals(string3);
                    stringArray = null;
                    if (!bl) break block24;
                }
                arrayList2.clear();
                arrayList2.add(string5);
                if (stringArray3 != null) {
                    Collections.addAll(arrayList2, stringArray3);
                }
                arrayList2.add(string3);
                if (stringArray2 != null) {
                    Collections.addAll(arrayList2, stringArray2);
                }
                arrayList.clear();
                arrayList.add(string4);
                arrayList.add(string2);
                boolean bl = string3.equals(string5);
                stringArray = null;
                if (!bl) {
                    stringArray = LoadedApk.getLibrariesFor(string6);
                }
            }
            if (this.mSharedLibraries != null) {
                for (String string8 : this.mSharedLibraries) {
                    if (arrayList2.contains(string8)) continue;
                    arrayList2.add(0, string8);
                }
            }
            if (stringArray != null) {
                for (void var29_25 : stringArray) {
                    if (arrayList2.contains(var29_25)) continue;
                    arrayList2.add(0, var29_25);
                }
            }
            String string9 = TextUtils.join((CharSequence)File.pathSeparator, arrayList2);
            String string10 = TextUtils.join((CharSequence)File.pathSeparator, arrayList);
            StrictMode.ThreadPolicy threadPolicy = StrictMode.allowThreadDiskReads();
            this.mClassLoader = ApplicationLoaders.getDefault().getClassLoader(string9, string10, this.mBaseClassLoader);
            StrictMode.setThreadPolicy(threadPolicy);
            return this.mClassLoader;
        }
    }

    public CompatibilityInfo getCompatibilityInfo() {
        return this.mDisplayAdjustments.getCompatibilityInfo();
    }

    public String getDataDir() {
        return this.mDataDir;
    }

    public File getDataDirFile() {
        return this.mDataDirFile;
    }

    public String getLibDir() {
        return this.mLibDir;
    }

    public String[] getOverlayDirs() {
        return this.mOverlayDirs;
    }

    public String getPackageName() {
        return this.mPackageName;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public IIntentReceiver getReceiverDispatcher(BroadcastReceiver broadcastReceiver, Context context, Handler handler, Instrumentation instrumentation, boolean bl) {
        ArrayMap<Context, ArrayMap<BroadcastReceiver, ReceiverDispatcher>> arrayMap = this.mReceivers;
        synchronized (arrayMap) {
            ReceiverDispatcher receiverDispatcher;
            block13: {
                ArrayMap<BroadcastReceiver, ReceiverDispatcher> arrayMap2;
                ArrayMap<BroadcastReceiver, ReceiverDispatcher> arrayMap3;
                block14: {
                    void var10_14;
                    block15: {
                        ReceiverDispatcher receiverDispatcher2;
                        ArrayMap<BroadcastReceiver, ReceiverDispatcher> arrayMap4 = null;
                        if (bl && (arrayMap4 = this.mReceivers.get(context)) != null) {
                            ReceiverDispatcher receiverDispatcher3 = arrayMap4.get(broadcastReceiver);
                            arrayMap3 = arrayMap4;
                            receiverDispatcher2 = receiverDispatcher3;
                        } else {
                            arrayMap3 = arrayMap4;
                            receiverDispatcher2 = null;
                        }
                        if (receiverDispatcher2 == null) {
                            receiverDispatcher = new ReceiverDispatcher(broadcastReceiver, context, handler, instrumentation, bl);
                            if (!bl) break block13;
                            if (arrayMap3 != null) break block14;
                            arrayMap2 = new ArrayMap();
                            this.mReceivers.put(context, arrayMap2);
                        }
                        try {
                            receiverDispatcher2.validate(context, handler);
                        }
                        catch (Throwable throwable) {
                        }
                        receiverDispatcher = receiverDispatcher2;
                        break block13;
                        break block15;
                        finally {
                        }
                    }
                    throw var10_14;
                }
                arrayMap2 = arrayMap3;
                arrayMap2.put(broadcastReceiver, receiverDispatcher);
            }
            receiverDispatcher.mForgotten = false;
            return receiverDispatcher.getIIntentReceiver();
        }
    }

    public String getResDir() {
        return this.mResDir;
    }

    public Resources getResources(ActivityThread activityThread) {
        if (this.mResources == null) {
            this.mResources = activityThread.getTopLevelResources(this.mResDir, this.mSplitResDirs, this.mOverlayDirs, this.mApplicationInfo.sharedLibraryFiles, 0, null, this, this.mPackageName);
        }
        return this.mResources;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public final IServiceConnection getServiceDispatcher(ServiceConnection serviceConnection, Context context, Handler handler, int n) {
        ArrayMap<Context, ArrayMap<ServiceConnection, ServiceDispatcher>> arrayMap = this.mServices;
        synchronized (arrayMap) {
            ServiceDispatcher serviceDispatcher;
            ServiceDispatcher serviceDispatcher2;
            ArrayMap<ServiceConnection, ServiceDispatcher> arrayMap2 = this.mServices.get(context);
            ServiceDispatcher serviceDispatcher3 = arrayMap2 != null ? (serviceDispatcher2 = arrayMap2.get(serviceConnection)) : null;
            if (serviceDispatcher3 == null) {
                block8: {
                    serviceDispatcher = new ServiceDispatcher(serviceConnection, context, handler, n);
                    if (arrayMap2 != null) break block8;
                    arrayMap2 = new ArrayMap();
                    this.mServices.put(context, arrayMap2);
                }
                arrayMap2.put(serviceConnection, serviceDispatcher);
                return serviceDispatcher.getIServiceConnection();
            }
            try {
                serviceDispatcher3.validate(context, handler);
                serviceDispatcher = serviceDispatcher3;
            }
            catch (Throwable throwable) {
            }
            return serviceDispatcher.getIServiceConnection();
            throw throwable;
        }
    }

    public String[] getSplitAppDirs() {
        return this.mSplitAppDirs;
    }

    public String[] getSplitResDirs() {
        return this.mSplitResDirs;
    }

    void installSystemApplicationInfo(ApplicationInfo applicationInfo, ClassLoader classLoader) {
        if (!$assertionsDisabled && !applicationInfo.packageName.equals("android")) {
            throw new AssertionError();
        }
        this.mApplicationInfo = applicationInfo;
        this.mClassLoader = classLoader;
    }

    public boolean isSecurityViolation() {
        return this.mSecurityViolation;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Application makeApplication(boolean bl, Instrumentation instrumentation) {
        Application application;
        block11: {
            block10: {
                if (this.mApplication != null) {
                    return this.mApplication;
                }
                application = null;
                String string2 = this.mApplicationInfo.className;
                if (bl || string2 == null) {
                    string2 = "android.app.Application";
                }
                try {
                    ClassLoader classLoader = this.getClassLoader();
                    boolean bl2 = this.mPackageName.equals("android");
                    application = null;
                    if (!bl2) {
                        this.initializeJavaContextClassLoader();
                    }
                    ContextImpl contextImpl = ContextImpl.createAppContext(this.mActivityThread, this);
                    application = this.mActivityThread.mInstrumentation.newApplication(classLoader, string2, contextImpl);
                    contextImpl.setOuterContext(application);
                }
                catch (Exception exception) {
                    if (this.mActivityThread.mInstrumentation.onException(application, exception)) break block10;
                    throw new RuntimeException("Unable to instantiate application " + string2 + ": " + exception.toString(), exception);
                }
            }
            this.mActivityThread.mAllApplications.add(application);
            this.mApplication = application;
            if (instrumentation != null) {
                try {
                    instrumentation.callApplicationOnCreate(application);
                }
                catch (Exception exception) {
                    if (instrumentation.onException(application, exception)) break block11;
                    throw new RuntimeException("Unable to create application " + application.getClass().getName() + ": " + exception.toString(), exception);
                }
            }
        }
        SparseArray<String> sparseArray = this.getAssets(this.mActivityThread).getAssignedPackageIdentifiers();
        int n = sparseArray.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = sparseArray.keyAt(n2);
            if (n3 != 1 && n3 != 127) {
                this.rewriteRValues(this.getClassLoader(), sparseArray.valueAt(n2), n3);
            }
            ++n2;
        }
        return application;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void removeContextRegistrations(Context context, String string2, String string3) {
        boolean bl = StrictMode.vmRegistrationLeaksEnabled();
        ArrayMap<BroadcastReceiver, ReceiverDispatcher> arrayMap = this.mReceivers.remove(context);
        if (arrayMap != null) {
            for (int i = 0; i < arrayMap.size(); ++i) {
                ReceiverDispatcher receiverDispatcher = arrayMap.valueAt(i);
                IntentReceiverLeaked intentReceiverLeaked = new IntentReceiverLeaked(string3 + " " + string2 + " has leaked IntentReceiver " + receiverDispatcher.getIntentReceiver() + " that was " + "originally registered here. Are you missing a " + "call to unregisterReceiver()?");
                intentReceiverLeaked.setStackTrace(receiverDispatcher.getLocation().getStackTrace());
                Slog.e("ActivityThread", intentReceiverLeaked.getMessage(), intentReceiverLeaked);
                if (bl) {
                    StrictMode.onIntentReceiverLeaked(intentReceiverLeaked);
                }
                try {
                    ActivityManagerNative.getDefault().unregisterReceiver(receiverDispatcher.getIIntentReceiver());
                    continue;
                }
                catch (RemoteException remoteException) {}
            }
        }
        this.mUnregisteredReceivers.remove(context);
        ArrayMap<ServiceConnection, ServiceDispatcher> arrayMap2 = this.mServices.remove(context);
        if (arrayMap2 != null) {
            for (int i = 0; i < arrayMap2.size(); ++i) {
                ServiceDispatcher serviceDispatcher = arrayMap2.valueAt(i);
                ServiceConnectionLeaked serviceConnectionLeaked = new ServiceConnectionLeaked(string3 + " " + string2 + " has leaked ServiceConnection " + serviceDispatcher.getServiceConnection() + " that was originally bound here");
                serviceConnectionLeaked.setStackTrace(serviceDispatcher.getLocation().getStackTrace());
                Slog.e("ActivityThread", serviceConnectionLeaked.getMessage(), serviceConnectionLeaked);
                if (bl) {
                    StrictMode.onServiceConnectionLeaked(serviceConnectionLeaked);
                }
                try {
                    ActivityManagerNative.getDefault().unbindService(serviceDispatcher.getIServiceConnection());
                }
                catch (RemoteException remoteException) {}
                serviceDispatcher.doForget();
            }
        }
        this.mUnboundServices.remove(context);
    }

    public void setCompatibilityInfo(CompatibilityInfo compatibilityInfo) {
        this.mDisplayAdjustments.setCompatibilityInfo(compatibilityInfo);
    }

    static final class ReceiverDispatcher {
        final Handler mActivityThread;
        final Context mContext;
        boolean mForgotten;
        final IIntentReceiver.Stub mIIntentReceiver;
        final Instrumentation mInstrumentation;
        final IntentReceiverLeaked mLocation;
        final BroadcastReceiver mReceiver;
        final boolean mRegistered;
        RuntimeException mUnregisterLocation;

        /*
         * Enabled aggressive block sorting
         */
        ReceiverDispatcher(BroadcastReceiver broadcastReceiver, Context context, Handler handler, Instrumentation instrumentation, boolean bl) {
            if (handler == null) {
                throw new NullPointerException("Handler must not be null");
            }
            boolean bl2 = !bl;
            this.mIIntentReceiver = new InnerReceiver(this, bl2);
            this.mReceiver = broadcastReceiver;
            this.mContext = context;
            this.mActivityThread = handler;
            this.mInstrumentation = instrumentation;
            this.mRegistered = bl;
            this.mLocation = new IntentReceiverLeaked(null);
            this.mLocation.fillInStackTrace();
        }

        IIntentReceiver getIIntentReceiver() {
            return this.mIIntentReceiver;
        }

        BroadcastReceiver getIntentReceiver() {
            return this.mReceiver;
        }

        IntentReceiverLeaked getLocation() {
            return this.mLocation;
        }

        RuntimeException getUnregisterLocation() {
            return this.mUnregisterLocation;
        }

        public void performReceive(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
            Args args = new Args(intent, n, string2, bundle, bl, bl2, n2);
            if (!this.mActivityThread.post(args) && this.mRegistered && bl) {
                args.sendFinished(ActivityManagerNative.getDefault());
            }
        }

        void setUnregisterLocation(RuntimeException runtimeException) {
            this.mUnregisterLocation = runtimeException;
        }

        void validate(Context context, Handler handler) {
            if (this.mContext != context) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != handler) {
                throw new IllegalStateException("Receiver " + this.mReceiver + " registered with differing handler (was " + this.mActivityThread + " now " + handler + ")");
            }
        }

        final class Args
        extends BroadcastReceiver.PendingResult
        implements Runnable {
            private Intent mCurIntent;
            private final boolean mOrdered;

            /*
             * Enabled aggressive block sorting
             */
            public Args(Intent intent, int n, String string2, Bundle bundle, boolean bl, boolean bl2, int n2) {
                int n3 = ReceiverDispatcher.this.mRegistered ? 1 : 2;
                super(n, string2, bundle, n3, bl, bl2, ReceiverDispatcher.this.mIIntentReceiver.asBinder(), n2);
                this.mCurIntent = intent;
                this.mOrdered = bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void run() {
                BroadcastReceiver broadcastReceiver;
                block6: {
                    broadcastReceiver = ReceiverDispatcher.this.mReceiver;
                    boolean bl = this.mOrdered;
                    IActivityManager iActivityManager = ActivityManagerNative.getDefault();
                    Intent intent = this.mCurIntent;
                    this.mCurIntent = null;
                    if (broadcastReceiver == null || ReceiverDispatcher.this.mForgotten) {
                        if (ReceiverDispatcher.this.mRegistered && bl) {
                            this.sendFinished(iActivityManager);
                        }
                        return;
                    }
                    Trace.traceBegin(64L, "broadcastReceiveReg");
                    try {
                        ClassLoader classLoader = ReceiverDispatcher.this.mReceiver.getClass().getClassLoader();
                        intent.setExtrasClassLoader(classLoader);
                        this.setExtrasClassLoader(classLoader);
                        broadcastReceiver.setPendingResult(this);
                        broadcastReceiver.onReceive(ReceiverDispatcher.this.mContext, intent);
                    }
                    catch (Exception exception) {
                        if (ReceiverDispatcher.this.mRegistered && bl) {
                            this.sendFinished(iActivityManager);
                        }
                        if (ReceiverDispatcher.this.mInstrumentation != null && ReceiverDispatcher.this.mInstrumentation.onException(ReceiverDispatcher.this.mReceiver, exception)) break block6;
                        Trace.traceEnd(64L);
                        throw new RuntimeException("Error receiving broadcast " + intent + " in " + ReceiverDispatcher.this.mReceiver, exception);
                    }
                }
                if (broadcastReceiver.getPendingResult() != null) {
                    this.finish();
                }
                Trace.traceEnd(64L);
            }
        }

        static final class InnerReceiver
        extends IIntentReceiver.Stub {
            final WeakReference<ReceiverDispatcher> mDispatcher;
            final ReceiverDispatcher mStrongRef;

            /*
             * Enabled aggressive block sorting
             */
            InnerReceiver(ReceiverDispatcher receiverDispatcher, boolean bl) {
                this.mDispatcher = new WeakReference<ReceiverDispatcher>(receiverDispatcher);
                if (!bl) {
                    receiverDispatcher = null;
                }
                this.mStrongRef = receiverDispatcher;
            }

            /*
             * Unable to fully structure code
             */
            @Override
            public void performReceive(Intent var1_1, int var2_2, String var3_3, Bundle var4_4, boolean var5_5, boolean var6_6, int var7_7) {
                var8_8 = (ReceiverDispatcher)this.mDispatcher.get();
                if (var8_8 != null) {
                    var8_8.performReceive(var1_1, var2_2, var3_3, var4_4, var5_5, var6_6, var7_7);
                    return;
                }
                var9_9 = ActivityManagerNative.getDefault();
                if (var4_4 == null) ** GOTO lbl10
                try {
                    var4_4.setAllowFds(false);
lbl10:
                    // 2 sources

                    var9_9.finishReceiver(this, var2_2, var3_3, var4_4, false);
                    return;
                }
                catch (RemoteException var10_10) {
                    Slog.w("ActivityThread", "Couldn't finish broadcast to unregistered receiver");
                    return;
                }
            }
        }
    }

    static final class ServiceDispatcher {
        private final ArrayMap<ComponentName, ConnectionInfo> mActiveConnections = new ArrayMap();
        private final Handler mActivityThread;
        private final ServiceConnection mConnection;
        private final Context mContext;
        private boolean mDied;
        private final int mFlags;
        private boolean mForgotten;
        private final InnerConnection mIServiceConnection = new InnerConnection(this);
        private final ServiceConnectionLeaked mLocation;
        private RuntimeException mUnbindLocation;

        ServiceDispatcher(ServiceConnection serviceConnection, Context context, Handler handler, int n) {
            this.mConnection = serviceConnection;
            this.mContext = context;
            this.mActivityThread = handler;
            this.mLocation = new ServiceConnectionLeaked(null);
            this.mLocation.fillInStackTrace();
            this.mFlags = n;
        }

        public void connected(ComponentName componentName, IBinder iBinder) {
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(componentName, iBinder, 0));
                return;
            }
            this.doConnected(componentName, iBinder);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void death(ComponentName componentName, IBinder iBinder) {
            // MONITORENTER : this
            this.mDied = true;
            ConnectionInfo connectionInfo = this.mActiveConnections.remove(componentName);
            if (connectionInfo == null || connectionInfo.binder != iBinder) {
                // MONITOREXIT : this
                return;
            }
            connectionInfo.binder.unlinkToDeath(connectionInfo.deathMonitor, 0);
            // MONITOREXIT : this
            if (this.mActivityThread != null) {
                this.mActivityThread.post(new RunConnection(componentName, iBinder, 1));
                return;
            }
            this.doDeath(componentName, iBinder);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         * Converted monitor instructions to comments
         * Lifted jumps to return sites
         */
        public void doConnected(ComponentName componentName, IBinder iBinder) {
            // MONITORENTER : this
            if (this.mForgotten) {
                // MONITOREXIT : this
                return;
            }
            ConnectionInfo connectionInfo = this.mActiveConnections.get(componentName);
            if (connectionInfo != null && connectionInfo.binder == iBinder) {
                // MONITOREXIT : this
                return;
            }
            if (iBinder != null) {
                this.mDied = false;
                ConnectionInfo connectionInfo2 = new ConnectionInfo();
                connectionInfo2.binder = iBinder;
                connectionInfo2.deathMonitor = new DeathMonitor(componentName, iBinder);
                try {
                    iBinder.linkToDeath(connectionInfo2.deathMonitor, 0);
                    this.mActiveConnections.put(componentName, connectionInfo2);
                }
                catch (RemoteException remoteException) {
                    this.mActiveConnections.remove(componentName);
                    // MONITOREXIT : this
                    return;
                }
            } else {
                this.mActiveConnections.remove(componentName);
            }
            if (connectionInfo != null) {
                connectionInfo.binder.unlinkToDeath(connectionInfo.deathMonitor, 0);
            }
            // MONITOREXIT : this
            if (connectionInfo != null) {
                this.mConnection.onServiceDisconnected(componentName);
            }
            if (iBinder == null) return;
            this.mConnection.onServiceConnected(componentName, iBinder);
        }

        public void doDeath(ComponentName componentName, IBinder iBinder) {
            this.mConnection.onServiceDisconnected(componentName);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void doForget() {
            synchronized (this) {
                int n = 0;
                while (true) {
                    if (n >= this.mActiveConnections.size()) {
                        this.mActiveConnections.clear();
                        this.mForgotten = true;
                        return;
                    }
                    ConnectionInfo connectionInfo = this.mActiveConnections.valueAt(n);
                    connectionInfo.binder.unlinkToDeath(connectionInfo.deathMonitor, 0);
                    ++n;
                }
            }
        }

        int getFlags() {
            return this.mFlags;
        }

        IServiceConnection getIServiceConnection() {
            return this.mIServiceConnection;
        }

        ServiceConnectionLeaked getLocation() {
            return this.mLocation;
        }

        ServiceConnection getServiceConnection() {
            return this.mConnection;
        }

        RuntimeException getUnbindLocation() {
            return this.mUnbindLocation;
        }

        void setUnbindLocation(RuntimeException runtimeException) {
            this.mUnbindLocation = runtimeException;
        }

        void validate(Context context, Handler handler) {
            if (this.mContext != context) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing Context (was " + this.mContext + " now " + context + ")");
            }
            if (this.mActivityThread != handler) {
                throw new RuntimeException("ServiceConnection " + this.mConnection + " registered with differing handler (was " + this.mActivityThread + " now " + handler + ")");
            }
        }

        private static class ConnectionInfo {
            IBinder binder;
            IBinder.DeathRecipient deathMonitor;

            private ConnectionInfo() {
            }
        }

        private final class DeathMonitor
        implements IBinder.DeathRecipient {
            final ComponentName mName;
            final IBinder mService;

            DeathMonitor(ComponentName componentName, IBinder iBinder) {
                this.mName = componentName;
                this.mService = iBinder;
            }

            @Override
            public void binderDied() {
                ServiceDispatcher.this.death(this.mName, this.mService);
            }
        }

        private static class InnerConnection
        extends IServiceConnection.Stub {
            final WeakReference<ServiceDispatcher> mDispatcher;

            InnerConnection(ServiceDispatcher serviceDispatcher) {
                this.mDispatcher = new WeakReference<ServiceDispatcher>(serviceDispatcher);
            }

            @Override
            public void connected(ComponentName componentName, IBinder iBinder) throws RemoteException {
                ServiceDispatcher serviceDispatcher = (ServiceDispatcher)this.mDispatcher.get();
                if (serviceDispatcher != null) {
                    serviceDispatcher.connected(componentName, iBinder);
                }
            }
        }

        private final class RunConnection
        implements Runnable {
            final int mCommand;
            final ComponentName mName;
            final IBinder mService;

            RunConnection(ComponentName componentName, IBinder iBinder, int n) {
                this.mName = componentName;
                this.mService = iBinder;
                this.mCommand = n;
            }

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public void run() {
                if (this.mCommand == 0) {
                    ServiceDispatcher.this.doConnected(this.mName, this.mService);
                    return;
                } else {
                    if (this.mCommand != 1) return;
                    ServiceDispatcher.this.doDeath(this.mName, this.mService);
                    return;
                }
            }
        }
    }

    private static class WarningContextClassLoader
    extends ClassLoader {
        private static boolean warned = false;

        private WarningContextClassLoader() {
        }

        private void warn(String string2) {
            if (warned) {
                return;
            }
            warned = true;
            Thread.currentThread().setContextClassLoader(this.getParent());
            Slog.w("ActivityThread", "ClassLoader." + string2 + ": " + "The class loader returned by " + "Thread.getContextClassLoader() may fail for processes " + "that host multiple applications. You should explicitly " + "specify a context class loader. For example: " + "Thread.setContextClassLoader(getClass().getClassLoader());");
        }

        @Override
        public void clearAssertionStatus() {
            this.warn("clearAssertionStatus");
            this.getParent().clearAssertionStatus();
        }

        @Override
        public URL getResource(String string2) {
            this.warn("getResource");
            return this.getParent().getResource(string2);
        }

        @Override
        public InputStream getResourceAsStream(String string2) {
            this.warn("getResourceAsStream");
            return this.getParent().getResourceAsStream(string2);
        }

        @Override
        public Enumeration<URL> getResources(String string2) throws IOException {
            this.warn("getResources");
            return this.getParent().getResources(string2);
        }

        @Override
        public Class<?> loadClass(String string2) throws ClassNotFoundException {
            this.warn("loadClass");
            return this.getParent().loadClass(string2);
        }

        @Override
        public void setClassAssertionStatus(String string2, boolean bl) {
            this.warn("setClassAssertionStatus");
            this.getParent().setClassAssertionStatus(string2, bl);
        }

        @Override
        public void setDefaultAssertionStatus(boolean bl) {
            this.warn("setDefaultAssertionStatus");
            this.getParent().setDefaultAssertionStatus(bl);
        }

        @Override
        public void setPackageAssertionStatus(String string2, boolean bl) {
            this.warn("setPackageAssertionStatus");
            this.getParent().setPackageAssertionStatus(string2, bl);
        }
    }
}

