/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.ITransientNotification;
import android.app.Notification;
import android.content.ComponentName;
import android.content.pm.ParceledListSlice;
import android.net.Uri;
import android.os.Binder;
import android.os.Bundle;
import android.os.IBinder;
import android.os.IInterface;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.service.notification.Condition;
import android.service.notification.IConditionListener;
import android.service.notification.IConditionProvider;
import android.service.notification.INotificationListener;
import android.service.notification.StatusBarNotification;
import android.service.notification.ZenModeConfig;

public interface INotificationManager
extends IInterface {
    public boolean areNotificationsEnabledForPackage(String var1, int var2) throws RemoteException;

    public void cancelAllNotifications(String var1, int var2) throws RemoteException;

    public void cancelNotificationFromListener(INotificationListener var1, String var2, String var3, int var4) throws RemoteException;

    public void cancelNotificationWithTag(String var1, String var2, int var3, int var4) throws RemoteException;

    public void cancelNotificationsFromListener(INotificationListener var1, String[] var2) throws RemoteException;

    public void cancelToast(String var1, ITransientNotification var2) throws RemoteException;

    public void enqueueNotificationWithTag(String var1, String var2, String var3, int var4, Notification var5, int[] var6, int var7) throws RemoteException;

    public void enqueueToast(String var1, ITransientNotification var2, int var3) throws RemoteException;

    public StatusBarNotification[] getActiveNotifications(String var1) throws RemoteException;

    public ParceledListSlice getActiveNotificationsFromListener(INotificationListener var1, String[] var2, int var3) throws RemoteException;

    public Condition[] getAutomaticZenModeConditions() throws RemoteException;

    public ComponentName getEffectsSuppressor() throws RemoteException;

    public int getHintsFromListener(INotificationListener var1) throws RemoteException;

    public StatusBarNotification[] getHistoricalNotifications(String var1, int var2) throws RemoteException;

    public int getInterruptionFilterFromListener(INotificationListener var1) throws RemoteException;

    public int getPackagePriority(String var1, int var2) throws RemoteException;

    public int getPackageVisibilityOverride(String var1, int var2) throws RemoteException;

    public ZenModeConfig getZenModeConfig() throws RemoteException;

    public boolean matchesCallFilter(Bundle var1) throws RemoteException;

    public void notifyConditions(String var1, IConditionProvider var2, Condition[] var3) throws RemoteException;

    public void registerListener(INotificationListener var1, ComponentName var2, int var3) throws RemoteException;

    public void requestHintsFromListener(INotificationListener var1, int var2) throws RemoteException;

    public void requestInterruptionFilterFromListener(INotificationListener var1, int var2) throws RemoteException;

    public void requestZenModeConditions(IConditionListener var1, int var2) throws RemoteException;

    public void setAutomaticZenModeConditions(Uri[] var1) throws RemoteException;

    public void setNotificationsEnabledForPackage(String var1, int var2, boolean var3) throws RemoteException;

    public void setOnNotificationPostedTrimFromListener(INotificationListener var1, int var2) throws RemoteException;

    public void setPackagePriority(String var1, int var2, int var3) throws RemoteException;

    public void setPackageVisibilityOverride(String var1, int var2, int var3) throws RemoteException;

    public void setZenModeCondition(Condition var1) throws RemoteException;

    public boolean setZenModeConfig(ZenModeConfig var1) throws RemoteException;

    public void unregisterListener(INotificationListener var1, int var2) throws RemoteException;

    public static abstract class Stub
    extends Binder
    implements INotificationManager {
        private static final String DESCRIPTOR = "android.app.INotificationManager";
        static final int TRANSACTION_areNotificationsEnabledForPackage = 7;
        static final int TRANSACTION_cancelAllNotifications = 1;
        static final int TRANSACTION_cancelNotificationFromListener = 16;
        static final int TRANSACTION_cancelNotificationWithTag = 5;
        static final int TRANSACTION_cancelNotificationsFromListener = 17;
        static final int TRANSACTION_cancelToast = 3;
        static final int TRANSACTION_enqueueNotificationWithTag = 4;
        static final int TRANSACTION_enqueueToast = 2;
        static final int TRANSACTION_getActiveNotifications = 12;
        static final int TRANSACTION_getActiveNotificationsFromListener = 18;
        static final int TRANSACTION_getAutomaticZenModeConditions = 32;
        static final int TRANSACTION_getEffectsSuppressor = 24;
        static final int TRANSACTION_getHintsFromListener = 20;
        static final int TRANSACTION_getHistoricalNotifications = 13;
        static final int TRANSACTION_getInterruptionFilterFromListener = 22;
        static final int TRANSACTION_getPackagePriority = 9;
        static final int TRANSACTION_getPackageVisibilityOverride = 11;
        static final int TRANSACTION_getZenModeConfig = 26;
        static final int TRANSACTION_matchesCallFilter = 25;
        static final int TRANSACTION_notifyConditions = 28;
        static final int TRANSACTION_registerListener = 14;
        static final int TRANSACTION_requestHintsFromListener = 19;
        static final int TRANSACTION_requestInterruptionFilterFromListener = 21;
        static final int TRANSACTION_requestZenModeConditions = 29;
        static final int TRANSACTION_setAutomaticZenModeConditions = 31;
        static final int TRANSACTION_setNotificationsEnabledForPackage = 6;
        static final int TRANSACTION_setOnNotificationPostedTrimFromListener = 23;
        static final int TRANSACTION_setPackagePriority = 8;
        static final int TRANSACTION_setPackageVisibilityOverride = 10;
        static final int TRANSACTION_setZenModeCondition = 30;
        static final int TRANSACTION_setZenModeConfig = 27;
        static final int TRANSACTION_unregisterListener = 15;

        public Stub() {
            this.attachInterface(this, DESCRIPTOR);
        }

        public static INotificationManager asInterface(IBinder iBinder) {
            if (iBinder == null) {
                return null;
            }
            IInterface iInterface = iBinder.queryLocalInterface(DESCRIPTOR);
            if (iInterface != null && iInterface instanceof INotificationManager) {
                return (INotificationManager)iInterface;
            }
            return new Proxy(iBinder);
        }

        @Override
        public IBinder asBinder() {
            return this;
        }

        /*
         * Enabled aggressive block sorting
         */
        @Override
        public boolean onTransact(int n, Parcel parcel, Parcel parcel2, int n2) throws RemoteException {
            switch (n) {
                default: {
                    return super.onTransact(n, parcel, parcel2, n2);
                }
                case 1598968902: {
                    parcel2.writeString(DESCRIPTOR);
                    return true;
                }
                case 1: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.cancelAllNotifications(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 2: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.enqueueToast(parcel.readString(), ITransientNotification.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 3: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.cancelToast(parcel.readString(), ITransientNotification.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    return true;
                }
                case 4: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string2 = parcel.readString();
                    String string3 = parcel.readString();
                    String string4 = parcel.readString();
                    int n3 = parcel.readInt();
                    Notification notification = parcel.readInt() != 0 ? Notification.CREATOR.createFromParcel(parcel) : null;
                    int[] nArray = parcel.createIntArray();
                    this.enqueueNotificationWithTag(string2, string3, string4, n3, notification, nArray, parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeIntArray(nArray);
                    return true;
                }
                case 5: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.cancelNotificationWithTag(parcel.readString(), parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 6: {
                    parcel.enforceInterface(DESCRIPTOR);
                    String string5 = parcel.readString();
                    int n4 = parcel.readInt();
                    boolean bl = parcel.readInt() != 0;
                    this.setNotificationsEnabledForPackage(string5, n4, bl);
                    parcel2.writeNoException();
                    return true;
                }
                case 7: {
                    parcel.enforceInterface(DESCRIPTOR);
                    boolean bl = this.areNotificationsEnabledForPackage(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    int n5 = 0;
                    if (bl) {
                        n5 = 1;
                    }
                    parcel2.writeInt(n5);
                    return true;
                }
                case 8: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setPackagePriority(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 9: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n6 = this.getPackagePriority(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n6);
                    return true;
                }
                case 10: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setPackageVisibilityOverride(parcel.readString(), parcel.readInt(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 11: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n7 = this.getPackageVisibilityOverride(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeInt(n7);
                    return true;
                }
                case 12: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getActiveNotifications(parcel.readString());
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 13: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Parcelable[] parcelableArray = this.getHistoricalNotifications(parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    parcel2.writeTypedArray(parcelableArray, 1);
                    return true;
                }
                case 14: {
                    parcel.enforceInterface(DESCRIPTOR);
                    INotificationListener iNotificationListener = INotificationListener.Stub.asInterface(parcel.readStrongBinder());
                    ComponentName componentName = parcel.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel) : null;
                    this.registerListener(iNotificationListener, componentName, parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 15: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.unregisterListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 16: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.cancelNotificationFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()), parcel.readString(), parcel.readString(), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 17: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.cancelNotificationsFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()), parcel.createStringArray());
                    parcel2.writeNoException();
                    return true;
                }
                case 18: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ParceledListSlice parceledListSlice = this.getActiveNotificationsFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()), parcel.createStringArray(), parcel.readInt());
                    parcel2.writeNoException();
                    if (parceledListSlice != null) {
                        parcel2.writeInt(1);
                        parceledListSlice.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 19: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.requestHintsFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 20: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n8 = this.getHintsFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n8);
                    return true;
                }
                case 21: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.requestInterruptionFilterFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 22: {
                    parcel.enforceInterface(DESCRIPTOR);
                    int n9 = this.getInterruptionFilterFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()));
                    parcel2.writeNoException();
                    parcel2.writeInt(n9);
                    return true;
                }
                case 23: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setOnNotificationPostedTrimFromListener(INotificationListener.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    parcel2.writeNoException();
                    return true;
                }
                case 24: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ComponentName componentName = this.getEffectsSuppressor();
                    parcel2.writeNoException();
                    if (componentName != null) {
                        parcel2.writeInt(1);
                        componentName.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 25: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Bundle bundle = parcel.readInt() != 0 ? Bundle.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.matchesCallFilter(bundle);
                    parcel2.writeNoException();
                    int n10 = 0;
                    if (bl) {
                        n10 = 1;
                    }
                    parcel2.writeInt(n10);
                    return true;
                }
                case 26: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ZenModeConfig zenModeConfig = this.getZenModeConfig();
                    parcel2.writeNoException();
                    if (zenModeConfig != null) {
                        parcel2.writeInt(1);
                        zenModeConfig.writeToParcel(parcel2, 1);
                        return true;
                    }
                    parcel2.writeInt(0);
                    return true;
                }
                case 27: {
                    parcel.enforceInterface(DESCRIPTOR);
                    ZenModeConfig zenModeConfig = parcel.readInt() != 0 ? ZenModeConfig.CREATOR.createFromParcel(parcel) : null;
                    boolean bl = this.setZenModeConfig(zenModeConfig);
                    parcel2.writeNoException();
                    int n11 = 0;
                    if (bl) {
                        n11 = 1;
                    }
                    parcel2.writeInt(n11);
                    return true;
                }
                case 28: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.notifyConditions(parcel.readString(), IConditionProvider.Stub.asInterface(parcel.readStrongBinder()), parcel.createTypedArray(Condition.CREATOR));
                    return true;
                }
                case 29: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.requestZenModeConditions(IConditionListener.Stub.asInterface(parcel.readStrongBinder()), parcel.readInt());
                    return true;
                }
                case 30: {
                    parcel.enforceInterface(DESCRIPTOR);
                    Condition condition = parcel.readInt() != 0 ? Condition.CREATOR.createFromParcel(parcel) : null;
                    this.setZenModeCondition(condition);
                    return true;
                }
                case 31: {
                    parcel.enforceInterface(DESCRIPTOR);
                    this.setAutomaticZenModeConditions(parcel.createTypedArray(Uri.CREATOR));
                    return true;
                }
                case 32: 
            }
            parcel.enforceInterface(DESCRIPTOR);
            Parcelable[] parcelableArray = this.getAutomaticZenModeConditions();
            parcel2.writeNoException();
            parcel2.writeTypedArray(parcelableArray, 1);
            return true;
        }

        private static class Proxy
        implements INotificationManager {
            private IBinder mRemote;

            Proxy(IBinder iBinder) {
                this.mRemote = iBinder;
            }

            @Override
            public boolean areNotificationsEnabledForPackage(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(7, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    boolean bl = false;
                    if (n2 != 0) {
                        bl = true;
                    }
                    parcel2.recycle();
                    parcel.recycle();
                    return bl;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public IBinder asBinder() {
                return this.mRemote;
            }

            @Override
            public void cancelAllNotifications(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(1, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void cancelNotificationFromListener(INotificationListener iNotificationListener, String string2, String string3, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeInt(n);
                    this.mRemote.transact(16, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void cancelNotificationWithTag(String string2, String string3, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(5, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void cancelNotificationsFromListener(INotificationListener iNotificationListener, String[] stringArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeStringArray(stringArray);
                    this.mRemote.transact(17, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void cancelToast(String string2, ITransientNotification iTransientNotification) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iTransientNotification != null ? iTransientNotification.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(3, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void enqueueNotificationWithTag(String string2, String string3, String string4, int n, Notification notification, int[] nArray, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeString(string3);
                    parcel.writeString(string4);
                    parcel.writeInt(n);
                    if (notification != null) {
                        parcel.writeInt(1);
                        notification.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeIntArray(nArray);
                    parcel.writeInt(n2);
                    this.mRemote.transact(4, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.readIntArray(nArray);
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void enqueueToast(String string2, ITransientNotification iTransientNotification, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = iTransientNotification != null ? iTransientNotification.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(2, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public StatusBarNotification[] getActiveNotifications(String string2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    this.mRemote.transact(12, parcel, parcel2, 0);
                    parcel2.readException();
                    StatusBarNotification[] statusBarNotificationArray = parcel2.createTypedArray(StatusBarNotification.CREATOR);
                    return statusBarNotificationArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ParceledListSlice getActiveNotificationsFromListener(INotificationListener iNotificationListener, String[] stringArray, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeStringArray(stringArray);
                    parcel.writeInt(n);
                    this.mRemote.transact(18, parcel, parcel2, 0);
                    parcel2.readException();
                    ParceledListSlice parceledListSlice = parcel2.readInt() != 0 ? (ParceledListSlice)ParceledListSlice.CREATOR.createFromParcel(parcel2) : null;
                    return parceledListSlice;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public Condition[] getAutomaticZenModeConditions() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(32, parcel, parcel2, 0);
                    parcel2.readException();
                    Condition[] conditionArray = parcel2.createTypedArray(Condition.CREATOR);
                    return conditionArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ComponentName getEffectsSuppressor() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(24, parcel, parcel2, 0);
                    parcel2.readException();
                    ComponentName componentName = parcel2.readInt() != 0 ? ComponentName.CREATOR.createFromParcel(parcel2) : null;
                    return componentName;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getHintsFromListener(INotificationListener iNotificationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(20, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public StatusBarNotification[] getHistoricalNotifications(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(13, parcel, parcel2, 0);
                    parcel2.readException();
                    StatusBarNotification[] statusBarNotificationArray = parcel2.createTypedArray(StatusBarNotification.CREATOR);
                    return statusBarNotificationArray;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            public String getInterfaceDescriptor() {
                return Stub.DESCRIPTOR;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public int getInterruptionFilterFromListener(INotificationListener iNotificationListener) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    this.mRemote.transact(22, parcel, parcel2, 0);
                    parcel2.readException();
                    int n = parcel2.readInt();
                    parcel2.recycle();
                    parcel.recycle();
                    return n;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public int getPackagePriority(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(9, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public int getPackageVisibilityOverride(String string2, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    this.mRemote.transact(11, parcel, parcel2, 0);
                    parcel2.readException();
                    int n2 = parcel2.readInt();
                    return n2;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public ZenModeConfig getZenModeConfig() throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    this.mRemote.transact(26, parcel, parcel2, 0);
                    parcel2.readException();
                    ZenModeConfig zenModeConfig = parcel2.readInt() != 0 ? ZenModeConfig.CREATOR.createFromParcel(parcel2) : null;
                    return zenModeConfig;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean matchesCallFilter(Bundle bundle) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (bundle != null) {
                                parcel2.writeInt(1);
                                bundle.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(25, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void notifyConditions(String string2, IConditionProvider iConditionProvider, Condition[] conditionArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    IBinder iBinder = null;
                    if (iConditionProvider != null) {
                        iBinder = iConditionProvider.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeTypedArray(conditionArray, 0);
                    this.mRemote.transact(28, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void registerListener(INotificationListener iNotificationListener, ComponentName componentName, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    if (componentName != null) {
                        parcel.writeInt(1);
                        componentName.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    parcel.writeInt(n);
                    this.mRemote.transact(14, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestHintsFromListener(INotificationListener iNotificationListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(19, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestInterruptionFilterFromListener(INotificationListener iNotificationListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(21, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void requestZenModeConditions(IConditionListener iConditionListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = null;
                    if (iConditionListener != null) {
                        iBinder = iConditionListener.asBinder();
                    }
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(29, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setAutomaticZenModeConditions(Uri[] uriArray) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeTypedArray(uriArray, 0);
                    this.mRemote.transact(31, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            @Override
            public void setNotificationsEnabledForPackage(String string2, int n, boolean bl) throws RemoteException {
                int n2;
                Parcel parcel;
                Parcel parcel2;
                block4: {
                    parcel2 = Parcel.obtain();
                    parcel = Parcel.obtain();
                    parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel2.writeString(string2);
                    parcel2.writeInt(n);
                    n2 = 0;
                    if (!bl) break block4;
                    n2 = 1;
                }
                try {
                    parcel2.writeInt(n2);
                    this.mRemote.transact(6, parcel2, parcel, 0);
                    parcel.readException();
                    return;
                }
                finally {
                    parcel.recycle();
                    parcel2.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setOnNotificationPostedTrimFromListener(INotificationListener iNotificationListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(23, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }

            @Override
            public void setPackagePriority(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(8, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            @Override
            public void setPackageVisibilityOverride(String string2, int n, int n2) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    parcel.writeString(string2);
                    parcel.writeInt(n);
                    parcel.writeInt(n2);
                    this.mRemote.transact(10, parcel, parcel2, 0);
                    parcel2.readException();
                    return;
                }
                finally {
                    parcel2.recycle();
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void setZenModeCondition(Condition condition) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    if (condition != null) {
                        parcel.writeInt(1);
                        condition.writeToParcel(parcel, 0);
                    } else {
                        parcel.writeInt(0);
                    }
                    this.mRemote.transact(30, parcel, null, 1);
                    return;
                }
                finally {
                    parcel.recycle();
                }
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public boolean setZenModeConfig(ZenModeConfig zenModeConfig) throws RemoteException {
                Parcel parcel;
                Parcel parcel2;
                boolean bl;
                block6: {
                    block5: {
                        bl = true;
                        parcel2 = Parcel.obtain();
                        parcel = Parcel.obtain();
                        try {
                            parcel2.writeInterfaceToken(Stub.DESCRIPTOR);
                            if (zenModeConfig != null) {
                                parcel2.writeInt(1);
                                zenModeConfig.writeToParcel(parcel2, 0);
                            } else {
                                parcel2.writeInt(0);
                            }
                            this.mRemote.transact(27, parcel2, parcel, 0);
                            parcel.readException();
                            int n = parcel.readInt();
                            if (n == 0) break block5;
                            break block6;
                        }
                        catch (Throwable throwable) {
                            parcel.recycle();
                            parcel2.recycle();
                            throw throwable;
                        }
                    }
                    bl = false;
                }
                parcel.recycle();
                parcel2.recycle();
                return bl;
            }

            /*
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            @Override
            public void unregisterListener(INotificationListener iNotificationListener, int n) throws RemoteException {
                Parcel parcel = Parcel.obtain();
                Parcel parcel2 = Parcel.obtain();
                try {
                    parcel.writeInterfaceToken(Stub.DESCRIPTOR);
                    IBinder iBinder = iNotificationListener != null ? iNotificationListener.asBinder() : null;
                    parcel.writeStrongBinder(iBinder);
                    parcel.writeInt(n);
                    this.mRemote.transact(15, parcel, parcel2, 0);
                    parcel2.readException();
                    parcel2.recycle();
                    parcel.recycle();
                    return;
                }
                catch (Throwable throwable) {
                    parcel2.recycle();
                    parcel.recycle();
                    throw throwable;
                }
            }
        }
    }
}

