/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Fragment;
import android.app.FragmentManager;
import android.app.FragmentManagerImpl;
import android.app.FragmentTransaction;
import android.app.SharedElementCallback;
import android.graphics.Rect;
import android.transition.Transition;
import android.transition.TransitionManager;
import android.transition.TransitionSet;
import android.util.ArrayMap;
import android.util.Log;
import android.util.LogWriter;
import android.util.Pair;
import android.util.SparseArray;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import com.android.internal.util.FastPrintWriter;
import java.io.FileDescriptor;
import java.io.PrintWriter;
import java.util.ArrayList;

final class BackStackRecord
extends FragmentTransaction
implements FragmentManager.BackStackEntry,
Runnable {
    static final int OP_ADD = 1;
    static final int OP_ATTACH = 7;
    static final int OP_DETACH = 6;
    static final int OP_HIDE = 4;
    static final int OP_NULL = 0;
    static final int OP_REMOVE = 3;
    static final int OP_REPLACE = 2;
    static final int OP_SHOW = 5;
    static final String TAG = "FragmentManager";
    boolean mAddToBackStack;
    boolean mAllowAddToBackStack = true;
    int mBreadCrumbShortTitleRes;
    CharSequence mBreadCrumbShortTitleText;
    int mBreadCrumbTitleRes;
    CharSequence mBreadCrumbTitleText;
    boolean mCommitted;
    int mEnterAnim;
    int mExitAnim;
    Op mHead;
    int mIndex = -1;
    final FragmentManagerImpl mManager;
    String mName;
    int mNumOp;
    int mPopEnterAnim;
    int mPopExitAnim;
    ArrayList<String> mSharedElementSourceNames;
    ArrayList<String> mSharedElementTargetNames;
    Op mTail;
    int mTransition;
    int mTransitionStyle;

    public BackStackRecord(FragmentManagerImpl fragmentManagerImpl) {
        this.mManager = fragmentManagerImpl;
    }

    private static void addTargets(Transition transition2, ArrayList<View> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            transition2.addTarget(arrayList.get(i));
        }
    }

    private ArrayList<View> addTransitionTargets(final TransitionState transitionState, final Transition transition2, final Transition transition3, final Transition transition4, final View view, final Fragment fragment, final Fragment fragment2, final ArrayList<View> arrayList, final boolean bl, final ArrayList<View> arrayList2) {
        if (transition2 == null && transition3 == null && transition4 == null) {
            return null;
        }
        final ArrayList<View> arrayList3 = new ArrayList<View>();
        view.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

            /*
             * Enabled aggressive block sorting
             */
            @Override
            public boolean onPreDraw() {
                view.getViewTreeObserver().removeOnPreDrawListener(this);
                BackStackRecord.this.excludeHiddenFragments(arrayList, fragment.mContainerId, transition4);
                Transition transition22 = transition3;
                ArrayMap arrayMap = null;
                if (transition22 != null) {
                    arrayMap = BackStackRecord.this.mapSharedElementsIn(transitionState, bl, fragment);
                    BackStackRecord.removeTargets(transition3, arrayList2);
                    arrayList2.clear();
                    if (arrayMap.isEmpty()) {
                        arrayList2.add(transitionState.nonExistentView);
                    } else {
                        arrayList2.addAll(arrayMap.values());
                    }
                    BackStackRecord.addTargets(transition3, arrayList2);
                    BackStackRecord.this.setEpicenterIn(arrayMap, transitionState);
                    BackStackRecord.this.callSharedElementEnd(transitionState, fragment, fragment2, bl, arrayMap);
                }
                if (transition2 != null) {
                    View view2 = fragment.getView();
                    if (view2 != null) {
                        view2.captureTransitioningViews(arrayList3);
                        if (arrayMap != null) {
                            arrayList3.removeAll(arrayMap.values());
                        }
                        BackStackRecord.addTargets(transition2, arrayList3);
                    }
                    BackStackRecord.this.setSharedElementEpicenter(transition2, transitionState);
                }
                return true;
            }
        });
        return arrayList3;
    }

    private TransitionState beginTransition(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2, boolean bl) {
        TransitionState transitionState = new TransitionState();
        transitionState.nonExistentView = new View(this.mManager.mActivity);
        for (int i = 0; i < sparseArray.size(); ++i) {
            this.configureTransitions(sparseArray.keyAt(i), transitionState, bl, sparseArray, sparseArray2);
        }
        for (int i = 0; i < sparseArray2.size(); ++i) {
            int n = sparseArray2.keyAt(i);
            if (sparseArray.get(n) != null) continue;
            this.configureTransitions(n, transitionState, bl, sparseArray, sparseArray2);
        }
        return transitionState;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void calculateFragments(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        if (this.mManager.mContainer.hasView()) {
            Op op = this.mHead;
            while (op != null) {
                switch (op.cmd) {
                    case 1: {
                        this.setLastIn(sparseArray2, op.fragment);
                        break;
                    }
                    case 2: {
                        Fragment fragment = op.fragment;
                        if (this.mManager.mAdded != null) {
                            for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                                Fragment fragment2 = this.mManager.mAdded.get(i);
                                if (fragment != null && fragment2.mContainerId != fragment.mContainerId) continue;
                                if (fragment2 == fragment) {
                                    fragment = null;
                                    continue;
                                }
                                BackStackRecord.setFirstOut(sparseArray, fragment2);
                            }
                        }
                        this.setLastIn(sparseArray2, fragment);
                        break;
                    }
                    case 3: {
                        BackStackRecord.setFirstOut(sparseArray, op.fragment);
                        break;
                    }
                    case 4: {
                        BackStackRecord.setFirstOut(sparseArray, op.fragment);
                        break;
                    }
                    case 5: {
                        this.setLastIn(sparseArray2, op.fragment);
                        break;
                    }
                    case 6: {
                        BackStackRecord.setFirstOut(sparseArray, op.fragment);
                        break;
                    }
                    case 7: {
                        this.setLastIn(sparseArray2, op.fragment);
                        break;
                    }
                }
                op = op.next;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void callSharedElementEnd(TransitionState transitionState, Fragment fragment, Fragment fragment2, boolean bl, ArrayMap<String, View> arrayMap) {
        SharedElementCallback sharedElementCallback = bl ? fragment2.mEnterTransitionCallback : fragment.mEnterTransitionCallback;
        sharedElementCallback.onSharedElementEnd(new ArrayList<String>(arrayMap.keySet()), new ArrayList<View>(arrayMap.values()), null);
    }

    private static ArrayList<View> captureExitingViews(Transition transition2, Fragment fragment, ArrayMap<String, View> arrayMap) {
        ArrayList<View> arrayList = null;
        if (transition2 != null) {
            arrayList = new ArrayList<View>();
            fragment.getView().captureTransitioningViews(arrayList);
            if (arrayMap != null) {
                arrayList.removeAll(arrayMap.values());
            }
            BackStackRecord.addTargets(transition2, arrayList);
        }
        return arrayList;
    }

    private static Transition cloneTransition(Transition transition2) {
        if (transition2 != null) {
            transition2 = transition2.clone();
        }
        return transition2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private void configureTransitions(int n, TransitionState transitionState, boolean bl, SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        Transition transition2;
        ArrayList<View> arrayList;
        ArrayList<View> arrayList2;
        Transition transition3;
        Transition transition4;
        Transition transition5;
        Fragment fragment;
        Fragment fragment2;
        ViewGroup viewGroup;
        block12: {
            block11: {
                String string2;
                View view;
                viewGroup = (ViewGroup)this.mManager.mContainer.findViewById(n);
                if (viewGroup == null) break block11;
                fragment2 = sparseArray2.get(n);
                fragment = sparseArray.get(n);
                transition5 = BackStackRecord.getEnterTransition(fragment2, bl);
                transition4 = BackStackRecord.getSharedElementTransition(fragment2, fragment, bl);
                transition3 = BackStackRecord.getExitTransition(fragment, bl);
                if (transition5 == null && transition4 == null && transition3 == null) break block11;
                if (transition5 != null) {
                    transition5.addTarget(transitionState.nonExistentView);
                }
                arrayList2 = new ArrayList<View>();
                ArrayMap<String, View> arrayMap = null;
                if (transition4 != null) {
                    arrayMap = this.remapSharedElements(transitionState, fragment, bl);
                    if (arrayMap.isEmpty()) {
                        arrayList2.add(transitionState.nonExistentView);
                    } else {
                        arrayList2.addAll(arrayMap.values());
                    }
                    BackStackRecord.addTargets(transition4, arrayList2);
                    SharedElementCallback sharedElementCallback = bl ? fragment.mEnterTransitionCallback : fragment2.mEnterTransitionCallback;
                    ArrayList<String> arrayList3 = new ArrayList<String>(arrayMap.keySet());
                    ArrayList<View> arrayList4 = new ArrayList<View>(arrayMap.values());
                    sharedElementCallback.onSharedElementStart(arrayList3, arrayList4, null);
                }
                if ((arrayList = BackStackRecord.captureExitingViews(transition3, fragment, arrayMap)) == null || arrayList.isEmpty()) {
                    transition3 = null;
                }
                if (this.mSharedElementTargetNames != null && arrayMap != null && (view = arrayMap.get(string2 = this.mSharedElementTargetNames.get(0))) != null) {
                    if (transition3 != null) {
                        BackStackRecord.setEpicenter(transition3, view);
                    }
                    if (transition4 != null) {
                        BackStackRecord.setEpicenter(transition4, view);
                    }
                }
                if ((transition2 = BackStackRecord.mergeTransitions(transition5, transition3, transition4, fragment2, bl)) != null) break block12;
            }
            return;
        }
        ArrayList<View> arrayList5 = new ArrayList<View>();
        ArrayList<View> arrayList6 = this.addTransitionTargets(transitionState, transition5, transition4, transition2, viewGroup, fragment2, fragment, arrayList5, bl, arrayList2);
        transition2.setNameOverrides(transitionState.nameOverrides);
        transition2.excludeTarget(transitionState.nonExistentView, true);
        this.excludeHiddenFragments(arrayList5, n, transition2);
        TransitionManager.beginDelayedTransition(viewGroup, transition2);
        this.removeTargetedViewsFromTransitions(viewGroup, transitionState.nonExistentView, transition5, arrayList6, transition3, arrayList, transition4, arrayList2, transition2, arrayList5);
    }

    private void doAddOp(int n, Fragment fragment, String string2, int n2) {
        fragment.mFragmentManager = this.mManager;
        if (string2 != null) {
            if (fragment.mTag != null && !string2.equals(fragment.mTag)) {
                throw new IllegalStateException("Can't change tag of fragment " + fragment + ": was " + fragment.mTag + " now " + string2);
            }
            fragment.mTag = string2;
        }
        if (n != 0) {
            if (fragment.mFragmentId != 0 && fragment.mFragmentId != n) {
                throw new IllegalStateException("Can't change container ID of fragment " + fragment + ": was " + fragment.mFragmentId + " now " + n);
            }
            fragment.mFragmentId = n;
            fragment.mContainerId = n;
        }
        Op op = new Op();
        op.cmd = n2;
        op.fragment = fragment;
        this.addOp(op);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void excludeHiddenFragments(ArrayList<View> arrayList, int n, Transition transition2) {
        if (this.mManager.mAdded != null) {
            for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                Fragment fragment = this.mManager.mAdded.get(i);
                if (fragment.mView == null || fragment.mContainer == null || fragment.mContainerId != n) continue;
                if (fragment.mHidden) {
                    if (arrayList.contains(fragment.mView)) continue;
                    transition2.excludeTarget(fragment.mView, true);
                    arrayList.add(fragment.mView);
                    continue;
                }
                transition2.excludeTarget(fragment.mView, false);
                arrayList.remove(fragment.mView);
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Transition getEnterTransition(Fragment fragment, boolean bl) {
        Transition transition2;
        if (fragment == null) {
            return null;
        }
        if (bl) {
            transition2 = fragment.getReenterTransition();
            return BackStackRecord.cloneTransition(transition2);
        }
        transition2 = fragment.getEnterTransition();
        return BackStackRecord.cloneTransition(transition2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Transition getExitTransition(Fragment fragment, boolean bl) {
        Transition transition2;
        if (fragment == null) {
            return null;
        }
        if (bl) {
            transition2 = fragment.getReturnTransition();
            return BackStackRecord.cloneTransition(transition2);
        }
        transition2 = fragment.getExitTransition();
        return BackStackRecord.cloneTransition(transition2);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static Transition getSharedElementTransition(Fragment fragment, Fragment fragment2, boolean bl) {
        Transition transition2;
        if (fragment == null || fragment2 == null) {
            return null;
        }
        if (bl) {
            transition2 = fragment2.getSharedElementReturnTransition();
            return BackStackRecord.cloneTransition(transition2);
        }
        transition2 = fragment.getSharedElementEnterTransition();
        return BackStackRecord.cloneTransition(transition2);
    }

    private ArrayMap<String, View> mapEnteringSharedElements(TransitionState transitionState, Fragment fragment, boolean bl) {
        ArrayMap<String, View> arrayMap;
        block3: {
            block2: {
                arrayMap = new ArrayMap<String, View>();
                View view = fragment.getView();
                if (view == null || this.mSharedElementSourceNames == null) break block2;
                view.findNamedViews(arrayMap);
                if (!bl) break block3;
                arrayMap = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, arrayMap);
            }
            return arrayMap;
        }
        arrayMap.retainAll(this.mSharedElementTargetNames);
        return arrayMap;
    }

    private ArrayMap<String, View> mapSharedElementsIn(TransitionState transitionState, boolean bl, Fragment fragment) {
        ArrayMap<String, View> arrayMap = this.mapEnteringSharedElements(transitionState, fragment, bl);
        if (bl) {
            fragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, arrayMap);
            this.setBackNameOverrides(transitionState, arrayMap, true);
            return arrayMap;
        }
        fragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, arrayMap);
        this.setNameOverrides(transitionState, arrayMap, true);
        return arrayMap;
    }

    /*
     * Enabled aggressive block sorting
     */
    private static Transition mergeTransitions(Transition transition2, Transition transition3, Transition transition4, Fragment fragment, boolean bl) {
        Transition transition5;
        boolean bl2 = true;
        if (transition2 != null && transition3 != null) {
            bl2 = bl ? fragment.getAllowReturnTransitionOverlap() : fragment.getAllowEnterTransitionOverlap();
        }
        if (bl2) {
            TransitionSet transitionSet = new TransitionSet();
            if (transition2 != null) {
                transitionSet.addTransition(transition2);
            }
            if (transition3 != null) {
                transitionSet.addTransition(transition3);
            }
            if (transition4 != null) {
                transitionSet.addTransition(transition4);
            }
            return transitionSet;
        }
        if (transition3 != null && transition2 != null) {
            transition5 = new TransitionSet().addTransition(transition3).addTransition(transition2).setOrdering(1);
        } else if (transition3 != null) {
            transition5 = transition3;
        } else {
            transition5 = null;
            if (transition2 != null) {
                transition5 = transition2;
            }
        }
        if (transition4 == null) {
            return transition5;
        }
        TransitionSet transitionSet = new TransitionSet();
        if (transition5 != null) {
            transitionSet.addTransition(transition5);
        }
        transitionSet.addTransition(transition4);
        return transitionSet;
    }

    private static ArrayMap<String, View> remapNames(ArrayList<String> arrayList, ArrayList<String> arrayList2, ArrayMap<String, View> arrayMap) {
        ArrayMap<String, View> arrayMap2 = new ArrayMap<String, View>();
        if (!arrayMap.isEmpty()) {
            int n = arrayList.size();
            for (int i = 0; i < n; ++i) {
                View view = arrayMap.get(arrayList.get(i));
                if (view == null) continue;
                arrayMap2.put(arrayList2.get(i), view);
            }
        }
        return arrayMap2;
    }

    /*
     * Enabled aggressive block sorting
     */
    private ArrayMap<String, View> remapSharedElements(TransitionState transitionState, Fragment fragment, boolean bl) {
        ArrayMap<String, View> arrayMap = new ArrayMap<String, View>();
        if (this.mSharedElementSourceNames != null) {
            fragment.getView().findNamedViews(arrayMap);
            if (bl) {
                arrayMap.retainAll(this.mSharedElementTargetNames);
            } else {
                arrayMap = BackStackRecord.remapNames(this.mSharedElementSourceNames, this.mSharedElementTargetNames, arrayMap);
            }
        }
        if (bl) {
            fragment.mEnterTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, arrayMap);
            this.setBackNameOverrides(transitionState, arrayMap, false);
            return arrayMap;
        }
        fragment.mExitTransitionCallback.onMapSharedElements(this.mSharedElementTargetNames, arrayMap);
        this.setNameOverrides(transitionState, arrayMap, false);
        return arrayMap;
    }

    private void removeTargetedViewsFromTransitions(final ViewGroup viewGroup, final View view, final Transition transition2, final ArrayList<View> arrayList, final Transition transition3, final ArrayList<View> arrayList2, final Transition transition4, final ArrayList<View> arrayList3, final Transition transition5, final ArrayList<View> arrayList4) {
        if (transition5 != null) {
            viewGroup.getViewTreeObserver().addOnPreDrawListener(new ViewTreeObserver.OnPreDrawListener(){

                @Override
                public boolean onPreDraw() {
                    viewGroup.getViewTreeObserver().removeOnPreDrawListener(this);
                    if (transition2 != null) {
                        transition2.removeTarget(view);
                        BackStackRecord.removeTargets(transition2, arrayList);
                    }
                    if (transition3 != null) {
                        BackStackRecord.removeTargets(transition3, arrayList2);
                    }
                    if (transition4 != null) {
                        BackStackRecord.removeTargets(transition4, arrayList3);
                    }
                    int n = arrayList4.size();
                    for (int i = 0; i < n; ++i) {
                        transition5.excludeTarget((View)arrayList4.get(i), false);
                    }
                    transition5.excludeTarget(view, false);
                    return true;
                }
            });
        }
    }

    private static void removeTargets(Transition transition2, ArrayList<View> arrayList) {
        int n = arrayList.size();
        for (int i = 0; i < n; ++i) {
            transition2.removeTarget(arrayList.get(i));
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setBackNameOverrides(TransitionState transitionState, ArrayMap<String, View> arrayMap, boolean bl) {
        int n = this.mSharedElementTargetNames.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = this.mSharedElementSourceNames.get(n2);
            View view = arrayMap.get(this.mSharedElementTargetNames.get(n2));
            if (view != null) {
                String string3 = view.getTransitionName();
                if (bl) {
                    BackStackRecord.setNameOverride(transitionState.nameOverrides, string2, string3);
                } else {
                    BackStackRecord.setNameOverride(transitionState.nameOverrides, string3, string2);
                }
            }
            ++n2;
        }
        return;
    }

    private static void setEpicenter(Transition transition2, View view) {
        final Rect rect = new Rect();
        view.getBoundsOnScreen(rect);
        transition2.setEpicenterCallback(new Transition.EpicenterCallback(){

            @Override
            public Rect onGetEpicenter(Transition transition2) {
                return rect;
            }
        });
    }

    private void setEpicenterIn(ArrayMap<String, View> arrayMap, TransitionState transitionState) {
        View view;
        if (this.mSharedElementTargetNames != null && !arrayMap.isEmpty() && (view = arrayMap.get(this.mSharedElementTargetNames.get(0))) != null) {
            transitionState.enteringEpicenterView = view;
        }
    }

    private static void setFirstOut(SparseArray<Fragment> sparseArray, Fragment fragment) {
        int n;
        if (fragment != null && (n = fragment.mContainerId) != 0 && !fragment.isHidden() && fragment.isAdded() && fragment.getView() != null && sparseArray.get(n) == null) {
            sparseArray.put(n, fragment);
        }
    }

    private void setLastIn(SparseArray<Fragment> sparseArray, Fragment fragment) {
        int n;
        if (fragment != null && (n = fragment.mContainerId) != 0) {
            sparseArray.put(n, fragment);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void setNameOverride(ArrayMap<String, String> arrayMap, String string2, String string3) {
        if (string2 == null || string3 == null || string2.equals(string3)) return;
        for (int i = 0; i < arrayMap.size(); ++i) {
            if (!string2.equals(arrayMap.valueAt(i))) continue;
            arrayMap.setValueAt(i, string3);
            return;
        }
        arrayMap.put(string2, string3);
    }

    /*
     * Enabled aggressive block sorting
     */
    private void setNameOverrides(TransitionState transitionState, ArrayMap<String, View> arrayMap, boolean bl) {
        int n = arrayMap.size();
        int n2 = 0;
        while (n2 < n) {
            String string2 = arrayMap.keyAt(n2);
            String string3 = arrayMap.valueAt(n2).getTransitionName();
            if (bl) {
                BackStackRecord.setNameOverride(transitionState.nameOverrides, string2, string3);
            } else {
                BackStackRecord.setNameOverride(transitionState.nameOverrides, string3, string2);
            }
            ++n2;
        }
        return;
    }

    private static void setNameOverrides(TransitionState transitionState, ArrayList<String> arrayList, ArrayList<String> arrayList2) {
        if (arrayList != null) {
            for (int i = 0; i < arrayList.size(); ++i) {
                String string2 = arrayList.get(i);
                String string3 = arrayList2.get(i);
                BackStackRecord.setNameOverride(transitionState.nameOverrides, string2, string3);
            }
        }
    }

    private void setSharedElementEpicenter(Transition transition2, final TransitionState transitionState) {
        transition2.setEpicenterCallback(new Transition.EpicenterCallback(){
            private Rect mEpicenter;

            @Override
            public Rect onGetEpicenter(Transition transition2) {
                if (this.mEpicenter == null && transitionState.enteringEpicenterView != null) {
                    this.mEpicenter = new Rect();
                    transitionState.enteringEpicenterView.getBoundsOnScreen(this.mEpicenter);
                }
                return this.mEpicenter;
            }
        });
    }

    @Override
    public FragmentTransaction add(int n, Fragment fragment) {
        this.doAddOp(n, fragment, null, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(int n, Fragment fragment, String string2) {
        this.doAddOp(n, fragment, string2, 1);
        return this;
    }

    @Override
    public FragmentTransaction add(Fragment fragment, String string2) {
        this.doAddOp(0, fragment, string2, 1);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void addOp(Op op) {
        if (this.mHead == null) {
            this.mTail = op;
            this.mHead = op;
        } else {
            op.prev = this.mTail;
            this.mTail.next = op;
            this.mTail = op;
        }
        op.enterAnim = this.mEnterAnim;
        op.exitAnim = this.mExitAnim;
        op.popEnterAnim = this.mPopEnterAnim;
        op.popExitAnim = this.mPopExitAnim;
        this.mNumOp = 1 + this.mNumOp;
    }

    @Override
    public FragmentTransaction addSharedElement(View view, String string2) {
        String string3 = view.getTransitionName();
        if (string3 == null) {
            throw new IllegalArgumentException("Unique transitionNames are required for all sharedElements");
        }
        if (this.mSharedElementSourceNames == null) {
            this.mSharedElementSourceNames = new ArrayList();
            this.mSharedElementTargetNames = new ArrayList();
        }
        this.mSharedElementSourceNames.add(string3);
        this.mSharedElementTargetNames.add(string2);
        return this;
    }

    @Override
    public FragmentTransaction addToBackStack(String string2) {
        if (!this.mAllowAddToBackStack) {
            throw new IllegalStateException("This FragmentTransaction is not allowed to be added to the back stack.");
        }
        this.mAddToBackStack = true;
        this.mName = string2;
        return this;
    }

    @Override
    public FragmentTransaction attach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 7;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    void bumpBackStackNesting(int n) {
        if (this.mAddToBackStack) {
            if (FragmentManagerImpl.DEBUG) {
                Log.v(TAG, "Bump nesting in " + this + " by " + n);
            }
            Op op = this.mHead;
            while (op != null) {
                if (op.fragment != null) {
                    Fragment fragment = op.fragment;
                    fragment.mBackStackNesting = n + fragment.mBackStackNesting;
                    if (FragmentManagerImpl.DEBUG) {
                        Log.v(TAG, "Bump nesting of " + op.fragment + " to " + op.fragment.mBackStackNesting);
                    }
                }
                if (op.removed != null) {
                    for (int i = -1 + op.removed.size(); i >= 0; --i) {
                        Fragment fragment = op.removed.get(i);
                        fragment.mBackStackNesting = n + fragment.mBackStackNesting;
                        if (!FragmentManagerImpl.DEBUG) continue;
                        Log.v(TAG, "Bump nesting of " + fragment + " to " + fragment.mBackStackNesting);
                    }
                }
                op = op.next;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void calculateBackFragments(SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        if (this.mManager.mContainer.hasView()) {
            Op op = this.mHead;
            while (op != null) {
                switch (op.cmd) {
                    case 1: {
                        BackStackRecord.setFirstOut(sparseArray, op.fragment);
                        break;
                    }
                    case 2: {
                        if (op.removed != null) {
                            for (int i = -1 + op.removed.size(); i >= 0; --i) {
                                this.setLastIn(sparseArray2, op.removed.get(i));
                            }
                        }
                        BackStackRecord.setFirstOut(sparseArray, op.fragment);
                        break;
                    }
                    case 3: {
                        this.setLastIn(sparseArray2, op.fragment);
                        break;
                    }
                    case 4: {
                        this.setLastIn(sparseArray2, op.fragment);
                        break;
                    }
                    case 5: {
                        BackStackRecord.setFirstOut(sparseArray, op.fragment);
                        break;
                    }
                    case 6: {
                        this.setLastIn(sparseArray2, op.fragment);
                        break;
                    }
                    case 7: {
                        BackStackRecord.setFirstOut(sparseArray, op.fragment);
                        break;
                    }
                }
                op = op.next;
            }
        }
    }

    @Override
    public int commit() {
        return this.commitInternal(false);
    }

    @Override
    public int commitAllowingStateLoss() {
        return this.commitInternal(true);
    }

    /*
     * Enabled aggressive block sorting
     */
    int commitInternal(boolean bl) {
        if (this.mCommitted) {
            throw new IllegalStateException("commit already called");
        }
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Commit: " + this);
            FastPrintWriter fastPrintWriter = new FastPrintWriter(new LogWriter(2, TAG), false, 1024);
            this.dump("  ", null, fastPrintWriter, null);
            ((PrintWriter)fastPrintWriter).flush();
        }
        this.mCommitted = true;
        this.mIndex = this.mAddToBackStack ? this.mManager.allocBackStackIndex(this) : -1;
        this.mManager.enqueueAction(this, bl);
        return this.mIndex;
    }

    @Override
    public FragmentTransaction detach(Fragment fragment) {
        Op op = new Op();
        op.cmd = 6;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction disallowAddToBackStack() {
        if (this.mAddToBackStack) {
            throw new IllegalStateException("This transaction is already being added to the back stack");
        }
        this.mAllowAddToBackStack = false;
        return this;
    }

    public void dump(String string2, FileDescriptor fileDescriptor, PrintWriter printWriter, String[] stringArray) {
        this.dump(string2, printWriter, true);
    }

    /*
     * Enabled aggressive block sorting
     */
    void dump(String string2, PrintWriter printWriter, boolean bl) {
        if (bl) {
            printWriter.print(string2);
            printWriter.print("mName=");
            printWriter.print(this.mName);
            printWriter.print(" mIndex=");
            printWriter.print(this.mIndex);
            printWriter.print(" mCommitted=");
            printWriter.println(this.mCommitted);
            if (this.mTransition != 0) {
                printWriter.print(string2);
                printWriter.print("mTransition=#");
                printWriter.print(Integer.toHexString(this.mTransition));
                printWriter.print(" mTransitionStyle=#");
                printWriter.println(Integer.toHexString(this.mTransitionStyle));
            }
            if (this.mEnterAnim != 0 || this.mExitAnim != 0) {
                printWriter.print(string2);
                printWriter.print("mEnterAnim=#");
                printWriter.print(Integer.toHexString(this.mEnterAnim));
                printWriter.print(" mExitAnim=#");
                printWriter.println(Integer.toHexString(this.mExitAnim));
            }
            if (this.mPopEnterAnim != 0 || this.mPopExitAnim != 0) {
                printWriter.print(string2);
                printWriter.print("mPopEnterAnim=#");
                printWriter.print(Integer.toHexString(this.mPopEnterAnim));
                printWriter.print(" mPopExitAnim=#");
                printWriter.println(Integer.toHexString(this.mPopExitAnim));
            }
            if (this.mBreadCrumbTitleRes != 0 || this.mBreadCrumbTitleText != null) {
                printWriter.print(string2);
                printWriter.print("mBreadCrumbTitleRes=#");
                printWriter.print(Integer.toHexString(this.mBreadCrumbTitleRes));
                printWriter.print(" mBreadCrumbTitleText=");
                printWriter.println(this.mBreadCrumbTitleText);
            }
            if (this.mBreadCrumbShortTitleRes != 0 || this.mBreadCrumbShortTitleText != null) {
                printWriter.print(string2);
                printWriter.print("mBreadCrumbShortTitleRes=#");
                printWriter.print(Integer.toHexString(this.mBreadCrumbShortTitleRes));
                printWriter.print(" mBreadCrumbShortTitleText=");
                printWriter.println(this.mBreadCrumbShortTitleText);
            }
        }
        if (this.mHead != null) {
            printWriter.print(string2);
            printWriter.println("Operations:");
            String string3 = string2 + "    ";
            Op op = this.mHead;
            int n = 0;
            while (op != null) {
                String string4;
                switch (op.cmd) {
                    default: {
                        string4 = "cmd=" + op.cmd;
                        break;
                    }
                    case 0: {
                        string4 = "NULL";
                        break;
                    }
                    case 1: {
                        string4 = "ADD";
                        break;
                    }
                    case 2: {
                        string4 = "REPLACE";
                        break;
                    }
                    case 3: {
                        string4 = "REMOVE";
                        break;
                    }
                    case 4: {
                        string4 = "HIDE";
                        break;
                    }
                    case 5: {
                        string4 = "SHOW";
                        break;
                    }
                    case 6: {
                        string4 = "DETACH";
                        break;
                    }
                    case 7: {
                        string4 = "ATTACH";
                    }
                }
                printWriter.print(string2);
                printWriter.print("  Op #");
                printWriter.print(n);
                printWriter.print(": ");
                printWriter.print(string4);
                printWriter.print(" ");
                printWriter.println(op.fragment);
                if (bl) {
                    if (op.enterAnim != 0 || op.exitAnim != 0) {
                        printWriter.print(string3);
                        printWriter.print("enterAnim=#");
                        printWriter.print(Integer.toHexString(op.enterAnim));
                        printWriter.print(" exitAnim=#");
                        printWriter.println(Integer.toHexString(op.exitAnim));
                    }
                    if (op.popEnterAnim != 0 || op.popExitAnim != 0) {
                        printWriter.print(string3);
                        printWriter.print("popEnterAnim=#");
                        printWriter.print(Integer.toHexString(op.popEnterAnim));
                        printWriter.print(" popExitAnim=#");
                        printWriter.println(Integer.toHexString(op.popExitAnim));
                    }
                }
                if (op.removed != null && op.removed.size() > 0) {
                    for (int i = 0; i < op.removed.size(); ++i) {
                        printWriter.print(string3);
                        if (op.removed.size() == 1) {
                            printWriter.print("Removed: ");
                        } else {
                            if (i == 0) {
                                printWriter.println("Removed:");
                            }
                            printWriter.print(string3);
                            printWriter.print("  #");
                            printWriter.print(i);
                            printWriter.print(": ");
                        }
                        printWriter.println(op.removed.get(i));
                    }
                }
                op = op.next;
                ++n;
            }
        }
    }

    @Override
    public CharSequence getBreadCrumbShortTitle() {
        if (this.mBreadCrumbShortTitleRes != 0) {
            return this.mManager.mActivity.getText(this.mBreadCrumbShortTitleRes);
        }
        return this.mBreadCrumbShortTitleText;
    }

    @Override
    public int getBreadCrumbShortTitleRes() {
        return this.mBreadCrumbShortTitleRes;
    }

    @Override
    public CharSequence getBreadCrumbTitle() {
        if (this.mBreadCrumbTitleRes != 0) {
            return this.mManager.mActivity.getText(this.mBreadCrumbTitleRes);
        }
        return this.mBreadCrumbTitleText;
    }

    @Override
    public int getBreadCrumbTitleRes() {
        return this.mBreadCrumbTitleRes;
    }

    @Override
    public int getId() {
        return this.mIndex;
    }

    @Override
    public String getName() {
        return this.mName;
    }

    public int getTransition() {
        return this.mTransition;
    }

    public int getTransitionStyle() {
        return this.mTransitionStyle;
    }

    @Override
    public FragmentTransaction hide(Fragment fragment) {
        Op op = new Op();
        op.cmd = 4;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public boolean isAddToBackStackAllowed() {
        return this.mAllowAddToBackStack;
    }

    @Override
    public boolean isEmpty() {
        return this.mNumOp == 0;
    }

    /*
     * Enabled aggressive block sorting
     */
    public TransitionState popFromBackStack(boolean bl, TransitionState transitionState, SparseArray<Fragment> sparseArray, SparseArray<Fragment> sparseArray2) {
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "popFromBackStack: " + this);
            FastPrintWriter fastPrintWriter = new FastPrintWriter(new LogWriter(2, TAG), false, 1024);
            this.dump("  ", null, fastPrintWriter, null);
            ((PrintWriter)fastPrintWriter).flush();
        }
        if (transitionState == null) {
            if (sparseArray.size() != 0 || sparseArray2.size() != 0) {
                transitionState = this.beginTransition(sparseArray, sparseArray2, true);
            }
        } else if (!bl) {
            BackStackRecord.setNameOverrides(transitionState, this.mSharedElementTargetNames, this.mSharedElementSourceNames);
        }
        this.bumpBackStackNesting(-1);
        Op op = this.mTail;
        while (op != null) {
            switch (op.cmd) {
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
                case 1: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popExitAnim;
                    this.mManager.removeFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 2: {
                    Fragment fragment = op.fragment;
                    if (fragment != null) {
                        fragment.mNextAnim = op.popExitAnim;
                        this.mManager.removeFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    }
                    if (op.removed == null) break;
                    for (int i = 0; i < op.removed.size(); ++i) {
                        Fragment fragment2 = op.removed.get(i);
                        fragment2.mNextAnim = op.popEnterAnim;
                        this.mManager.addFragment(fragment2, false);
                    }
                    break;
                }
                case 3: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popEnterAnim;
                    this.mManager.addFragment(fragment, false);
                    break;
                }
                case 4: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popEnterAnim;
                    this.mManager.showFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popExitAnim;
                    this.mManager.hideFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popEnterAnim;
                    this.mManager.attachFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.popExitAnim;
                    this.mManager.detachFragment(fragment, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle);
                }
            }
            op = op.prev;
        }
        if (bl) {
            this.mManager.moveToState(this.mManager.mCurState, FragmentManagerImpl.reverseTransit(this.mTransition), this.mTransitionStyle, true);
            transitionState = null;
        }
        if (this.mIndex >= 0) {
            this.mManager.freeBackStackIndex(this.mIndex);
            this.mIndex = -1;
        }
        return transitionState;
    }

    @Override
    public FragmentTransaction remove(Fragment fragment) {
        Op op = new Op();
        op.cmd = 3;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    @Override
    public FragmentTransaction replace(int n, Fragment fragment) {
        return this.replace(n, fragment, null);
    }

    @Override
    public FragmentTransaction replace(int n, Fragment fragment, String string2) {
        if (n == 0) {
            throw new IllegalArgumentException("Must use non-zero containerViewId");
        }
        this.doAddOp(n, fragment, string2, 2);
        return this;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void run() {
        if (FragmentManagerImpl.DEBUG) {
            Log.v(TAG, "Run: " + this);
        }
        if (this.mAddToBackStack && this.mIndex < 0) {
            throw new IllegalStateException("addToBackStack() called after commit()");
        }
        this.bumpBackStackNesting(1);
        SparseArray<Fragment> sparseArray = new SparseArray<Fragment>();
        SparseArray<Fragment> sparseArray2 = new SparseArray<Fragment>();
        this.calculateFragments(sparseArray, sparseArray2);
        this.beginTransition(sparseArray, sparseArray2, false);
        Op op = this.mHead;
        while (op != null) {
            switch (op.cmd) {
                default: {
                    throw new IllegalArgumentException("Unknown cmd: " + op.cmd);
                }
                case 1: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(fragment, false);
                    break;
                }
                case 2: {
                    Fragment fragment = op.fragment;
                    if (this.mManager.mAdded != null) {
                        for (int i = 0; i < this.mManager.mAdded.size(); ++i) {
                            Fragment fragment2 = this.mManager.mAdded.get(i);
                            if (FragmentManagerImpl.DEBUG) {
                                Log.v(TAG, "OP_REPLACE: adding=" + fragment + " old=" + fragment2);
                            }
                            if (fragment != null && fragment2.mContainerId != fragment.mContainerId) continue;
                            if (fragment2 == fragment) {
                                fragment = null;
                                op.fragment = null;
                                continue;
                            }
                            if (op.removed == null) {
                                op.removed = new ArrayList();
                            }
                            op.removed.add(fragment2);
                            fragment2.mNextAnim = op.exitAnim;
                            if (this.mAddToBackStack) {
                                fragment2.mBackStackNesting = 1 + fragment2.mBackStackNesting;
                                if (FragmentManagerImpl.DEBUG) {
                                    Log.v(TAG, "Bump nesting of " + fragment2 + " to " + fragment2.mBackStackNesting);
                                }
                            }
                            this.mManager.removeFragment(fragment2, this.mTransition, this.mTransitionStyle);
                        }
                    }
                    if (fragment == null) break;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.addFragment(fragment, false);
                    break;
                }
                case 3: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.exitAnim;
                    this.mManager.removeFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 4: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.exitAnim;
                    this.mManager.hideFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 5: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.showFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 6: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.exitAnim;
                    this.mManager.detachFragment(fragment, this.mTransition, this.mTransitionStyle);
                    break;
                }
                case 7: {
                    Fragment fragment = op.fragment;
                    fragment.mNextAnim = op.enterAnim;
                    this.mManager.attachFragment(fragment, this.mTransition, this.mTransitionStyle);
                }
            }
            op = op.next;
        }
        this.mManager.moveToState(this.mManager.mCurState, this.mTransition, this.mTransitionStyle, true);
        if (this.mAddToBackStack) {
            this.mManager.addBackStackState(this);
        }
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(int n) {
        this.mBreadCrumbShortTitleRes = n;
        this.mBreadCrumbShortTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbShortTitle(CharSequence charSequence) {
        this.mBreadCrumbShortTitleRes = 0;
        this.mBreadCrumbShortTitleText = charSequence;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(int n) {
        this.mBreadCrumbTitleRes = n;
        this.mBreadCrumbTitleText = null;
        return this;
    }

    @Override
    public FragmentTransaction setBreadCrumbTitle(CharSequence charSequence) {
        this.mBreadCrumbTitleRes = 0;
        this.mBreadCrumbTitleText = charSequence;
        return this;
    }

    @Override
    public FragmentTransaction setCustomAnimations(int n, int n2) {
        return this.setCustomAnimations(n, n2, 0, 0);
    }

    @Override
    public FragmentTransaction setCustomAnimations(int n, int n2, int n3, int n4) {
        this.mEnterAnim = n;
        this.mExitAnim = n2;
        this.mPopEnterAnim = n3;
        this.mPopExitAnim = n4;
        return this;
    }

    @Override
    public FragmentTransaction setSharedElement(View view, String string2) {
        String string3 = view.getTransitionName();
        if (string3 == null) {
            throw new IllegalArgumentException("Unique transitionNames are required for all sharedElements");
        }
        this.mSharedElementSourceNames = new ArrayList(1);
        this.mSharedElementSourceNames.add(string3);
        this.mSharedElementTargetNames = new ArrayList(1);
        this.mSharedElementTargetNames.add(string2);
        return this;
    }

    @Override
    public FragmentTransaction setSharedElements(Pair<View, String> ... pairArray) {
        if (pairArray == null || pairArray.length == 0) {
            this.mSharedElementSourceNames = null;
            this.mSharedElementTargetNames = null;
            return this;
        }
        ArrayList<String> arrayList = new ArrayList<String>(pairArray.length);
        ArrayList arrayList2 = new ArrayList(pairArray.length);
        for (int i = 0; i < pairArray.length; ++i) {
            String string2 = ((View)pairArray[i].first).getTransitionName();
            if (string2 == null) {
                throw new IllegalArgumentException("Unique transitionNames are required for all sharedElements");
            }
            arrayList.add(string2);
            arrayList2.add(pairArray[i].second);
        }
        this.mSharedElementSourceNames = arrayList;
        this.mSharedElementTargetNames = arrayList2;
        return this;
    }

    @Override
    public FragmentTransaction setTransition(int n) {
        this.mTransition = n;
        return this;
    }

    @Override
    public FragmentTransaction setTransitionStyle(int n) {
        this.mTransitionStyle = n;
        return this;
    }

    @Override
    public FragmentTransaction show(Fragment fragment) {
        Op op = new Op();
        op.cmd = 5;
        op.fragment = fragment;
        this.addOp(op);
        return this;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder(128);
        stringBuilder.append("BackStackEntry{");
        stringBuilder.append(Integer.toHexString(System.identityHashCode(this)));
        if (this.mIndex >= 0) {
            stringBuilder.append(" #");
            stringBuilder.append(this.mIndex);
        }
        if (this.mName != null) {
            stringBuilder.append(" ");
            stringBuilder.append(this.mName);
        }
        stringBuilder.append("}");
        return stringBuilder.toString();
    }

    static final class Op {
        int cmd;
        int enterAnim;
        int exitAnim;
        Fragment fragment;
        Op next;
        int popEnterAnim;
        int popExitAnim;
        Op prev;
        ArrayList<Fragment> removed;

        Op() {
        }
    }

    public class TransitionState {
        public View enteringEpicenterView;
        public ArrayMap<String, String> nameOverrides = new ArrayMap();
        public View nonExistentView;
    }
}

