/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.AlarmStats;
import android.app.IAlarmManager;
import android.app.PendingIntent;
import android.content.Context;
import android.os.Binder;
import android.os.Parcel;
import android.os.Parcelable;
import android.os.RemoteException;
import android.os.UserHandle;
import android.os.WorkSource;
import java.util.ArrayList;
import java.util.Collections;

public class AlarmManager {
    public static final String ACTION_NEXT_ALARM_CLOCK_CHANGED = "android.app.action.NEXT_ALARM_CLOCK_CHANGED";
    public static final int ELAPSED_REALTIME = 3;
    public static final int ELAPSED_REALTIME_WAKEUP = 2;
    public static final long INTERVAL_DAY = 86400000L;
    public static final long INTERVAL_FIFTEEN_MINUTES = 900000L;
    public static final long INTERVAL_HALF_DAY = 43200000L;
    public static final long INTERVAL_HALF_HOUR = 1800000L;
    public static final long INTERVAL_HOUR = 3600000L;
    public static final int RTC = 1;
    public static final int RTC_WAKEUP = 0;
    private static final String TAG = "AlarmManager";
    public static final long WINDOW_EXACT = 0L;
    public static final long WINDOW_HEURISTIC = -1L;
    private final boolean mAlwaysExact;
    private ArrayList<String> mFilteredPackages;
    private final IAlarmManager mService;

    /*
     * Enabled aggressive block sorting
     */
    AlarmManager(IAlarmManager iAlarmManager, Context context) {
        this.mService = iAlarmManager;
        boolean bl = context.getApplicationInfo().targetSdkVersion < 19;
        this.mAlwaysExact = bl;
        this.init();
    }

    public static String convertTime(long l) {
        long l2 = l / 3600000L;
        long l3 = l % 3600000L / 60000L;
        double d = l % 3600000L % 60000L / 1000L;
        return l2 + "h:" + l3 + "m:" + d + "s";
    }

    public static String getType(int n) {
        switch (n) {
            default: {
                return "Unknown";
            }
            case 0: {
                return "RTC_WAKEUP";
            }
            case 1: {
                return "RTC";
            }
            case 2: {
                return "ELAPSED_REALTIME_WAKEUP";
            }
            case 3: 
        }
        return "ELAPSED_REALTIME";
    }

    private long legacyExactLength() {
        if (this.mAlwaysExact) {
            return 0L;
        }
        return -1L;
    }

    private void setImpl(int n, long l, long l2, long l3, PendingIntent pendingIntent, WorkSource workSource, AlarmClockInfo alarmClockInfo) {
        if (l < 0L) {
            l = 0L;
        }
        if (Binder.getCallingUid() != 1000 && (n == 0 || n == 2) && Collections.binarySearch(this.mFilteredPackages, pendingIntent.getCreatorPackage()) >= 0) {
            ++n;
        }
        try {
            this.mService.set(n, l, l2, l3, pendingIntent, workSource, alarmClockInfo);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public boolean areWakeupAlarmDisabledForPackage(String string2) {
        try {
            boolean bl = this.mService.areWakeupAlarmDisabledForPackage(string2);
            return bl;
        }
        catch (RemoteException remoteException) {
            return false;
        }
    }

    public void cancel(PendingIntent pendingIntent) {
        try {
            this.mService.remove(pendingIntent);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void getAlarmList() {
        try {
            this.mService.getAlarmList();
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public AlarmStats getAlarmStats() {
        try {
            AlarmStats alarmStats = this.mService.getAlarmStats();
            return alarmStats;
        }
        catch (RemoteException remoteException) {
            return new AlarmStats(0);
        }
    }

    public AlarmClockInfo getNextAlarmClock() {
        return this.getNextAlarmClock(UserHandle.myUserId());
    }

    public AlarmClockInfo getNextAlarmClock(int n) {
        try {
            AlarmClockInfo alarmClockInfo = this.mService.getNextAlarmClock(n);
            return alarmClockInfo;
        }
        catch (RemoteException remoteException) {
            return null;
        }
    }

    public void init() {
        this.mFilteredPackages = new ArrayList();
        this.mFilteredPackages.add("com.google.android.gsf");
        this.mFilteredPackages.add("com.google.android.apps.maps");
        this.mFilteredPackages.add("com.google.android.apps.plus");
        this.mFilteredPackages.add("com.google.android.googlequicksearchbox");
        this.mFilteredPackages.add("com.google.android.gms");
        Collections.sort(this.mFilteredPackages);
    }

    public void set(int n, long l, long l2, long l3, PendingIntent pendingIntent, WorkSource workSource) {
        this.setImpl(n, l, l2, l3, pendingIntent, workSource, null);
    }

    public void set(int n, long l, PendingIntent pendingIntent) {
        this.setImpl(n, l, this.legacyExactLength(), 0L, pendingIntent, null, null);
    }

    public void setAlarmClock(AlarmClockInfo alarmClockInfo, PendingIntent pendingIntent) {
        this.setImpl(0, alarmClockInfo.getTriggerTime(), 0L, 0L, pendingIntent, null, alarmClockInfo);
    }

    public void setExact(int n, long l, PendingIntent pendingIntent) {
        this.setImpl(n, l, 0L, 0L, pendingIntent, null, null);
    }

    public void setInexactRepeating(int n, long l, long l2, PendingIntent pendingIntent) {
        this.setImpl(n, l, -1L, l2, pendingIntent, null, null);
    }

    public void setRepeating(int n, long l, long l2, PendingIntent pendingIntent) {
        this.setImpl(n, l, this.legacyExactLength(), l2, pendingIntent, null, null);
    }

    public void setTime(long l) {
        try {
            this.mService.setTime(l);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setTimeZone(String string2) {
        try {
            this.mService.setTimeZone(string2);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setWakeupAlarmDisabledForPackage(String string2, boolean bl) {
        try {
            this.mService.setWakeupAlarmDisabledForPackage(string2, bl);
            return;
        }
        catch (RemoteException remoteException) {
            return;
        }
    }

    public void setWindow(int n, long l, long l2, PendingIntent pendingIntent) {
        this.setImpl(n, l, l2, 0L, pendingIntent, null, null);
    }

    public static final class AlarmClockInfo
    implements Parcelable {
        public static final Parcelable.Creator<AlarmClockInfo> CREATOR = new Parcelable.Creator<AlarmClockInfo>(){

            @Override
            public AlarmClockInfo createFromParcel(Parcel parcel) {
                return new AlarmClockInfo(parcel);
            }

            public AlarmClockInfo[] newArray(int n) {
                return new AlarmClockInfo[n];
            }
        };
        private final PendingIntent mShowIntent;
        private final long mTriggerTime;

        public AlarmClockInfo(long l, PendingIntent pendingIntent) {
            this.mTriggerTime = l;
            this.mShowIntent = pendingIntent;
        }

        AlarmClockInfo(Parcel parcel) {
            this.mTriggerTime = parcel.readLong();
            this.mShowIntent = (PendingIntent)parcel.readParcelable(PendingIntent.class.getClassLoader());
        }

        @Override
        public int describeContents() {
            return 0;
        }

        public PendingIntent getShowIntent() {
            return this.mShowIntent;
        }

        public long getTriggerTime() {
            return this.mTriggerTime;
        }

        @Override
        public void writeToParcel(Parcel parcel, int n) {
            parcel.writeLong(this.mTriggerTime);
            parcel.writeParcelable(this.mShowIntent, n);
        }
    }
}

