/*
 * Decompiled with CFR 0.152.
 */
package android.app;

import android.app.Activity;
import android.app.ActivityManagerNative;
import android.app.IActivityContainer;
import android.app.IActivityContainerCallback;
import android.app.PendingIntent;
import android.content.Context;
import android.content.ContextWrapper;
import android.content.IIntentSender;
import android.content.Intent;
import android.content.IntentSender;
import android.graphics.SurfaceTexture;
import android.os.IBinder;
import android.os.RemoteException;
import android.util.AttributeSet;
import android.util.DisplayMetrics;
import android.util.Log;
import android.view.InputEvent;
import android.view.MotionEvent;
import android.view.Surface;
import android.view.TextureView;
import android.view.View;
import android.view.ViewGroup;
import android.view.WindowManager;
import dalvik.system.CloseGuard;
import java.lang.ref.WeakReference;

public class ActivityView
extends ViewGroup {
    private static final boolean DEBUG = false;
    private static final String TAG = "ActivityView";
    private Activity mActivity;
    private ActivityContainerWrapper mActivityContainer;
    private ActivityViewCallback mActivityViewCallback;
    private int mHeight;
    private int mLastVisibility;
    DisplayMetrics mMetrics;
    Intent mQueuedIntent;
    IIntentSender mQueuedPendingIntent;
    private Surface mSurface;
    private final TextureView mTextureView;
    private int mWidth;

    public ActivityView(Context context) {
        this(context, null);
    }

    public ActivityView(Context context, AttributeSet attributeSet) {
        this(context, attributeSet, 0);
    }

    public ActivityView(Context context, AttributeSet attributeSet, int n) {
        super(context, attributeSet, n);
        while (true) {
            block6: {
                block5: {
                    if (!(context instanceof ContextWrapper)) break block5;
                    if (!(context instanceof Activity)) break block6;
                    this.mActivity = (Activity)context;
                }
                if (this.mActivity != null) break;
                throw new IllegalStateException("The ActivityView's Context is not an Activity.");
            }
            context = ((ContextWrapper)context).getBaseContext();
        }
        try {
            this.mActivityContainer = new ActivityContainerWrapper(ActivityManagerNative.getDefault().createActivityContainer(this.mActivity.getActivityToken(), new ActivityContainerCallback(this)));
            this.mTextureView = new TextureView(context);
            this.mTextureView.setSurfaceTextureListener(new ActivityViewSurfaceTextureListener());
        }
        catch (RemoteException remoteException) {
            throw new RuntimeException("ActivityView: Unable to create ActivityContainer. " + remoteException);
        }
        this.addView(this.mTextureView);
        WindowManager windowManager = (WindowManager)this.mActivity.getSystemService("window");
        this.mMetrics = new DisplayMetrics();
        windowManager.getDefaultDisplay().getMetrics(this.mMetrics);
        this.mLastVisibility = this.getVisibility();
    }

    static /* synthetic */ int access$202(ActivityView activityView, int n) {
        activityView.mWidth = n;
        return n;
    }

    static /* synthetic */ int access$302(ActivityView activityView, int n) {
        activityView.mHeight = n;
        return n;
    }

    static /* synthetic */ Surface access$502(ActivityView activityView, Surface surface) {
        activityView.mSurface = surface;
        return surface;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void attachToSurfaceWhenReady() {
        block6: {
            block5: {
                block4: {
                    SurfaceTexture surfaceTexture = this.mTextureView.getSurfaceTexture();
                    if (surfaceTexture == null || this.mSurface != null) break block5;
                    this.mSurface = new Surface(surfaceTexture);
                    try {
                        this.mActivityContainer.setSurface(this.mSurface, this.mWidth, this.mHeight, this.mMetrics.densityDpi);
                        if (this.mQueuedIntent == null) break block4;
                        this.mActivityContainer.startActivity(this.mQueuedIntent);
                    }
                    catch (RemoteException remoteException) {
                        this.mSurface.release();
                        this.mSurface = null;
                        throw new RuntimeException("ActivityView: Unable to create ActivityContainer. " + remoteException);
                    }
                    this.mQueuedIntent = null;
                    return;
                }
                if (this.mQueuedPendingIntent != null) break block6;
            }
            return;
        }
        this.mActivityContainer.startActivityIntentSender(this.mQueuedPendingIntent);
        this.mQueuedPendingIntent = null;
    }

    private boolean injectInputEvent(InputEvent inputEvent) {
        return this.mActivityContainer != null && this.mActivityContainer.injectEvent(inputEvent);
    }

    public boolean isAttachedToDisplay() {
        return this.mSurface != null;
    }

    @Override
    public void onAttachedToWindow() {
    }

    @Override
    public void onDetachedFromWindow() {
    }

    @Override
    public boolean onGenericMotionEvent(MotionEvent motionEvent) {
        if (motionEvent.isFromSource(2) && this.injectInputEvent(motionEvent)) {
            return true;
        }
        return super.onGenericMotionEvent(motionEvent);
    }

    @Override
    protected void onLayout(boolean bl, int n, int n2, int n3, int n4) {
        this.mTextureView.layout(0, 0, n3 - n, n4 - n2);
    }

    @Override
    public boolean onTouchEvent(MotionEvent motionEvent) {
        return this.injectInputEvent(motionEvent) || super.onTouchEvent(motionEvent);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void onVisibilityChanged(View var1_1, int var2_2) {
        block7: {
            block6: {
                super.onVisibilityChanged(var1_1, var2_2);
                if (this.mSurface == null) break block6;
                if (var2_2 != 8) break block7;
                this.mActivityContainer.setSurface(null, this.mWidth, this.mHeight, this.mMetrics.densityDpi);
            }
lbl7:
            // 3 sources

            while (true) {
                this.mLastVisibility = var2_2;
                return;
            }
        }
        try {
            if (this.mLastVisibility != 8) ** GOTO lbl7
            this.mActivityContainer.setSurface(this.mSurface, this.mWidth, this.mHeight, this.mMetrics.densityDpi);
            ** continue;
        }
        catch (RemoteException var3_3) {
            throw new RuntimeException("ActivityView: Unable to set surface of ActivityContainer. " + var3_3);
        }
    }

    public void release() {
        if (this.mActivityContainer == null) {
            Log.e(TAG, "Duplicate call to release");
            return;
        }
        this.mActivityContainer.release();
        this.mActivityContainer = null;
        if (this.mSurface != null) {
            this.mSurface.release();
            this.mSurface = null;
        }
        this.mTextureView.setSurfaceTextureListener(null);
    }

    public void setCallback(ActivityViewCallback activityViewCallback) {
        this.mActivityViewCallback = activityViewCallback;
    }

    public void startActivity(PendingIntent pendingIntent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        IIntentSender iIntentSender = pendingIntent.getTarget();
        if (this.mSurface != null) {
            this.mActivityContainer.startActivityIntentSender(iIntentSender);
            return;
        }
        this.mActivityContainer.checkEmbeddedAllowedIntentSender(iIntentSender);
        this.mQueuedPendingIntent = iIntentSender;
        this.mQueuedIntent = null;
    }

    public void startActivity(Intent intent) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        if (this.mSurface != null) {
            this.mActivityContainer.startActivity(intent);
            return;
        }
        this.mActivityContainer.checkEmbeddedAllowed(intent);
        this.mQueuedIntent = intent;
        this.mQueuedPendingIntent = null;
    }

    public void startActivity(IntentSender intentSender) {
        if (this.mActivityContainer == null) {
            throw new IllegalStateException("Attempt to call startActivity after release");
        }
        IIntentSender iIntentSender = intentSender.getTarget();
        if (this.mSurface != null) {
            this.mActivityContainer.startActivityIntentSender(iIntentSender);
            return;
        }
        this.mActivityContainer.checkEmbeddedAllowedIntentSender(iIntentSender);
        this.mQueuedPendingIntent = iIntentSender;
        this.mQueuedIntent = null;
    }

    private static class ActivityContainerCallback
    extends IActivityContainerCallback.Stub {
        private final WeakReference<ActivityView> mActivityViewWeakReference;

        ActivityContainerCallback(ActivityView activityView) {
            this.mActivityViewWeakReference = new WeakReference<ActivityView>(activityView);
        }

        @Override
        public void onAllActivitiesComplete(IBinder iBinder) {
            ActivityViewCallback activityViewCallback;
            final ActivityView activityView = (ActivityView)this.mActivityViewWeakReference.get();
            if (activityView != null && (activityViewCallback = activityView.mActivityViewCallback) != null) {
                activityView.post(new Runnable(){

                    @Override
                    public void run() {
                        activityViewCallback.onAllActivitiesComplete(activityView);
                    }
                });
            }
        }

        @Override
        public void setVisible(IBinder iBinder, boolean bl) {
        }
    }

    private static class ActivityContainerWrapper {
        private final CloseGuard mGuard = CloseGuard.get();
        private final IActivityContainer mIActivityContainer;
        boolean mOpened;

        ActivityContainerWrapper(IActivityContainer iActivityContainer) {
            this.mIActivityContainer = iActivityContainer;
            this.mOpened = true;
            this.mGuard.open("release");
        }

        void attachToDisplay(int n) {
            try {
                this.mIActivityContainer.attachToDisplay(n);
                return;
            }
            catch (RemoteException remoteException) {
                return;
            }
        }

        void checkEmbeddedAllowed(Intent intent) {
            try {
                this.mIActivityContainer.checkEmbeddedAllowed(intent);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("ActivityView: Unable to startActivity from Intent. " + remoteException);
            }
        }

        void checkEmbeddedAllowedIntentSender(IIntentSender iIntentSender) {
            try {
                this.mIActivityContainer.checkEmbeddedAllowedIntentSender(iIntentSender);
                return;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("ActivityView: Unable to startActivity from IntentSender. " + remoteException);
            }
        }

        protected void finalize() throws Throwable {
            try {
                if (this.mGuard != null) {
                    this.mGuard.warnIfOpen();
                    this.release();
                }
                return;
            }
            finally {
                super.finalize();
            }
        }

        int getDisplayId() {
            try {
                int n = this.mIActivityContainer.getDisplayId();
                return n;
            }
            catch (RemoteException remoteException) {
                return -1;
            }
        }

        boolean injectEvent(InputEvent inputEvent) {
            try {
                boolean bl = this.mIActivityContainer.injectEvent(inputEvent);
                return bl;
            }
            catch (RemoteException remoteException) {
                return false;
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        void release() {
            CloseGuard closeGuard = this.mGuard;
            synchronized (closeGuard) {
                boolean bl = this.mOpened;
                if (bl) {
                    try {
                        this.mIActivityContainer.release();
                        this.mGuard.close();
                    }
                    catch (RemoteException remoteException) {}
                    this.mOpened = false;
                }
                return;
            }
        }

        void setSurface(Surface surface, int n, int n2, int n3) throws RemoteException {
            this.mIActivityContainer.setSurface(surface, n, n2, n3);
        }

        int startActivity(Intent intent) {
            try {
                int n = this.mIActivityContainer.startActivity(intent);
                return n;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("ActivityView: Unable to startActivity. " + remoteException);
            }
        }

        int startActivityIntentSender(IIntentSender iIntentSender) {
            try {
                int n = this.mIActivityContainer.startActivityIntentSender(iIntentSender);
                return n;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("ActivityView: Unable to startActivity from IntentSender. " + remoteException);
            }
        }
    }

    public static abstract class ActivityViewCallback {
        public abstract void onAllActivitiesComplete(ActivityView var1);
    }

    private class ActivityViewSurfaceTextureListener
    implements TextureView.SurfaceTextureListener {
        private ActivityViewSurfaceTextureListener() {
        }

        @Override
        public void onSurfaceTextureAvailable(SurfaceTexture surfaceTexture, int n, int n2) {
            if (ActivityView.this.mActivityContainer == null) {
                return;
            }
            ActivityView.access$202(ActivityView.this, n);
            ActivityView.access$302(ActivityView.this, n2);
            ActivityView.this.attachToSurfaceWhenReady();
        }

        @Override
        public boolean onSurfaceTextureDestroyed(SurfaceTexture surfaceTexture) {
            if (ActivityView.this.mActivityContainer == null) {
                return true;
            }
            ActivityView.this.mSurface.release();
            ActivityView.access$502(ActivityView.this, null);
            try {
                ActivityView.this.mActivityContainer.setSurface(null, ActivityView.this.mWidth, ActivityView.this.mHeight, ActivityView.this.mMetrics.densityDpi);
                return true;
            }
            catch (RemoteException remoteException) {
                throw new RuntimeException("ActivityView: Unable to set surface of ActivityContainer. " + remoteException);
            }
        }

        @Override
        public void onSurfaceTextureSizeChanged(SurfaceTexture surfaceTexture, int n, int n2) {
            if (ActivityView.this.mActivityContainer == null) {
                // empty if block
            }
        }

        @Override
        public void onSurfaceTextureUpdated(SurfaceTexture surfaceTexture) {
        }
    }
}

