/*
 * Decompiled with CFR 0.152.
 */
package android.animation;

import android.animation.Animator;
import android.animation.AnimatorListenerAdapter;
import android.animation.ObjectAnimator;
import android.animation.TimeInterpolator;
import android.animation.ValueAnimator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public final class AnimatorSet
extends Animator {
    private ValueAnimator mDelayAnim = null;
    private long mDuration = -1L;
    private TimeInterpolator mInterpolator = null;
    private boolean mNeedsSort = true;
    private HashMap<Animator, Node> mNodeMap;
    private ArrayList<Node> mNodes;
    private ArrayList<Animator> mPlayingSet = new ArrayList();
    private boolean mReversible = true;
    private AnimatorSetListener mSetListener = null;
    private ArrayList<Node> mSortedNodes;
    private long mStartDelay = 0L;
    private boolean mStarted = false;
    boolean mTerminated = false;

    public AnimatorSet() {
        this.mNodeMap = new HashMap();
        this.mNodes = new ArrayList();
        this.mSortedNodes = new ArrayList();
    }

    static /* synthetic */ ValueAnimator access$102(AnimatorSet animatorSet, ValueAnimator valueAnimator) {
        animatorSet.mDelayAnim = valueAnimator;
        return valueAnimator;
    }

    static /* synthetic */ boolean access$402(AnimatorSet animatorSet, boolean bl) {
        animatorSet.mStarted = bl;
        return bl;
    }

    static /* synthetic */ boolean access$602(AnimatorSet animatorSet, boolean bl) {
        animatorSet.mReversible = bl;
        return bl;
    }

    private void sortNodes() {
        if (this.mNeedsSort) {
            this.mSortedNodes.clear();
            ArrayList<Node> arrayList = new ArrayList<Node>();
            int n = this.mNodes.size();
            for (int i = 0; i < n; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() != 0) continue;
                arrayList.add(node);
            }
            ArrayList<Node> arrayList2 = new ArrayList<Node>();
            while (arrayList.size() > 0) {
                int n2 = arrayList.size();
                for (int i = 0; i < n2; ++i) {
                    Node node = (Node)arrayList.get(i);
                    this.mSortedNodes.add(node);
                    if (node.nodeDependents == null) continue;
                    int n3 = node.nodeDependents.size();
                    for (int j = 0; j < n3; ++j) {
                        Node node2 = node.nodeDependents.get(j);
                        node2.nodeDependencies.remove(node);
                        if (node2.nodeDependencies.size() != 0) continue;
                        arrayList2.add(node2);
                    }
                }
                arrayList.clear();
                arrayList.addAll(arrayList2);
                arrayList2.clear();
            }
            this.mNeedsSort = false;
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                throw new IllegalStateException("Circular dependencies cannot exist in AnimatorSet");
            }
        } else {
            int n = this.mNodes.size();
            for (int i = 0; i < n; ++i) {
                Node node = this.mNodes.get(i);
                if (node.dependencies != null && node.dependencies.size() > 0) {
                    int n4 = node.dependencies.size();
                    for (int j = 0; j < n4; ++j) {
                        Dependency dependency = node.dependencies.get(j);
                        if (node.nodeDependencies == null) {
                            node.nodeDependencies = new ArrayList();
                        }
                        if (node.nodeDependencies.contains(dependency.node)) continue;
                        node.nodeDependencies.add(dependency.node);
                    }
                }
                node.done = false;
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Lifted jumps to return sites
     */
    @Override
    public boolean canReverse() {
        Node node;
        if (!this.mReversible) {
            return false;
        }
        Iterator<Node> iterator = this.mNodes.iterator();
        do {
            if (!iterator.hasNext()) return true;
            node = iterator.next();
            if (!node.animation.canReverse()) return false;
        } while (node.animation.getStartDelay() <= 0L);
        return false;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void cancel() {
        this.mTerminated = true;
        if (this.isStarted()) {
            ArrayList arrayList = this.mListeners;
            ArrayList arrayList2 = null;
            if (arrayList != null) {
                arrayList2 = (ArrayList)this.mListeners.clone();
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    ((Animator.AnimatorListener)iterator.next()).onAnimationCancel(this);
                }
            }
            if (this.mDelayAnim != null && this.mDelayAnim.isRunning()) {
                this.mDelayAnim.cancel();
            } else if (this.mSortedNodes.size() > 0) {
                Iterator<Node> iterator = this.mSortedNodes.iterator();
                while (iterator.hasNext()) {
                    iterator.next().animation.cancel();
                }
            }
            if (arrayList2 != null) {
                Iterator iterator = arrayList2.iterator();
                while (iterator.hasNext()) {
                    ((Animator.AnimatorListener)iterator.next()).onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    @Override
    public AnimatorSet clone() {
        AnimatorSet animatorSet = (AnimatorSet)super.clone();
        animatorSet.mNeedsSort = true;
        animatorSet.mTerminated = false;
        animatorSet.mStarted = false;
        animatorSet.mPlayingSet = new ArrayList();
        animatorSet.mNodeMap = new HashMap();
        animatorSet.mNodes = new ArrayList();
        animatorSet.mSortedNodes = new ArrayList();
        animatorSet.mReversible = this.mReversible;
        animatorSet.mSetListener = null;
        HashMap<Node, Node> hashMap = new HashMap<Node, Node>();
        for (Node node : this.mNodes) {
            Node node2 = node.clone();
            hashMap.put(node, node2);
            animatorSet.mNodes.add(node2);
            animatorSet.mNodeMap.put(node2.animation, node2);
            node2.dependencies = null;
            node2.tmpDependencies = null;
            node2.nodeDependents = null;
            node2.nodeDependencies = null;
            ArrayList<Animator.AnimatorListener> arrayList = node2.animation.getListeners();
            if (arrayList == null) continue;
            ArrayList<Animator.AnimatorListener> arrayList2 = null;
            for (Animator.AnimatorListener animatorListener : arrayList) {
                if (!(animatorListener instanceof AnimatorSetListener)) continue;
                if (arrayList2 == null) {
                    arrayList2 = new ArrayList<Animator.AnimatorListener>();
                }
                arrayList2.add(animatorListener);
            }
            if (arrayList2 == null) continue;
            Iterator iterator = arrayList2.iterator();
            while (iterator.hasNext()) {
                arrayList.remove((Animator.AnimatorListener)iterator.next());
            }
        }
        for (Node node : this.mNodes) {
            Node node3 = (Node)hashMap.get(node);
            if (node.dependencies == null) continue;
            for (Dependency dependency : node.dependencies) {
                node3.addDependency(new Dependency((Node)hashMap.get(dependency.node), dependency.rule));
            }
        }
        return animatorSet;
    }

    @Override
    public void end() {
        this.mTerminated = true;
        if (this.isStarted()) {
            if (this.mSortedNodes.size() != this.mNodes.size()) {
                this.sortNodes();
                for (Node node : this.mSortedNodes) {
                    if (this.mSetListener == null) {
                        this.mSetListener = new AnimatorSetListener(this);
                    }
                    node.animation.addListener(this.mSetListener);
                }
            }
            if (this.mDelayAnim != null) {
                this.mDelayAnim.cancel();
            }
            if (this.mSortedNodes.size() > 0) {
                Iterator<Node> iterator = this.mSortedNodes.iterator();
                while (iterator.hasNext()) {
                    iterator.next().animation.end();
                }
            }
            if (this.mListeners != null) {
                Iterator iterator = ((ArrayList)this.mListeners.clone()).iterator();
                while (iterator.hasNext()) {
                    ((Animator.AnimatorListener)iterator.next()).onAnimationEnd(this);
                }
            }
            this.mStarted = false;
        }
    }

    public ArrayList<Animator> getChildAnimations() {
        ArrayList<Animator> arrayList = new ArrayList<Animator>();
        Iterator<Node> iterator = this.mNodes.iterator();
        while (iterator.hasNext()) {
            arrayList.add(iterator.next().animation);
        }
        return arrayList;
    }

    @Override
    public long getDuration() {
        return this.mDuration;
    }

    @Override
    public TimeInterpolator getInterpolator() {
        return this.mInterpolator;
    }

    @Override
    public long getStartDelay() {
        return this.mStartDelay;
    }

    @Override
    public boolean isRunning() {
        Iterator<Node> iterator = this.mNodes.iterator();
        while (iterator.hasNext()) {
            if (!iterator.next().animation.isRunning()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean isStarted() {
        return this.mStarted;
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void pause() {
        boolean bl = this.mPaused;
        super.pause();
        if (bl || !this.mPaused) return;
        if (this.mDelayAnim != null) {
            this.mDelayAnim.pause();
            return;
        } else {
            Iterator<Node> iterator = this.mNodes.iterator();
            while (iterator.hasNext()) {
                iterator.next().animation.pause();
            }
        }
    }

    public Builder play(Animator animator2) {
        if (animator2 != null) {
            this.mNeedsSort = true;
            return new Builder(animator2);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     */
    public void playSequentially(List<Animator> list) {
        if (list == null || list.size() <= 0) return;
        this.mNeedsSort = true;
        if (list.size() == 1) {
            this.play(list.get(0));
            return;
        } else {
            this.mReversible = false;
            for (int i = 0; i < -1 + list.size(); ++i) {
                this.play(list.get(i)).before(list.get(i + 1));
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    public void playSequentially(Animator ... animatorArray) {
        if (animatorArray == null) return;
        this.mNeedsSort = true;
        if (animatorArray.length == 1) {
            this.play(animatorArray[0]);
            return;
        } else {
            this.mReversible = false;
            for (int i = 0; i < -1 + animatorArray.length; ++i) {
                this.play(animatorArray[i]).before(animatorArray[i + 1]);
            }
        }
    }

    public void playTogether(Collection<Animator> collection) {
        if (collection != null && collection.size() > 0) {
            this.mNeedsSort = true;
            Builder builder = null;
            for (Animator animator2 : collection) {
                if (builder == null) {
                    builder = this.play(animator2);
                    continue;
                }
                builder.with(animator2);
            }
        }
    }

    public void playTogether(Animator ... animatorArray) {
        if (animatorArray != null) {
            this.mNeedsSort = true;
            Builder builder = this.play(animatorArray[0]);
            for (int i = 1; i < animatorArray.length; ++i) {
                builder.with(animatorArray[i]);
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void resume() {
        boolean bl = this.mPaused;
        super.resume();
        if (!bl || this.mPaused) return;
        if (this.mDelayAnim != null) {
            this.mDelayAnim.resume();
            return;
        } else {
            Iterator<Node> iterator = this.mNodes.iterator();
            while (iterator.hasNext()) {
                iterator.next().animation.resume();
            }
        }
    }

    @Override
    public void reverse() {
        if (this.canReverse()) {
            Iterator<Node> iterator = this.mNodes.iterator();
            while (iterator.hasNext()) {
                iterator.next().animation.reverse();
            }
        }
    }

    @Override
    public AnimatorSet setDuration(long l) {
        if (l < 0L) {
            throw new IllegalArgumentException("duration must be a value of zero or greater");
        }
        this.mDuration = l;
        return this;
    }

    @Override
    public void setInterpolator(TimeInterpolator timeInterpolator) {
        this.mInterpolator = timeInterpolator;
    }

    @Override
    public void setStartDelay(long l) {
        if (this.mStartDelay > 0L) {
            this.mReversible = false;
        }
        this.mStartDelay = l;
    }

    @Override
    public void setTarget(Object object) {
        Iterator<Node> iterator = this.mNodes.iterator();
        while (iterator.hasNext()) {
            Animator animator2 = iterator.next().animation;
            if (animator2 instanceof AnimatorSet) {
                ((AnimatorSet)animator2).setTarget(object);
                continue;
            }
            if (!(animator2 instanceof ObjectAnimator)) continue;
            ((ObjectAnimator)animator2).setTarget(object);
        }
    }

    @Override
    public void setupEndValues() {
        Iterator<Node> iterator = this.mNodes.iterator();
        while (iterator.hasNext()) {
            iterator.next().animation.setupEndValues();
        }
    }

    @Override
    public void setupStartValues() {
        Iterator<Node> iterator = this.mNodes.iterator();
        while (iterator.hasNext()) {
            iterator.next().animation.setupStartValues();
        }
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public void start() {
        this.mTerminated = false;
        this.mStarted = true;
        this.mPaused = false;
        Iterator<Node> iterator = this.mNodes.iterator();
        while (iterator.hasNext()) {
            iterator.next().animation.setAllowRunningAsynchronously(false);
        }
        if (this.mDuration >= 0L) {
            Iterator<Node> iterator2 = this.mNodes.iterator();
            while (iterator2.hasNext()) {
                iterator2.next().animation.setDuration(this.mDuration);
            }
        }
        if (this.mInterpolator != null) {
            Iterator<Node> iterator3 = this.mNodes.iterator();
            while (iterator3.hasNext()) {
                iterator3.next().animation.setInterpolator(this.mInterpolator);
            }
        }
        this.sortNodes();
        int n = this.mSortedNodes.size();
        for (int i = 0; i < n; ++i) {
            Node node = this.mSortedNodes.get(i);
            ArrayList<Animator.AnimatorListener> arrayList = node.animation.getListeners();
            if (arrayList == null || arrayList.size() <= 0) continue;
            for (Animator.AnimatorListener animatorListener : new ArrayList<Animator.AnimatorListener>(arrayList)) {
                if (!(animatorListener instanceof DependencyListener) && !(animatorListener instanceof AnimatorSetListener)) continue;
                node.animation.removeListener(animatorListener);
            }
        }
        final ArrayList<Node> arrayList = new ArrayList<Node>();
        for (int i = 0; i < n; ++i) {
            Node node = this.mSortedNodes.get(i);
            if (this.mSetListener == null) {
                AnimatorSetListener animatorSetListener;
                this.mSetListener = animatorSetListener = new AnimatorSetListener(this);
            }
            if (node.dependencies == null || node.dependencies.size() == 0) {
                arrayList.add(node);
            } else {
                int n2 = node.dependencies.size();
                for (int j = 0; j < n2; ++j) {
                    Dependency dependency = node.dependencies.get(j);
                    Animator animator2 = dependency.node.animation;
                    DependencyListener dependencyListener = new DependencyListener(this, node, dependency.rule);
                    animator2.addListener(dependencyListener);
                }
                node.tmpDependencies = (ArrayList)node.dependencies.clone();
            }
            node.animation.addListener(this.mSetListener);
        }
        if (this.mStartDelay <= 0L) {
            for (Node node : arrayList) {
                node.animation.start();
                this.mPlayingSet.add(node.animation);
            }
        } else {
            this.mDelayAnim = ValueAnimator.ofFloat(0.0f, 1.0f);
            this.mDelayAnim.setDuration(this.mStartDelay);
            ValueAnimator valueAnimator = this.mDelayAnim;
            AnimatorListenerAdapter animatorListenerAdapter = new AnimatorListenerAdapter(){
                boolean canceled = false;

                @Override
                public void onAnimationCancel(Animator animator2) {
                    this.canceled = true;
                }

                @Override
                public void onAnimationEnd(Animator animator2) {
                    if (!this.canceled) {
                        int n = arrayList.size();
                        for (int i = 0; i < n; ++i) {
                            Node node = (Node)arrayList.get(i);
                            node.animation.start();
                            AnimatorSet.this.mPlayingSet.add(node.animation);
                        }
                    }
                    AnimatorSet.access$102(AnimatorSet.this, null);
                }
            };
            valueAnimator.addListener(animatorListenerAdapter);
            this.mDelayAnim.start();
        }
        if (this.mListeners != null) {
            ArrayList arrayList2 = (ArrayList)this.mListeners.clone();
            int n3 = arrayList2.size();
            for (int i = 0; i < n3; ++i) {
                ((Animator.AnimatorListener)arrayList2.get(i)).onAnimationStart(this);
            }
        }
        if (this.mNodes.size() == 0 && this.mStartDelay == 0L) {
            this.mStarted = false;
            if (this.mListeners != null) {
                ArrayList arrayList3 = (ArrayList)this.mListeners.clone();
                int n4 = arrayList3.size();
                for (int i = 0; i < n4; ++i) {
                    ((Animator.AnimatorListener)arrayList3.get(i)).onAnimationEnd(this);
                }
            }
        }
    }

    private class AnimatorSetListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;

        AnimatorSetListener(AnimatorSet animatorSet2) {
            this.mAnimatorSet = animatorSet2;
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
            if (!AnimatorSet.this.mTerminated && AnimatorSet.this.mPlayingSet.size() == 0 && AnimatorSet.this.mListeners != null) {
                int n = AnimatorSet.this.mListeners.size();
                for (int i = 0; i < n; ++i) {
                    ((Animator.AnimatorListener)AnimatorSet.this.mListeners.get(i)).onAnimationCancel(this.mAnimatorSet);
                }
            }
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            block3: {
                animator2.removeListener(this);
                AnimatorSet.this.mPlayingSet.remove(animator2);
                ((Node)((AnimatorSet)this.mAnimatorSet).mNodeMap.get((Object)animator2)).done = true;
                if (AnimatorSet.this.mTerminated) break block3;
                ArrayList arrayList = this.mAnimatorSet.mSortedNodes;
                boolean bl = true;
                int n = arrayList.size();
                int n2 = 0;
                while (true) {
                    block5: {
                        block4: {
                            if (n2 >= n) break block4;
                            if (((Node)arrayList.get((int)n2)).done) break block5;
                            bl = false;
                        }
                        if (!bl) break block3;
                        if (AnimatorSet.this.mListeners == null) break;
                        ArrayList arrayList2 = (ArrayList)AnimatorSet.this.mListeners.clone();
                        int n3 = arrayList2.size();
                        for (int i = 0; i < n3; ++i) {
                            ((Animator.AnimatorListener)arrayList2.get(i)).onAnimationEnd(this.mAnimatorSet);
                        }
                        break;
                    }
                    ++n2;
                }
                AnimatorSet.access$402(this.mAnimatorSet, false);
                this.mAnimatorSet.mPaused = false;
            }
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
        }

        @Override
        public void onAnimationStart(Animator animator2) {
        }
    }

    public class Builder {
        private Node mCurrentNode;

        Builder(Animator animator2) {
            this.mCurrentNode = (Node)AnimatorSet.this.mNodeMap.get(animator2);
            if (this.mCurrentNode == null) {
                this.mCurrentNode = new Node(animator2);
                AnimatorSet.this.mNodeMap.put(animator2, this.mCurrentNode);
                AnimatorSet.this.mNodes.add(this.mCurrentNode);
            }
        }

        public Builder after(long l) {
            ValueAnimator valueAnimator = ValueAnimator.ofFloat(0.0f, 1.0f);
            valueAnimator.setDuration(l);
            this.after(valueAnimator);
            return this;
        }

        public Builder after(Animator animator2) {
            AnimatorSet.access$602(AnimatorSet.this, false);
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator2);
            if (node == null) {
                node = new Node(animator2);
                AnimatorSet.this.mNodeMap.put(animator2, node);
                AnimatorSet.this.mNodes.add(node);
            }
            Dependency dependency = new Dependency(node, 1);
            this.mCurrentNode.addDependency(dependency);
            return this;
        }

        public Builder before(Animator animator2) {
            AnimatorSet.access$602(AnimatorSet.this, false);
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator2);
            if (node == null) {
                node = new Node(animator2);
                AnimatorSet.this.mNodeMap.put(animator2, node);
                AnimatorSet.this.mNodes.add(node);
            }
            node.addDependency(new Dependency(this.mCurrentNode, 1));
            return this;
        }

        public Builder with(Animator animator2) {
            Node node = (Node)AnimatorSet.this.mNodeMap.get(animator2);
            if (node == null) {
                node = new Node(animator2);
                AnimatorSet.this.mNodeMap.put(animator2, node);
                AnimatorSet.this.mNodes.add(node);
            }
            node.addDependency(new Dependency(this.mCurrentNode, 0));
            return this;
        }
    }

    private static class Dependency {
        static final int AFTER = 1;
        static final int WITH;
        public Node node;
        public int rule;

        public Dependency(Node node, int n) {
            this.node = node;
            this.rule = n;
        }
    }

    private static class DependencyListener
    implements Animator.AnimatorListener {
        private AnimatorSet mAnimatorSet;
        private Node mNode;
        private int mRule;

        public DependencyListener(AnimatorSet animatorSet, Node node, int n) {
            this.mAnimatorSet = animatorSet;
            this.mNode = node;
            this.mRule = n;
        }

        /*
         * Enabled aggressive block sorting
         */
        private void startIfReady(Animator animator2) {
            block2: {
                block3: {
                    if (this.mAnimatorSet.mTerminated) break block3;
                    int n = this.mNode.tmpDependencies.size();
                    int n2 = 0;
                    while (true) {
                        block5: {
                            Dependency dependency;
                            block4: {
                                dependency = null;
                                if (n2 >= n) break block4;
                                Dependency dependency2 = this.mNode.tmpDependencies.get(n2);
                                if (dependency2.rule != this.mRule || dependency2.node.animation != animator2) break block5;
                                dependency = dependency2;
                                animator2.removeListener(this);
                            }
                            this.mNode.tmpDependencies.remove(dependency);
                            if (this.mNode.tmpDependencies.size() != 0) break;
                            break block2;
                        }
                        ++n2;
                    }
                }
                return;
            }
            this.mNode.animation.start();
            this.mAnimatorSet.mPlayingSet.add(this.mNode.animation);
        }

        @Override
        public void onAnimationCancel(Animator animator2) {
        }

        @Override
        public void onAnimationEnd(Animator animator2) {
            if (this.mRule == 1) {
                this.startIfReady(animator2);
            }
        }

        @Override
        public void onAnimationRepeat(Animator animator2) {
        }

        @Override
        public void onAnimationStart(Animator animator2) {
            if (this.mRule == 0) {
                this.startIfReady(animator2);
            }
        }
    }

    private static class Node
    implements Cloneable {
        public Animator animation;
        public ArrayList<Dependency> dependencies = null;
        public boolean done = false;
        public ArrayList<Node> nodeDependencies = null;
        public ArrayList<Node> nodeDependents = null;
        public ArrayList<Dependency> tmpDependencies = null;

        public Node(Animator animator2) {
            this.animation = animator2;
        }

        public void addDependency(Dependency dependency) {
            if (this.dependencies == null) {
                this.dependencies = new ArrayList();
                this.nodeDependencies = new ArrayList();
            }
            this.dependencies.add(dependency);
            if (!this.nodeDependencies.contains(dependency.node)) {
                this.nodeDependencies.add(dependency.node);
            }
            Node node = dependency.node;
            if (node.nodeDependents == null) {
                node.nodeDependents = new ArrayList();
            }
            node.nodeDependents.add(this);
        }

        public Node clone() {
            try {
                Node node = (Node)super.clone();
                node.animation = this.animation.clone();
                return node;
            }
            catch (CloneNotSupportedException cloneNotSupportedException) {
                throw new AssertionError();
            }
        }
    }
}

