/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.utilities;

import java.lang.management.GarbageCollectorMXBean;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryUsage;
import java.util.List;
import javax.management.Notification;
import javax.management.NotificationEmitter;
import javax.management.NotificationListener;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MemoryUsageMonitor {
    static final Logger LOGGER = LogManager.getLogger(MemoryUsageMonitor.class);
    static final long MB_TO_BYTE = 0x100000L;
    static final long SEC_TO_MS = 1000L;
    private static final MemoryUsageMonitor INSTANCE = new MemoryUsageMonitor();
    private boolean running = false;
    private long threshold = 0L;
    private boolean warned = false;
    private int maxMem = Integer.MIN_VALUE;
    private int skipSteps = 1;
    private int logCounter = 0;

    public static MemoryUsageMonitor getInstance() {
        return INSTANCE;
    }

    private MemoryUsageMonitor() {
    }

    public synchronized void setWarnThreshold(int threshold) {
        this.threshold = threshold < 0 ? 0L : (long)threshold * 0x100000L;
    }

    public synchronized void setSkipSteps(int skipSteps) {
        this.skipSteps = skipSteps < 1 ? 1 : skipSteps;
    }

    public int getMaxMemSeen() {
        return this.maxMem;
    }

    public synchronized void setupMonitoring(int timeInterval) {
        if (!this.running) {
            if (timeInterval <= 0) {
                LOGGER.info("Set up memory usage monitoring after each garbage collection");
                this.setupMonitoringAfterGC();
            } else {
                LOGGER.info("Set up memory usage monitoring after every {} seconds", timeInterval);
                this.setupPeriodicMonitoring(timeInterval);
            }
            this.running = true;
        } else {
            LOGGER.warn("Memory usage monitoring already running!");
        }
    }

    private void setupMonitoringAfterGC() {
        List<GarbageCollectorMXBean> gcbeans = ManagementFactory.getGarbageCollectorMXBeans();
        for (GarbageCollectorMXBean gcbean : gcbeans) {
            NotificationEmitter emitter = (NotificationEmitter)((Object)gcbean);
            emitter.addNotificationListener(new GCListener(), null, null);
        }
    }

    private void setupPeriodicMonitoring(int time) {
        Thread t = new Thread(new PeriodicMonitor(time));
        t.setDaemon(true);
        t.start();
    }

    void logMem() {
        if (this.logCounter % this.skipSteps == 0) {
            MemoryUsage mem = ManagementFactory.getMemoryMXBean().getHeapMemoryUsage();
            int usedMem = (int)Math.ceil((double)mem.getUsed() / 1048576.0);
            if (usedMem > this.maxMem) {
                this.maxMem = usedMem;
            }
            LOGGER.debug("Used Heapspace: {}MB", usedMem);
            if (this.threshold > 0L) {
                if ((long)usedMem > this.threshold && !this.warned) {
                    LOGGER.warn("Memory usage threshold of {}MB reached", this.threshold / 0x100000L + 1L);
                    this.warned = true;
                } else if ((long)usedMem <= this.threshold && this.warned) {
                    this.warned = false;
                }
            }
        }
        ++this.logCounter;
    }

    private class GCListener
    implements NotificationListener {
        @Override
        public void handleNotification(Notification notification, Object handback) {
            if (notification.getType().equals("com.sun.management.gc.notification")) {
                MemoryUsageMonitor.this.logMem();
            }
        }
    }

    private class PeriodicMonitor
    implements Runnable {
        private final long time;

        public PeriodicMonitor(int time) {
            this.time = (long)time * 1000L;
        }

        @Override
        public void run() {
            while (true) {
                MemoryUsageMonitor.this.logMem();
                try {
                    Thread.sleep(this.time);
                    continue;
                }
                catch (InterruptedException e) {
                    LOGGER.error("Thread sleep interrupted: {}", e.getMessage());
                    continue;
                }
                break;
            }
        }
    }
}

