/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.utilities;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import soot.toolkits.scalar.Pair;

public class HTMLFrameBuilder
implements Appendable {
    private static final Logger LOGGER = LogManager.getLogger(HTMLFrameBuilder.class);
    private static final String TRUSTWORTHY_ICON_BASE64 = "<img src=\"data:image/png;base64," + HTMLFrameBuilder.fileToBase64("data/images/yes.png") + "\" alt=\":)\" /><br />";
    private static final String NOT_TRUSTWORTHY_ICON_BASE64 = "<img src=\"data:image/png;base64," + HTMLFrameBuilder.fileToBase64("data/images/no.png") + "\" alt=\":(\" /><br />";
    private static final String SCRIPT = "var defPxRatio;function revertZoom() {var invZoom = defPxRatio / window.devicePixelRatio;var rules = document.styleSheets[0].cssRules;rules[rules.length-3].style.setProperty('-webkit-transform', 'scale(' + invZoom + ')');rules[rules.length-3].style.setProperty('transform', 'scale(' + invZoom + ')');rules[rules.length-3].style.setProperty('width', 1/invZoom*100 + '%', 'important');rules[rules.length-2].style.setProperty('-webkit-transform', 'translateY(-' + invZoom*100 + '%) scale(' + invZoom + ')');rules[rules.length-2].style.setProperty('transform', 'translateY(-' + invZoom*100 + '%) scale(' + invZoom + ')');rules[rules.length-1].style.setProperty('-webkit-transform', 'translateY(' + invZoom*100 + '%) scale(' + invZoom + ')');rules[rules.length-1].style.setProperty('transform', 'translateY(' + invZoom*100 + '%) scale(' + invZoom + ')');} window.addEventListener('resize', revertZoom, false);window.addEventListener('DOMContentLoaded', function(){defPxRatio = window.devicePixelRatio;}, false);function setHeaderSpace() {var contentSpaceHeader = document.querySelector('body > div#header.header-space');if(contentSpaceHeader) {var content = contentSpaceHeader.parentNode.querySelector('div#content');var fontSize = window.getComputedStyle(contentSpaceHeader).getPropertyValue('font-size');var height = window.getComputedStyle(contentSpaceHeader).getPropertyValue('height');var invZoom = defPxRatio / window.devicePixelRatio;var contentSpace = Math.round((2*parseInt(fontSize)+parseInt(height))*invZoom);content.style.setProperty('padding-top', contentSpace + 'px');} } window.addEventListener('resize', setHeaderSpace, false);window.addEventListener('DOMContentLoaded', setHeaderSpace, false);";
    private static final String STYLE = "html {height:100%;} body {background: #F4F4F4;font-family: Verdana, Geneva, sans-serif;font-size: 75%;padding: 0;margin: 0;min-height: 100%;} div#header {position: fixed;top: 0;left: 0;margin: 0;transition: 1s ease-in-out;-webkit-transform-origin: left top;transform-origin: left top;} div#header > div {background: white;padding: 1em;margin: 1em;box-shadow: 0 0 .5em .1em rgba(0,0,0,.4);} div#legend {float: right;} td.icon {width: 1em;height: 1em;padding-right: .5em;padding-top: .3em;} td.icon > * {height: 100%;margin: 0;} div#stats {float: left;} div#stats table td {padding-right: 1em;} div#hint {position: fixed;bottom: 100%;left: 0;box-sizing: border-box;padding: .3em;text-align: center;background: #ffe032;background: linear-gradient(to bottom, #d9d9d9 0%,#ededed 100%);transition: all 0.5s ease-in-out, opacity 0s ease-in-out 0.5s;-webkit-transform-origin: left bottom;transform-origin: left bottom;} div#content {padding: 3em;} body:hover > div#hint.auto-hide {transition: all 0.5s ease-in-out 1.1s, opacity 0.5s ease-in-out 6s;} body:hover > div#hint.auto-hide:not(.persistent) {opacity: 0;} div.no-zoom {transform: scale(1);width: 100%;} body:hover > div#header.auto-hide.no-zoom {-webkit-transform: translateY(-100%) scale(1);transform: translateY(-100%) scale(1);} body:hover > div#hint.auto-hide.no-zoom {-webkit-transform: translateY(100%) scale(1);transform: translateY(100%) scale(1);box-shadow: 0 0 .5em .1em rgba(0,0,0,0.4);} ";
    private final Appendable appendable;
    private boolean started = false;
    private boolean completed = false;
    private final String title;
    private boolean isTrustworthy;
    private final List<String[]> statRows = new LinkedList<String[]>();
    private final List<Pair<String, String>> legendEntries = new LinkedList<Pair<String, String>>();
    private boolean isHeaderAutoHide = false;
    private boolean isHintPersistent = true;
    private boolean isHeaderSpace = false;
    private String customStyle = "";
    private String customScript = "";

    public HTMLFrameBuilder(Appendable app, String htmlTitle) {
        if (app == null) {
            throw new IllegalArgumentException("The wrapped Appendable must not be null!");
        }
        if (htmlTitle == null) {
            throw new IllegalArgumentException("The htmlTitle must not be null!");
        }
        this.appendable = app;
        this.title = htmlTitle;
    }

    public HTMLFrameBuilder setCustomStyle(String cssString) {
        if (cssString == null) {
            throw new IllegalArgumentException("The CSS String must not be null!");
        }
        this.checkNotStarted();
        this.customStyle = cssString;
        return this;
    }

    public HTMLFrameBuilder setCustomScript(String jsString) {
        if (jsString == null) {
            throw new IllegalArgumentException("The JavaScript String must not be null!");
        }
        this.checkNotStarted();
        this.customScript = jsString;
        return this;
    }

    public HTMLFrameBuilder setAppTrustworthy(boolean appTrustworthy) {
        this.checkNotCompleted();
        this.isTrustworthy = appTrustworthy;
        return this;
    }

    public HTMLFrameBuilder setHeaderAutoHide(boolean headerAutoHide) {
        this.checkNotCompleted();
        this.isHeaderAutoHide = headerAutoHide;
        return this;
    }

    public HTMLFrameBuilder setHintPersistent(boolean hintPersistent) {
        this.checkNotCompleted();
        this.isHintPersistent = hintPersistent;
        return this;
    }

    public HTMLFrameBuilder setHeaderSpace(boolean headerSpace) {
        this.checkNotCompleted();
        this.isHeaderSpace = headerSpace;
        return this;
    }

    public HTMLFrameBuilder addStaticticsRow(String ... cells) {
        if (this.statRows.size() > 0 && this.statRows.get(0).length != cells.length) {
            throw new IllegalArgumentException("The number of cells per row has to be equal for all rows!");
        }
        this.checkNotCompleted();
        this.statRows.add(cells);
        return this;
    }

    public HTMLFrameBuilder addLegendEntry(String svgIcon, String description) {
        if (svgIcon == null || description == null) {
            throw new IllegalArgumentException("Both svgIcon and description must not be null!");
        }
        this.checkNotCompleted();
        this.legendEntries.add(new Pair<String, String>(svgIcon, description));
        return this;
    }

    @Override
    public HTMLFrameBuilder append(CharSequence csq) throws IOException {
        this.checkNotCompleted();
        if (!this.started) {
            this.createHTMLPrefix();
            this.started = true;
        }
        this.appendable.append(csq);
        return this;
    }

    @Override
    public HTMLFrameBuilder append(CharSequence csq, int start, int end) throws IOException {
        return this.append(csq.subSequence(start, end));
    }

    @Override
    public HTMLFrameBuilder append(char c) throws IOException {
        return this.append(Character.toString(c));
    }

    public void complete() throws IOException {
        this.append("");
        this.createHTMLSuffix();
        this.completed = true;
    }

    private void checkNotCompleted() {
        if (this.completed) {
            throw new RuntimeException("The instance of HTMLFrameBuilder has already been completed, this action would have no effect!");
        }
    }

    private void checkNotStarted() {
        if (this.started) {
            throw new RuntimeException("The instance of HTMLFrameBuilder has already been started, this action would have no effect!");
        }
    }

    private void createHTMLPrefix() throws IOException {
        this.appendable.append("<!DOCTYPE html>\n");
        this.appendable.append("<html><head><title>").append(this.title).append("</title>\n<style type=\"text/css\">\n");
        this.appendable.append(STYLE).append("\n</style>\n<style type=\"text/css\">\n").append(this.customStyle).append("\n</style>\n<script type=\"text/javascript\">\n");
        this.appendable.append(SCRIPT).append("\n</script>\n<script type=\"text/javascript\">\n").append(this.customScript).append("\n</script></head><body><div id=\"").append("content").append("\">\n");
    }

    private void createHTMLSuffix() throws IOException {
        this.appendable.append("\n</div><div id=\"").append("header").append("\" class=\"").append("no-zoom");
        if (this.isHeaderAutoHide) {
            this.appendable.append(" ").append("auto-hide");
            if (this.isHeaderSpace) {
                this.appendable.append(" ").append("header-space");
            }
        } else {
            this.appendable.append(" ").append("header-space");
        }
        this.appendable.append("\">\n");
        this.createStatistics();
        this.appendable.append("\n");
        this.createLegend();
        this.appendable.append("\n</div><div id=\"").append("hint").append("\" class=\"").append("no-zoom");
        if (this.isHeaderAutoHide) {
            this.appendable.append(" ").append("auto-hide");
            if (this.isHintPersistent) {
                this.appendable.append(" ").append("persistent");
            }
        }
        this.appendable.append("\">Unhover mouse cursor from result to see header</div></body></html>");
    }

    private void createStatistics() throws IOException {
        if (this.statRows.size() > 0) {
            this.appendable.append("<div id=\"").append("stats").append("\">");
            this.appendable.append("<center><strong>Statistics</strong></center>");
            this.appendable.append("<table>");
            this.appendable.append("<tr>").append("<td align=\"center\">");
            if (this.isTrustworthy) {
                this.appendable.append(TRUSTWORTHY_ICON_BASE64);
            } else {
                this.appendable.append(NOT_TRUSTWORTHY_ICON_BASE64).append("Not ");
            }
            this.appendable.append("Trustworthy");
            this.appendable.append("<td valign=\"bottom\">").append("<table>");
            for (String[] row : this.statRows) {
                this.appendable.append("<tr>");
                String[] stringArray = row;
                int n = row.length;
                int n2 = 0;
                while (n2 < n) {
                    String cell = stringArray[n2];
                    this.appendable.append("<td>").append(cell).append("</td>");
                    ++n2;
                }
                this.appendable.append("</tr>");
            }
            this.appendable.append("</table></td></tr></table></div>");
        }
    }

    private void createLegend() throws IOException {
        if (this.legendEntries.size() > 0) {
            this.appendable.append("<div id=\"").append("legend").append("\">");
            this.appendable.append("<center><strong>Legend</strong></center>");
            this.appendable.append("<table>");
            for (Pair<String, String> entry : this.legendEntries) {
                this.appendable.append("<tr>");
                this.appendable.append("<td class=\"").append("icon").append("\">").append(entry.getO1()).append("</td>");
                this.appendable.append("<td>").append(entry.getO2()).append("</td>");
                this.appendable.append("</tr>");
            }
            this.appendable.append("</table></div>");
        }
    }

    private static String fileToBase64(String fileName) {
        try {
            return Base64.getEncoder().encodeToString(Files.readAllBytes(Paths.get(fileName, new String[0])));
        }
        catch (IOException e) {
            LOGGER.debug("Error when creating base64 encoding of PNG: {}", e.getMessage());
            return "";
        }
    }

    public static final class HTMLClasses {
        public static final String ICON = "icon";
        public static final String AUTO_HIDE = "auto-hide";
        public static final String PERSISTENT = "persistent";
        public static final String HEADER_SPACE = "header-space";
        public static final String NO_ZOOM = "no-zoom";
    }

    public static final class HTMLIDs {
        public static final String LEGEND = "legend";
        public static final String STATS = "stats";
        public static final String HEADER = "header";
        public static final String CONTENT = "content";
        public static final String HINT = "hint";
    }
}

