/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.extension.lvl1;

import com.google.common.collect.Iterables;
import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.analyzer.ManifestPermissionComparerLvl1;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import soot.SootClass;
import soot.SootMethod;

public class ManifestPermissionComparerLvl1Test {
    private static ManifestPermissionComparerLvl1 mpc;
    private static AnalysisGraph analysisGraph;
    private static EnhancedInput enhancedInput;

    @Before
    public void before() {
        SootAdapter.getInstance().reinitSoot();
    }

    @Test
    public void comparePermissionAssignedtest() {
        Path apkFile = Paths.get("test_resources/SimpleRequiredInternetP.apk", new String[0]);
        Enhancer enhancer = new Enhancer();
        analysisGraph = new AnalysisGraph(enhancer.enhance(apkFile));
        mpc = new ManifestPermissionComparerLvl1();
        AnalysisResultLvl1 analysisResult = mpc.compare(analysisGraph);
        EnhancedInput ei = (EnhancedInput)analysisResult.getAnalysisGraph().getInput();
        Permission permissionClass = null;
        Permission permissionMethod = null;
        SootClass[] sootClassArray = ei.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        block0: while (n2 < n) {
            SootClass classOrComponent = sootClassArray[n2];
            if (classOrComponent.toString().contains("MainActivity")) {
                permissionClass = Iterables.get(ei.getPermissionsFor(classOrComponent), 0);
                for (SootMethod method : classOrComponent.getMethods()) {
                    if (!method.toString().contains("onCreate")) continue;
                    permissionMethod = Iterables.get(ei.getPermissionsFor(method), 0);
                    break block0;
                }
                break;
            }
            ++n2;
        }
        Assert.assertNotNull(permissionClass);
        Assert.assertEquals((Object)"android.permission.INTERNET", (Object)permissionClass.getName());
        Assert.assertNotNull(permissionMethod);
        Assert.assertEquals((Object)"android.permission.INTERNET", (Object)permissionMethod.getName());
        Assert.assertEquals((Object)true, (Object)ei.getMaybeMoreList().isEmpty());
    }

    @Test
    public void compareMaybeMoretest() {
        Path apkFile = Paths.get("test_resources/SimpleIntents.apk", new String[0]);
        Enhancer enhancer = new Enhancer();
        enhancedInput = (EnhancedInput)enhancer.enhance(apkFile);
        Assert.assertEquals((Object)false, (Object)enhancedInput.getMaybeMoreList().isEmpty());
    }
}

