/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.extension.lvl1;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.extension.Enhancer;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.IntentAnalyzerLvl1;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

public class IntentAnalyzerLvl1Test {
    IntentAnalyzerLvl1 intentAnalyzer;

    @Before
    public void before() {
        Path apkFile = Paths.get("test_resources/SimpleIntents.apk", new String[0]);
        Enhancer enhancer = new Enhancer();
        EnhancedInput enhancedInput = (EnhancedInput)enhancer.enhance(apkFile);
        this.intentAnalyzer = new IntentAnalyzerLvl1(enhancedInput);
    }

    private static Unit findStmt(String className, String methodName, String unitCharSeq, EnhancedInput ei) {
        Unit u = null;
        SootClass[] sootClassArray = ei.getAppClasses();
        int n = sootClassArray.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass componentOrClass = sootClassArray[n2];
            if (componentOrClass.getName().toString().contains(className)) {
                for (SootMethod method : componentOrClass.getMethods()) {
                    if (!method.getName().toString().contains(methodName) || componentOrClass.isInterface()) continue;
                    Body body = method.retrieveActiveBody();
                    for (Unit stm : body.getUnits()) {
                        if (!stm.toString().contains(unitCharSeq)) continue;
                        System.out.println(stm);
                        u = stm;
                    }
                }
            }
            ++n2;
        }
        return u;
    }

    @Test
    public void Intentanalyzerlvl1test() {
        Unit testStmt = IntentAnalyzerLvl1Test.findStmt("MainActivity", "launch_explicit", "(android.content.Context,java.lang.Class)", (EnhancedInput)this.intentAnalyzer.getGraph().getInput());
        this.intentAnalyzer.analyzeExplicitIntents();
        Assert.assertNotNull(this.intentAnalyzer.getGraph().getOutgoingTransitions(testStmt));
    }
}

