/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.core.services;

import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.services.CoreServices;
import de.upb.pga3.panda2.core.services.GlobalVariable;
import de.upb.pga3.panda2.core.services.StatementAnalyzer;
import de.upb.pga3.panda2.extension.Enhancer;
import java.io.File;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.BeforeClass;
import org.junit.Test;
import soot.Body;
import soot.SootClass;
import soot.SootMethod;

public class GlobalVariableTest {
    @BeforeClass
    public static void setUpBeforeClass() throws Exception {
    }

    @Before
    public void setUp() throws Exception {
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testGeneral() {
        Enhancer enhancer = new Enhancer();
        File f = new File("test_resources/IntentExample.apk");
        EnhancedInput ei = (EnhancedInput)enhancer.enhance(f.toPath());
        StatementAnalyzer stmtAnalyzer = CoreServices.getStatementAnalyzerInstance();
        boolean isAndroidComponent = false;
        SootClass[] classes = ei.getAppClasses();
        HashMap<String, GlobalVariable> mapGlobalVars = new HashMap<String, GlobalVariable>();
        SootClass[] sootClassArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass c = sootClassArray[n2];
            isAndroidComponent = ei.isAndroidComponent(c);
            List<SootMethod> methods = c.getMethods();
            if (isAndroidComponent) {
                for (SootMethod m : methods) {
                    try {
                        if (!GlobalVariableTest.isConstructor(m)) continue;
                        Body body = m.retrieveActiveBody();
                        stmtAnalyzer.extractGlobalVars(body, ei, mapGlobalVars);
                    }
                    catch (RuntimeException body) {
                        // empty catch block
                    }
                }
            }
            ++n2;
        }
        if (!mapGlobalVars.isEmpty()) {
            Collection colVars = mapGlobalVars.values();
            for (GlobalVariable var : colVars) {
                String type = var.getType();
                Assert.assertNotNull((Object)type);
                boolean isString = var.isInTypeOf("java.lang.String");
                if (isString) {
                    Assert.assertTrue((boolean)isString);
                } else {
                    Assert.assertFalse((boolean)isString);
                }
                String varName = var.getVarName();
                if (varName != null) {
                    Assert.assertNotNull((Object)varName);
                } else {
                    Assert.assertNull((Object)varName);
                }
                SootClass sc = var.getParentClass();
                if (sc != null) {
                    Assert.assertNotNull((Object)sc);
                } else {
                    Assert.assertNull((Object)sc);
                }
                String varStr = var.toString();
                Assert.assertNotNull((Object)varStr);
                boolean isEqual = var.equals(new GlobalVariable(sc));
                Assert.assertFalse((boolean)isEqual);
                List<String> lstValues = var.getValues();
                Assert.assertNull(lstValues);
            }
        }
    }

    private static boolean isConstructor(SootMethod inSootMethod) {
        String signature;
        return inSootMethod != null && (signature = inSootMethod.getSignature()).contains(": void <init>");
    }
}

