/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.test.client.cmdline;

import de.upb.pga3.panda2.client.cmdline.CommandLine;
import de.upb.pga3.panda2.client.core.AnalysisRegistry;
import java.io.File;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class CommandLineTest {
    String[] initialArguments1;
    String[] initialArguments2;
    String[] initialArguments3;
    String[] initialArguments4;
    String[] initialArguments5;
    String[] initialArguments6;
    String[] initialArguments7;
    final CommandLine cmdL = new CommandLine();

    @Before
    public void setUp() throws Exception {
        this.initialArguments1 = new String[]{"-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view", "-v", "textual", "-ts", "true"};
        this.initialArguments2 = new String[]{"-l", "level1", "-i", "-r", "view", "-v", "textual"};
        this.initialArguments3 = new String[]{"-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "save", "-fp", "test_resources/anaResult1.pa2", "-ts", "true"};
        this.initialArguments4 = new String[]{"-l", "level1", "-i", "test_resources/DummyAPP.apk", "-ci", "test_resources/anaResult1.pa2", "-r", "save", "-fp", "test_resources/anaResult2.pa2", "-ts", "true"};
        this.initialArguments5 = new String[]{"-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view", "-v", "message", "-ts", "false"};
        this.initialArguments6 = new String[]{"-l", "level1", "-i", "test_resources/DummyAPP.apk", "-r", "view", "-v", "textual", "-ts", "true", "-f", "REQUIRED", "-dl", "APP"};
        this.initialArguments7 = new String[]{"-opt", "load", "-fp", "test_resources/anaResult1.pa2"};
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void validateInitialInputPosTest() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments1);
        Assert.assertTrue((boolean)out1);
    }

    @Test
    public void validateInitialInputNegTest() {
        boolean out2 = this.cmdL.validateInitialInput(this.initialArguments2);
        Assert.assertFalse((boolean)out2);
    }

    @Test
    public void filterResultPostest() {
        this.validateInitialInputPosTest();
        this.cmdL.saveOrShowResult();
        this.cmdL.filterResult();
        System.out.println(this.cmdL.toString());
        Assert.assertNotNull((Object)this.cmdL);
    }

    @Test
    public void saveOrShowResultPosTest() {
        this.validateInitialInputPosTest();
        this.cmdL.saveOrShowResult();
        Assert.assertNotNull((Object)this.cmdL);
    }

    @Test
    public void validateAndCompareInputtest() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments4);
        Assert.assertTrue((boolean)out1);
        this.cmdL.validateAndCompareInput();
        Assert.assertNotNull((Object)this.cmdL);
    }

    @Test
    public void saveResultPosTest() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments3);
        Assert.assertTrue((boolean)out1);
        this.cmdL.saveOrShowResult();
        Assert.assertNotNull((Object)this.cmdL);
        Assert.assertTrue((boolean)new File("test_resources/anaResult1.pa2").isFile());
    }

    @Test
    public void saveResultComparisonTest() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments4);
        Assert.assertTrue((boolean)out1);
        this.cmdL.saveOrShowResult();
        Assert.assertNotNull((Object)this.cmdL);
        Assert.assertTrue((boolean)new File("test_resources/anaResult2.pa2").isFile());
    }

    @Test
    public void showResultMessageTest() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments5);
        Assert.assertTrue((boolean)out1);
        this.cmdL.saveOrShowResult();
        Assert.assertNotNull((Object)this.cmdL);
    }

    @Test
    public void showResultWithInitialFilterTest() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments6);
        Assert.assertTrue((boolean)out1);
        this.cmdL.saveOrShowResult();
        Assert.assertNotNull((Object)this.cmdL);
    }

    @Test
    public void loadResult() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments7);
        Assert.assertTrue((boolean)out1);
        this.cmdL.saveOrShowResult();
        Assert.assertNotNull((Object)this.cmdL);
    }

    @Test
    public void getDetailLevelList() {
        boolean out1 = this.cmdL.validateInitialInput(this.initialArguments7);
        Assert.assertTrue((boolean)out1);
        this.cmdL.getClientCommandLine().viewPreviousAnalysisResult();
        Assert.assertFalse((boolean)AnalysisRegistry.getInstance().getName(this.cmdL.getClientCommandLine().getAnalysisResult()).equals("Unknown"));
        Assert.assertTrue((this.cmdL.getClientCommandLine().getDetailLevels().size() > 0 ? 1 : 0) != 0);
    }
}

