/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2b.graphgenerator;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.core.datastructures.ResultInput;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.core.services.IntentInformation;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import java.util.List;
import soot.SootClass;
import soot.Unit;

public class NodeLinkerLvl2b {
    private AnalysisGraph resultGraph;
    private ResultInput ri;

    public NodeLinkerLvl2b(AnalysisGraph ag) {
        this.resultGraph = ag;
        this.ri = (ResultInput)ag.getInput();
    }

    public void link(IntentInformation intentInfo) {
        List<Unit> stms = intentInfo.getLstLaunchingUnits();
        if (stms != null && !stms.isEmpty()) {
            for (Unit stm : stms) {
                boolean enhancedInputFound = false;
                EnhancedInput ei = null;
                int i = 0;
                while (i < this.ri.getResults().size()) {
                    ei = (EnhancedInput)((AnalysisResultLvl1)this.ri.getResults().get(i)).getAnalysisGraph().getInput();
                    if (ei.getBodyForUnit(stm) != null) {
                        enhancedInputFound = true;
                        break;
                    }
                    ++i;
                }
                if (enhancedInputFound) {
                    if (intentInfo.getTargetClasses() == null) {
                        this.resultGraph.addMessage(new Message(MessageType.WARNING, "Implicit intent", "Target could not be found in any Application."));
                        return;
                    }
                    for (SootClass target : intentInfo.getTargetClasses()) {
                        if (target == null) {
                            this.resultGraph.addMessage(new Message(MessageType.WARNING, "Implicit intent", "Target could not be found in any Application."));
                            return;
                        }
                        Transition transition = new Transition(stm, target);
                        this.resultGraph.addTransition(transition);
                        transition = new Transition(ei.getBodyForUnit(stm).getMethod(), target);
                        this.resultGraph.addTransition(transition);
                        transition = new Transition(ei.getBodyForUnit(stm).getMethod().getDeclaringClass(), target);
                        this.resultGraph.addTransition(transition);
                    }
                    continue;
                }
                throw new NullPointerException("Could not find implicit intent source.");
            }
        }
    }

    public AnalysisGraph getGraph() {
        return this.resultGraph;
    }
}

