/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2b;

import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.ResultTypeLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.SVGArrowLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.SVGBarLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.SVGPermissionLvl2b;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SVGGraphicLvl2b {
    private List<SVGArrowLvl2b> arrows = new ArrayList<SVGArrowLvl2b>();
    private Map<Permission, SVGPermissionLvl2b> mapOfPermissions = new HashMap<Permission, SVGPermissionLvl2b>();
    private SVGBarLvl2b[] bars = new SVGBarLvl2b[5];
    private SVGBarLvl2b[] barsComp = new SVGBarLvl2b[5];
    private int xLineStart;
    private boolean compare;

    public SVGGraphicLvl2b(List<SVGArrowLvl2b> arrows, Map<Permission, SVGPermissionLvl2b> mapOfPermissions, SVGBarLvl2b[] bars, SVGBarLvl2b[] barsComp, int xLineStart, boolean compare) {
        this.arrows = arrows;
        this.mapOfPermissions = mapOfPermissions;
        this.bars = bars;
        this.barsComp = barsComp;
        this.xLineStart = xLineStart;
        this.compare = compare;
    }

    public String toString() {
        StringBuilder svgBody = new StringBuilder();
        svgBody.append("\n\t<!-- Permissions -->\n");
        for (SVGPermissionLvl2b svgObject : this.mapOfPermissions.values()) {
            String shortName = svgObject.getPermission().getName();
            if (shortName.length() > 30) {
                shortName = ".." + shortName.substring(shortName.length() - 27);
            }
            svgBody.append("\t<text x=\"" + this.xLineStart + "\" y=\"" + svgObject.getY() + "\" fill=\"black\" style=\"font-family: Verdana; font-size: 13px;\">" + shortName + "<title>" + svgObject.getPermission().getName() + "</title></text>\n");
        }
        svgBody.append("\n\t<!-- Groups -->\n");
        int i = 0;
        while (i < 5) {
            svgBody.append("\t<rect x=\"" + this.bars[i].getX() + "\" y=\"" + this.bars[i].getY() + "\" width=\"" + AnalysisResultLvl2b.barWidth + "\" height=\"" + this.bars[i].getHeight() + "\" fill=\"" + ResultTypeLvl2b.getColorOfType(i) + "\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke;\" stroke=\"#000000\"><title>" + ResultTypeLvl2b.getStringOfType(i) + "</title></rect>\n");
            ++i;
        }
        if (this.compare) {
            i = 0;
            while (i < 5) {
                svgBody.append("\t<rect x=\"" + this.barsComp[i].getX() + "\" y=\"" + this.barsComp[i].getY() + "\" width=\"" + AnalysisResultLvl2b.barWidth + "\" height=\"" + this.barsComp[i].getHeight() + "\" fill=\"" + ResultTypeLvl2b.getColorOfType(i) + "\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke;\" stroke=\"#000000\"><title>" + ResultTypeLvl2b.getStringOfType(i) + "</title></rect>\n");
                ++i;
            }
        }
        svgBody.append("\n\t<!-- Arrows -->\n");
        for (SVGArrowLvl2b svgObject : this.arrows) {
            if (svgObject.getDirect() == 0) {
                svgBody.append("\t<line x1=\"" + svgObject.getFrom()[0] + "\" y1=\"" + svgObject.getFrom()[1] + "\" x2=\"" + svgObject.getTo()[0] + "\" y2=\"" + svgObject.getTo()[1] + "\" stroke=\"black\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke; fill: none;\" />\n");
                continue;
            }
            if (svgObject.getDirect() == 1) {
                svgBody.append("\t<line x1=\"" + svgObject.getFrom()[0] + "\" y1=\"" + svgObject.getFrom()[1] + "\" x2=\"" + svgObject.getTo()[0] + "\" y2=\"" + svgObject.getTo()[1] + "\" stroke=\"black\" stroke-dasharray=\"10, 7\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke; fill: none;\" />\n");
                continue;
            }
            svgBody.append("\t<line x1=\"" + svgObject.getFrom()[0] + "\" y1=\"" + svgObject.getFrom()[1] + "\" x2=\"" + svgObject.getTo()[0] + "\" y2=\"" + svgObject.getTo()[1] + "\" stroke=\"black\" style=\"stroke-width: 3px; vector-effect: non-scaling-stroke; fill: none;\" />\n");
        }
        return svgBody.toString();
    }
}

