/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2b;

import de.upb.pga3.panda2.core.Analysis;
import de.upb.pga3.panda2.core.AnalysisFactory;
import de.upb.pga3.panda2.core.datastructures.AnalysisResult;
import de.upb.pga3.panda2.extension.A3AnalysisProcedure;
import de.upb.pga3.panda2.extension.lvl1.analyzer.AnalyzerLvl1;
import de.upb.pga3.panda2.extension.lvl1.graphgenerator.GraphGeneratorLvl1;
import de.upb.pga3.panda2.extension.lvl2b.AnalysisResultLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.analyzer.AnalyzerLvl2b;
import de.upb.pga3.panda2.extension.lvl2b.graphgenerator.GraphGeneratorLvl2b;
import java.io.File;
import java.util.ArrayList;
import java.util.List;

public class AnalysisFactoryLvl2b
implements AnalysisFactory {
    private File apk;
    private File apkForPrevRes;
    private List<File> nnapks;
    private AnalysisResult prevRes;
    private boolean allmode;

    public AnalysisFactoryLvl2b(File apk, List<File> nnapks, AnalysisResultLvl2b prevRes, boolean allmode) {
        this.apk = apk;
        this.nnapks = nnapks;
        this.prevRes = prevRes;
        this.allmode = allmode;
        this.apkForPrevRes = null;
    }

    public AnalysisFactoryLvl2b(File apk, List<File> nnapks, File apkForPrevRes, boolean allmode) {
        this.apk = apk;
        this.nnapks = nnapks;
        this.prevRes = null;
        this.allmode = allmode;
        this.apkForPrevRes = apkForPrevRes;
    }

    @Override
    public List<Analysis> createAnalysis() {
        ArrayList<Analysis> analysesList = new ArrayList<Analysis>();
        ArrayList<Analysis> analysesLvl1 = new ArrayList<Analysis>();
        if (this.nnapks != null) {
            for (File nnapk : this.nnapks) {
                A3AnalysisProcedure anaProc = new A3AnalysisProcedure(new GraphGeneratorLvl1(), new AnalyzerLvl1());
                Analysis ana = new Analysis(nnapk.toPath(), null, anaProc);
                analysesLvl1.add(ana);
            }
        }
        analysesList.addAll(analysesLvl1);
        if (this.apkForPrevRes != null) {
            A3AnalysisProcedure anaProcComp = new A3AnalysisProcedure(new GraphGeneratorLvl1(), new AnalyzerLvl1());
            Analysis anaComp = new Analysis(this.apkForPrevRes.toPath(), null, anaProcComp);
            analysesList.add(anaComp);
            anaProcComp = new A3AnalysisProcedure(new GraphGeneratorLvl2b(), new AnalyzerLvl2b(this.allmode));
            anaComp = new Analysis(null, null, anaProcComp);
            analysesList.add(anaComp);
            analysesList.addAll(analysesLvl1);
        }
        A3AnalysisProcedure anaProc = new A3AnalysisProcedure(new GraphGeneratorLvl1(), new AnalyzerLvl1());
        Analysis ana = new Analysis(this.apk.toPath(), null, anaProc);
        analysesList.add(ana);
        anaProc = new A3AnalysisProcedure(new GraphGeneratorLvl2b(), new AnalyzerLvl2b(this.allmode));
        ana = new Analysis(null, this.prevRes, anaProc);
        analysesList.add(ana);
        return analysesList;
    }
}

