/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a.flowpath;

import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.PathElement;
import java.util.HashMap;
import java.util.Map;

public final class ResourceElement
implements PathElement {
    private static final long serialVersionUID = 6022575591958902880L;
    private static final Map<ResourceElement, ResourceElement> instancePool = new HashMap<ResourceElement, ResourceElement>();
    private final String permName;

    public static ResourceElement get(Permission permName) {
        ResourceElement resEle = new ResourceElement(permName);
        if (instancePool.containsKey(resEle)) {
            resEle = instancePool.get(resEle);
        } else {
            instancePool.put(resEle, resEle);
        }
        return resEle;
    }

    private ResourceElement(Permission perm) {
        if (perm == null) {
            throw new IllegalArgumentException("The given permission must not be null!");
        }
        this.permName = perm.getName();
    }

    public String getPermissionName() {
        return this.toString();
    }

    @Override
    public String toFullString() {
        return this.toString();
    }

    public String toString() {
        return this.permName;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.permName == null ? 0 : this.permName.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        ResourceElement other = (ResourceElement)obj;
        return !(this.permName == null ? other.permName != null : !this.permName.equals(other.permName));
    }
}

