/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl2a;

import de.upb.pga3.panda2.core.datastructures.DetailLevel;
import de.upb.pga3.panda2.extension.lvl2a.AnalysisResultLvl2a;
import de.upb.pga3.panda2.extension.lvl2a.HtmlTableBuilder;
import de.upb.pga3.panda2.extension.lvl2a.SVGGraphBuilder;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.FlowPath;
import de.upb.pga3.panda2.extension.lvl2a.flowpath.ResourceElement;
import de.upb.pga3.panda2.utilities.HTMLFrameBuilder;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import soot.toolkits.scalar.Pair;

public class ComparisonAnalysisResultLvl2a
extends AnalysisResultLvl2a {
    Map<ResourceElement, List<FlowPath>> mMapNewSources;
    Map<ResourceElement, List<FlowPath>> mMapRemovedSources;
    Map<ResourceElement, List<FlowPath>> mMapNewSinks;
    Map<ResourceElement, List<FlowPath>> mMapRemovedSinks;
    Map<String, ResourceElement> mMapComparisonFilters;

    public ComparisonAnalysisResultLvl2a(AnalysisResultLvl2a inRes) {
        this.mLstMessages = inRes.getMessages();
        this.mMapFilters = inRes.mMapFilters;
        this.mMapSinks = inRes.mMapSinks;
        this.mMapSources = inRes.mMapSources;
        this.setAppName(inRes.getAppName());
        this.mMapComparisonFilters = new HashMap<String, ResourceElement>();
        this.mMapNewSources = new HashMap<ResourceElement, List<FlowPath>>();
        this.mMapRemovedSources = new HashMap<ResourceElement, List<FlowPath>>();
        this.mMapNewSinks = new HashMap<ResourceElement, List<FlowPath>>();
        this.mMapRemovedSinks = new HashMap<ResourceElement, List<FlowPath>>();
    }

    public boolean addNewPath(FlowPath inNewPath) {
        if (inNewPath != null && inNewPath.isComplete()) {
            List<FlowPath> lstFlowPaths = this.mMapNewSources.get(inNewPath.getSource());
            if (lstFlowPaths == null) {
                lstFlowPaths = new ArrayList<FlowPath>();
                lstFlowPaths.add(inNewPath);
                this.mMapNewSources.put(inNewPath.getSource(), lstFlowPaths);
            } else {
                lstFlowPaths.add(inNewPath);
            }
            List<FlowPath> lstFlowPaths2 = this.mMapNewSinks.get(inNewPath.getSink());
            if (lstFlowPaths2 == null) {
                lstFlowPaths2 = new ArrayList<FlowPath>();
                lstFlowPaths2.add(inNewPath);
                this.mMapNewSinks.put(inNewPath.getSink(), lstFlowPaths2);
            } else {
                lstFlowPaths2.add(inNewPath);
            }
            return true;
        }
        throw new IllegalArgumentException("The path to be added must not be null and must be complete!");
    }

    public boolean addRemovedPath(FlowPath inRemovedPath) {
        if (inRemovedPath != null && inRemovedPath.isComplete()) {
            List<FlowPath> lstFlowPaths = this.mMapRemovedSources.get(inRemovedPath.getSource());
            if (lstFlowPaths == null) {
                lstFlowPaths = new ArrayList<FlowPath>();
                lstFlowPaths.add(inRemovedPath);
                this.mMapRemovedSources.put(inRemovedPath.getSource(), lstFlowPaths);
            } else {
                lstFlowPaths.add(inRemovedPath);
            }
            List<FlowPath> lstFlowPaths2 = this.mMapRemovedSinks.get(inRemovedPath.getSink());
            if (lstFlowPaths2 == null) {
                lstFlowPaths2 = new ArrayList<FlowPath>();
                lstFlowPaths2.add(inRemovedPath);
                this.mMapRemovedSinks.put(inRemovedPath.getSink(), lstFlowPaths2);
            } else {
                lstFlowPaths2.add(inRemovedPath);
            }
            return true;
        }
        throw new IllegalArgumentException("The path to be added must not be null and must be complete!");
    }

    @Override
    public void createFilters() {
        super.createFilters();
        this.fetchFilters(this.mMapNewSources.keySet(), "Source:");
        this.fetchFilters(this.mMapRemovedSources.keySet(), "Source:");
        this.fetchFilters(this.mMapNewSinks.keySet(), "Sink:");
        this.fetchFilters(this.mMapRemovedSinks.keySet(), "Sink:");
    }

    private void fetchFilters(Collection<ResourceElement> permissions, String prefix) {
        for (ResourceElement p : permissions) {
            String str = String.valueOf(prefix) + p.toString();
            if (this.mMapComparisonFilters.containsKey(str)) continue;
            this.mMapComparisonFilters.put(str, p);
        }
    }

    @Override
    public String getGraphicalResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        Pair<Collection<FlowPath>, Collection<FlowPath>> pathsForRep = this.preprocess(inDetailLvl, inFilters);
        return this.createGraphicalResult(pathsForRep.getO1(), pathsForRep.getO2(), (AnalysisResultLvl2a.DetailLevelLvl2a)inDetailLvl, inShowStats);
    }

    private Pair<Collection<FlowPath>, Collection<FlowPath>> preprocess(DetailLevel inDetailLvl, List<String> inFilters) {
        AnalysisResultLvl2a.DetailLevelLvl2a dlvl = inDetailLvl == null || !(inDetailLvl instanceof AnalysisResultLvl2a.DetailLevelLvl2a) ? AnalysisResultLvl2a.DetailLevelLvl2a.RES_TO_RES : (AnalysisResultLvl2a.DetailLevelLvl2a)inDetailLvl;
        AnalysisResultLvl2a.RepresentationPreprocessor rp = new AnalysisResultLvl2a.RepresentationPreprocessor(this.mMapNewSources, this.mMapNewSinks, this.mMapComparisonFilters, inFilters, dlvl);
        Collection<FlowPath> colNewFlowPaths = rp.preprocess();
        rp = new AnalysisResultLvl2a.RepresentationPreprocessor(this.mMapRemovedSources, this.mMapRemovedSinks, this.mMapComparisonFilters, inFilters, dlvl);
        Collection<FlowPath> colRemovedFlowPaths = rp.preprocess();
        return new Pair<Collection<FlowPath>, Collection<FlowPath>>(colNewFlowPaths, colRemovedFlowPaths);
    }

    private String createGraphicalResult(Collection<FlowPath> inNewPaths, Collection<FlowPath> inRemovedPaths, AnalysisResultLvl2a.DetailLevelLvl2a inDetailLvl, boolean autoHideHeader) {
        StringBuilder sb = new StringBuilder();
        HTMLFrameBuilder fb = new HTMLFrameBuilder(sb, "Intra-App Information Flow Analysis");
        fb.setAppTrustworthy(this.mMapSources.size() == 0);
        fb.addStaticticsRow("Number of new source permission(s): ", "<strong>" + this.mMapNewSources.size() + "</strong>");
        fb.addStaticticsRow("Number of removed source permission(s): ", "<strong>" + this.mMapRemovedSources.size() + "</strong>");
        fb.addStaticticsRow("Number of new sink permission(s): ", "<strong>" + this.mMapNewSinks.size() + "</strong>");
        fb.addStaticticsRow("Number of removed sink permission(s): ", "<strong>" + this.mMapRemovedSinks.size() + "</strong>");
        fb.addStaticticsRow("Number of new distinguish path(s): ", "<strong>" + inNewPaths.size() + "</strong>");
        fb.addStaticticsRow("Number of removed distinguish path(s): ", "<strong>" + inRemovedPaths.size() + "</strong>");
        AnalysisResultLvl2a.createLegend(inDetailLvl, fb);
        fb.addLegendEntry("<div style=\"background:#21C87B;\"></div>", "New Information Flow Edge");
        fb.addLegendEntry("<div style=\"background:#E04741;\"></div>", "Removed Information Flow Edge");
        fb.setHeaderAutoHide(autoHideHeader);
        fb.setHintPersistent(false);
        fb.setCustomStyle("svg {font-size: 80%;} svg g.edge > path {stroke-width: .3em;transition: .2s ease-in-out;} svg g.cluster > text, svg g.node > text {fill: white;stroke: black;stroke-width: .015em;font-weight: bold;} svg g.edge > text {transition: .2s ease-in-out;} svg g.edge.highlighted > polygon, svg g.edge.highlighted > path {stroke-width: .4em;stroke: #F09514;filter: url(#drop-shadow);} svg g.edge.highlighted > text {fill: #F09514;filter: url(#drop-shadow);} ");
        fb.setCustomScript("var edges;function stylePath(edge) {var edgeText = edge.parentNode.getElementsByTagName('text')[0];var pathIdx = edgeText.innerHTML;var newPathIdx;for (i = 0; i < edges.length; i++) {edgeText = edges[i].parentNode.getElementsByTagName('text')[0];newPathIdx = edgeText.innerHTML;if(newPathIdx===pathIdx) {edges[i].parentNode.classList.toggle('highlighted');} } } function edgeClicked(event) {stylePath(event.target);} function setMousePathListener() {edges = document.querySelectorAll('svg g.edge > path');console.log('Found edges: '+edges.length);for (i = 0; i < edges.length; i++) {edges[i].addEventListener('click', edgeClicked, false);} } window.addEventListener('DOMContentLoaded', setMousePathListener, false);");
        SVGGraphBuilder builder = new SVGGraphBuilder();
        for (FlowPath path : inNewPaths) {
            builder.addPath(path, "#21C87B");
        }
        for (FlowPath path : inRemovedPaths) {
            builder.addPath(path, "#E04741");
        }
        try {
            fb.append("<svg height=\"0\" width=\"0\" xmlns=\"http://www.w3.org/2000/svg\"><filter id=\"drop-shadow\"><feGaussianBlur in=\"SourceAlpha\" stdDeviation=\"2.2\"/><feOffset dx=\"0\" dy=\"0\" result=\"offsetblur\"/><feFlood flood-color=\"white\"/><feComposite in2=\"offsetblur\" operator=\"in\"/><feMerge><feMergeNode/><feMergeNode in=\"SourceGraphic\"/></feMerge></filter></svg>");
            fb.append(builder.buildGraph());
            fb.complete();
        }
        catch (IOException e) {
            LOGGER.error("Error when creating graphical result: {}", e.getMessage());
            LOGGER.debug(e);
        }
        return sb.toString();
    }

    @Override
    public String getTextualResult(DetailLevel inDetailLvl, List<String> inFilters, boolean inShowStats) {
        Pair<Collection<FlowPath>, Collection<FlowPath>> pathsForRep = this.preprocess(inDetailLvl, inFilters);
        return this.createTextualResult(pathsForRep.getO1(), pathsForRep.getO2(), (AnalysisResultLvl2a.DetailLevelLvl2a)inDetailLvl, inShowStats);
    }

    private String createTextualResult(Collection<FlowPath> inNewPaths, Collection<FlowPath> inRemovedPaths, AnalysisResultLvl2a.DetailLevelLvl2a inDetailLvl, boolean autoHideHeader) {
        LinkedList<FlowPath> removedPaths = new LinkedList<FlowPath>();
        for (List<FlowPath> fpList : this.mMapRemovedSources.values()) {
            removedPaths.addAll(fpList);
        }
        LinkedList<FlowPath> newPaths = new LinkedList<FlowPath>();
        for (List<FlowPath> fpList : this.mMapNewSources.values()) {
            newPaths.addAll(fpList);
        }
        int iNoNewSources = this.mMapNewSources.keySet().size();
        int iNoNewSinks = this.mMapNewSinks.keySet().size();
        int iNoRemovedSources = this.mMapRemovedSources.keySet().size();
        int iNoRemoveSinks = this.mMapRemovedSinks.keySet().size();
        StringBuilder sb = new StringBuilder();
        HTMLFrameBuilder fb = new HTMLFrameBuilder(sb, "Intra-App Information Flow Analysis");
        fb.addStaticticsRow("Number of source permission(s): ", "<font color=\"red\"><strong>" + iNoNewSources + "</strong></font>");
        fb.addStaticticsRow("Number of removed source permission(s): ", "<font color=\"red\"><strong>" + iNoRemovedSources + "</strong></font>");
        fb.addStaticticsRow("Number of sink permission(s): ", "<font color=\"blue\"><strong>" + iNoNewSinks + "</strong></font>");
        fb.addStaticticsRow("Number of removed sink permission(s): ", "<font color=\"blue\"><strong>" + iNoRemoveSinks + "</strong></font>");
        fb.addStaticticsRow("Number of new path(s): ", "<strong>" + newPaths.size() + "</strong>");
        fb.addStaticticsRow("Number of removed path(s): ", "<strong>" + removedPaths.size() + "</strong>");
        fb.addLegendEntry("<div class=\"icon\" style=\"background:#ff0000;\"></div>", "SOURCE PERMISSION");
        fb.addLegendEntry("<div class=\"icon\" style=\"background:#0006fd;\"></div>", "SINK PERMISSION");
        fb.setHeaderAutoHide(autoHideHeader);
        fb.setHintPersistent(false);
        fb.setCustomStyle(HtmlTableBuilder.cssStyle);
        HtmlTableBuilder tableBuilder = new HtmlTableBuilder(true, this.getAppName());
        tableBuilder.processResult(inNewPaths, inRemovedPaths, inDetailLvl);
        try {
            fb.append(tableBuilder.toString());
            fb.complete();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return sb.toString();
    }

    @Override
    public List<String> getFilters() {
        ArrayList<String> filters = new ArrayList<String>();
        filters.addAll(this.mMapComparisonFilters.keySet());
        return filters;
    }
}

