/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl1.graphgenerator;

import de.upb.pga3.panda2.core.datastructures.AnalysisGraph;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Message;
import de.upb.pga3.panda2.core.datastructures.MessageType;
import de.upb.pga3.panda2.core.datastructures.Transition;
import de.upb.pga3.panda2.core.services.IntentInformation;
import java.util.List;
import soot.SootClass;
import soot.Unit;

public class NodeLinkerLvl1 {
    private AnalysisGraph resultGraph;
    private EnhancedInput ei;

    public NodeLinkerLvl1(AnalysisGraph ag) {
        this.resultGraph = ag;
        this.ei = (EnhancedInput)ag.getInput();
    }

    public void link(IntentInformation intentInfo) {
        if (intentInfo.getTargetClasses() == null || intentInfo.getTargetClasses().isEmpty()) {
            this.resultGraph.addMessage(new Message(MessageType.INFO, "No Target", "No target class could not be found for explicit intent definition"));
            return;
        }
        List<Unit> stms = intentInfo.getLstLaunchingUnits();
        if (stms != null && !stms.isEmpty()) {
            for (Unit stm : stms) {
                for (SootClass target : intentInfo.getTargetClasses()) {
                    Transition transition = new Transition(stm, target);
                    this.resultGraph.addTransition(transition);
                    transition = new Transition(this.ei.getBodyForUnit(stm).getMethod(), target);
                    this.resultGraph.addTransition(transition);
                    transition = new Transition(this.ei.getBodyForUnit(stm).getMethod().getDeclaringClass(), target);
                    this.resultGraph.addTransition(transition);
                }
            }
        }
    }

    public AnalysisGraph getGraph() {
        return this.resultGraph;
    }
}

