/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.extension.lvl1;

import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.extension.lvl1.AnalysisResultLvl1;
import de.upb.pga3.panda2.extension.lvl1.ResultTypeLvl1;
import de.upb.pga3.panda2.extension.lvl1.SVGArrowLvl1;
import de.upb.pga3.panda2.extension.lvl1.SVGBarLvl1;
import de.upb.pga3.panda2.extension.lvl1.SVGPermissionLvl1;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SVGGraphicLvl1 {
    private List<SVGArrowLvl1> arrows = new ArrayList<SVGArrowLvl1>();
    private Map<Permission, SVGPermissionLvl1> mapOfPermissions = new HashMap<Permission, SVGPermissionLvl1>();
    private SVGBarLvl1[] bars = new SVGBarLvl1[5];
    private SVGBarLvl1[] barsComp = new SVGBarLvl1[5];
    private int xLineStart;
    private boolean compare;

    public SVGGraphicLvl1(List<SVGArrowLvl1> arrows, Map<Permission, SVGPermissionLvl1> mapOfPermissions, SVGBarLvl1[] bars, SVGBarLvl1[] barsComp, int xLineStart, boolean compare) {
        this.arrows = arrows;
        this.mapOfPermissions = mapOfPermissions;
        this.bars = bars;
        this.barsComp = barsComp;
        this.xLineStart = xLineStart;
        this.compare = compare;
    }

    public String toString() {
        StringBuilder svgBody = new StringBuilder();
        svgBody.append("\n\t<!-- Permissions -->\n");
        for (SVGPermissionLvl1 svgObject : this.mapOfPermissions.values()) {
            String shortName = svgObject.getPermission().getName();
            if (shortName.length() > 30) {
                shortName = ".." + shortName.substring(shortName.length() - 27);
            }
            svgBody.append("\t<text x=\"" + this.xLineStart + "\" y=\"" + svgObject.getY() + "\" fill=\"black\" style=\"font-family: Verdana; font-size: 13px;\">" + shortName + "<title>" + svgObject.getPermission().getName() + "</title></text>\n");
        }
        svgBody.append("\n\t<!-- Groups -->\n");
        int i = 0;
        while (i < 5) {
            svgBody.append("\t<rect x=\"" + this.bars[i].getX() + "\" y=\"" + this.bars[i].getY() + "\" width=\"" + AnalysisResultLvl1.barWidth + "\" height=\"" + this.bars[i].getHeight() + "\" fill=\"" + ResultTypeLvl1.getColorOfType(i) + "\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke;\" stroke=\"#000000\"><title>" + ResultTypeLvl1.getStringOfType(i) + "</title></rect>\n");
            ++i;
        }
        if (this.compare) {
            i = 0;
            while (i < 5) {
                svgBody.append("\t<rect x=\"" + this.barsComp[i].getX() + "\" y=\"" + this.barsComp[i].getY() + "\" width=\"" + AnalysisResultLvl1.barWidth + "\" height=\"" + this.barsComp[i].getHeight() + "\" fill=\"" + ResultTypeLvl1.getColorOfType(i) + "\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke;\" stroke=\"#000000\"><title>" + ResultTypeLvl1.getStringOfType(i) + "</title></rect>\n");
                ++i;
            }
        }
        svgBody.append("\n\t<!-- Arrows -->\n");
        for (SVGArrowLvl1 svgObject : this.arrows) {
            svgBody.append("\t<line x1=\"" + svgObject.getFrom()[0] + "\" y1=\"" + svgObject.getFrom()[1] + "\" x2=\"" + svgObject.getTo()[0] + "\" y2=\"" + svgObject.getTo()[1] + "\" stroke=\"black\" style=\"stroke-width: 1px; vector-effect: non-scaling-stroke; fill: none;\" />\n");
        }
        return svgBody.toString();
    }
}

