/*
 * Decompiled with CFR 0.152.
 */
package de.upb.pga3.panda2.demos;

import de.upb.pga3.panda2.client.core.datastructures.ManifestInfo;
import de.upb.pga3.panda2.core.SootAdapter;
import de.upb.pga3.panda2.core.datastructures.EnhancedInput;
import de.upb.pga3.panda2.core.datastructures.Permission;
import de.upb.pga3.panda2.core.services.A3XMLParser;
import de.upb.pga3.panda2.core.services.CoreServices;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import soot.Body;
import soot.PatchingChain;
import soot.Scene;
import soot.SootClass;
import soot.SootMethod;
import soot.Unit;

public class EnhancedInputForTestingNew {
    public static EnhancedInput generateEnhancedInputForApp(Path path) {
        String className = "MainActivity";
        String methodName = "launch_implicit";
        String unitCharSeq = "Uri parse";
        SootAdapter.getInstance().init(path);
        SootAdapter.getInstance().run(SootAdapter.SootPhase.WJTP);
        String appName = "SimpleIntents";
        ManifestInfo manifestInfo = A3XMLParser.getInstance().getManifestInformation();
        EnhancedInput ei = new EnhancedInput("SimpleIntents", manifestInfo);
        ei.setScene(Scene.v());
        Permission[] allPermissions = new Permission[]{new Permission("INTERNET")};
        EnhancedInputForTestingNew.addPermissionToApp(allPermissions, ei);
        EnhancedInputForTestingNew.addPermissionToElement("MainActivity", "launch_implicit", "Uri parse", new Permission("INTERNET"), ei);
        return ei;
    }

    public static EnhancedInput generateEnhancedInputForOnlyExplicitApp(Path path) {
        SootAdapter.getInstance().init(path);
        SootAdapter.getInstance().run(SootAdapter.SootPhase.WJTP);
        String appName = "OnlyExplicit";
        ManifestInfo manifestInfo = A3XMLParser.getInstance().getManifestInformation();
        EnhancedInput ei = new EnhancedInput("OnlyExplicit", manifestInfo);
        ei.setScene(Scene.v());
        return ei;
    }

    public static EnhancedInput generateEnhancedInputForOnlyImplicitApp(Path path) {
        SootAdapter.getInstance().init(path);
        SootAdapter.getInstance().run(SootAdapter.SootPhase.WJTP);
        String appName = "OnlyImplicit";
        ManifestInfo manifestInfo = A3XMLParser.getInstance().getManifestInformation();
        EnhancedInput ei = new EnhancedInput("OnlyImplicit", manifestInfo);
        ei.setScene(Scene.v());
        return ei;
    }

    private static void addPermissionToApp(Permission[] permissions, EnhancedInput ei) {
        Collection<Permission> lstPerm = CoreServices.getDataStorageInstance().getAllPermissions().values();
        Permission[] permissionArray = permissions;
        int n = permissions.length;
        int n2 = 0;
        while (n2 < n) {
            Permission newPermission = permissionArray[n2];
            if (newPermission != null && newPermission.getName().length() > 0) {
                Permission foundPermission = null;
                for (Permission item : lstPerm) {
                    if (!item.getName().contains(newPermission.getName())) continue;
                    foundPermission = item;
                }
                ei.addPermission(foundPermission);
            }
            ++n2;
        }
    }

    private static void addPermissionToElement(String className, String methodName, String unitCharSeq, Permission permission, EnhancedInput ei) {
        SootClass[] classes;
        Collection<Permission> lstPerm = CoreServices.getDataStorageInstance().getAllPermissions().values();
        SootClass[] sootClassArray = classes = ei.getAppClasses();
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            SootClass c = sootClassArray[n2];
            if (c.getName().toString().contains(className)) {
                List<SootMethod> methods = c.getMethods();
                for (SootMethod m : methods) {
                    if (!m.getName().toString().contains(methodName)) continue;
                    Body body = m.retrieveActiveBody();
                    PatchingChain<Unit> units = body.getUnits();
                    for (Unit u : units) {
                        ei.mapUnitToBody(u, body);
                        if (!u.toString().contains(unitCharSeq)) continue;
                        for (Permission item : lstPerm) {
                            if (!item.getName().contains(permission.getName())) continue;
                            ei.addPermissionTo(u, permission);
                        }
                    }
                }
            }
            ++n2;
        }
    }
}

